/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkFgMeldeInfosSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class WkFgPanSeven
extends JPanel
implements DisposableCidsBeanStore {
    private Logger LOG = Logger.getLogger(WkFgPanSeven.class);
    private CidsBean cidsBean;
    private JScrollPane jScrollPane1;
    private JLabel lblHeading;
    private JLabel lblSpace;
    private SemiRoundedPanel panHeadQuality;
    private RoundedPanel panQuality;
    private JPanel panQualityContent;
    private JXTable tabPressure;

    public WkFgPanSeven() {
        this(true);
    }

    public WkFgPanSeven(boolean readOnly) {
        this.initComponents();
        this.jScrollPane1.setVisible(true);
        this.tabPressure.setRowHeight(75);
        this.tabPressure.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setVerticalAlignment(1);
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel) {
                    ((JLabel)c).setText("<html>" + ((JLabel)c).getText() + "</html>");
                    ((JLabel)c).setToolTipText("<html>" + WkFgPanSeven.wrapText(String.valueOf(value), 50) + "</html>");
                }
                return c;
            }
        });
    }

    public static String wrapText(String text, int size) {
        StringBuilder buffer = new StringBuilder(text.length());
        int lineLength = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                lineLength = 0;
                buffer.append("<br>");
                continue;
            }
            if (lineLength >= size && text.charAt(i) == ' ') {
                lineLength = 1;
                buffer.append("<br>");
                buffer.append(text.charAt(i));
                continue;
            }
            ++lineLength;
            buffer.append(text.charAt(i));
        }
        return buffer.toString();
    }

    private void initComponents() {
        this.panQuality = new RoundedPanel();
        this.panHeadQuality = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panQualityContent = new JPanel();
        this.lblSpace = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tabPressure = new JXTable();
        this.setMinimumSize(new Dimension(1150, 690));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(1150, 690));
        this.setLayout(new BorderLayout());
        this.panHeadQuality.setBackground(new Color(51, 51, 51));
        this.panHeadQuality.setMinimumSize(new Dimension(109, 24));
        this.panHeadQuality.setPreferredSize(new Dimension(109, 24));
        this.panHeadQuality.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText("Anh\u00f6rung");
        this.panHeadQuality.add((Component)this.lblHeading);
        this.panQuality.add((Component)this.panHeadQuality, (Object)"North");
        this.panQualityContent.setMinimumSize(new Dimension(1100, 260));
        this.panQualityContent.setOpaque(false);
        this.panQualityContent.setPreferredSize(new Dimension(1100, 260));
        this.panQualityContent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.panQualityContent.add((Component)this.lblSpace, gridBagConstraints);
        this.jScrollPane1.setViewportView((Component)this.tabPressure);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panQualityContent.add((Component)this.jScrollPane1, gridBagConstraints);
        this.panQuality.add((Component)this.panQualityContent, (Object)"Center");
        this.add((Component)this.panQuality, "Center");
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(final CidsBean cidsBean) {
        if (cidsBean != null) {
            boolean showPanMelinf;
            this.cidsBean = cidsBean;
            boolean bl = showPanMelinf = SessionManager.getSession().getUser().getUserGroup().getName().equalsIgnoreCase("administratoren") || SessionManager.getSession().getUser().getUserGroup().getName().toLowerCase().startsWith("stalu");
            if (showPanMelinf) {
                Thread t = new Thread("retrieveAnhData"){

                    @Override
                    public void run() {
                        try {
                            WkFgMeldeInfosSearch anhoerungInfo = new WkFgMeldeInfosSearch((String)cidsBean.getProperty("wk_k"));
                            ArrayList infos = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)anhoerungInfo);
                            int currentRow = 0;
                            WkFgPanSeven.this.tabPressure.setModel((TableModel)new CustomTableModel(infos));
                            for (ArrayList row : infos) {
                                int maxLength = 0;
                                for (Object col : row) {
                                    if (String.valueOf(col).length() <= maxLength) continue;
                                    maxLength = String.valueOf(col).length();
                                }
                                if (maxLength > 44) {
                                    WkFgPanSeven.this.tabPressure.setRowHeight(currentRow, maxLength / 22 * 20);
                                }
                                ++currentRow;
                            }
                        }
                        catch (Exception e) {
                            WkFgPanSeven.this.LOG.error((Object)"Error while retrieving anh\u00f6rungs infos", (Throwable)e);
                        }
                    }
                };
                t.start();
            } else {
                this.tabPressure.setModel((TableModel)new CustomTableModel(new ArrayList<ArrayList>()));
            }
        } else {
            this.tabPressure.setModel((TableModel)new CustomTableModel(new ArrayList<ArrayList>()));
        }
    }

    public void dispose() {
    }

    public static class CustomTableModel
    implements TableModel {
        private static final String[] COLUMN_NAMES = new String[]{"Katalog-Nummer", "Name des Einwenders", "Nr. der Stellungnahme", "Nr. der Einzelforderung", "Bezug", "Einzelforderung", "erwiderte Einzelforderung", "Bemerkung"};
        private final List<TableModelListener> listener = new ArrayList<TableModelListener>();
        private final List<ArrayList> data;

        public CustomTableModel(List<ArrayList> data) {
            this.data = data;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex).get(columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        public void fireTableChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener tmp : this.listener) {
                tmp.tableChanged(e);
            }
        }
    }
}

