/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.tools.CacheException;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgPanSix;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgPanTen;
import de.cismet.cids.custom.wrrl_db_mv.util.QualityStatusCodeComparator;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;

public class WkFgPanThirteen
extends JPanel
implements DisposableCidsBeanStore,
ListSelectionListener {
    private static final Logger LOG = Logger.getLogger(WkFgPanTen.class);
    private final MstTableModel model = new MstTableModel();
    private CidsBean cidsBean;
    private DefaultBindableReferenceCombo cbEco_stat1;
    private DefaultBindableReferenceCombo cbPropOhne;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JTable jtMstTab1;
    private JLabel lblChemGesStat;
    private JLabel lblHeading;
    private JLabel lblPropOhne;
    private JLabel lblSpace;
    private JLabel lblTitle;
    private JLabel lblUQN8;
    private JPanel panAnl8;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JTextField txtHymoGkBemerkung3;
    private JTextField txtPropOhne;
    private BindingGroup bindingGroup;

    public WkFgPanThirteen() {
        this(false);
    }

    public WkFgPanThirteen(boolean readOnly) {
        this.initComponents();
        if (readOnly) {
            RendererTools.makeReadOnly(this.txtPropOhne);
            RendererTools.makeReadOnly(this.txtHymoGkBemerkung3);
            RendererTools.makeReadOnly((JComboBox)this.cbPropOhne);
            RendererTools.makeReadOnly((JComboBox)this.cbEco_stat1);
        }
        this.jScrollPane1.getViewport().setOpaque(false);
        this.jtMstTab1.getSelectionModel().addListSelectionListener(this);
        if (readOnly) {
            this.jtMstTab1.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    c.setForeground(Color.BLUE);
                    return c;
                }
            });
            this.jtMstTab1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = WkFgPanThirteen.this.jtMstTab1.rowAtPoint(e.getPoint());
                    if (row != -1) {
                        CidsBean mstBean;
                        int col = WkFgPanThirteen.this.jtMstTab1.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                        col = WkFgPanThirteen.this.jtMstTab1.convertColumnIndexToModel(col);
                        String columnName = WkFgPanThirteen.this.model.getColumnName(col);
                        row = WkFgPanThirteen.this.jtMstTab1.convertRowIndexToModel(row);
                        Object value = WkFgPanThirteen.this.model.getValueAt(row, col);
                        if (columnName.equalsIgnoreCase("MST") && row < WkFgPanThirteen.this.model.getData().size() && (mstBean = WkFgPanThirteen.this.model.getData().get(row)) != null && mstBean.getProperty("messstelle") instanceof CidsBean) {
                            ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObjectNode(new MetaObjectNode((CidsBean)mstBean.getProperty("messstelle")), false);
                        }
                    }
                }
            });
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.panInfoContent = new JPanel();
        this.lblSpace = new JLabel();
        this.lblTitle = new JLabel();
        this.txtPropOhne = new JTextField();
        this.cbPropOhne = new ScrollableComboBox(new QualityStatusCodeComparator(), true);
        this.lblPropOhne = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jtMstTab1 = new JTable();
        this.lblUQN8 = new JLabel();
        this.panAnl8 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.lblChemGesStat = new JLabel();
        this.cbEco_stat1 = new ScrollableComboBox(new QualityStatusCodeComparator(), true);
        this.txtHymoGkBemerkung3 = new JTextField();
        this.setMinimumSize(new Dimension(910, 650));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(910, 650));
        this.setLayout(new BorderLayout());
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText(NbBundle.getMessage(WkFgPanThirteen.class, (String)"WkFgPanThirteen.lblHeading.text"));
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setOpaque(false);
        this.panInfoContent.setMaximumSize(new Dimension(888, 400));
        this.panInfoContent.setMinimumSize(new Dimension(888, 400));
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setPreferredSize(new Dimension(888, 400));
        this.panInfoContent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.lblSpace, gridBagConstraints);
        this.lblTitle.setText(NbBundle.getMessage(WkFgPanThirteen.class, (String)"WkFgPanThirteen.lblTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        this.panInfoContent.add((Component)this.lblTitle, gridBagConstraints);
        this.txtPropOhne.setMinimumSize(new Dimension(300, 20));
        this.txtPropOhne.setPreferredSize(new Dimension(300, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.chem_uqn_bemerkung}"), (Object)this.txtPropOhne, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInfoContent.add((Component)this.txtPropOhne, gridBagConstraints);
        this.cbPropOhne.setMinimumSize(new Dimension(150, 20));
        this.cbPropOhne.setPreferredSize(new Dimension(150, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.cstnu}"), (Object)this.cbPropOhne, (Property)BeanProperty.create((String)"selectedItem"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        this.cbPropOhne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkFgPanThirteen.this.cbPropOhneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.cbPropOhne, gridBagConstraints);
        this.lblPropOhne.setText(NbBundle.getMessage(WkFgPanThirteen.class, (String)"WkFgPanThirteen.lblPropOhne.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panInfoContent.add((Component)this.lblPropOhne, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(800, 170));
        this.jScrollPane3.setOpaque(false);
        this.jScrollPane3.setPreferredSize(new Dimension(900, 170));
        this.jtMstTab1.setModel(this.model);
        this.jScrollPane3.setViewportView(this.jtMstTab1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        this.lblUQN8.setText(NbBundle.getMessage(WkFgPanThirteen.class, (String)"ChemieMstMessungenEditor.lblUQN6.text", (Object[])new Object[0]));
        this.lblUQN8.setToolTipText(NbBundle.getMessage(WkFgPanThirteen.class, (String)"ChemieMstMessungenEditor.lblUQN6.toolTipText", (Object[])new Object[0]));
        this.lblUQN8.setMinimumSize(new Dimension(380, 20));
        this.lblUQN8.setPreferredSize(new Dimension(380, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblUQN8, gridBagConstraints);
        this.panAnl8.setOpaque(false);
        this.panAnl8.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.panAnl8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panInfoContent.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panInfoContent.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblChemGesStat.setText(NbBundle.getMessage(WkFgPanThirteen.class, (String)"WkFgPanThirteen.lblChemGesStat.text"));
        this.lblChemGesStat.setToolTipText(NbBundle.getMessage(WkFgPanThirteen.class, (String)"WkFgPanThirteen.lblChemGesStat.toolTipText", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        this.jPanel3.add((Component)this.lblChemGesStat, gridBagConstraints);
        this.cbEco_stat1.setMinimumSize(new Dimension(150, 20));
        this.cbEco_stat1.setPreferredSize(new Dimension(150, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.chem_stat}"), (Object)this.cbEco_stat1, (Property)BeanProperty.create((String)"selectedItem"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        this.cbEco_stat1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkFgPanThirteen.this.cbEco_stat1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.jPanel3.add((Component)this.cbEco_stat1, gridBagConstraints);
        this.txtHymoGkBemerkung3.setMinimumSize(new Dimension(200, 20));
        this.txtHymoGkBemerkung3.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.chem_ges_bemerkung}"), (Object)this.txtHymoGkBemerkung3, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.jPanel3.add((Component)this.txtHymoGkBemerkung3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.panInfoContent.add((Component)this.jPanel3, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.panInfoContent);
        this.panInfo.add((Component)this.jScrollPane1, (Object)"Center");
        this.add((Component)this.panInfo, "Center");
        this.bindingGroup.bind();
    }

    private void cbPropOhneActionPerformed(ActionEvent evt) {
    }

    private void cbEco_stat1ActionPerformed(ActionEvent evt) {
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(final CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)this.cidsBean);
            this.model.fireTableDataChanged();
            final String chemGesBem = (String)cidsBean.getProperty("chem_ges_bemerkung");
            if (chemGesBem != null && chemGesBem.startsWith("http")) {
                this.txtHymoGkBemerkung3.setForeground(new Color(28, 72, 227));
                this.txtHymoGkBemerkung3.addMouseListener(new MouseAdapter(){
                    boolean isHandCursor = false;

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (chemGesBem != null) {
                            try {
                                BrowserLauncher.openURL((String)chemGesBem);
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)ex, (Throwable)ex);
                            }
                        }
                    }
                });
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WkFgPanThirteen.this.model.refreshData(cidsBean);
                }
            }).start();
            this.bindingGroup.bind();
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.jtMstTab1.getSelectedRow() > -1) {
            CidsBean sbean = this.model.getData().get(this.jtMstTab1.getSelectedRow());
            int mstId = (Integer)sbean.getProperty("messstelle.id");
            Integer messjahr = (Integer)sbean.getProperty("messjahr");
            List<CidsBean> anl8 = this.model.getStoff(mstId, messjahr, false);
            this.panAnl8.removeAll();
            if (anl8 == null || anl8.isEmpty()) {
                JLabel lblUQN8Val = new JLabel();
                lblUQN8Val.setMinimumSize(new Dimension(380, 20));
                lblUQN8Val.setPreferredSize(new Dimension(380, 20));
                lblUQN8Val.setText("keine UQN \u00dcberschreitungen");
                this.panAnl8.add((Component)lblUQN8Val, "Center");
            } else {
                UQNTable tab = new UQNTable(anl8);
                JScrollPane scrollPane = new JScrollPane((Component)((Object)tab));
                scrollPane.setMinimumSize(new Dimension(580, 200));
                scrollPane.setPreferredSize(new Dimension(580, 200));
                scrollPane.setOpaque(false);
                this.panAnl8.add((Component)scrollPane, "Center");
            }
        }
    }

    public static class UQNTable
    extends JXTable {
        public UQNTable(List<CidsBean> beans) {
            this.setModel(new CustomStoffTableModel(beans));
            this.initRenderer();
        }

        public UQNTable(List<CidsBean> beans, String[][] header) {
            this.setModel(new CustomStoffTableModel(beans, header));
            this.initRenderer();
        }

        private void initRenderer() {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component com = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof Number && com instanceof JLabel) {
                        DecimalFormat formatter = new DecimalFormat("0.########");
                        ((JLabel)com).setText(formatter.format(value));
                    }
                    return com;
                }
            };
            this.getColumn(1).setCellRenderer(renderer);
            this.getColumn(3).setCellRenderer(renderer);
        }

        private class CustomStoffTableModel
        extends AbstractTableModel {
            private String[][] header = new String[][]{{"Stoffname", "substance_code.name_de"}, {"Messwert", "messwert"}, {"Einheit", "einheit"}, {"Grenzwert", "grenzwert"}, {"UQN-Art", "uqn_type.value"}};
            private List<CidsBean> data = new ArrayList<CidsBean>();

            public CustomStoffTableModel(List<CidsBean> beans) {
                this.data = beans;
            }

            public CustomStoffTableModel(List<CidsBean> beans, String[][] header) {
                this.data = beans;
                this.header = header;
            }

            @Override
            public int getRowCount() {
                return this.data.size();
            }

            @Override
            public int getColumnCount() {
                return this.header.length;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.header[columnIndex][0];
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = this.data.get(rowIndex).getProperty(this.header[columnIndex][1]);
                if (value instanceof Number) {
                    DecimalFormat formatter = new DecimalFormat("0.########");
                    return formatter.format(value);
                }
                return value == null ? null : String.valueOf(value);
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }
        }
    }

    public static class MstTableModel
    extends AbstractTableModel {
        private String[][] header = new String[][]{{"MST", "messstelle.messstelle"}, {"WK", "wk_k"}, {"Jahr", "messjahr"}, {"UQN-\u00dcberschreitung", ""}};
        private List<CidsBean> data = new ArrayList<CidsBean>();
        private List<CidsBean> stoffData = new ArrayList<CidsBean>();
        private Boolean isInitialised = false;
        private CidsBean wkBean;
        private boolean anl6 = false;

        public MstTableModel() {
        }

        public MstTableModel(boolean anl6) {
            this.anl6 = anl6;
        }

        @Override
        public int getRowCount() {
            if (!this.isInitialised.booleanValue()) {
                return 1;
            }
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.header.length) {
                return this.header[columnIndex][0];
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (!this.isInitialised.booleanValue()) {
                return "lade ...";
            }
            if (rowIndex < this.data.size() && columnIndex < this.header.length) {
                if (columnIndex == 3) {
                    if (this.hasStoff((Integer)this.data.get(rowIndex).getProperty("messstelle.id"), (Integer)this.data.get(rowIndex).getProperty("messjahr"))) {
                        return "ja";
                    }
                    return "nein";
                }
                if (columnIndex == 1) {
                    if (this.wkBean != null) {
                        return (String)this.wkBean.getProperty("wk_k");
                    }
                    return "";
                }
                Object value = this.data.get(rowIndex).getProperty(this.header[columnIndex][1]);
                if (value != null) {
                    if (value instanceof CidsBean) {
                        return String.valueOf(((CidsBean)value).getProperty("name"));
                    }
                    if (value instanceof Boolean) {
                        return (Boolean)value != false ? "Ja" : "Nein";
                    }
                    return String.valueOf(value);
                }
                return "-";
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void refreshData(CidsBean cidsBean) {
            this.wkBean = cidsBean;
            this.data.clear();
            this.data.addAll(WkFgPanSix.getChemMst(cidsBean));
            this.stoffData.addAll(this.getChemMst(this.getIdsFromMstList(this.data)));
            this.isInitialised = true;
            this.fireTableDataChanged();
        }

        private boolean hasStoff(Integer mst, Integer year) {
            if (mst == null || year == null) {
                return false;
            }
            for (CidsBean stoff : this.stoffData) {
                Integer mstYear;
                if (stoff.getProperty("mst.id") == null || !stoff.getProperty("mst.id").equals(mst) || (mstYear = (Integer)stoff.getProperty("jahr_messung")) == null || !mstYear.equals(year)) continue;
                Boolean anl6Val = (Boolean)stoff.getProperty("substance_code.anl_6");
                Boolean anl8Val = (Boolean)stoff.getProperty("substance_code.anl_8");
                if ((!this.anl6 || anl6Val == null || !anl6Val.booleanValue()) && (this.anl6 || anl8Val == null || !anl8Val.booleanValue())) continue;
                return true;
            }
            return false;
        }

        public List<CidsBean> getStoff(Integer mst, Integer year, boolean anl6) {
            ArrayList<CidsBean> hits = new ArrayList<CidsBean>();
            if (mst == null || year == null) {
                return hits;
            }
            for (CidsBean stoff : this.stoffData) {
                Integer mstYear;
                if (!stoff.getProperty("mst.id").equals(mst) || (mstYear = (Integer)stoff.getProperty("jahr_messung")) == null || !mstYear.equals(year)) continue;
                Boolean anl6Val = (Boolean)stoff.getProperty("substance_code.anl_6");
                Boolean anl8Val = (Boolean)stoff.getProperty("substance_code.anl_8");
                if ((!anl6 || anl6Val == null || !anl6Val.booleanValue()) && (anl6 || anl8Val == null || !anl8Val.booleanValue())) continue;
                hits.add(stoff);
            }
            return hits;
        }

        private String getIdsFromMstList(List<CidsBean> mstList) {
            StringBuilder sb = null;
            for (CidsBean mst : mstList) {
                if (sb == null) {
                    sb = new StringBuilder(String.valueOf(mst.getProperty("messstelle.id")));
                    continue;
                }
                sb.append(",").append(String.valueOf(mst.getProperty("messstelle.id")));
            }
            return sb == null ? null : sb.toString();
        }

        private List<CidsBean> getChemMst(String mstIds) {
            ArrayList<CidsBean> data = new ArrayList<CidsBean>();
            if (mstIds == null) {
                return data;
            }
            try {
                MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"chemie_mst_stoff");
                if (MC != null) {
                    MetaObject[] metaObjects;
                    String query = "select " + MC.getID() + ", m." + MC.getPrimaryKey() + " from " + MC.getTableName();
                    query = query + " m";
                    query = query + " WHERE mst in (" + mstIds + ")";
                    for (MetaObject mo : metaObjects = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, MC, false, WkFgEditor.CONNECTION_CONTEXT)) {
                        data.add(mo.getBean());
                    }
                }
            }
            catch (CacheException e) {
                LOG.error((Object)"Error while trying to receive measurements.", (Throwable)e);
            }
            return data;
        }

        public List<CidsBean> getData() {
            return this.data;
        }

        public void clearModel() {
            this.data.clear();
        }
    }
}

