/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkGwMstChemieMessungenEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CoordinateConverter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class WkGwMstGueteStammdatenEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
FooterComponentProvider,
DocumentListener {
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"WkGwMstGueteStammdatenEditor");
    private static final Logger LOG = Logger.getLogger(WkGwMstGueteStammdatenEditor.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_gw_mst_chemie_messungen", (ConnectionContext)CC);
    private boolean readOnly = false;
    private CidsBean cidsBean;
    private boolean noDocumentUpdate = false;
    private volatile boolean urlExists = true;
    private JButton btnBack1;
    private JButton btnForward;
    private JPanel jPanel1;
    private JLabel lblBauj;
    private JLabel lblBaujVal;
    private JLabel lblFilterOb;
    private JLabel lblFilterObVal;
    private JLabel lblFilterUn;
    private JLabel lblFilterUnVal;
    private JLabel lblFoot;
    private JLabel lblGelHoehe;
    private JLabel lblGelHoeheVal;
    private JLabel lblGewVal;
    private JLabel lblHeading;
    private JLabel lblHoeheM;
    private JLabel lblHoeheMVal;
    private JLabel lblLageVal;
    private JLabel lblMstCodeVal;
    private JLabel lblMstKennz;
    private JLabel lblMstName;
    private JLabel lblReHo;
    private JLabel lblStatus;
    private JLabel lblStatusVal;
    private JLabel lblSteckbrief;
    private JLabel lblSteckbriefVal;
    private JLabel lblWkGw;
    private JLabel lblWkGwVal;
    private JPanel panFooter;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panScr;
    private JPanel panStamm;
    private JTextField txtJahr;
    private WkGwMstChemieMessungenEditor wkGwMstChemieMessungenEditor1;
    private BindingGroup bindingGroup;

    public WkGwMstGueteStammdatenEditor() {
        this(false);
    }

    public WkGwMstGueteStammdatenEditor(boolean readOnly) {
        this(readOnly, false);
    }

    public WkGwMstGueteStammdatenEditor(final boolean readOnly, boolean embedded) {
        this.readOnly = readOnly;
        this.initComponents();
        if (embedded) {
            this.panStamm.setVisible(false);
        }
        this.txtJahr.getDocument().addDocumentListener(this);
        if (readOnly) {
            this.lblWkGwVal.setForeground(Color.BLUE);
            this.lblWkGwVal.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CidsBean bean = (CidsBean)WkGwMstGueteStammdatenEditor.this.cidsBean.getProperty("wk_gw");
                    if (bean != null && readOnly) {
                        ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObjectNode(new MetaObjectNode(bean), false);
                    }
                }
            });
        }
    }

    public void setCidsBean(final CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            this.urlExists = true;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WkGwMstGueteStammdatenEditor.this.txtJahr.setText(String.valueOf(new GregorianCalendar().get(1)));
                }
            });
            this.refreshMeasures();
            this.bindingGroup.bind();
            final String url = "https://www.fis-wasser-mv.de/doku/gwk_steckbr/" + cidsBean.getProperty("messstelle") + ".pdf";
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WkGwMstGueteStammdatenEditor.this.lblSteckbriefVal.setText("<html><a href=\"" + url + "\">" + cidsBean.getProperty("messstelle") + "</a></html>");
                }
            });
            this.lblSteckbriefVal.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        if (WkGwMstGueteStammdatenEditor.this.urlExists) {
                            BrowserLauncher.openURL((String)url);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex, (Throwable)ex);
                    }
                }
            });
            Thread checkUrl = new Thread(){

                @Override
                public void run() {
                    try {
                        boolean check = WebAccessManager.getInstance().checkIfURLaccessible(new URL(url));
                        if (!check) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    WkGwMstGueteStammdatenEditor.this.lblSteckbriefVal.setText("kein Steckbrief vorhanden");
                                    WkGwMstGueteStammdatenEditor.this.urlExists = false;
                                }
                            });
                        }
                    }
                    catch (MalformedURLException e) {
                        LOG.error((Object)("URL invalid: " + url), (Throwable)e);
                    }
                }
            };
            checkUrl.start();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WkGwMstGueteStammdatenEditor.this.wkGwMstChemieMessungenEditor1.setCidsBeans(null, null);
                }
            });
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.panStamm = new JPanel();
        this.lblMstKennz = new JLabel();
        this.lblMstName = new JLabel();
        this.lblReHo = new JLabel();
        this.lblBauj = new JLabel();
        this.lblMstCodeVal = new JLabel();
        this.lblGewVal = new JLabel();
        this.lblLageVal = new JLabel();
        this.lblBaujVal = new JLabel();
        this.lblStatus = new JLabel();
        this.lblStatusVal = new JLabel();
        this.lblFilterOb = new JLabel();
        this.lblFilterObVal = new JLabel();
        this.lblFilterUnVal = new JLabel();
        this.lblFilterUn = new JLabel();
        this.lblGelHoehe = new JLabel();
        this.lblGelHoeheVal = new JLabel();
        this.lblHoeheMVal = new JLabel();
        this.lblHoeheM = new JLabel();
        this.lblSteckbrief = new JLabel();
        this.lblSteckbriefVal = new JLabel();
        this.lblWkGw = new JLabel();
        this.lblWkGwVal = new JLabel();
        this.panScr = new JPanel();
        this.txtJahr = new JTextField();
        this.btnBack1 = new JButton();
        this.btnForward = new JButton();
        this.wkGwMstChemieMessungenEditor1 = new WkGwMstChemieMessungenEditor();
        this.jPanel1 = new JPanel();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setMinimumSize(new Dimension(1400, 1200));
        this.setPreferredSize(new Dimension(1400, 1200));
        this.setLayout(new GridBagLayout());
        this.panInfo.setMinimumSize(new Dimension(1400, 1200));
        this.panInfo.setPreferredSize(new Dimension(1400, 1200));
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText("Messstation");
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.panStamm.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), "Stammdaten"));
        this.panStamm.setOpaque(false);
        this.panStamm.setLayout(new GridBagLayout());
        this.lblMstKennz.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblMstKennz.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblMstKennz, gridBagConstraints);
        this.lblMstName.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblMstName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblMstName, gridBagConstraints);
        this.lblReHo.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblReHo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblReHo, gridBagConstraints);
        this.lblBauj.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblBauj.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblBauj, gridBagConstraints);
        this.lblMstCodeVal.setMinimumSize(new Dimension(200, 20));
        this.lblMstCodeVal.setPreferredSize(new Dimension(200, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.messstelle}"), (Object)this.lblMstCodeVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblMstCodeVal, gridBagConstraints);
        this.lblGewVal.setMinimumSize(new Dimension(200, 20));
        this.lblGewVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.mst_name}"), (Object)this.lblGewVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblGewVal, gridBagConstraints);
        this.lblLageVal.setMinimumSize(new Dimension(200, 20));
        this.lblLageVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.the_geom}"), (Object)this.lblLageVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"/");
        binding.setSourceUnreadableValue((Object)"<error>");
        binding.setConverter((Converter)new CoordinateConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblLageVal, gridBagConstraints);
        this.lblBaujVal.setMinimumSize(new Dimension(200, 20));
        this.lblBaujVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.baujahr}"), (Object)this.lblBaujVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblBaujVal, gridBagConstraints);
        this.lblStatus.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstStammdatenEditor.lbStatus.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblStatus, gridBagConstraints);
        this.lblStatusVal.setMinimumSize(new Dimension(200, 20));
        this.lblStatusVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.status}"), (Object)this.lblStatusVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblStatusVal, gridBagConstraints);
        this.lblFilterOb.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblFilterOb.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblFilterOb, gridBagConstraints);
        this.lblFilterObVal.setMinimumSize(new Dimension(200, 20));
        this.lblFilterObVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.filter_bis} m"), (Object)this.lblFilterObVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblFilterObVal, gridBagConstraints);
        this.lblFilterUnVal.setMinimumSize(new Dimension(200, 20));
        this.lblFilterUnVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.filter_von} m"), (Object)this.lblFilterUnVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblFilterUnVal, gridBagConstraints);
        this.lblFilterUn.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblFilterUn.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblFilterUn, gridBagConstraints);
        this.lblGelHoehe.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblGelHoehe.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblGelHoehe, gridBagConstraints);
        this.lblGelHoeheVal.setMinimumSize(new Dimension(200, 20));
        this.lblGelHoeheVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gelaendehoehe} ${cidsBean.h_sys_gel.value}"), (Object)this.lblGelHoeheVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblGelHoeheVal, gridBagConstraints);
        this.lblHoeheMVal.setMinimumSize(new Dimension(200, 20));
        this.lblHoeheMVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hoehe_messpunkt} ${cidsBean.h_sys_mp.value}"), (Object)this.lblHoeheMVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblHoeheMVal, gridBagConstraints);
        this.lblHoeheM.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblHoeheM.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblHoeheM, gridBagConstraints);
        this.lblSteckbrief.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstStammdatenEditor.lbSteckbrief.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panStamm.add((Component)this.lblSteckbrief, gridBagConstraints);
        this.lblSteckbriefVal.setMinimumSize(new Dimension(200, 20));
        this.lblSteckbriefVal.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panStamm.add((Component)this.lblSteckbriefVal, gridBagConstraints);
        this.lblWkGw.setText(NbBundle.getMessage(WkGwMstGueteStammdatenEditor.class, (String)"WkGwMstMengeStammdatenEditor.lblWkGw.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblWkGw, gridBagConstraints);
        this.lblWkGwVal.setMinimumSize(new Dimension(200, 20));
        this.lblWkGwVal.setPreferredSize(new Dimension(200, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wk_gw.name}"), (Object)this.lblWkGwVal, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panStamm.add((Component)this.lblWkGwVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panInfoContent.add((Component)this.panStamm, gridBagConstraints);
        this.panScr.setOpaque(false);
        this.panScr.setLayout(new GridBagLayout());
        this.txtJahr.setMinimumSize(new Dimension(100, 20));
        this.txtJahr.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.txtJahr, gridBagConstraints);
        this.btnBack1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left.png")));
        this.btnBack1.setBorder(null);
        this.btnBack1.setBorderPainted(false);
        this.btnBack1.setContentAreaFilled(false);
        this.btnBack1.setFocusPainted(false);
        this.btnBack1.setMaximumSize(new Dimension(30, 30));
        this.btnBack1.setMinimumSize(new Dimension(30, 30));
        this.btnBack1.setPreferredSize(new Dimension(30, 30));
        this.btnBack1.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left-pressed.png")));
        this.btnBack1.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left-selected.png")));
        this.btnBack1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkGwMstGueteStammdatenEditor.this.btnBack1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.btnBack1, gridBagConstraints);
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right-pressed.png")));
        this.btnForward.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right-selected.png")));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkGwMstGueteStammdatenEditor.this.btnForwardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.btnForward, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.panInfoContent.add((Component)this.panScr, gridBagConstraints);
        this.wkGwMstChemieMessungenEditor1.setMinimumSize(new Dimension(1000, 600));
        this.wkGwMstChemieMessungenEditor1.setPreferredSize(new Dimension(1000, 600));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panInfoContent.add((Component)this.wkGwMstChemieMessungenEditor1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.jPanel1, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.panInfo, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnBack1ActionPerformed(ActionEvent evt) {
        int year = this.getCurrentlyEnteredYear();
        this.noDocumentUpdate = true;
        this.txtJahr.setText(String.valueOf(--year));
        this.noDocumentUpdate = false;
        final int newYear = year;
        WaitingDialogThread<YearAndMeasure> wdt = new WaitingDialogThread<YearAndMeasure>(StaticSwingTools.getParentFrame((Component)this), true, "Lade Messwerte", null, 100){

            protected YearAndMeasure doInBackground() throws Exception {
                CidsBean[] measure = null;
                int measureYear = newYear;
                while ((measure = WkGwMstGueteStammdatenEditor.this.getDataForYear(measureYear)) == null && --measureYear > 2000) {
                }
                return new YearAndMeasure(measure, ++measureYear);
            }

            protected void done() {
                try {
                    YearAndMeasure measure = (YearAndMeasure)this.get();
                    WkGwMstGueteStammdatenEditor.this.noDocumentUpdate = true;
                    WkGwMstGueteStammdatenEditor.this.txtJahr.setText(String.valueOf(measure.getYear()));
                    WkGwMstGueteStammdatenEditor.this.noDocumentUpdate = false;
                    WkGwMstGueteStammdatenEditor.this.showNewMeasure(measure.getMeasure());
                }
                catch (Exception e) {
                    LOG.error((Object)"Erro while searching measure values", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        int year = this.getCurrentlyEnteredYear();
        final int newYear = ++year;
        WaitingDialogThread<YearAndMeasure> wdt = new WaitingDialogThread<YearAndMeasure>(StaticSwingTools.getParentFrame((Component)this), true, "Lade Messwerte", null, 100){

            protected YearAndMeasure doInBackground() throws Exception {
                CidsBean[] measure = null;
                int measureYear = newYear;
                int currentYear = new GregorianCalendar().get(1);
                while ((measure = WkGwMstGueteStammdatenEditor.this.getDataForYear(measureYear)) == null && ++measureYear <= currentYear) {
                }
                return new YearAndMeasure(measure, --measureYear);
            }

            protected void done() {
                try {
                    YearAndMeasure measure = (YearAndMeasure)this.get();
                    WkGwMstGueteStammdatenEditor.this.noDocumentUpdate = true;
                    WkGwMstGueteStammdatenEditor.this.txtJahr.setText(String.valueOf(measure.getYear()));
                    WkGwMstGueteStammdatenEditor.this.noDocumentUpdate = false;
                    WkGwMstGueteStammdatenEditor.this.showNewMeasure(measure.getMeasure());
                }
                catch (Exception e) {
                    LOG.error((Object)"Erro while searching measure values", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void refreshMeasures() {
        int year = this.getCurrentlyEnteredYear();
        final CidsBean[] measure = this.getDataForYear(year);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WkGwMstGueteStammdatenEditor.this.showNewMeasure(measure);
            }
        });
    }

    private void showNewMeasure(CidsBean[] measure) {
        this.wkGwMstChemieMessungenEditor1.setCidsBeans(measure, this.cidsBean);
    }

    private int getCurrentlyEnteredYear() {
        try {
            return Integer.parseInt(this.txtJahr.getText());
        }
        catch (NumberFormatException e) {
            return new GregorianCalendar().get(1);
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        return String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    private CidsBean[] getDataForYear(int year) {
        try {
            String query = "select " + MC.getID() + ", m." + MC.getPrimaryKey() + " from " + MC.getTableName();
            query = query + " m WHERE m.mst = '" + this.cidsBean.getProperty("messstelle");
            query = query + "' AND date_part('year'::text, datum)::integer = " + year + " and (wert_no3 is not null or wert_ar is not null or wert_cd is not null or wert_pb is not null or wert_hg is not null or wert_nh4 is not null or wert_cl is not null or wert_no2 is not null or wert_po4 is not null or wert_so4 is not null or wert_cmhm is not null) order by datum asc";
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0, CC);
            if (metaObjects != null && metaObjects.length >= 0) {
                ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                for (MetaObject mo : metaObjects) {
                    CidsBean retVal = mo.getBean();
                    beans.add(retVal);
                }
                return beans.isEmpty() ? null : beans.toArray(new CidsBean[beans.size()]);
            }
            return null;
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Error while trying to receive measurements.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.noDocumentUpdate && e.getDocument().getLength() == 4) {
            this.refreshMeasures();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.noDocumentUpdate && e.getDocument().getLength() == 4) {
            this.refreshMeasures();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private static class YearAndMeasure {
        private CidsBean[] measure;
        private int year;

        public YearAndMeasure(CidsBean[] measure, int year) {
            this.measure = measure;
            this.year = year;
        }

        public CidsBean[] getMeasure() {
            return this.measure;
        }

        public void setMeasure(CidsBean[] measure) {
            this.measure = measure;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }
    }
}

