/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkKgMstMessungenPanOne;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.FooterComponentProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class WkKgJahresGkEditor
extends JPanel
implements CidsBeanRenderer,
EditorSaveListener,
FooterComponentProvider {
    private static final Logger LOG = Logger.getLogger(WkKgJahresGkEditor.class);
    private static final String[][] STOFF_HEADER = new String[][]{{"Stoffname", "substance_code.name_de"}, {"Messwert", "messwert"}, {"Einheit", "einheit"}, {"Grenzwert", "grenzwert"}, {"UQN-Art", "uqn_type.value"}, {"Jahr", "jahr_messung"}};
    private boolean readOnly = false;
    private CidsBean cidsBean;
    private JPanel jPanel4;
    private JLabel lblFoot;
    private JPanel panFooter;
    private WkKgMstMessungenPanOne wkKgMstMessungenPanOne1;

    public WkKgJahresGkEditor() {
        this(false);
    }

    public WkKgJahresGkEditor(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.clearForm();
        this.jPanel4.addMouseListener(new MouseAdapter(){
            boolean isHandCursor = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.isMouseOver(e)) {
                    try {
                        BrowserLauncher.openURL((String)"https://www.gesetze-im-internet.de/ogewv_2016/anlage_7.html");
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex, (Throwable)ex);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!this.isHandCursor && this.isMouseOver(e)) {
                    WkKgJahresGkEditor.this.jPanel4.setCursor(Cursor.getPredefinedCursor(12));
                    this.isHandCursor = true;
                } else if (this.isHandCursor) {
                    WkKgJahresGkEditor.this.jPanel4.setCursor(Cursor.getPredefinedCursor(0));
                    this.isHandCursor = false;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.isHandCursor) {
                    WkKgJahresGkEditor.this.jPanel4.setCursor(Cursor.getPredefinedCursor(0));
                    this.isHandCursor = false;
                }
            }

            private boolean isMouseOver(MouseEvent e) {
                return e.getPoint().x > 10 && e.getPoint().x < 85 && e.getPoint().y < 18;
            }
        });
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.setCidsBean(cidsBean, null);
    }

    public void setCidsBean(final CidsBean cidsBean, final CidsBean parent) {
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            if (!this.readOnly) {
                this.setEnable(true);
            }
            if (parent != null && !this.readOnly) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cidsBean.addPropertyChangeListener((PropertyChangeListener)new SubObjectPropertyChangedListener(parent));
                    }
                });
            }
        } else {
            if (!this.readOnly) {
                this.setEnable(false);
            }
            this.clearForm();
        }
        if (this.readOnly) {
            this.setEnable(false);
        }
        this.lblFoot.setText("");
        this.wkKgMstMessungenPanOne1.setCidsBean(cidsBean);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void clearForm() {
        this.lblFoot.setText("");
    }

    private void setEnable(final boolean enable) {
        EventQueue.invokeLater(new Thread("Enable editor"){

            @Override
            public void run() {
                WkKgJahresGkEditor.this.wkKgMstMessungenPanOne1.setEnable(enable);
            }
        });
    }

    private void initComponents() {
        this.panFooter = new JPanel();
        this.lblFoot = new JLabel();
        this.jPanel4 = new JPanel();
        this.wkKgMstMessungenPanOne1 = new WkKgMstMessungenPanOne();
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.lblFoot.setFont(new Font("Tahoma", 1, 12));
        this.lblFoot.setForeground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 25, 7, 25);
        this.panFooter.add((Component)this.lblFoot, gridBagConstraints);
        this.setMinimumSize(new Dimension(910, 1250));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(910, 1250));
        this.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), NbBundle.getMessage(WkKgJahresGkEditor.class, (String)"WkKgJahresGkEditor.jPanel4.border.title_1", (Object[])new Object[0]), 0, 0, new Font("Dialog", 0, 12), new Color(28, 72, 227)));
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanel4.add((Component)this.wkKgMstMessungenPanOne1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    public static void setColorOfField(JTextField mit, Number oD, boolean reverseColors, Color foregroundColor) {
        mit.setDisabledTextColor(new Color(139, 142, 143));
        mit.setBackground(new Color(245, 246, 247));
        if (mit.getText() == null || mit.getText().equals("") || mit.getText().equals("<nicht gesetzt>")) {
            mit.setBackground(new Color(245, 246, 247));
            return;
        }
        if (oD == null) {
            mit.setBackground(new Color(245, 246, 247));
            return;
        }
        try {
            double mitD = Double.parseDouble(mit.getText().replace(",", "."));
            if (reverseColors) {
                mit.setBackground(WkKgJahresGkEditor.calcColorReverse(mitD, oD.doubleValue()));
            } else {
                mit.setBackground(WkKgJahresGkEditor.calcColor(mitD, oD.doubleValue()));
            }
            if (mit.getBackground().equals(Color.RED)) {
                mit.setDisabledTextColor(new Color(255, 255, 255));
            }
        }
        catch (NumberFormatException e) {
            mit.setOpaque(false);
        }
    }

    public static Color calcColor(double mittel, double o) {
        if (mittel <= o) {
            return Color.GREEN;
        }
        return Color.RED;
    }

    public static Color calcColorReverse(double mittel, double o) {
        if (mittel >= o) {
            return Color.GREEN;
        }
        return Color.RED;
    }

    public void dispose() {
    }

    public String getTitle() {
        return String.valueOf(this.cidsBean);
    }

    public void setTitle(String title) {
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        return true;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public class SubObjectPropertyChangedListener
    implements PropertyChangeListener {
        private final CidsBean parent;

        public SubObjectPropertyChangedListener(CidsBean parent) {
            this.parent = parent;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.parent != null) {
                this.parent.setArtificialChangeFlag(true);
            }
        }
    }
}

