/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.tools.CacheException;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkKgBioDetailPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

public class WkKgPanBio
extends JPanel
implements DisposableCidsBeanStore,
ListSelectionListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(WkKgPanBio.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_kg_bio_mst_messungen");
    private final MstTableModel model = new MstTableModel();
    private CidsBean cidsBean;
    private int measureNumber = 0;
    private boolean noDocumentUpdate = false;
    private boolean readOnly = false;
    private final List<CidsBean> beansToSave = new ArrayList<CidsBean>();
    private JButton btnBack1;
    private JButton btnForward;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTable jtMstTab1;
    private JLabel lblHeading;
    private JLabel lblSpace;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panScr;
    private JTextField txtJahr;
    private WkKgBioDetailPanel wkKgBioDetailPanel1;

    public WkKgPanBio() {
        this(false);
    }

    WkKgPanBio(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.jtMstTab1.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel) {
                    if (value instanceof String && ((String)value).length() > 10) {
                        ((JLabel)c).setToolTipText(String.valueOf(value));
                    } else {
                        ((JLabel)c).setToolTipText(null);
                    }
                    if (!isSelected && column > 1) {
                        if (value != null && String.valueOf(value).equalsIgnoreCase("ja")) {
                            ((JLabel)c).setBackground(Color.GREEN);
                        } else if (value != null && String.valueOf(value).equalsIgnoreCase("nein")) {
                            ((JLabel)c).setBackground(Color.RED);
                        } else {
                            ((JLabel)c).setBackground(Color.WHITE);
                        }
                    } else if (!isSelected) {
                        ((JLabel)c).setBackground(Color.WHITE);
                    }
                }
                return c;
            }
        });
        this.wkKgBioDetailPanel1.setCidsBean(null);
        this.jScrollPane1.getViewport().setOpaque(false);
        this.jtMstTab1.getSelectionModel().addListSelectionListener(this);
        this.txtJahr.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.panInfoContent = new JPanel();
        this.lblSpace = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jtMstTab1 = new JTable();
        this.jPanel1 = new JPanel();
        this.panScr = new JPanel();
        this.txtJahr = new JTextField();
        this.btnBack1 = new JButton();
        this.btnForward = new JButton();
        this.wkKgBioDetailPanel1 = new WkKgBioDetailPanel();
        this.setMinimumSize(new Dimension(910, 580));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(910, 580));
        this.setLayout(new BorderLayout());
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText("Chemisches Monitoring");
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setOpaque(false);
        this.panInfoContent.setMaximumSize(new Dimension(777, 400));
        this.panInfoContent.setMinimumSize(new Dimension(777, 400));
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setPreferredSize(new Dimension(777, 400));
        this.panInfoContent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.lblSpace, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(800, 250));
        this.jScrollPane3.setOpaque(false);
        this.jScrollPane3.setPreferredSize(new Dimension(800, 250));
        this.jtMstTab1.setModel(this.model);
        this.jScrollPane3.setViewportView(this.jtMstTab1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 15, 10);
        this.panInfoContent.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Messwerte"));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.panScr.setOpaque(false);
        this.panScr.setLayout(new GridBagLayout());
        this.txtJahr.setMinimumSize(new Dimension(100, 20));
        this.txtJahr.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.txtJahr, gridBagConstraints);
        this.btnBack1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left.png")));
        this.btnBack1.setBorder(null);
        this.btnBack1.setBorderPainted(false);
        this.btnBack1.setContentAreaFilled(false);
        this.btnBack1.setFocusPainted(false);
        this.btnBack1.setMaximumSize(new Dimension(30, 30));
        this.btnBack1.setMinimumSize(new Dimension(30, 30));
        this.btnBack1.setPreferredSize(new Dimension(30, 30));
        this.btnBack1.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left-pressed.png")));
        this.btnBack1.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-left-selected.png")));
        this.btnBack1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanBio.this.btnBack1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.btnBack1, gridBagConstraints);
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right-pressed.png")));
        this.btnForward.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/arrow-right-selected.png")));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanBio.this.btnForwardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panScr.add((Component)this.btnForward, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.jPanel1.add((Component)this.panScr, gridBagConstraints);
        this.wkKgBioDetailPanel1.setMinimumSize(new Dimension(1400, 300));
        this.wkKgBioDetailPanel1.setPreferredSize(new Dimension(1400, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.wkKgBioDetailPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panInfoContent.add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.panInfoContent);
        this.panInfo.add((Component)this.jScrollPane1, (Object)"Center");
        this.add((Component)this.panInfo, "Center");
    }

    private void btnBack1ActionPerformed(ActionEvent evt) {
        int year = this.getCurrentlyEnteredYear();
        if (--this.measureNumber < 0) {
            this.measureNumber = 0;
            --year;
        }
        this.noDocumentUpdate = true;
        this.txtJahr.setText(String.valueOf(year));
        this.noDocumentUpdate = false;
        final int newYear = year;
        WaitingDialogThread<YearAndMeasure> wdt = new WaitingDialogThread<YearAndMeasure>(StaticSwingTools.getParentFrame((Component)this), true, "Lade Messwerte", null, 100){

            protected YearAndMeasure doInBackground() throws Exception {
                CidsBean measure = null;
                int measureYear = newYear;
                while ((measure = WkKgPanBio.this.getDataForYear(measureYear, WkKgPanBio.this.measureNumber)) == null && --measureYear > 1990) {
                }
                return new YearAndMeasure(measure, ++measureYear);
            }

            protected void done() {
                try {
                    YearAndMeasure measure = (YearAndMeasure)this.get();
                    WkKgPanBio.this.noDocumentUpdate = true;
                    WkKgPanBio.this.txtJahr.setText(String.valueOf(measure.getYear()));
                    WkKgPanBio.this.noDocumentUpdate = false;
                    WkKgPanBio.this.showNewMeasure(measure.getMeasure());
                }
                catch (Exception e) {
                    LOG.error((Object)"Erro while searching measure values", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        final int year = this.getCurrentlyEnteredYear();
        ++this.measureNumber;
        WaitingDialogThread<YearAndMeasure> wdt = new WaitingDialogThread<YearAndMeasure>(StaticSwingTools.getParentFrame((Component)this), true, "Lade Messwerte", null, 100){

            protected YearAndMeasure doInBackground() throws Exception {
                CidsBean measure = WkKgPanBio.this.getDataForYear(year, WkKgPanBio.this.measureNumber);
                if (measure == null) {
                    WkKgPanBio.this.measureNumber = 0;
                    int measureYear = year + 1;
                    measure = null;
                    int currentYear = new GregorianCalendar().get(1);
                    while ((measure = WkKgPanBio.this.getDataForYear(measureYear, WkKgPanBio.this.measureNumber)) == null && ++measureYear <= currentYear) {
                    }
                    return new YearAndMeasure(measure, --measureYear);
                }
                return new YearAndMeasure(measure, year);
            }

            protected void done() {
                try {
                    YearAndMeasure measure = (YearAndMeasure)this.get();
                    WkKgPanBio.this.noDocumentUpdate = true;
                    WkKgPanBio.this.txtJahr.setText(String.valueOf(measure.getYear()));
                    WkKgPanBio.this.noDocumentUpdate = false;
                    WkKgPanBio.this.showNewMeasure(measure.getMeasure());
                }
                catch (Exception e) {
                    LOG.error((Object)"Erro while searching measure values", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private int getCurrentlyEnteredYear() {
        try {
            return Integer.parseInt(this.txtJahr.getText());
        }
        catch (NumberFormatException e) {
            this.txtJahr.setText(String.valueOf(new GregorianCalendar().get(1)));
            return new GregorianCalendar().get(1);
        }
    }

    private CidsBean getDataForYear(int year, int number) {
        int row = this.jtMstTab1.getSelectedRow();
        if (row != -1) {
            row = this.jtMstTab1.convertRowIndexToModel(row);
            CidsBean mstStamm = ((MstTableModel)this.jtMstTab1.getModel()).getData().get(row);
            ArrayList<CidsBean> beansFromYear = new ArrayList<CidsBean>();
            List messungen = (List)mstStamm.getProperty("messungen");
            for (CidsBean bean : messungen) {
                if (bean.getProperty("jahr") == null || !bean.getProperty("jahr").equals(year)) continue;
                beansFromYear.add(bean);
            }
            if (beansFromYear != null && number >= 0 && number < beansFromYear.size()) {
                CidsBean retVal = (CidsBean)beansFromYear.get(number);
                int index = -1;
                index = this.beansToSave.indexOf(retVal);
                if (index != -1) {
                    return this.beansToSave.get(index);
                }
                this.beansToSave.add(retVal);
                return retVal;
            }
            return null;
        }
        return null;
    }

    private void showNewMeasure(CidsBean measure) {
        this.saveLastMeasure();
        this.wkKgBioDetailPanel1.setCidsBean(measure, this.cidsBean);
    }

    private void saveLastMeasure() {
        CidsBean lastMeasure;
        if (!this.readOnly && (lastMeasure = this.wkKgBioDetailPanel1.getCidsBean()) != null && !this.beansToSave.contains(lastMeasure)) {
            this.beansToSave.add(lastMeasure);
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(final CidsBean cidsBean) {
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            this.model.fireTableDataChanged();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WkKgPanBio.this.model.refreshData(cidsBean);
                }
            }).start();
            this.refreshMeasures();
        }
    }

    public void dispose() {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.jtMstTab1.getSelectedRow() > -1) {
            CidsBean sbean = this.model.getData().get(this.jtMstTab1.getSelectedRow());
            this.refreshMeasures();
        }
    }

    public static synchronized List<CidsBean> getBioMst(CidsBean cidsBean) {
        ArrayList<CidsBean> data = new ArrayList<CidsBean>();
        try {
            MetaObject[] metaObjects;
            MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_kg_mst_stammdaten");
            String query = "select " + MC.getID() + ", m." + MC.getPrimaryKey() + " from " + MC.getTableName();
            query = query + " m";
            query = query + " WHERE m.wk_kg = " + cidsBean.getProperty("id");
            query = query + " order by messstelle";
            for (MetaObject mo : metaObjects = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, MC, false, WkFgEditor.CONNECTION_CONTEXT)) {
                data.add(mo.getBean());
            }
        }
        catch (CacheException e) {
            LOG.error((Object)"Error while trying to receive measurements.", (Throwable)e);
        }
        return data;
    }

    private void refreshMeasures() {
        int year = this.getCurrentlyEnteredYear();
        this.measureNumber = 0;
        final CidsBean measure = this.getDataForYear(year, this.measureNumber);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WkKgPanBio.this.showNewMeasure(measure);
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.noDocumentUpdate && e.getDocument().getLength() == 4) {
            this.refreshMeasures();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.noDocumentUpdate && e.getDocument().getLength() == 4) {
            this.refreshMeasures();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private static class YearAndMeasure {
        private CidsBean measure;
        private int year;

        public YearAndMeasure(CidsBean measure, int year) {
            this.measure = measure;
            this.year = year;
        }

        public CidsBean getMeasure() {
            return this.measure;
        }

        public void setMeasure(CidsBean measure) {
            this.measure = measure;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }
    }

    public class MstTableModel
    extends AbstractTableModel {
        private final String[][] HEADER = new String[][]{{"WK", "wk_k"}, {"MST", "messstelle"}, {"Phytoplankton", "ppt_class"}, {"Gro\u00dfalgen und Angiospermen", "phyb_class"}, {"Benthische wirbellose Fauna", "mzb_class"}};
        private List<CidsBean> data = new ArrayList<CidsBean>();
        private boolean isInitialised = false;
        private CidsBean wkBean = null;

        @Override
        public int getRowCount() {
            if (!this.isInitialised) {
                return 1;
            }
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.HEADER.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.HEADER.length) {
                return this.HEADER[columnIndex][0];
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (!this.isInitialised) {
                return "lade ...";
            }
            if (rowIndex < this.data.size() && columnIndex < this.HEADER.length) {
                if (columnIndex == 0) {
                    return WkKgPanBio.this.cidsBean.getProperty("wk_k");
                }
                if (columnIndex == 2 || columnIndex == 3 || columnIndex == 4) {
                    List messungenBean = (List)this.data.get(rowIndex).getProperty("messungen");
                    boolean found = false;
                    for (CidsBean mBean : messungenBean) {
                        if (mBean.getProperty(this.HEADER[columnIndex][1]) == null) continue;
                        found = true;
                        break;
                    }
                    return found ? "Ja" : "Nein";
                }
                Object value = this.data.get(rowIndex).getProperty(this.HEADER[columnIndex][1]);
                if (value != null) {
                    if (value instanceof CidsBean) {
                        return String.valueOf(((CidsBean)value).getProperty("name"));
                    }
                    return String.valueOf(value);
                }
                return "-";
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void refreshData(CidsBean cidsBean) {
            this.wkBean = cidsBean;
            this.data.clear();
            this.data.addAll(WkKgPanBio.getBioMst(cidsBean));
            this.isInitialised = true;
            this.fireTableDataChanged();
        }

        public List<CidsBean> getData() {
            return this.data;
        }

        public void clearModel() {
            this.data.clear();
        }
    }
}

