/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgPanOne;
import de.cismet.cids.custom.wrrl_db_mv.server.search.PressureImpactsProposals;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.DefaultBindableScrollableComboboxCellEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.RendererTools;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;
import de.cismet.cids.custom.wrrl_db_mv.util.UIUtil;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;

public class WkKgPanOne
extends JPanel
implements DisposableCidsBeanStore {
    private static final Logger LOG = Logger.getLogger(WkKgPanOne.class);
    private static final MetaClass WHY_HMWB_MC;
    private static final MetaClass IMPACT_SRC_MC;
    private static final MetaClass IMPACT_CODE_MC;
    private static final MetaClass DRIVER_MC;
    private static final MetaClass SUBSTANCE_CODE_MC;
    private static Map<Integer, Set<Integer>> pressureImpactMap;
    private static Map<WkFgPanOne.PressureImpact, Set<Integer>> pressureImpactDriverMap;
    private static final ConnectionContext CC;
    private boolean readOnly = false;
    private CidsBean cidsBean;
    private JButton btnAddImpactSrc;
    private JButton btnAddWhyHmwb;
    private JButton btnMenImpactSrcAbort;
    private JButton btnMenImpactSrcOk;
    private JButton btnMenWhyHmwbAbort;
    private JButton btnMenWhyHmwbOk;
    private JButton btnRemImpactSrc;
    private JButton btnRemWhyHmwb;
    private JComboBox cbImpactSrcCataloge;
    private JComboBox cbWhyHmwbSrcCataloge;
    private DefaultBindableReferenceCombo defaultBindableReferenceCombo1;
    private DefaultBindableReferenceCombo defaultBindableReferenceCombo2;
    private JDialog dlgImpactSrc1Cataloge;
    private JDialog dlgWhyHmwbsCataloge;
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTextArea jTextArea1;
    private JLabel labWebsite;
    private JLabel lblArtificialKey;
    private JLabel lblArtificialValue;
    private JLabel lblHeading;
    private JLabel lblImpactSrcCataloge;
    private JLabel lblModifiedKey;
    private JLabel lblNameKey;
    private JLabel lblPredecKey;
    private JLabel lblTheGeomKey;
    private JLabel lblTyCdCwKey;
    private JLabel lblTyMvKey;
    private JLabel lblWebsite;
    private JLabel lblWhyHmwbCataloge;
    private JLabel lblWhyHmwbKey;
    private JList lstWhyHmwbs;
    private JPanel panContrImpactSrc;
    private JPanel panContrWhyHmwb;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panMenButtonsImpactSrc;
    private JPanel panMenButtonsWhyHmwb;
    private JPanel panPressure;
    private JPanel panSpacerBottom;
    private JScrollPane scpWhyHmwbs;
    private JXTable tabPressure;
    private JTextField txtName;
    private JTextField txtTyMv;
    private BindingGroup bindingGroup;

    public WkKgPanOne() {
        this(false);
    }

    public WkKgPanOne(boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        if (readOnly) {
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtTyMv);
            RendererTools.makeReadOnly((JComboBox)this.defaultBindableReferenceCombo1);
            RendererTools.makeReadOnly((JComboBox)this.defaultBindableReferenceCombo2);
            this.panContrImpactSrc.setVisible(false);
            this.panContrWhyHmwb.setVisible(false);
            this.lblTheGeomKey.setVisible(false);
            this.jComboBox1.setVisible(false);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.dlgWhyHmwbsCataloge = new JDialog(StaticSwingTools.getParentFrame((Component)this));
        this.lblWhyHmwbCataloge = new JLabel();
        DefaultBindableReferenceCombo cb2 = new DefaultBindableReferenceCombo(WHY_HMWB_MC, true, true);
        this.cbWhyHmwbSrcCataloge = cb2;
        this.panMenButtonsWhyHmwb = new JPanel();
        this.btnMenWhyHmwbAbort = new JButton();
        this.btnMenWhyHmwbOk = new JButton();
        this.dlgImpactSrc1Cataloge = new JDialog(StaticSwingTools.getParentFrame((Component)this));
        this.lblImpactSrcCataloge = new JLabel();
        ScrollableComboBox cb3 = new ScrollableComboBox(IMPACT_SRC_MC, false, false);
        this.cbImpactSrcCataloge = cb3;
        this.panMenButtonsImpactSrc = new JPanel();
        this.btnMenImpactSrcAbort = new JButton();
        this.btnMenImpactSrcOk = new JButton();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblNameKey = new JLabel();
        this.txtName = new JTextField();
        this.defaultBindableReferenceCombo1 = new DefaultBindableReferenceCombo();
        this.lblTyCdCwKey = new JLabel();
        this.lblModifiedKey = new JLabel();
        this.defaultBindableReferenceCombo2 = new DefaultBindableReferenceCombo();
        this.jPanel4 = new JPanel();
        this.scpWhyHmwbs = new JScrollPane();
        this.lstWhyHmwbs = new JList();
        this.lblWhyHmwbKey = new JLabel();
        this.panContrWhyHmwb = new JPanel();
        this.btnAddWhyHmwb = new JButton();
        this.btnRemWhyHmwb = new JButton();
        this.lblTyMvKey = new JLabel();
        this.txtTyMv = new JTextField();
        this.labWebsite = new JLabel();
        this.lblWebsite = new JLabel();
        this.panSpacerBottom = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.lblArtificialKey = new JLabel();
        this.lblPredecKey = new JLabel();
        this.jComboBox1 = this.readOnly ? new JComboBox() : new DefaultCismapGeometryComboBoxEditor();
        this.jPanel5 = new JPanel();
        this.lblTheGeomKey = new JLabel();
        this.lblArtificialValue = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.panPressure = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tabPressure = new JXTable();
        this.panContrImpactSrc = new JPanel();
        this.btnAddImpactSrc = new JButton();
        this.btnRemImpactSrc = new JButton();
        this.dlgWhyHmwbsCataloge.getContentPane().setLayout(new GridBagLayout());
        this.lblWhyHmwbCataloge.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblWhyHmwbCataloge.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgWhyHmwbsCataloge.getContentPane().add((Component)this.lblWhyHmwbCataloge, gridBagConstraints);
        this.cbWhyHmwbSrcCataloge.setMinimumSize(new Dimension(250, 18));
        this.cbWhyHmwbSrcCataloge.setPreferredSize(new Dimension(250, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgWhyHmwbsCataloge.getContentPane().add((Component)this.cbWhyHmwbSrcCataloge, gridBagConstraints);
        this.panMenButtonsWhyHmwb.setLayout(new GridBagLayout());
        this.btnMenWhyHmwbAbort.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.btnMenWhyHmwbAbort.text"));
        this.btnMenWhyHmwbAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnMenWhyHmwbAbortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtonsWhyHmwb.add((Component)this.btnMenWhyHmwbAbort, gridBagConstraints);
        this.btnMenWhyHmwbOk.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.btnMenWhyHmwbOk.text"));
        this.btnMenWhyHmwbOk.setMaximumSize(new Dimension(85, 23));
        this.btnMenWhyHmwbOk.setMinimumSize(new Dimension(85, 23));
        this.btnMenWhyHmwbOk.setPreferredSize(new Dimension(85, 23));
        this.btnMenWhyHmwbOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnMenWhyHmwbOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtonsWhyHmwb.add((Component)this.btnMenWhyHmwbOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgWhyHmwbsCataloge.getContentPane().add((Component)this.panMenButtonsWhyHmwb, gridBagConstraints);
        this.dlgImpactSrc1Cataloge.getContentPane().setLayout(new GridBagLayout());
        this.lblImpactSrcCataloge.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblImpactSrcCataloge.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgImpactSrc1Cataloge.getContentPane().add((Component)this.lblImpactSrcCataloge, gridBagConstraints);
        this.cbImpactSrcCataloge.setMinimumSize(new Dimension(450, 18));
        this.cbImpactSrcCataloge.setPreferredSize(new Dimension(450, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgImpactSrc1Cataloge.getContentPane().add((Component)this.cbImpactSrcCataloge, gridBagConstraints);
        this.panMenButtonsImpactSrc.setLayout(new GridBagLayout());
        this.btnMenImpactSrcAbort.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.btnMenImpactSrcAbort.text"));
        this.btnMenImpactSrcAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnMenImpactSrcAbortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtonsImpactSrc.add((Component)this.btnMenImpactSrcAbort, gridBagConstraints);
        this.btnMenImpactSrcOk.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.btnMenImpactSrcOk.text"));
        this.btnMenImpactSrcOk.setMaximumSize(new Dimension(85, 23));
        this.btnMenImpactSrcOk.setMinimumSize(new Dimension(85, 23));
        this.btnMenImpactSrcOk.setPreferredSize(new Dimension(85, 23));
        this.btnMenImpactSrcOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnMenImpactSrcOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtonsImpactSrc.add((Component)this.btnMenImpactSrcOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgImpactSrc1Cataloge.getContentPane().add((Component)this.panMenButtonsImpactSrc, gridBagConstraints);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblHeading.text"));
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblNameKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblNameKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblNameKey, gridBagConstraints);
        this.txtName.setMinimumSize(new Dimension(250, 20));
        this.txtName.setPreferredSize(new Dimension(250, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"null");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.txtName, gridBagConstraints);
        this.defaultBindableReferenceCombo1.setMinimumSize(new Dimension(250, 20));
        this.defaultBindableReferenceCombo1.setPreferredSize(new Dimension(250, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ty_cd_cw}"), (Object)this.defaultBindableReferenceCombo1, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.defaultBindableReferenceCombo1, gridBagConstraints);
        this.lblTyCdCwKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblTyCdCwKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblTyCdCwKey, gridBagConstraints);
        this.lblModifiedKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblModifiedKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblModifiedKey, gridBagConstraints);
        this.defaultBindableReferenceCombo2.setMinimumSize(new Dimension(250, 20));
        this.defaultBindableReferenceCombo2.setPreferredSize(new Dimension(250, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.modified}"), (Object)this.defaultBindableReferenceCombo2, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.defaultBindableReferenceCombo2, gridBagConstraints);
        this.jPanel4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.scpWhyHmwbs.setMinimumSize(new Dimension(250, 80));
        this.scpWhyHmwbs.setPreferredSize(new Dimension(250, 80));
        this.lstWhyHmwbs.setSelectionMode(0);
        ELProperty eLProperty = ELProperty.create((String)"${cidsBean.why_hmwbs}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstWhyHmwbs);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.scpWhyHmwbs.setViewportView(this.lstWhyHmwbs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.scpWhyHmwbs, gridBagConstraints);
        this.lblWhyHmwbKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblWhyHmwbKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblWhyHmwbKey, gridBagConstraints);
        this.panContrWhyHmwb.setOpaque(false);
        this.panContrWhyHmwb.setLayout(new GridBagLayout());
        this.btnAddWhyHmwb.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_add_mini.png")));
        this.btnAddWhyHmwb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnAddWhyHmwbActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panContrWhyHmwb.add((Component)this.btnAddWhyHmwb, gridBagConstraints);
        this.btnRemWhyHmwb.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png")));
        this.btnRemWhyHmwb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnRemWhyHmwbActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panContrWhyHmwb.add((Component)this.btnRemWhyHmwb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        this.jPanel2.add((Component)this.panContrWhyHmwb, gridBagConstraints);
        this.lblTyMvKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblTyMvKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblTyMvKey, gridBagConstraints);
        this.txtTyMv.setMinimumSize(new Dimension(250, 20));
        this.txtTyMv.setPreferredSize(new Dimension(250, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ty_mv}"), (Object)this.txtTyMv, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.txtTyMv, gridBagConstraints);
        this.labWebsite.setCursor(new Cursor(12));
        this.labWebsite.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WkKgPanOne.this.labWebsiteMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.labWebsite, gridBagConstraints);
        this.lblWebsite.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblWebsite.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.lblWebsite, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.jPanel2, gridBagConstraints);
        this.panSpacerBottom.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.panSpacerBottom, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(25, 5, 25, 5);
        this.panInfoContent.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblArtificialKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblArtificialKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblArtificialKey, gridBagConstraints);
        this.lblPredecKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblPredecKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblPredecKey, gridBagConstraints);
        if (!this.readOnly) {
            this.jComboBox1.setMinimumSize(new Dimension(300, 20));
            this.jComboBox1.setPreferredSize(new Dimension(300, 20));
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.the_geom}"), (Object)this.jComboBox1, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.jComboBox1).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jComboBox1, gridBagConstraints);
        this.jPanel5.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.lblTheGeomKey.setText(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.lblTheGeomKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblTheGeomKey, gridBagConstraints);
        this.lblArtificialValue.setMinimumSize(new Dimension(300, 20));
        this.lblArtificialValue.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.artificial.name}"), (Object)this.lblArtificialValue, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"null");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.lblArtificialValue, gridBagConstraints);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wb_predecs}"), (Object)this.jTextArea1, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.jPanel1, gridBagConstraints);
        this.panPressure.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WkKgPanOne.class, (String)"WkKgPanOne.panPressure.border.title", (Object[])new Object[0])));
        this.panPressure.setMinimumSize(new Dimension(110, 300));
        this.panPressure.setOpaque(false);
        this.panPressure.setPreferredSize(new Dimension(110, 300));
        this.panPressure.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView((Component)this.tabPressure);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPressure.add((Component)this.jScrollPane2, gridBagConstraints);
        this.panContrImpactSrc.setOpaque(false);
        this.panContrImpactSrc.setLayout(new GridBagLayout());
        this.btnAddImpactSrc.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_add_mini.png")));
        this.btnAddImpactSrc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnAddImpactSrcActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panContrImpactSrc.add((Component)this.btnAddImpactSrc, gridBagConstraints);
        this.btnRemImpactSrc.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/edit_remove_mini.png")));
        this.btnRemImpactSrc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkKgPanOne.this.btnRemImpactSrcActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panContrImpactSrc.add((Component)this.btnRemImpactSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panPressure.add((Component)this.panContrImpactSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.panPressure, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        this.add((Component)this.panInfo, "Center");
        this.bindingGroup.bind();
    }

    private void btnAddWhyHmwbActionPerformed(ActionEvent evt) {
        this.dlgWhyHmwbsCataloge.pack();
        StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)this), (JDialog)this.dlgWhyHmwbsCataloge, (boolean)true);
    }

    private void btnRemWhyHmwbActionPerformed(ActionEvent evt) {
        int answer;
        Object selection = this.lstWhyHmwbs.getSelectedValue();
        if (selection != null && (answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Soll der Eintrag wirklich gel\u00f6scht werden?", "Eintrag entfernen", 0)) == 0) {
            try {
                CidsBean beanToDelete = (CidsBean)selection;
                Object beanColl = this.cidsBean.getProperty("why_hmwbs");
                if (beanColl instanceof Collection) {
                    ((Collection)beanColl).remove(beanToDelete);
                }
            }
            catch (Exception e) {
                UIUtil.showExceptionToUser(e, this);
            }
        }
    }

    private void btnMenWhyHmwbAbortActionPerformed(ActionEvent evt) {
        this.dlgWhyHmwbsCataloge.setVisible(false);
    }

    private void btnMenWhyHmwbOkActionPerformed(ActionEvent evt) {
        Object selection = this.cbWhyHmwbSrcCataloge.getSelectedItem();
        if (selection instanceof CidsBean) {
            CidsBean selectedBean = (CidsBean)selection;
            List<CidsBean> colToAdd = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "why_hmwbs");
            if (colToAdd != null && !colToAdd.contains(selectedBean)) {
                colToAdd.add(selectedBean);
            }
        }
        this.dlgWhyHmwbsCataloge.setVisible(false);
    }

    private void labWebsiteMouseClicked(MouseEvent evt) {
        try {
            BrowserLauncher.openURL((String)("https://fis-wasser-mv.de/charts/steckbriefe/cw/cw_wk.php?kg=" + String.valueOf(this.cidsBean.getProperty("wk_k"))));
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
        }
    }

    private void btnAddImpactSrcActionPerformed(ActionEvent evt) {
        this.dlgImpactSrc1Cataloge.setSize(500, 150);
        StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)this), (JDialog)this.dlgImpactSrc1Cataloge, (boolean)true);
    }

    private void btnRemImpactSrcActionPerformed(ActionEvent evt) {
        int answer;
        int selectedRow = this.tabPressure.getSelectedRow();
        CidsBean selection = ((WkFgPanOne.PressureTableModel)this.tabPressure.getModel()).getCidsBean(selectedRow);
        if (selection != null && (answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Soll die Beslastungsquelle '" + selection.toString() + "' wirklich gel\u00f6scht werden?", "Belastungsquelle entfernen", 0)) == 0) {
            try {
                Object beanColl = this.cidsBean.getProperty("pressure_impact_driver");
                if (beanColl instanceof Collection && selection != null) {
                    ((Collection)beanColl).remove(selection);
                    this.setModel();
                }
            }
            catch (Exception e) {
                UIUtil.showExceptionToUser(e, this);
            }
        }
    }

    private void btnMenImpactSrcAbortActionPerformed(ActionEvent evt) {
        this.dlgImpactSrc1Cataloge.setVisible(false);
    }

    private void btnMenImpactSrcOkActionPerformed(ActionEvent evt) {
        Object selection = this.cbImpactSrcCataloge.getSelectedItem();
        try {
            if (selection instanceof CidsBean) {
                CidsBean selectedBean = (CidsBean)selection;
                CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("wk_fg_pressure_impact_driver");
                newBean.setProperty("pressure", (Object)selectedBean);
                List<CidsBean> colToAdd = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "pressure_impact_driver");
                if (colToAdd != null) {
                    colToAdd.add(newBean);
                    this.setModel();
                }
            }
            this.dlgImpactSrc1Cataloge.setVisible(false);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create new cids bean", (Throwable)e);
        }
    }

    private static void initProposals() {
        try {
            PressureImpactsProposals search = new PressureImpactsProposals();
            search.initWithConnectionContext(CC);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, CC);
            ArrayList list = (ArrayList)res;
            if (list != null) {
                for (ArrayList row : list) {
                    Integer pressure = (Integer)row.get(0);
                    Integer impact = (Integer)row.get(1);
                    Integer driver = (Integer)row.get(2);
                    if (pressure == null || impact == null) continue;
                    WkFgPanOne.PressureImpact pressureImpact = new WkFgPanOne.PressureImpact(pressure, impact);
                    Set<Integer> impactDriverList = pressureImpactDriverMap.get(pressureImpact);
                    Set<Integer> impactList = pressureImpactMap.get(pressure);
                    if (impactList == null) {
                        impactList = new HashSet<Integer>();
                        pressureImpactMap.put(pressure, impactList);
                    }
                    if (impactDriverList == null) {
                        impactDriverList = new HashSet<Integer>();
                        pressureImpactDriverMap.put(pressureImpact, impactList);
                    }
                    impactList.add(impact);
                    impactDriverList.add(driver);
                }
            }
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Cannot retrieve Pressure Impacts proposal", (Throwable)e);
        }
    }

    private void setModel() {
        if (this.cidsBean != null) {
            List<CidsBean> pressures = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "pressure_impact_driver");
            this.tabPressure.setModel((TableModel)new WkFgPanOne.PressureTableModel(this.readOnly, pressures));
        } else {
            this.tabPressure.setModel((TableModel)new WkFgPanOne.PressureTableModel(this.readOnly));
        }
        DefaultBindableScrollableComboboxCellEditor cbImpact = new DefaultBindableScrollableComboboxCellEditor(IMPACT_CODE_MC, true);
        DefaultBindableScrollableComboboxCellEditor cbdriver = new DefaultBindableScrollableComboboxCellEditor(DRIVER_MC, true);
        DefaultBindableScrollableComboboxCellEditor cbSubstance = new DefaultBindableScrollableComboboxCellEditor(SUBSTANCE_CODE_MC, true, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                Integer value1 = (Integer)o1.getProperty("value");
                Integer value2 = (Integer)o2.getProperty("value");
                String name1 = (String)o1.getProperty("name");
                String name2 = (String)o2.getProperty("name");
                if (value1 == null && value2 != null) {
                    return 1;
                }
                if (value1 != null && value2 == null) {
                    return -1;
                }
                return name1.compareTo(name2);
            }
        });
        cbImpact.getComboBox().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CidsBean bean;
                Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof DefaultBindableReferenceCombo.NullableItem) {
                    ((JLabel)result).setText(" ");
                }
                if (result instanceof JLabel && value instanceof CidsBean && !WkKgPanOne.this.isImpactProposed(bean = (CidsBean)value)) {
                    ((JLabel)result).setForeground(Color.GRAY);
                }
                return result;
            }
        });
        cbdriver.getComboBox().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CidsBean bean;
                Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof DefaultBindableReferenceCombo.NullableItem) {
                    ((JLabel)result).setText(" ");
                }
                if (result instanceof JLabel && value instanceof CidsBean && !WkKgPanOne.this.isDriverProposed(bean = (CidsBean)value)) {
                    ((JLabel)result).setForeground(Color.GRAY);
                }
                return result;
            }
        });
        this.tabPressure.getColumn(2).setCellEditor(cbImpact);
        this.tabPressure.getColumn(3).setCellEditor(cbdriver);
        this.tabPressure.getColumn(4).setCellEditor(cbSubstance);
        this.tabPressure.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setVerticalAlignment(1);
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel) {
                    ((JLabel)c).setText("<html>" + ((JLabel)c).getText() + "</html>");
                    ((JLabel)c).setToolTipText(String.valueOf(value));
                }
                return c;
            }
        });
        this.tabPressure.setDefaultRenderer(CidsBean.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setVerticalAlignment(1);
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel) {
                    ((JLabel)c).setText("<html>" + ((JLabel)c).getText() + "</html>");
                    ((JLabel)c).setToolTipText(String.valueOf(value));
                }
                return c;
            }
        });
        this.tabPressure.setRowHeight(55);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)this.cidsBean);
            this.bindingGroup.bind();
            this.labWebsite.setText("<html><a href=\"https://fis-wasser-mv.de/charts/steckbriefe/cw/cw_wk.php?kg" + String.valueOf(cidsBean.getProperty("wk_k")) + "\">" + String.valueOf(cidsBean.getProperty("wk_k")) + "</a></html>");
        } else {
            this.labWebsite.setText("");
        }
        this.setModel();
    }

    public void dispose() {
        if (this.jComboBox1 instanceof DefaultCismapGeometryComboBoxEditor) {
            ((DefaultCismapGeometryComboBoxEditor)this.jComboBox1).dispose();
        }
        this.bindingGroup.unbind();
    }

    private boolean isImpactProposed(CidsBean impact) {
        int selectedRow = this.tabPressure.getSelectedRow();
        CidsBean bean = ((WkFgPanOne.PressureTableModel)this.tabPressure.getModel()).getCidsBean(selectedRow);
        if (bean != null) {
            Integer pressureId = (Integer)bean.getProperty("pressure.id");
            Integer impactId = (Integer)impact.getProperty("id");
            if (pressureId == null || pressureImpactMap.isEmpty() || impactId == null) {
                return true;
            }
            Set<Integer> proposedImpacts = pressureImpactMap.get(pressureId);
            if (proposedImpacts != null) {
                return proposedImpacts.contains(impactId);
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean isDriverProposed(CidsBean driver) {
        int selectedRow = this.tabPressure.getSelectedRow();
        CidsBean bean = ((WkFgPanOne.PressureTableModel)this.tabPressure.getModel()).getCidsBean(selectedRow);
        if (bean != null) {
            Integer pressureId = (Integer)bean.getProperty("pressure.id");
            Integer impactId = (Integer)bean.getProperty("impact.id");
            Integer driverId = (Integer)driver.getProperty("id");
            if (pressureId == null || pressureImpactDriverMap.isEmpty() || impactId == null || driverId == null) {
                return true;
            }
            WkFgPanOne.PressureImpact pressureImpact = new WkFgPanOne.PressureImpact(pressureId, impactId);
            Set<Integer> proposedDriver = pressureImpactDriverMap.get(pressureImpact);
            if (proposedDriver != null) {
                return proposedDriver.contains(driverId);
            }
        } else {
            return true;
        }
        return false;
    }

    static {
        pressureImpactMap = new HashMap<Integer, Set<Integer>>();
        pressureImpactDriverMap = new HashMap<WkFgPanOne.PressureImpact, Set<Integer>>();
        CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"Wk_KG");
        IMPACT_SRC_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.pressure_type_code_neu", (ConnectionContext)CC);
        WHY_HMWB_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.de_effection_on_code", (ConnectionContext)CC);
        IMPACT_CODE_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.impact_code", (ConnectionContext)CC);
        DRIVER_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.driver_code", (ConnectionContext)CC);
        SUBSTANCE_CODE_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.codelist_substance_code", (ConnectionContext)CC);
        new Thread("Init proposals"){

            @Override
            public void run() {
                WkKgPanOne.initProposals();
            }
        }.start();
    }
}

