/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.actions.wrrl_db_mv.FgskSplitArToolbarItem;
import de.cismet.cids.custom.reports.QBWReport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class QuerbauwerkeTitleComponent
extends JPanel {
    private static Logger LOG = Logger.getLogger(FgskSplitArToolbarItem.class);
    private final transient ActionListener printL;
    private transient CidsBean cidsBean;
    private JButton btnReport;
    private JLabel lblTitle;

    public QuerbauwerkeTitleComponent() {
        this.initComponents();
        this.printL = new PrintListener();
        this.btnReport.addActionListener((ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.printL, (Object)this.btnReport));
    }

    private void setTitle(final String title) {
        if (EventQueue.isDispatchThread()) {
            this.lblTitle.setText(title);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuerbauwerkeTitleComponent.this.lblTitle.setText(title);
                }
            });
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        this.setTitle(String.valueOf(cidsBean));
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.btnReport = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText(NbBundle.getMessage(QuerbauwerkeTitleComponent.class, (String)"QuerbauwerkeTitleComponent.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblTitle, gridBagConstraints);
        this.btnReport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wrrl_db_mv/printer.png")));
        this.btnReport.setText(NbBundle.getMessage(QuerbauwerkeTitleComponent.class, (String)"QuerbauwerkeTitleComponent.btnReport.text"));
        this.btnReport.setBorderPainted(false);
        this.btnReport.setContentAreaFilled(false);
        this.btnReport.setFocusPainted(false);
        this.btnReport.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wrrl_db_mv/printer_pressed.png")));
        if (this.showPrintButton()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.btnReport, gridBagConstraints);
        }
    }

    private boolean showPrintButton() {
        try {
            return SessionManager.getSession().getUser().getUserGroup().getName().equalsIgnoreCase("administratoren") || SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "printQbw", ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)QuerbauwerkeTitleComponent.class.getName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot check print permission");
            return false;
        }
    }

    private final class PrintListener
    implements ActionListener {
        private PrintListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QBWReport report = new QBWReport(QuerbauwerkeTitleComponent.this.cidsBean);
            report.print();
        }
    }
}

