/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WkFgPanOne;
import de.cismet.cids.custom.wrrl_db_mv.server.search.PressureImpactsProposals;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.DefaultBindableScrollableComboboxCellEditor;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;

public class WkSgPanOne
extends JPanel
implements DisposableCidsBeanStore {
    private static final Logger LOG = Logger.getLogger(WkSgPanOne.class);
    private static final MetaClass IMPACT_CODE_MC;
    private static final MetaClass DRIVER_MC;
    private static final MetaClass SUBSTANCE_CODE_MC;
    private static Map<Integer, Set<Integer>> pressureImpactMap;
    private static Map<WkFgPanOne.PressureImpact, Set<Integer>> pressureImpactDriverMap;
    private static final ConnectionContext CC;
    private CidsBean cidsBean;
    private final boolean editable = true;
    private final boolean readOnly = true;
    private JScrollPane jScrollPane2;
    private JLabel labWebside;
    private JLabel lblArtificial;
    private JLabel lblGeolCat;
    private JLabel lblHeading;
    private JLabel lblImpact;
    private JLabel lblImpactSrc;
    private JLabel lblKuestenWk;
    private JLabel lblLw_name;
    private JLabel lblModified;
    private JLabel lblSee_id;
    private JLabel lblSpacing;
    private JLabel lblTy_cd_lw;
    private JLabel lblValArtificial;
    private JLabel lblValGeol_cat;
    private JLabel lblValLW_name;
    private JLabel lblValModified;
    private JLabel lblValSee_id;
    private JLabel lblValTy_cd_lw;
    private JLabel lblValWb_predect;
    private JLabel lblValWhy_hmwb;
    private JLabel lblWebside;
    private JLabel lblWhy_hmwb;
    private JLabel lblWkK;
    private JLabel lblWk_k;
    private JList lstImpact;
    private JList lstImpactSrc;
    private SemiRoundedPanel panHeadInfo;
    private RoundedPanel panInfo;
    private JPanel panInfoContent;
    private JPanel panPressure;
    private JScrollPane scpImpact;
    private JScrollPane scpImpactSrc;
    private JSeparator sepMiddle;
    private JXTable tabPressure;
    private BindingGroup bindingGroup;

    public WkSgPanOne() {
        this.initComponents();
        this.lblImpact.setVisible(false);
        this.lblImpactSrc.setVisible(false);
        this.scpImpact.setVisible(false);
        this.scpImpactSrc.setVisible(false);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panInfo = new RoundedPanel();
        this.panHeadInfo = new SemiRoundedPanel();
        this.lblHeading = new JLabel();
        this.panInfoContent = new JPanel();
        this.lblImpactSrc = new JLabel();
        this.lblImpact = new JLabel();
        this.lblSpacing = new JLabel();
        this.sepMiddle = new JSeparator();
        this.scpImpact = new JScrollPane();
        this.lstImpact = new JList();
        this.scpImpactSrc = new JScrollPane();
        this.lstImpactSrc = new JList();
        this.lblWkK = new JLabel();
        this.lblLw_name = new JLabel();
        this.lblSee_id = new JLabel();
        this.lblTy_cd_lw = new JLabel();
        this.lblGeolCat = new JLabel();
        this.lblArtificial = new JLabel();
        this.lblModified = new JLabel();
        this.lblWhy_hmwb = new JLabel();
        this.lblKuestenWk = new JLabel();
        this.lblWk_k = new JLabel();
        this.lblValLW_name = new JLabel();
        this.lblValSee_id = new JLabel();
        this.lblValTy_cd_lw = new JLabel();
        this.lblValGeol_cat = new JLabel();
        this.lblValArtificial = new JLabel();
        this.lblValModified = new JLabel();
        this.lblValWhy_hmwb = new JLabel();
        this.lblValWb_predect = new JLabel();
        this.labWebside = new JLabel();
        this.lblWebside = new JLabel();
        this.panPressure = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tabPressure = new JXTable();
        this.setMinimumSize(new Dimension(1100, 550));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(1100, 550));
        this.setLayout(new BorderLayout());
        this.panHeadInfo.setBackground(new Color(51, 51, 51));
        this.panHeadInfo.setMinimumSize(new Dimension(109, 24));
        this.panHeadInfo.setPreferredSize(new Dimension(109, 24));
        this.panHeadInfo.setLayout((LayoutManager)new FlowLayout());
        this.lblHeading.setForeground(new Color(255, 255, 255));
        this.lblHeading.setText("Allgemeine Informationen");
        this.panHeadInfo.add((Component)this.lblHeading);
        this.panInfo.add((Component)this.panHeadInfo, (Object)"North");
        this.panInfoContent.setOpaque(false);
        this.panInfoContent.setLayout(new GridBagLayout());
        this.lblImpactSrc.setText("Sign. Belastungsquellen");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panInfoContent.add((Component)this.lblImpactSrc, gridBagConstraints);
        this.lblImpact.setText("Auswirkungen der Bel.");
        this.lblImpact.setToolTipText("Auswirkungen der Belastungen");
        this.lblImpact.setMaximumSize(new Dimension(180, 17));
        this.lblImpact.setMinimumSize(new Dimension(180, 17));
        this.lblImpact.setPreferredSize(new Dimension(180, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblImpact, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weighty = 1.0;
        this.panInfoContent.add((Component)this.lblSpacing, gridBagConstraints);
        this.sepMiddle.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 14;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(15, 5, 5, 15);
        this.panInfoContent.add((Component)this.sepMiddle, gridBagConstraints);
        this.scpImpact.setMinimumSize(new Dimension(300, 80));
        this.scpImpact.setPreferredSize(new Dimension(300, 80));
        this.lstImpact.setSelectionMode(0);
        ELProperty eLProperty = ELProperty.create((String)"${cidsBean.impact}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstImpact);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.scpImpact.setViewportView(this.lstImpact);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInfoContent.add((Component)this.scpImpact, gridBagConstraints);
        this.scpImpactSrc.setMaximumSize(new Dimension(300, 80));
        this.scpImpactSrc.setMinimumSize(new Dimension(300, 80));
        this.scpImpactSrc.setPreferredSize(new Dimension(300, 80));
        this.lstImpactSrc.setSelectionMode(0);
        eLProperty = ELProperty.create((String)"${cidsBean.impact_src}");
        jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstImpactSrc);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.scpImpactSrc.setViewportView(this.lstImpactSrc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.scpImpactSrc, gridBagConstraints);
        this.lblWkK.setText("WK-K\u00fcrzel");
        this.lblWkK.setToolTipText("Wasserk\u00f6rper-K\u00fcrzel");
        this.lblWkK.setMaximumSize(new Dimension(180, 17));
        this.lblWkK.setMinimumSize(new Dimension(180, 17));
        this.lblWkK.setPreferredSize(new Dimension(180, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 25, 5, 5);
        this.panInfoContent.add((Component)this.lblWkK, gridBagConstraints);
        this.lblLw_name.setText("Wasserk\u00f6rpername");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panInfoContent.add((Component)this.lblLw_name, gridBagConstraints);
        this.lblSee_id.setText("ID des einzelnen Sees");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panInfoContent.add((Component)this.lblSee_id, gridBagConstraints);
        this.lblTy_cd_lw.setText(NbBundle.getMessage(WkSgPanOne.class, (String)"WkSgPanOne.lblTy_cd_lw.text"));
        this.lblTy_cd_lw.setToolTipText("Typ d. See-WK - Code");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panInfoContent.add((Component)this.lblTy_cd_lw, gridBagConstraints);
        this.lblGeolCat.setText("Geol. Typ des WK");
        this.lblGeolCat.setToolTipText("Geologischer Typ des Wasserk\u00f6rpers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panInfoContent.add((Component)this.lblGeolCat, gridBagConstraints);
        this.lblArtificial.setText("K\u00fcnstlich?");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblArtificial, gridBagConstraints);
        this.lblModified.setText("Erheblich ver\u00e4ndert?");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblModified, gridBagConstraints);
        this.lblWhy_hmwb.setText("Schutzgut");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblWhy_hmwb, gridBagConstraints);
        this.lblKuestenWk.setText("Ehemalige WK-Bezeichnung");
        this.lblKuestenWk.setMaximumSize(new Dimension(180, 17));
        this.lblKuestenWk.setMinimumSize(new Dimension(180, 17));
        this.lblKuestenWk.setPreferredSize(new Dimension(180, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblKuestenWk, gridBagConstraints);
        this.lblWk_k.setMaximumSize(new Dimension(300, 20));
        this.lblWk_k.setMinimumSize(new Dimension(300, 20));
        this.lblWk_k.setPreferredSize(new Dimension(300, 20));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wk_k}"), (Object)this.lblWk_k, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wk_k}"), (Object)this.lblWk_k, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblWk_k, gridBagConstraints);
        this.lblValLW_name.setMaximumSize(new Dimension(300, 20));
        this.lblValLW_name.setMinimumSize(new Dimension(300, 20));
        this.lblValLW_name.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.lw_name}"), (Object)this.lblValLW_name, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.lw_name}"), (Object)this.lblValLW_name, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblValLW_name, gridBagConstraints);
        this.lblValSee_id.setMaximumSize(new Dimension(300, 20));
        this.lblValSee_id.setMinimumSize(new Dimension(300, 20));
        this.lblValSee_id.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.see_id}"), (Object)this.lblValSee_id, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.see_id}"), (Object)this.lblValSee_id, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblValSee_id, gridBagConstraints);
        this.lblValTy_cd_lw.setMaximumSize(new Dimension(300, 20));
        this.lblValTy_cd_lw.setMinimumSize(new Dimension(300, 20));
        this.lblValTy_cd_lw.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ty_cd_lw.value} - ${cidsBean.ty_cd_lw.name}"), (Object)this.lblValTy_cd_lw, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ty_cd_lw.value} - ${cidsBean.ty_cd_lw.name}"), (Object)this.lblValTy_cd_lw, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblValTy_cd_lw, gridBagConstraints);
        this.lblValGeol_cat.setMaximumSize(new Dimension(300, 20));
        this.lblValGeol_cat.setMinimumSize(new Dimension(300, 20));
        this.lblValGeol_cat.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geol_cat.name}"), (Object)this.lblValGeol_cat, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geol_cat.name}"), (Object)this.lblValGeol_cat, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.lblValGeol_cat, gridBagConstraints);
        this.lblValArtificial.setMaximumSize(new Dimension(300, 20));
        this.lblValArtificial.setMinimumSize(new Dimension(300, 20));
        this.lblValArtificial.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.artificial.name}"), (Object)this.lblValArtificial, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.artificial.name}"), (Object)this.lblValArtificial, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 10);
        this.panInfoContent.add((Component)this.lblValArtificial, gridBagConstraints);
        this.lblValModified.setMaximumSize(new Dimension(300, 20));
        this.lblValModified.setMinimumSize(new Dimension(300, 20));
        this.lblValModified.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.modified.name}"), (Object)this.lblValModified, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.modified.name}"), (Object)this.lblValModified, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInfoContent.add((Component)this.lblValModified, gridBagConstraints);
        this.lblValWhy_hmwb.setMaximumSize(new Dimension(300, 20));
        this.lblValWhy_hmwb.setMinimumSize(new Dimension(300, 20));
        this.lblValWhy_hmwb.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.WHY_HMWB}"), (Object)this.lblValWhy_hmwb, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.WHY_HMWB}"), (Object)this.lblValWhy_hmwb, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInfoContent.add((Component)this.lblValWhy_hmwb, gridBagConstraints);
        this.lblValWb_predect.setMaximumSize(new Dimension(300, 20));
        this.lblValWb_predect.setMinimumSize(new Dimension(300, 20));
        this.lblValWb_predect.setPreferredSize(new Dimension(300, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wb_predec}"), (Object)this.lblValWb_predect, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<nicht gesetzt>");
        binding.setSourceUnreadableValue((Object)"<nicht gesetzt>");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.wb_predec}"), (Object)this.lblValWb_predect, (Property)BeanProperty.create((String)"toolTipText"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInfoContent.add((Component)this.lblValWb_predect, gridBagConstraints);
        this.labWebside.setCursor(new Cursor(12));
        this.labWebside.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WkSgPanOne.this.labWebsideMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panInfoContent.add((Component)this.labWebside, gridBagConstraints);
        this.lblWebside.setText(NbBundle.getMessage(WkSgPanOne.class, (String)"WkSgPanOne.lblWebside.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 0, 0);
        this.panInfoContent.add((Component)this.lblWebside, gridBagConstraints);
        this.panPressure.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WkSgPanOne.class, (String)"WkSgPanOne.panPressure.border.title", (Object[])new Object[0])));
        this.panPressure.setMinimumSize(new Dimension(110, 300));
        this.panPressure.setOpaque(false);
        this.panPressure.setPreferredSize(new Dimension(110, 300));
        this.panPressure.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView((Component)this.tabPressure);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPressure.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInfoContent.add((Component)this.panPressure, gridBagConstraints);
        this.panInfo.add((Component)this.panInfoContent, (Object)"Center");
        this.add((Component)this.panInfo, "Center");
        this.bindingGroup.bind();
    }

    private void labWebsideMouseClicked(MouseEvent evt) {
        try {
            BrowserLauncher.openURL((String)("https://fis-wasser-mv.de/charts/steckbriefe/lw/lw_wk.php?sg=" + String.valueOf(this.cidsBean.getProperty("wk_k"))));
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)this.cidsBean);
            this.bindingGroup.bind();
            this.labWebside.setText("<html><a href=\"https://fis-wasser-mv.de/charts/steckbriefe/lw/lw_wk.php?sg=" + String.valueOf(cidsBean.getProperty("wk_k")) + "\">Webseite</a></html>");
        } else {
            this.labWebside.setText("");
        }
        this.setModel();
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    private static void initProposals() {
        try {
            PressureImpactsProposals search = new PressureImpactsProposals();
            search.initWithConnectionContext(CC);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, CC);
            ArrayList list = (ArrayList)res;
            if (list != null) {
                for (ArrayList row : list) {
                    Integer pressure = (Integer)row.get(0);
                    Integer impact = (Integer)row.get(1);
                    Integer driver = (Integer)row.get(2);
                    if (pressure == null || impact == null) continue;
                    WkFgPanOne.PressureImpact pressureImpact = new WkFgPanOne.PressureImpact(pressure, impact);
                    Set<Integer> impactDriverList = pressureImpactDriverMap.get(pressureImpact);
                    Set<Integer> impactList = pressureImpactMap.get(pressure);
                    if (impactList == null) {
                        impactList = new HashSet<Integer>();
                        pressureImpactMap.put(pressure, impactList);
                    }
                    if (impactDriverList == null) {
                        impactDriverList = new HashSet<Integer>();
                        pressureImpactDriverMap.put(pressureImpact, impactList);
                    }
                    impactList.add(impact);
                    impactDriverList.add(driver);
                }
            }
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Cannot retrieve Pressure Impacts proposal", (Throwable)e);
        }
    }

    private void setModel() {
        if (this.cidsBean != null) {
            List<CidsBean> pressures = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "pressure_impact_driver");
            this.tabPressure.setModel((TableModel)new WkFgPanOne.PressureTableModel(true, pressures));
        } else {
            this.tabPressure.setModel((TableModel)new WkFgPanOne.PressureTableModel(true));
        }
        DefaultBindableScrollableComboboxCellEditor cbImpact = new DefaultBindableScrollableComboboxCellEditor(IMPACT_CODE_MC, true);
        DefaultBindableScrollableComboboxCellEditor cbdriver = new DefaultBindableScrollableComboboxCellEditor(DRIVER_MC, true);
        DefaultBindableScrollableComboboxCellEditor cbSubstance = new DefaultBindableScrollableComboboxCellEditor(SUBSTANCE_CODE_MC, true, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                Integer value1 = (Integer)o1.getProperty("value");
                Integer value2 = (Integer)o2.getProperty("value");
                String name1 = (String)o1.getProperty("name");
                String name2 = (String)o2.getProperty("name");
                if (value1 == null && value2 != null) {
                    return 1;
                }
                if (value1 != null && value2 == null) {
                    return -1;
                }
                return name1.compareTo(name2);
            }
        });
        cbImpact.getComboBox().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CidsBean bean;
                Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof DefaultBindableReferenceCombo.NullableItem) {
                    ((JLabel)result).setText(" ");
                }
                if (result instanceof JLabel && value instanceof CidsBean && !WkSgPanOne.this.isImpactProposed(bean = (CidsBean)value)) {
                    ((JLabel)result).setForeground(Color.GRAY);
                }
                return result;
            }
        });
        cbdriver.getComboBox().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CidsBean bean;
                Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof DefaultBindableReferenceCombo.NullableItem) {
                    ((JLabel)result).setText(" ");
                }
                if (result instanceof JLabel && value instanceof CidsBean && !WkSgPanOne.this.isDriverProposed(bean = (CidsBean)value)) {
                    ((JLabel)result).setForeground(Color.GRAY);
                }
                return result;
            }
        });
        this.tabPressure.getColumn(2).setCellEditor(cbImpact);
        this.tabPressure.getColumn(3).setCellEditor(cbdriver);
        this.tabPressure.getColumn(4).setCellEditor(cbSubstance);
        this.tabPressure.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setVerticalAlignment(1);
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel) {
                    ((JLabel)c).setText("<html>" + ((JLabel)c).getText() + "</html>");
                    ((JLabel)c).setToolTipText(String.valueOf(value));
                }
                return c;
            }
        });
        this.tabPressure.setDefaultRenderer(CidsBean.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setVerticalAlignment(1);
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel) {
                    ((JLabel)c).setText("<html>" + ((JLabel)c).getText() + "</html>");
                    ((JLabel)c).setToolTipText(String.valueOf(value));
                }
                return c;
            }
        });
        this.tabPressure.setRowHeight(55);
    }

    private boolean isImpactProposed(CidsBean impact) {
        int selectedRow = this.tabPressure.getSelectedRow();
        CidsBean bean = ((WkFgPanOne.PressureTableModel)this.tabPressure.getModel()).getCidsBean(selectedRow);
        if (bean != null) {
            Integer pressureId = (Integer)bean.getProperty("pressure.id");
            Integer impactId = (Integer)impact.getProperty("id");
            if (pressureId == null || pressureImpactMap.isEmpty() || impactId == null) {
                return true;
            }
            Set<Integer> proposedImpacts = pressureImpactMap.get(pressureId);
            if (proposedImpacts != null) {
                return proposedImpacts.contains(impactId);
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean isDriverProposed(CidsBean driver) {
        int selectedRow = this.tabPressure.getSelectedRow();
        CidsBean bean = ((WkFgPanOne.PressureTableModel)this.tabPressure.getModel()).getCidsBean(selectedRow);
        if (bean != null) {
            Integer pressureId = (Integer)bean.getProperty("pressure.id");
            Integer impactId = (Integer)bean.getProperty("impact.id");
            Integer driverId = (Integer)driver.getProperty("id");
            if (pressureId == null || pressureImpactDriverMap.isEmpty() || impactId == null || driverId == null) {
                return true;
            }
            WkFgPanOne.PressureImpact pressureImpact = new WkFgPanOne.PressureImpact(pressureId, impactId);
            Set<Integer> proposedDriver = pressureImpactDriverMap.get(pressureImpact);
            if (proposedDriver != null) {
                return proposedDriver.contains(driverId);
            }
        } else {
            return true;
        }
        return false;
    }

    static {
        pressureImpactMap = new HashMap<Integer, Set<Integer>>();
        pressureImpactDriverMap = new HashMap<WkFgPanOne.PressureImpact, Set<Integer>>();
        CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"Wk_SG");
        IMPACT_CODE_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.impact_code");
        DRIVER_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.driver_code");
        SUBSTANCE_CODE_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wfd.codelist_substance_code");
        new Thread("Init proposals"){

            @Override
            public void run() {
                WkSgPanOne.initProposals();
            }
        }.start();
    }
}

