/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.permissions.wrrl_db_mv;

import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import de.cismet.cids.dynamics.AbstractCustomBeanPermissionProvider;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.PropertyReader;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class BasicGeometryFomFilePermissionProvider
extends AbstractCustomBeanPermissionProvider {
    public static HashMap<String, Geometry> PERMISSIONGEOMS = new HashMap();
    private static final transient Logger log = Logger.getLogger(BasicGeometryFomFilePermissionProvider.class);

    public boolean getCustomReadPermissionDecisionforUser(User u) {
        return true;
    }

    public boolean getCustomWritePermissionDecisionforUser(User u) {
        if (u.getUserGroup().getName().equalsIgnoreCase("administratoren")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"member of admin group. permission is granted");
            }
            return true;
        }
        Geometry g = this.getGeometry();
        if (g == null) {
            log.info((Object)(this.getGeometry() + "delivered a null value. access is granted"));
            return true;
        }
        Geometry objectGeom = g;
        String userGroup = u.getUserGroup().getName();
        String end = userGroup.substring(userGroup.length() - 2);
        Geometry groupGeom = PERMISSIONGEOMS.get(end);
        if (groupGeom == null) {
            log.info((Object)"the user group did not have a permission geometry. permission is denied");
            return false;
        }
        return groupGeom.contains(objectGeom);
    }

    public boolean getCustomReadPermissionDecisionforUser(User user, ConnectionContext cc) {
        return this.getCustomReadPermissionDecisionforUser(user);
    }

    public boolean getCustomWritePermissionDecisionforUser(User user, ConnectionContext cc) {
        return this.getCustomWritePermissionDecisionforUser(user);
    }

    public abstract Geometry getGeometry();

    public static void main(String[] args) {
        System.out.println("WM:" + PERMISSIONGEOMS.get("WM").getArea());
        System.out.println("NM:" + PERMISSIONGEOMS.get("NM").getArea());
        System.out.println("VP:" + PERMISSIONGEOMS.get("VP").getArea());
        System.out.println("MS:" + PERMISSIONGEOMS.get("MS").getArea());
        System.out.println("liebhaberEI".substring("liebhaberEI".length() - 2));
    }

    static {
        PropertyReader geomperm = new PropertyReader("/de/cismet/cids/custom/permissions/geomperm.properties");
        WKBReader r = new WKBReader(new GeometryFactory());
        Set<Object> keys = geomperm.getInternalProperties().keySet();
        for (Object key : keys) {
            try {
                String hexVal = geomperm.getProperty((String)key);
                if (hexVal == null) continue;
                Geometry g = r.read(WKBReader.hexToBytes((String)hexVal));
                PERMISSIONGEOMS.put((String)key, g);
            }
            catch (ParseException ex) {
                log.error((Object)"Error during parse of MM Permission Geom");
            }
        }
    }
}

