/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.permissions.wrrl_db_mv;

import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cids.custom.permissions.wrrl_db_mv.CidsRestrictionGeometryStore;
import de.cismet.cids.dynamics.AbstractCustomBeanPermissionProvider;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BasicGeometryFromCidsObjectPermissionProvider
extends AbstractCustomBeanPermissionProvider {
    private static final transient Logger log = Logger.getLogger(BasicGeometryFromCidsObjectPermissionProvider.class);

    public boolean getCustomReadPermissionDecisionforUser(User u) {
        return true;
    }

    public boolean getCustomWritePermissionDecisionforUser(User u) {
        if (u.getUserGroup().getName().equalsIgnoreCase("administratoren")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"member of admin group. permission is granted");
            }
            return true;
        }
        Geometry objectGeom = this.getGeometry();
        if (objectGeom == null) {
            log.info((Object)(this.getGeometry() + "delivered a null value. access is granted"));
            return true;
        }
        String userGroup = u.getUserGroup().getName();
        STRtree restrictionfeatures = CidsRestrictionGeometryStore.getRestrictions().get(userGroup);
        ArrayList<String> restrictionKeys = CidsRestrictionGeometryStore.getRestrictionKeys().get(userGroup);
        boolean keyWordHitsAvailable = false;
        if (restrictionKeys == null) {
            return true;
        }
        for (String keyentry : restrictionKeys) {
            if (keyentry.toLowerCase().indexOf(this.getKey().toLowerCase()) <= -1) continue;
            keyWordHitsAvailable = true;
            break;
        }
        List selectedFeatures = restrictionfeatures.query(objectGeom.getEnvelopeInternal());
        for (Object hit : selectedFeatures) {
            boolean timestampHit;
            CidsFeature cf = (CidsFeature)hit;
            Geometry hitGeom = cf.getGeometry();
            CidsBean cb = cf.getMetaObject().getBean();
            Timestamp ts = (Timestamp)cb.getProperty("validuntil");
            Date now = new Date();
            String restrictionkeys = (String)cb.getProperty("restrictionkeys");
            Geometry intersectionGeom = hitGeom.intersection(objectGeom);
            boolean geometryHit = !intersectionGeom.isEmpty() && this.sizeByPercent(intersectionGeom, objectGeom) > 75.0;
            boolean keyWordHit = restrictionkeys.toLowerCase().indexOf(this.getKey().toLowerCase()) > -1;
            boolean bl = timestampHit = ts == null || ts.getTime() > now.getTime();
            if (!keyWordHit || !geometryHit || !timestampHit) continue;
            return true;
        }
        return !keyWordHitsAvailable;
    }

    private double sizeByPercent(Geometry intersectionGeom, Geometry geom) {
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            return intersectionGeom.getArea() * 100.0 / geom.getArea();
        }
        if (geom instanceof LineString || geom instanceof MultiLineString) {
            return intersectionGeom.getLength() * 100.0 / geom.getLength();
        }
        return 100.0;
    }

    public boolean getCustomReadPermissionDecisionforUser(User user, ConnectionContext cc) {
        return this.getCustomReadPermissionDecisionforUser(user);
    }

    public boolean getCustomWritePermissionDecisionforUser(User user, ConnectionContext cc) {
        return this.getCustomWritePermissionDecisionforUser(user);
    }

    public abstract Geometry getGeometry();

    public abstract String getKey();
}

