/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.permissions.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.configuration.StartupHook;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CidsRestrictionGeometryStore
implements StartupHook {
    public static final String DOMAIN = "WRRL_DB_MV";
    public static final String TABLE = "CCS_RESTRICTIONINFO";
    private static final transient Logger log = Logger.getLogger(CidsRestrictionGeometryStore.class);
    private static HashMap<String, STRtree> restrictions = new HashMap();
    private static HashMap<String, ArrayList<String>> restrictionKeys = new HashMap();

    public void applicationStarted() {
        try {
            MetaObject[] metaObjects;
            if (log.isDebugEnabled()) {
                log.debug((Object)"CidsRestrictionGeometryStore initialization started");
            }
            MetaClass mc = ClassCacheMultiple.getMetaClass((String)DOMAIN, (String)TABLE);
            for (MetaObject mo : metaObjects = SessionManager.getConnection().getMetaObjectByQuery(SessionManager.getSession().getUser(), "SELECT " + mc.getID() + ", " + mc.getPrimaryKey() + " FROM " + mc.getTableName() + " order by " + mc.getPrimaryKey())) {
                CidsFeature feature;
                CidsBean cb = mo.getBean();
                String group = (String)cb.getProperty("usergroup.name");
                STRtree restrictionfeatures = restrictions.get(group);
                ArrayList<String> grouprestrictionKeys = restrictionKeys.get(group);
                if (restrictionfeatures == null) {
                    restrictionfeatures = new STRtree();
                    restrictions.put(group, restrictionfeatures);
                }
                if (grouprestrictionKeys == null) {
                    grouprestrictionKeys = new ArrayList();
                    restrictionKeys.put(group, grouprestrictionKeys);
                }
                if ((feature = new CidsFeature(mo)) != null && feature.getGeometry() != null) {
                    restrictionfeatures.insert(feature.getGeometry().getEnvelopeInternal(), (Object)feature);
                }
                grouprestrictionKeys.add((String)cb.getProperty("restrictionkeys"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("CidsRestrictionGeometryStore initialized with " + metaObjects.length + " Object" + (metaObjects.length == 1 ? "" : "s") + "."));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error during initialization of restriction objects.", (Throwable)e);
        }
    }

    public static HashMap<String, STRtree> getRestrictions() {
        return restrictions;
    }

    public static HashMap<String, ArrayList<String>> getRestrictionKeys() {
        return restrictionKeys;
    }
}

