/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports;

import de.cismet.cids.custom.reports.ProgressMonitorHandler;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.swing.JRViewer;
import org.apache.log4j.Logger;

public abstract class AbstractJasperReportPrint {
    protected static final Logger log = Logger.getLogger(AbstractJasperReportPrint.class);
    private final Collection<CidsBean> beans;
    private final String reportURL;
    private JasperPrintWorker jpw;
    private boolean beansCollection = true;
    private JFrame parentFrame;
    private String filename = null;

    public AbstractJasperReportPrint(String reportURL, Collection<CidsBean> beans) {
        this(null, reportURL, beans);
    }

    public AbstractJasperReportPrint(String reportURL, CidsBean bean) {
        this(null, reportURL, bean);
    }

    public AbstractJasperReportPrint(String reportURL, CidsBean bean, String filename) {
        this(null, reportURL, bean);
        this.filename = filename;
    }

    public AbstractJasperReportPrint(JFrame parent, String reportURL, CidsBean bean) {
        if (reportURL == null || bean == null) {
            throw new NullPointerException();
        }
        this.parentFrame = parent;
        this.reportURL = reportURL;
        this.beans = new ArrayList<CidsBean>();
        this.beans.add(bean);
        this.jpw = null;
    }

    public AbstractJasperReportPrint(JFrame parent, String reportURL, Collection<CidsBean> beans) {
        if (reportURL == null || beans == null) {
            throw new NullPointerException();
        }
        this.reportURL = reportURL;
        this.beans = beans;
        this.parentFrame = parent;
    }

    public abstract Map generateReportParam(CidsBean var1);

    public abstract Map generateReportParam(Collection<CidsBean> var1);

    public void print() {
        if (EventQueue.isDispatchThread()) {
            this.executePrint();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractJasperReportPrint.this.executePrint();
                }
            });
        }
    }

    private void executePrint() {
        JasperPrintWorker old = this.jpw;
        if (old != null && !old.isDone()) {
            old.cancel(true);
        }
        this.jpw = new JasperPrintWorker(this.filename);
        CismetThreadPool.execute((Runnable)this.jpw);
    }

    public boolean isBeansCollection() {
        return this.beansCollection;
    }

    public void setBeansCollection(boolean beansCollection) {
        this.beansCollection = beansCollection;
    }

    final class JasperPrintWorker
    extends SwingWorker<JasperPrint, Void> {
        private String fileName = null;

        public JasperPrintWorker() {
        }

        public JasperPrintWorker(String fileName) {
            this.fileName = fileName;
        }

        @Override
        protected JasperPrint doInBackground() throws Exception {
            JasperReport jasperReport;
            ProgressMonitor monitor = null;
            if (AbstractJasperReportPrint.this.parentFrame != null) {
                int maxVal = AbstractJasperReportPrint.this.beans.size() + 1;
                if (AbstractJasperReportPrint.this instanceof ProgressMonitorHandler) {
                    maxVal = 100;
                }
                monitor = new ProgressMonitor(AbstractJasperReportPrint.this.parentFrame, "erstelle Report", "", 0, maxVal);
                monitor.setMillisToDecideToPopup(0);
                monitor.setMillisToPopup(0);
                if (AbstractJasperReportPrint.this instanceof ProgressMonitorHandler) {
                    ((ProgressMonitorHandler)((Object)AbstractJasperReportPrint.this)).setMonitor(monitor);
                }
            }
            try {
                jasperReport = (JasperReport)JRLoader.loadObject((InputStream)this.getClass().getResourceAsStream(AbstractJasperReportPrint.this.reportURL));
            }
            catch (Throwable e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
            if (monitor != null) {
                monitor.setProgress(1);
            }
            JasperPrint jasperPrint = null;
            if (AbstractJasperReportPrint.this.isBeansCollection()) {
                Map params = AbstractJasperReportPrint.this.generateReportParam(AbstractJasperReportPrint.this.beans);
                JRBeanCollectionDataSource beanArray = new JRBeanCollectionDataSource(AbstractJasperReportPrint.this.beans);
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)params, (JRDataSource)beanArray);
            } else {
                int count = 1;
                for (CidsBean current : AbstractJasperReportPrint.this.beans) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    if (monitor != null && AbstractJasperReportPrint.this.beans.size() > 1) {
                        monitor.setProgress(++count);
                        monitor.setNote(current.toString());
                    }
                    Map params = AbstractJasperReportPrint.this.generateReportParam(current);
                    JRBeanArrayDataSource beanArray = new JRBeanArrayDataSource((Object[])new CidsBean[]{current});
                    if (jasperPrint == null) {
                        jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)params, (JRDataSource)beanArray);
                        continue;
                    }
                    jasperPrint.addPage((JRPrintPage)JasperFillManager.fillReport((JasperReport)jasperReport, (Map)params, (JRDataSource)beanArray).getPages().get(0));
                }
            }
            if (monitor != null) {
                monitor.close();
            }
            return jasperPrint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            block10: {
                try {
                    JasperPrint jp = (JasperPrint)this.get();
                    if (jp != null && !this.isCancelled() && this.fileName == null) {
                        JRViewer aViewer = new JRViewer(jp);
                        aViewer.setZoomRatio(0.35f);
                        this.setupPrintFrame(aViewer);
                        break block10;
                    }
                    ByteArrayOutputStream outTmp = new ByteArrayOutputStream();
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jp, (OutputStream)outTmp);
                    File file = new File(this.fileName);
                    String filePrefix = this.fileName.contains(".") ? this.fileName.substring(0, this.fileName.indexOf(".")) : this.fileName;
                    String extension = this.fileName.contains(".") ? this.fileName.substring(this.fileName.indexOf(".")) : "";
                    int index = 0;
                    while (file.exists()) {
                        file = new File(filePrefix + ++index + extension);
                    }
                    try (FileOutputStream fos = null;){
                        file.getParentFile().mkdirs();
                        fos = new FileOutputStream(file);
                        fos.write(outTmp.toByteArray());
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)ex, (Throwable)ex);
                }
            }
        }

        private void setupPrintFrame(JRViewer aViewer) {
            JFrame aFrame = new JFrame("Druckvorschau");
            aFrame.getContentPane().add((Component)aViewer);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = screenSize.width / 2 < 1000 ? screenSize.width / 2 : 1000;
            int height = screenSize.height / 2 < 1000 ? screenSize.height / 2 : 1000;
            aFrame.setSize(width, height);
            Insets insets = aFrame.getInsets();
            aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
            aFrame.setLocation((screenSize.width - aFrame.getWidth()) / 2, (screenSize.height - aFrame.getHeight()) / 2);
            aFrame.setVisible(true);
        }
    }
}

