/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.UserGroup;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.util.ConversionUtils;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.SLDStyledLayer;
import de.cismet.cismap.commons.gui.printing.AbstractPrintingInscriber;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.simple.SimpleLegendProvider;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.commons.security.AccessHandler;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.Static2DTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;
import org.deegree.commons.utils.Pair;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public abstract class AbstractLegendPrintingTemplate
extends AbstractPrintingInscriber {
    private static final Logger LOG = Logger.getLogger(AbstractLegendPrintingTemplate.class);
    String prefix = null;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField txtZeile1;
    private JTextField txtZeile2;

    public AbstractLegendPrintingTemplate() {
        this.initComponents();
    }

    public HashMap<String, String> getValues() {
        URL url;
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("Ueberschrift", this.txtZeile1.getText());
        hm.put("Unterschrift", this.txtZeile2.getText());
        UserGroup ug = SessionManager.getSession().getUser().getUserGroup();
        String imageName = "lung";
        imageName = ug.getName().toLowerCase();
        if (imageName.contains("_") && imageName.indexOf("_") != imageName.lastIndexOf("_")) {
            imageName = imageName.substring(0, imageName.lastIndexOf("_"));
        }
        if ((url = AbstractLegendPrintingTemplate.class.getResource("/de/cismet/cismap/commons/gui/printing/" + imageName + ".jpg")) == null && (url = AbstractLegendPrintingTemplate.class.getResource("/" + imageName + ".jpg")) == null) {
            url = AbstractLegendPrintingTemplate.class.getResource("/de/cismet/cids/custom/reports/mv.png");
        }
        try {
            hm.put("logo", ConversionUtils.image2String(ImageIO.read(url)));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading image data", (Throwable)e);
        }
        try {
            List<BufferedImage> legend = this.getLegend();
            if (legend != null) {
                ArrayList<String> legendStrings = new ArrayList<String>();
                for (BufferedImage image : legend) {
                    legendStrings.add(ConversionUtils.image2String(this.rescaleImage(image)));
                }
                hm.put("legend", ConversionUtils.jrDataSource2String(new ImageDataSource(legendStrings)));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading image data", (Throwable)e);
        }
        return hm;
    }

    protected List<BufferedImage> getLegend() {
        MappingModel model = CismapBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap serviceMap = model.getRasterServices();
        ArrayList<BufferedImage> legendArray = new ArrayList<BufferedImage>();
        BufferedImage legend = null;
        ArrayList keys = new ArrayList(serviceMap.keySet());
        Collections.sort(keys);
        Collections.reverse(keys);
        for (Integer key : keys) {
            MapService service = (MapService)serviceMap.get(key);
            if (service.getPNode() != null && !service.getPNode().getVisible()) continue;
            if (service instanceof AbstractFeatureService) {
                XBoundingBox currentBox;
                AbstractFeatureService afService = (AbstractFeatureService)service;
                if (afService.getBoundingBox() instanceof XBoundingBox) {
                    currentBox = (XBoundingBox)afService.getBoundingBox();
                } else {
                    Geometry g = afService.getBoundingBox().getGeometry(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                    currentBox = new XBoundingBox(g);
                }
                if (!afService.isVisibleInBoundingBox(currentBox)) continue;
            }
            try {
                BufferedImage image = this.getServiceLegend(service);
                if (image == null) continue;
                if (legend == null) {
                    legend = image;
                    continue;
                }
                if (legend.getHeight() + image.getHeight() <= this.getLegendHeight()) {
                    legend = Static2DTools.appendImage((Image)legend, (Image)image);
                    continue;
                }
                legendArray.add(legend);
                if (image.getHeight() <= this.getLegendHeight()) {
                    legend = image;
                    continue;
                }
                legend = this.rescaleImage(image);
            }
            catch (Exception e) {
                String name = "unknown";
                if (service instanceof AbstractFeatureService) {
                    name = ((AbstractFeatureService)service).getName();
                } else if (service instanceof WMSServiceLayer) {
                    name = ((WMSServiceLayer)service).getName();
                }
                LOG.error((Object)("Cannot create legend for layer" + name), (Throwable)e);
            }
        }
        if (legend != null) {
            legendArray.add(legend);
        }
        return legendArray;
    }

    protected BufferedImage getServiceLegend(MapService service) {
        BufferedImage legendImage = null;
        String name = "";
        if (service instanceof WMSServiceLayer) {
            legendImage = this.getWMSLegendImage((WMSServiceLayer)service);
            name = ((WMSServiceLayer)service).getName();
        } else if (service instanceof SimpleLegendProvider) {
            SimpleLegendProvider slp = (SimpleLegendProvider)service;
            legendImage = this.getImageFromUrl(slp.getLegendUrl());
        } else if (service instanceof SlidableWMSServiceLayerGroup) {
            Object elem;
            SlidableWMSServiceLayerGroup wmsLayer = (SlidableWMSServiceLayerGroup)service;
            List v = wmsLayer.getLayers();
            Iterator it = v.iterator();
            if (it.hasNext() && (elem = it.next()) instanceof WMSServiceLayer) {
                legendImage = this.getWMSLegendImage((WMSServiceLayer)elem);
                name = ((WMSServiceLayer)elem).getTitle();
            }
        } else if (service instanceof SLDStyledLayer) {
            SLDStyledLayer sldLayer = (SLDStyledLayer)service;
            Pair size = sldLayer.getLegendSize();
            legendImage = new BufferedImage((Integer)size.first, (Integer)size.second, 6);
            sldLayer.getLegend(legendImage.getWidth(), legendImage.getHeight(), legendImage.createGraphics());
        }
        if (service instanceof AbstractFeatureService) {
            name = ((AbstractFeatureService)service).getName();
        }
        if (legendImage != null) {
            legendImage = this.addLegendTitle(legendImage, name);
        }
        return legendImage;
    }

    protected BufferedImage addLegendTitle(BufferedImage legend, String title) {
        Font basicFont = new Font("Arial", 1, 12);
        FontMetrics fmetrics = legend.getGraphics().getFontMetrics(basicFont);
        int maxWidth = Math.max(legend.getWidth(null), 2 + (int)fmetrics.getStringBounds(title, legend.getGraphics()).getWidth());
        int maxHeight = legend.getHeight(null) + 16;
        BufferedImage image = new BufferedImage(maxWidth, maxHeight, 2);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(basicFont);
        graphics2D.drawString(title, 0, 12);
        graphics2D.drawImage((Image)legend, 0, 16, null);
        graphics2D.dispose();
        return image;
    }

    protected BufferedImage rescaleImage(BufferedImage legend) {
        BufferedImage image = new BufferedImage((int)((double)this.getLegendWidth() * 1.3), (int)((double)this.getLegendHeight() * 1.3), 2);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.drawImage(legend.getScaledInstance((int)((double)legend.getWidth() / 1.0), (int)((double)legend.getHeight() / 1.0), 4), 0, 0, null);
        graphics2D.dispose();
        return image;
    }

    protected BufferedImage downScaleImage(BufferedImage legend) {
        BufferedImage image = new BufferedImage((int)((double)this.getLegendWidth() * 1.3), (int)((double)this.getLegendHeight() * 1.3), 2);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.drawImage(legend.getScaledInstance((int)((double)legend.getWidth() / 1.0), (int)((double)legend.getHeight() / 1.0), 4), 0, 0, null);
        graphics2D.dispose();
        return image;
    }

    protected abstract int getLegendWidth();

    protected abstract int getLegendHeight();

    protected BufferedImage getWMSLegendImage(WMSServiceLayer wmsLayer) {
        BufferedImage legendImage = null;
        if (!wmsLayer.isDummy()) {
            List v = wmsLayer.getWMSLayers();
            for (Object elem : v) {
                if (!(elem instanceof WMSLayer)) continue;
                WMSLayer wl = (WMSLayer)elem;
                String url = null;
                try {
                    URL[] lua = wl.getSelectedStyle().getLegendURL();
                    url = this.getValidUrlString(lua[0]);
                    if (url == null) continue;
                    legendImage = this.getImageFromUrl(url);
                }
                catch (Exception t) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Could not find legend for " + wl.getOgcCapabilitiesLayer().getTitle()), (Throwable)t);
                }
            }
        }
        return legendImage;
    }

    private String getValidUrlString(URL url) throws Exception {
        String urlString;
        block4: {
            urlString = null;
            try {
                urlString = url.toURI().toASCIIString();
            }
            catch (Exception t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cannot convert legend url to ascii string", (Throwable)t);
                }
                if (!(urlString = url.toString()).contains("?")) break block4;
                String param = urlString.substring(urlString.indexOf("?") + 1);
                urlString = urlString.substring(0, urlString.indexOf("?")) + "?";
                StringTokenizer stParam = new StringTokenizer(param, "&");
                while (stParam.hasMoreTokens()) {
                    StringTokenizer stKeyVal = new StringTokenizer(stParam.nextToken(), "=");
                    if (stKeyVal.countTokens() != 2) continue;
                    urlString = urlString + "&" + stKeyVal.nextToken() + "=" + URLEncoder.encode(stKeyVal.nextToken(), "UTF-8");
                }
            }
        }
        return urlString;
    }

    protected BufferedImage getImageFromUrl(String url) {
        BufferedImage legendImage = null;
        if (url != null) {
            String requestParameter;
            String urlBase;
            int indexOfCharacter = 0;
            indexOfCharacter = url.indexOf(63);
            if (indexOfCharacter != -1) {
                urlBase = url.substring(0, indexOfCharacter);
                requestParameter = indexOfCharacter + 1 < url.length() ? url.substring(indexOfCharacter + 1, url.length()) : "";
            } else {
                urlBase = url;
                requestParameter = "";
            }
            try {
                InputStream is = WebAccessManager.getInstance().doRequest(new URL(urlBase), requestParameter, AccessHandler.ACCESS_METHODS.GET_REQUEST);
                legendImage = ImageIO.read(is);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while retrieving legend", (Throwable)e);
            }
        }
        return legendImage;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtZeile1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtZeile2 = new JTextField();
        this.jLabel1.setText(NbBundle.getMessage(AbstractLegendPrintingTemplate.class, (String)"AbstractLegendPrintingTemplate.jLabel1.text"));
        this.txtZeile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractLegendPrintingTemplate.this.txtZeile1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(AbstractLegendPrintingTemplate.class, (String)"AbstractLegendPrintingTemplate.jLabel2.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.txtZeile1, -1, 101, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.txtZeile2, -1, 101, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.txtZeile1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.txtZeile2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void txtZeile1ActionPerformed(ActionEvent evt) {
    }

    private static class ImageDataSource
    implements JRDataSource,
    Serializable {
        private int index = -1;
        private List<String> image;

        public ImageDataSource(List<String> image) {
            this.image = image;
        }

        public boolean next() throws JRException {
            return ++this.index < this.image.size();
        }

        public Object getFieldValue(JRField jrf) throws JRException {
            try {
                return ConversionUtils.String2Image(this.image.get(this.index));
            }
            catch (IOException ex) {
                LOG.error((Object)"Error while converting image");
                return null;
            }
        }
    }
}

