/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.UserException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.reports.AbstractJasperReportPrint;
import de.cismet.cids.custom.wrrl_db_mv.server.search.FgskIdSearch;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkkSearch;
import de.cismet.cids.custom.wrrl_db_mv.util.ReportUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public final class FgskReport
extends AbstractJasperReportPrint {
    private static final String REPORT_URL = "/de/cismet/cids/custom/reports/fgsk.jasper";
    private static final Logger LOG = Logger.getLogger(FgskReport.class);
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String INDETERMINATE = "nicht ermittelbar";
    private final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");

    public FgskReport(Collection<CidsBean> beans) {
        this((JFrame)null, beans);
    }

    public FgskReport(CidsBean bean) {
        super(REPORT_URL, bean);
        this.setBeansCollection(false);
    }

    public FgskReport(CidsBean bean, String filename) {
        super(REPORT_URL, bean, filename);
        this.setBeansCollection(false);
    }

    public FgskReport(JFrame parent, Collection<CidsBean> beans) {
        super(parent, REPORT_URL, beans);
        this.setBeansCollection(false);
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    private Integer toInteger(Object obj) {
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        return (Integer)obj;
    }

    private double convertNumberToDouble(Number obj) {
        if (obj == null) {
            return 0.0;
        }
        return obj.doubleValue();
    }

    private String convertNumberToString(Number obj) {
        if (obj == null) {
            return "0";
        }
        return String.valueOf(obj);
    }

    private void retrieveKartierabschnittParams(CidsBean bean, Map params) {
        String gew = "<nicht gesetzt>";
        String gwk = "<nicht gesetzt>";
        String wkName = "<nicht gesetzt>";
        String wkTypeId = "<nicht gesetzt>";
        String statString = "<nicht gesetzt>";
        CidsBean statLine = (CidsBean)bean.getProperty("linie");
        CidsBean route = null;
        if (statLine != null) {
            CidsBean statVon = (CidsBean)statLine.getProperty("von");
            CidsBean statBis = (CidsBean)statLine.getProperty("bis");
            if (statVon != null) {
                route = (CidsBean)statVon.getProperty("route");
                if (route != null) {
                    gew = this.toString(route.getProperty("routenname"));
                    gwk = this.toString(route.getProperty("gwk"));
                }
                if (statBis != null) {
                    statString = this.toString(statVon.getProperty("wert")) + " - " + this.toString(statBis.getProperty("wert"));
                }
            }
            String wkk = "<nicht gesetzt>";
            try {
                CidsBean geomEntry = (CidsBean)statLine.getProperty("geom");
                Geometry geom = geomEntry != null ? (Geometry)geomEntry.getProperty("geo_field") : null;
                String geomString = geom.toText();
                WkkSearch search = new WkkSearch(geomString, this.toString(route.getProperty("id")));
                Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
                ArrayList resArray = (ArrayList)res;
                if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                    Object o = ((ArrayList)resArray.get(0)).get(0);
                    if (o instanceof String) {
                        wkk = o.toString();
                        String query = "select " + this.MC.getID() + ", " + this.MC.getPrimaryKey() + " from " + this.MC.getTableName() + " where wk_k = '" + wkk + "'";
                        MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
                        if (metaObjects.length == 1) {
                            wkName = (String)metaObjects[0].getBean().getProperty("wk_n");
                            wkTypeId = this.toString(metaObjects[0].getBean().getProperty("typ_k.value"));
                        } else {
                            wkName = INDETERMINATE;
                            wkTypeId = INDETERMINATE;
                        }
                    }
                } else {
                    LOG.error((Object)"Server error in getWk_k(). Cids server search return null. See the server logs for further information");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while determining the water body", (Throwable)e);
            }
            params.put("gew", this.toString(gew));
            params.put("gwk", this.toString(gwk));
            params.put("wkk", this.toString(wkk));
            params.put("wkName", this.toString(wkName));
            params.put("wkType", wkTypeId);
            params.put("stationierung", this.toString(statString));
            params.put("gewaesser_abschnitt", this.toString(bean.getProperty("gewaesser_abschnitt")));
            params.put("bearbeiter", this.toString(bean.getProperty("bearbeiter")));
            params.put("erfassungsdatum", this.toString(DF.format(bean.getProperty("erfassungsdatum"))));
            params.put("fliessrichtung_id", this.toString(bean.getProperty("fliessrichtung_id")));
            params.put("wasserfuehrung_id", this.toString(bean.getProperty("wasserfuehrung_id")));
            params.put("foto_nr", this.toString(bean.getProperty("foto_nr")));
            Boolean unterhaltungerkennbar = (Boolean)bean.getProperty("unterhaltungerkennbar");
            if (unterhaltungerkennbar != null) {
                params.put("unterhaltungerkennbar", unterhaltungerkennbar != false ? "ja" : "nein");
            }
            params.put("sonderfall_id", this.toInteger(bean.getProperty("sonderfall_id.value")));
            params.put("erlaeuterung", this.toString(bean.getProperty("erlaeuterung")));
            params.put("gewaesserbreite_id", this.toInteger(bean.getProperty("gewaesserbreite_id.value")));
            params.put("gewaessertyp_id", this.toString(bean.getProperty("gewaessertyp_id.value")));
            List subTypes = (List)bean.getProperty("gewaessersubtyp");
            ArrayList<String> subTypesStringList = new ArrayList<String>(subTypes.size());
            for (CidsBean subTypeBean : subTypes) {
                subTypesStringList.add(this.toString(subTypeBean.getProperty("value")));
            }
            params.put("gewaessersubtyp", subTypesStringList);
            Boolean seeausfluss = (Boolean)bean.getProperty("seeausfluss");
            params.put("seeausfluss", seeausfluss == null ? Boolean.FALSE : seeausfluss);
            params.put("beschattung_id", this.toInteger(bean.getProperty("beschattung_id.value")));
            params.put("lauftyp_id", this.toInteger(bean.getProperty("lauftyp_id.value")));
            params.put("talform_id", this.toInteger(bean.getProperty("talform_id.value")));
            params.put("talform_kl_id", this.toInteger(bean.getProperty("talform_kl_id.value")));
            Boolean aeussereKolmation = (Boolean)bean.getProperty("aeussere_kolmation");
            params.put("aeussere_kolmation", aeussereKolmation == null ? Boolean.FALSE : aeussereKolmation);
        }
    }

    private void retrieveLaufentwicklungParams(CidsBean bean, Map params) {
        params.put("laufkruemmung_id", this.toInteger(bean.getProperty("laufkruemmung_id.value")));
        params.put("kruemmungserosion_id", this.toInteger(bean.getProperty("kruemmungserosion_id.value")));
        Number laengsbaenkeUFGK = (Number)bean.getProperty("laengsbaenke_ufkg");
        Number laengsbaenkeIB = (Number)bean.getProperty("laengsbaenke_ib");
        Number laengsbaenkeMB = (Number)bean.getProperty("laengsbaenke_mb");
        double laengsbaenkeSum = this.convertNumberToDouble(laengsbaenkeIB) + this.convertNumberToDouble(laengsbaenkeMB) + this.convertNumberToDouble(laengsbaenkeUFGK);
        params.put("laengsbaenke_ufkg", laengsbaenkeSum == 0.0 ? "" : this.convertNumberToString(laengsbaenkeUFGK));
        params.put("laengsbaenke_ib", laengsbaenkeSum == 0.0 ? "" : this.convertNumberToString(laengsbaenkeIB));
        params.put("laengsbaenke_mb", laengsbaenkeSum == 0.0 ? "" : this.convertNumberToString(laengsbaenkeMB));
        boolean isNotNull = laengsbaenkeIB != null && laengsbaenkeMB != null && laengsbaenkeUFGK != null;
        params.put("laengsbaenke_keine", isNotNull && laengsbaenkeSum == 0.0 ? "X" : "");
        Number laufstrukturenTV = (Number)bean.getProperty("laufstrukturen_tv");
        Number laufstrukturenSB = (Number)bean.getProperty("laufstrukturen_sb");
        Number laufstrukturenIBI = (Number)bean.getProperty("laufstrukturen_ibi");
        Number laufstrukturenLW = (Number)bean.getProperty("laufstrukturen_lw");
        Number laufstrukturenLV = (Number)bean.getProperty("laufstrukturen_lv");
        Number laufstrukturenLG = (Number)bean.getProperty("laufstrukturen_lg");
        double laufstrukturenSum = this.convertNumberToDouble(laufstrukturenTV) + this.convertNumberToDouble(laufstrukturenSB) + this.convertNumberToDouble(laufstrukturenIBI) + this.convertNumberToDouble(laufstrukturenLW) + this.convertNumberToDouble(laufstrukturenLV) + this.convertNumberToDouble(laufstrukturenLG);
        params.put("laufstrukturen_tv", laufstrukturenSum == 0.0 ? "" : this.convertNumberToString(laufstrukturenTV));
        params.put("laufstrukturen_sb", laufstrukturenSum == 0.0 ? "" : this.convertNumberToString(laufstrukturenSB));
        params.put("laufstrukturen_ibi", laufstrukturenSum == 0.0 ? "" : this.convertNumberToString(laufstrukturenIBI));
        params.put("laufstrukturen_lw", laufstrukturenSum == 0.0 ? "" : this.convertNumberToString(laufstrukturenLW));
        params.put("laufstrukturen_lv", laufstrukturenSum == 0.0 ? "" : this.convertNumberToString(laufstrukturenLV));
        params.put("laufstrukturen_lg", laufstrukturenSum == 0.0 ? "" : this.convertNumberToString(laufstrukturenLG));
        isNotNull = laufstrukturenIBI != null && laufstrukturenLG != null && laufstrukturenLV != null && laufstrukturenLW != null && laufstrukturenSB != null && laufstrukturenTV != null;
        params.put("laufstrukturen_keine", isNotNull && laufstrukturenSum == 0.0 ? "X" : "");
    }

    private void retrieveLaengsprofilParams(CidsBean bean, Map params) {
        params.put("fliessgeschwindigkeit_id", this.toInteger(bean.getProperty("fliessgeschwindigkeit_id.value")));
        params.put("stroemungsdiversitaet_id", this.toString(bean.getProperty("stroemungsdiversitaet_id")));
        params.put("tiefenvarianz_id", this.toString(bean.getProperty("tiefenvarianz_id")));
        params.put("tiefenerosion_id", this.toString(bean.getProperty("tiefenerosion_id")));
        params.put("querbaenke_anzahl", this.toString(bean.getProperty("querbaenke_anzahl")));
        List besondWasserFuehrungBeans = (List)bean.getProperty("besonderheiten_wasserfuehrung");
        ArrayList<Integer> besondWasserFuehrungIds = new ArrayList<Integer>(besondWasserFuehrungBeans.size());
        for (CidsBean tmpBean : besondWasserFuehrungBeans) {
            besondWasserFuehrungIds.add((Integer)tmpBean.getProperty("value"));
        }
        params.put("besonderheiten_wasserfuehrung", besondWasserFuehrungIds);
    }

    private void retrieveQuerprofilParams(CidsBean bean, Map params) {
        params.put("profiltyp_id", this.toInteger(bean.getProperty("profiltyp_id.value")));
        params.put("breitenvarianz_id", this.toInteger(bean.getProperty("breitenvarianz_id.value")));
        params.put("breitenerosion_id", this.toInteger(bean.getProperty("breitenerosion_id.value")));
        params.put("einschnitttiefe", this.toString(bean.getProperty("einschnitttiefe")));
        params.put("wassertiefe", this.toString(bean.getProperty("wassertiefe")));
        params.put("wasserspiegelbreite", this.toString(bean.getProperty("wasserspiegelbreite")));
        params.put("sohlenbreite", this.toString(bean.getProperty("sohlenbreite")));
        params.put("obere_profilbreite", this.toString(bean.getProperty("obere_profilbreite")));
    }

    private void retrieveSohlenstrukturParams(CidsBean bean, Map params) {
        params.put("sohlenverbau_id", this.toInteger(bean.getProperty("sohlenverbau_id.value")));
        params.put("z_sohlenverbau_id", this.toString(bean.getProperty("z_sohlenverbau_id")));
        Number sohlensubstratTON = (Number)bean.getProperty("sohlensubstrat_ton");
        Number sohlensubstratSAN = (Number)bean.getProperty("sohlensubstrat_san");
        Number sohlensubstratKIE = (Number)bean.getProperty("sohlensubstrat_kie");
        Number sohlensubstratSTE = (Number)bean.getProperty("sohlensubstrat_ste");
        Number sohlensubstratBLO = (Number)bean.getProperty("sohlensubstrat_blo");
        Number sohlensubstratSCH = (Number)bean.getProperty("sohlensubstrat_sch");
        Number sohlensubstratTOR = (Number)bean.getProperty("sohlensubstrat_tor");
        Number sohlensubstratTOT = (Number)bean.getProperty("sohlensubstrat_tot");
        Number sohlensubstratWUR = (Number)bean.getProperty("sohlensubstrat_wur");
        Number sohlensubstratKUE = (Number)bean.getProperty("sohlensubstrat_kue");
        double sohlensubstratSUM = this.convertNumberToDouble(sohlensubstratTON) + this.convertNumberToDouble(sohlensubstratSAN) + this.convertNumberToDouble(sohlensubstratKIE) + this.convertNumberToDouble(sohlensubstratSTE) + this.convertNumberToDouble(sohlensubstratBLO) + this.convertNumberToDouble(sohlensubstratSCH) + this.convertNumberToDouble(sohlensubstratTOR) + this.convertNumberToDouble(sohlensubstratTOT) + this.convertNumberToDouble(sohlensubstratWUR) + this.convertNumberToDouble(sohlensubstratKUE);
        params.put("sohlensubstrat_ton", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratTON));
        params.put("sohlensubstrat_san", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratSAN));
        params.put("sohlensubstrat_kie", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratKIE));
        params.put("sohlensubstrat_ste", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratSTE));
        params.put("sohlensubstrat_blo", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratBLO));
        params.put("sohlensubstrat_sch", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratSCH));
        params.put("sohlensubstrat_tor", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratTOR));
        params.put("sohlensubstrat_tot", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratTOT));
        params.put("sohlensubstrat_wur", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratWUR));
        params.put("sohlensubstrat_kue", sohlensubstratSUM == 0.0 ? "" : this.convertNumberToString(sohlensubstratKUE));
        boolean isNotNull = sohlensubstratTON != null && sohlensubstratSAN != null && sohlensubstratKIE != null && sohlensubstratSTE != null && sohlensubstratBLO != null && sohlensubstratSCH != null && sohlensubstratTOR != null && sohlensubstratTOT != null && sohlensubstratWUR != null && sohlensubstratKUE != null;
        params.put("sohlensubstrat_ne", isNotNull && sohlensubstratSUM == 0.0 ? "X" : "");
        Number sohlenstrukturenRIP = (Number)bean.getProperty("sohlenstrukturen_rip");
        Number sohlenstrukturenTH = (Number)bean.getProperty("sohlenstrukturen_th");
        Number sohlenstrukturenWU = (Number)bean.getProperty("sohlenstrukturen_wu");
        Number sohlenstrukturenKO = (Number)bean.getProperty("sohlenstrukturen_ko");
        double sohlenstrukturenSum = this.convertNumberToDouble(sohlenstrukturenRIP) + this.convertNumberToDouble(sohlenstrukturenTH) + this.convertNumberToDouble(sohlenstrukturenWU) + this.convertNumberToDouble(sohlenstrukturenKO);
        params.put("sohlenstrukturen_rip", sohlenstrukturenSum == 0.0 ? "" : this.convertNumberToString(sohlenstrukturenRIP));
        params.put("sohlenstrukturen_th", sohlenstrukturenSum == 0.0 ? "" : this.convertNumberToString(sohlenstrukturenTH));
        params.put("sohlenstrukturen_wu", sohlenstrukturenSum == 0.0 ? "" : this.convertNumberToString(sohlenstrukturenWU));
        params.put("sohlenstrukturen_ko", sohlenstrukturenSum == 0.0 ? "" : this.convertNumberToString(sohlenstrukturenKO));
        isNotNull = sohlenstrukturenRIP != null && sohlenstrukturenTH != null && sohlenstrukturenWU != null && sohlenstrukturenKO != null;
        params.put("sohlenstrukturen_kein", isNotNull && sohlenstrukturenSum == 0.0 ? "X" : "");
        Number belastungSohleMUE = (Number)bean.getProperty("belastung_sohle_mue");
        Number belastungSohleST = (Number)bean.getProperty("belastung_sohle_st");
        Number belastungSohleABW = (Number)bean.getProperty("belastung_sohle_abw");
        Number belastungSohleVO = (Number)bean.getProperty("belastung_sohle_vo");
        Number belastungSohleSA = (Number)bean.getProperty("belastung_sohle_sa");
        Number belastungSohleSO = (Number)bean.getProperty("belastung_sohle_so");
        double belastungSohleSUM = this.convertNumberToDouble(belastungSohleMUE) + this.convertNumberToDouble(belastungSohleST) + this.convertNumberToDouble(belastungSohleABW) + this.convertNumberToDouble(belastungSohleVO) + this.convertNumberToDouble(belastungSohleSA) + this.convertNumberToDouble(belastungSohleSO);
        params.put("belastung_sohle_mue", belastungSohleSUM == 0.0 ? "" : this.convertNumberToString(belastungSohleMUE));
        params.put("belastung_sohle_st", belastungSohleSUM == 0.0 ? "" : this.convertNumberToString(belastungSohleST));
        params.put("belastung_sohle_abw", belastungSohleSUM == 0.0 ? "" : this.convertNumberToString(belastungSohleABW));
        params.put("belastung_sohle_vo", belastungSohleSUM == 0.0 ? "" : this.convertNumberToString(belastungSohleVO));
        params.put("belastung_sohle_sa", belastungSohleSUM == 0.0 ? "" : this.convertNumberToString(belastungSohleSA));
        params.put("belastung_sohle_so", belastungSohleSUM == 0.0 ? "" : this.convertNumberToString(belastungSohleSO));
        isNotNull = belastungSohleMUE != null && belastungSohleST != null && belastungSohleABW != null && belastungSohleVO != null && belastungSohleSA != null && belastungSohleSO != null;
        params.put("belastung_sohle_keine", isNotNull && belastungSohleSUM == 0.0 ? "X" : "");
    }

    private void retrieveUferstrukturGewaesserumfeldParams(CidsBean bean, Map params) {
        params.put("ufervegetation_links_id", this.toString(bean.getProperty("ufervegetation_links_id")));
        params.put("ufervegetation_rechts_id", this.toString(bean.getProperty("ufervegetation_rechts_id")));
        Boolean isUferVegetationLinksTypical = (Boolean)bean.getProperty("ufervegetation_links_typical");
        Boolean isUferVegetationRechtsTypical = (Boolean)bean.getProperty("ufervegetation_rechts_typical");
        isUferVegetationLinksTypical = isUferVegetationLinksTypical == null ? Boolean.FALSE : isUferVegetationLinksTypical;
        Boolean bl = isUferVegetationRechtsTypical = isUferVegetationRechtsTypical == null ? Boolean.FALSE : isUferVegetationRechtsTypical;
        if (isUferVegetationLinksTypical != null) {
            params.put("ufervegetation_links_typical", isUferVegetationLinksTypical != false ? "Ja" : "Nein");
        } else {
            params.put("ufervegetation_links_typical", "ja / nein");
        }
        if (isUferVegetationRechtsTypical != null) {
            params.put("ufervegetation_rechts_typical", isUferVegetationRechtsTypical != false ? "Ja" : "Nein");
        } else {
            params.put("ufervegetation_rechts_typical", "ja / nein");
        }
        params.put("uferverbau_links_id", this.toInteger(bean.getProperty("uferverbau_links_id.value")));
        params.put("uferverbau_rechts_id", this.toInteger(bean.getProperty("uferverbau_rechts_id.value")));
        params.put("z_uferverbau_links_id", this.toString(bean.getProperty("z_uferverbau_links_id")));
        params.put("z_uferverbau_rechts_id", this.toString(bean.getProperty("z_uferverbau_rechts_id")));
        Number uferstrukturLinksBU = (Number)bean.getProperty("uferstruktur_bu_links");
        Number uferstrukturLinksPB = (Number)bean.getProperty("uferstruktur_pb_links");
        Number uferstrukturLinksUS = (Number)bean.getProperty("uferstruktur_us_links");
        Number uferstrukturLinksSB = (Number)bean.getProperty("uferstruktur_sb_links");
        Number uferstrukturLinksHA = (Number)bean.getProperty("uferstruktur_ha_links");
        Number uferstrukturLinksNBOE = (Number)bean.getProperty("uferstruktur_nboe_links");
        Number uferstrukturLinksSO = (Number)bean.getProperty("uferstruktur_so_links");
        double uferstrukturLinksSum = this.convertNumberToDouble(uferstrukturLinksBU) + this.convertNumberToDouble(uferstrukturLinksPB) + this.convertNumberToDouble(uferstrukturLinksUS) + this.convertNumberToDouble(uferstrukturLinksSB) + this.convertNumberToDouble(uferstrukturLinksHA) + this.convertNumberToDouble(uferstrukturLinksNBOE) + this.convertNumberToDouble(uferstrukturLinksSO);
        params.put("uferstruktur_bu_links", uferstrukturLinksSum == 0.0 ? "" : this.convertNumberToString(uferstrukturLinksBU));
        params.put("uferstruktur_pb_links", uferstrukturLinksSum == 0.0 ? "" : this.convertNumberToString(uferstrukturLinksPB));
        params.put("uferstruktur_us_links", uferstrukturLinksSum == 0.0 ? "" : this.convertNumberToString(uferstrukturLinksUS));
        params.put("uferstruktur_sb_links", uferstrukturLinksSum == 0.0 ? "" : this.convertNumberToString(uferstrukturLinksSB));
        params.put("uferstruktur_ha_links", uferstrukturLinksSum == 0.0 ? "" : this.convertNumberToString(uferstrukturLinksHA));
        params.put("uferstruktur_nboe_links", uferstrukturLinksSum == 0.0 ? "" : this.convertNumberToString(uferstrukturLinksNBOE));
        params.put("uferstruktur_so_links", uferstrukturLinksSum == 0.0 ? "" : this.convertNumberToString(uferstrukturLinksSO));
        boolean isNotNull = uferstrukturLinksBU != null && uferstrukturLinksPB != null && uferstrukturLinksUS != null && uferstrukturLinksSB != null && uferstrukturLinksHA != null && uferstrukturLinksNBOE != null && uferstrukturLinksSO != null;
        params.put("uferstruktur_keine_links", isNotNull && uferstrukturLinksSum == 0.0 ? "X" : "");
        Number uferstrukturRechtsBU = (Number)bean.getProperty("uferstruktur_bu_rechts");
        Number uferstrukturRechtsPB = (Number)bean.getProperty("uferstruktur_pb_rechts");
        Number uferstrukturRechtsUS = (Number)bean.getProperty("uferstruktur_us_rechts");
        Number uferstrukturRechtsSB = (Number)bean.getProperty("uferstruktur_sb_rechts");
        Number uferstrukturRechtsHA = (Number)bean.getProperty("uferstruktur_ha_rechts");
        Number uferstrukturRechtsNBOE = (Number)bean.getProperty("uferstruktur_nboe_rechts");
        Number uferstrukturRechtsSO = (Number)bean.getProperty("uferstruktur_so_rechts");
        double uferstrukturRechtsSum = this.convertNumberToDouble(uferstrukturRechtsBU) + this.convertNumberToDouble(uferstrukturRechtsPB) + this.convertNumberToDouble(uferstrukturRechtsUS) + this.convertNumberToDouble(uferstrukturRechtsSB) + this.convertNumberToDouble(uferstrukturRechtsHA) + this.convertNumberToDouble(uferstrukturRechtsNBOE) + this.convertNumberToDouble(uferstrukturRechtsSO);
        params.put("uferstruktur_bu_rechts", uferstrukturRechtsSum == 0.0 ? "" : this.convertNumberToString(uferstrukturRechtsBU));
        params.put("uferstruktur_pb_rechts", uferstrukturRechtsSum == 0.0 ? "" : this.convertNumberToString(uferstrukturRechtsPB));
        params.put("uferstruktur_us_rechts", uferstrukturRechtsSum == 0.0 ? "" : this.convertNumberToString(uferstrukturRechtsUS));
        params.put("uferstruktur_sb_rechts", uferstrukturRechtsSum == 0.0 ? "" : this.convertNumberToString(uferstrukturRechtsSB));
        params.put("uferstruktur_ha_rechts", uferstrukturRechtsSum == 0.0 ? "" : this.convertNumberToString(uferstrukturRechtsHA));
        params.put("uferstruktur_nboe_rechts", uferstrukturRechtsSum == 0.0 ? "" : this.convertNumberToString(uferstrukturRechtsNBOE));
        params.put("uferstruktur_so_rechts", uferstrukturRechtsSum == 0.0 ? "" : this.convertNumberToString(uferstrukturRechtsSO));
        isNotNull = uferstrukturRechtsBU != null && uferstrukturRechtsPB != null && uferstrukturRechtsUS != null && uferstrukturRechtsSB != null && uferstrukturRechtsHA != null && uferstrukturRechtsNBOE != null && uferstrukturRechtsSO != null;
        params.put("uferstruktur_keine_rechts", isNotNull && uferstrukturRechtsSum == 0.0 ? "X" : "");
        Number uferbelastungenLinksMUE = (Number)bean.getProperty("uferbelastungen_mue_links");
        Number uferbelastungenLinksST = (Number)bean.getProperty("uferbelastungen_st_links");
        Number uferbelastungenLinksTS = (Number)bean.getProperty("uferbelastungen_ts_links");
        Number uferbelastungenLinksEL = (Number)bean.getProperty("uferbelastungen_el_links");
        Number uferbelastungenLinksSO = (Number)bean.getProperty("uferbelastungen_so_links");
        double uferbelastungenLinksSum = this.convertNumberToDouble(uferbelastungenLinksMUE) + this.convertNumberToDouble(uferbelastungenLinksST) + this.convertNumberToDouble(uferbelastungenLinksTS) + this.convertNumberToDouble(uferbelastungenLinksEL) + this.convertNumberToDouble(uferbelastungenLinksSO);
        params.put("uferbelastungen_mue_links", uferbelastungenLinksSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenLinksMUE));
        params.put("uferbelastungen_st_links", uferbelastungenLinksSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenLinksST));
        params.put("uferbelastungen_ts_links", uferbelastungenLinksSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenLinksTS));
        params.put("uferbelastungen_el_links", uferbelastungenLinksSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenLinksEL));
        params.put("uferbelastungen_so_links", uferbelastungenLinksSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenLinksSO));
        isNotNull = uferbelastungenLinksMUE != null && uferbelastungenLinksST != null && uferbelastungenLinksTS != null && uferbelastungenLinksEL != null && uferbelastungenLinksSO != null;
        params.put("uferbelastungen_keine_links", isNotNull && uferbelastungenLinksSum == 0.0 ? "X" : "");
        Number uferbelastungenRechtsMUE = (Number)bean.getProperty("uferbelastungen_mue_rechts");
        Number uferbelastungenRechtsST = (Number)bean.getProperty("uferbelastungen_st_rechts");
        Number uferbelastungenRechtsTS = (Number)bean.getProperty("uferbelastungen_ts_rechts");
        Number uferbelastungenRechtsEL = (Number)bean.getProperty("uferbelastungen_el_rechts");
        Number uferbelastungenRechtsSO = (Number)bean.getProperty("uferbelastungen_so_rechts");
        double uferbelastungenRechtsSum = this.convertNumberToDouble(uferbelastungenRechtsMUE) + this.convertNumberToDouble(uferbelastungenRechtsST) + this.convertNumberToDouble(uferbelastungenRechtsTS) + this.convertNumberToDouble(uferbelastungenRechtsEL) + this.convertNumberToDouble(uferbelastungenRechtsSO);
        params.put("uferbelastungen_mue_rechts", uferbelastungenRechtsSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenRechtsMUE));
        params.put("uferbelastungen_st_rechts", uferbelastungenRechtsSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenRechtsST));
        params.put("uferbelastungen_ts_rechts", uferbelastungenRechtsSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenRechtsTS));
        params.put("uferbelastungen_el_rechts", uferbelastungenRechtsSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenRechtsEL));
        params.put("uferbelastungen_so_rechts", uferbelastungenRechtsSum == 0.0 ? "" : this.convertNumberToString(uferbelastungenRechtsSO));
        isNotNull = uferbelastungenRechtsMUE != null && uferbelastungenRechtsST != null && uferbelastungenRechtsTS != null && uferbelastungenRechtsEL != null && uferbelastungenRechtsSO != null;
        params.put("uferbelastungen_keine_rechts", isNotNull && uferbelastungenRechtsSum == 0.0 ? "X" : "");
        params.put("flaechennutzung_links_id", this.toString(bean.getProperty("flaechennutzung_links_id")));
        params.put("flaechennutzung_rechts_id", this.toString(bean.getProperty("flaechennutzung_rechts_id")));
        params.put("gewaesserrandstreifen_links_id", this.toString(bean.getProperty("gewaesserrandstreifen_links_id")));
        params.put("gewaesserrandstreifen_rechts_id", this.toString(bean.getProperty("gewaesserrandstreifen_rechts_id")));
        Number umfeldStrukturenLinksFM = (Number)bean.getProperty("umfeldstrukturen_fm_links");
        Number umfeldStrukturenLinksQ = (Number)bean.getProperty("umfeldstrukturen_q_links");
        Number umfeldStrukturenLinksAA = (Number)bean.getProperty("umfeldstrukturen_aa_links");
        Number umfeldStrukturenLinksAW = (Number)bean.getProperty("umfeldstrukturen_aw_links");
        Number umfeldStrukturenLinksW = (Number)bean.getProperty("umfeldstrukturen_w_links");
        Number umfeldStrukturenLinksSO = (Number)bean.getProperty("umfeldstrukturen_so_links");
        double umfeldStrukturenLinksSum = this.convertNumberToDouble(umfeldStrukturenLinksFM) + this.convertNumberToDouble(umfeldStrukturenLinksQ) + this.convertNumberToDouble(umfeldStrukturenLinksAA) + this.convertNumberToDouble(umfeldStrukturenLinksAW) + this.convertNumberToDouble(umfeldStrukturenLinksW) + this.convertNumberToDouble(umfeldStrukturenLinksSO);
        params.put("umfeldstrukturen_fm_links", umfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenLinksFM));
        params.put("umfeldstrukturen_q_links", umfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenLinksQ));
        params.put("umfeldstrukturen_aa_links", umfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenLinksAA));
        params.put("umfeldstrukturen_aw_links", umfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenLinksAW));
        params.put("umfeldstrukturen_w_links", umfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenLinksW));
        params.put("umfeldstrukturen_so_links", umfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenLinksSO));
        isNotNull = umfeldStrukturenLinksFM != null && umfeldStrukturenLinksQ != null && umfeldStrukturenLinksAA != null && umfeldStrukturenLinksAW != null && umfeldStrukturenLinksW != null && umfeldStrukturenLinksSO != null;
        params.put("umfeldstrukturen_keine_links", isNotNull && umfeldStrukturenLinksSum == 0.0 ? "X" : "");
        Number umfeldStrukturenRechtsFM = (Number)bean.getProperty("umfeldstrukturen_fm_rechts");
        Number umfeldStrukturenRechtsQ = (Number)bean.getProperty("umfeldstrukturen_q_rechts");
        Number umfeldStrukturenRechtsAA = (Number)bean.getProperty("umfeldstrukturen_aa_rechts");
        Number umfeldStrukturenRechtsAW = (Number)bean.getProperty("umfeldstrukturen_aw_rechts");
        Number umfeldStrukturenRechtsW = (Number)bean.getProperty("umfeldstrukturen_w_rechts");
        Number umfeldStrukturenRechtsSO = (Number)bean.getProperty("umfeldstrukturen_so_rechts");
        double umfeldStrukturenRechtsSum = this.convertNumberToDouble(umfeldStrukturenRechtsFM) + this.convertNumberToDouble(umfeldStrukturenRechtsQ) + this.convertNumberToDouble(umfeldStrukturenRechtsAA) + this.convertNumberToDouble(umfeldStrukturenRechtsAW) + this.convertNumberToDouble(umfeldStrukturenRechtsW) + this.convertNumberToDouble(umfeldStrukturenRechtsSO);
        params.put("umfeldstrukturen_fm_rechts", umfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenRechtsFM));
        params.put("umfeldstrukturen_q_rechts", umfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenRechtsQ));
        params.put("umfeldstrukturen_aa_rechts", umfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenRechtsAA));
        params.put("umfeldstrukturen_aw_rechts", umfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenRechtsAW));
        params.put("umfeldstrukturen_w_rechts", umfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenRechtsW));
        params.put("umfeldstrukturen_so_rechts", umfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(umfeldStrukturenRechtsSO));
        isNotNull = umfeldStrukturenRechtsFM != null && umfeldStrukturenRechtsQ != null && umfeldStrukturenRechtsAA != null && umfeldStrukturenRechtsAW != null && umfeldStrukturenRechtsW != null && umfeldStrukturenRechtsSO != null;
        params.put("umfeldstrukturen_keine_rechts", isNotNull && umfeldStrukturenRechtsSum == 0.0 ? "X" : "");
        Number sUmfeldStrukturenLinksAG = (Number)bean.getProperty("s_umfeldstrukturen_ag_links");
        Number sUmfeldStrukturenLinksFT = (Number)bean.getProperty("s_umfeldstrukturen_ft_links");
        Number sUmfeldStrukturenLinksGUA = (Number)bean.getProperty("s_umfeldstrukturen_gua_links");
        Number sUmfeldStrukturenLinksBV = (Number)bean.getProperty("s_umfeldstrukturen_bv_links");
        Number sUmfeldStrukturenLinksMA = (Number)bean.getProperty("s_umfeldstrukturen_ma_links");
        Number sUmfeldStrukturenLinksHW = (Number)bean.getProperty("s_umfeldstrukturen_hw_links");
        Number sUmfeldStrukturenLinksSO = (Number)bean.getProperty("s_umfeldstrukturen_so_links");
        double sUmfeldStrukturenLinksSum = this.convertNumberToDouble(sUmfeldStrukturenLinksAG) + this.convertNumberToDouble(sUmfeldStrukturenLinksFT) + this.convertNumberToDouble(sUmfeldStrukturenLinksGUA) + this.convertNumberToDouble(sUmfeldStrukturenLinksBV) + this.convertNumberToDouble(sUmfeldStrukturenLinksMA) + this.convertNumberToDouble(sUmfeldStrukturenLinksHW) + this.convertNumberToDouble(sUmfeldStrukturenLinksSO);
        params.put("s_umfeldstrukturen_ag_links", sUmfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenLinksAG));
        params.put("s_umfeldstrukturen_ft_links", sUmfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenLinksFT));
        params.put("s_umfeldstrukturen_gua_links", sUmfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenLinksGUA));
        params.put("s_umfeldstrukturen_bv_links", sUmfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenLinksBV));
        params.put("s_umfeldstrukturen_ma_links", sUmfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenLinksMA));
        params.put("s_umfeldstrukturen_hw_links", sUmfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenLinksHW));
        params.put("s_umfeldstrukturen_so_links", sUmfeldStrukturenLinksSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenLinksSO));
        isNotNull = sUmfeldStrukturenLinksAG != null && sUmfeldStrukturenLinksFT != null && sUmfeldStrukturenLinksGUA != null && sUmfeldStrukturenLinksBV != null && sUmfeldStrukturenLinksMA != null && sUmfeldStrukturenLinksHW != null && sUmfeldStrukturenLinksSO != null;
        params.put("s_umfeldstrukturen_keine_links", isNotNull && sUmfeldStrukturenLinksSum == 0.0 ? "X" : "");
        Number sUmfeldStrukturenRechtsAG = (Number)bean.getProperty("s_umfeldstrukturen_ag_rechts");
        Number sUmfeldStrukturenRechtsFT = (Number)bean.getProperty("s_umfeldstrukturen_ft_rechts");
        Number sUmfeldStrukturenRechtsGUA = (Number)bean.getProperty("s_umfeldstrukturen_gua_rechts");
        Number sUmfeldStrukturenRechtsBV = (Number)bean.getProperty("s_umfeldstrukturen_bv_rechts");
        Number sUmfeldStrukturenRechtsMA = (Number)bean.getProperty("s_umfeldstrukturen_ma_rechts");
        Number sUmfeldStrukturenRechtsHW = (Number)bean.getProperty("s_umfeldstrukturen_hw_rechts");
        Number sUmfeldStrukturenRechtsSO = (Number)bean.getProperty("s_umfeldstrukturen_so_rechts");
        double sUmfeldStrukturenRechtsSum = this.convertNumberToDouble(sUmfeldStrukturenRechtsAG) + this.convertNumberToDouble(sUmfeldStrukturenRechtsFT) + this.convertNumberToDouble(sUmfeldStrukturenRechtsGUA) + this.convertNumberToDouble(sUmfeldStrukturenRechtsBV) + this.convertNumberToDouble(sUmfeldStrukturenRechtsMA) + this.convertNumberToDouble(sUmfeldStrukturenRechtsHW) + this.convertNumberToDouble(sUmfeldStrukturenRechtsSO);
        params.put("s_umfeldstrukturen_ag_rechts", sUmfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenRechtsAG));
        params.put("s_umfeldstrukturen_ft_rechts", sUmfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenRechtsFT));
        params.put("s_umfeldstrukturen_gua_rechts", sUmfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenRechtsGUA));
        params.put("s_umfeldstrukturen_bv_rechts", sUmfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenRechtsBV));
        params.put("s_umfeldstrukturen_ma_rechts", sUmfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenRechtsMA));
        params.put("s_umfeldstrukturen_hw_rechts", sUmfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenRechtsHW));
        params.put("s_umfeldstrukturen_so_rechts", sUmfeldStrukturenRechtsSum == 0.0 ? "" : this.convertNumberToString(sUmfeldStrukturenRechtsSO));
        isNotNull = sUmfeldStrukturenRechtsAG != null && sUmfeldStrukturenRechtsFT != null && sUmfeldStrukturenRechtsGUA != null && sUmfeldStrukturenRechtsBV != null && sUmfeldStrukturenRechtsMA != null && sUmfeldStrukturenRechtsHW != null && sUmfeldStrukturenRechtsSO != null;
        params.put("s_umfeldstrukturen_keine_rechts", isNotNull && sUmfeldStrukturenRechtsSum == 0.0 ? "X" : "");
        Object beschreibung = bean.getProperty("beschreibung");
        params.put("beschreibung", beschreibung == null ? "" : this.toString(beschreibung));
    }

    @Override
    public Map generateReportParam(CidsBean current) {
        HashMap params = new HashMap();
        this.retrieveKartierabschnittParams(current, params);
        this.retrieveLaufentwicklungParams(current, params);
        this.retrieveLaengsprofilParams(current, params);
        this.retrieveQuerprofilParams(current, params);
        this.retrieveSohlenstrukturParams(current, params);
        this.retrieveUferstrukturGewaesserumfeldParams(current, params);
        return params;
    }

    @Override
    public Map generateReportParam(Collection<CidsBean> beans) {
        return Collections.EMPTY_MAP;
    }

    public static void createAllReports(String directory, String expression) {
        MetaClass fgskMc = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
        ArrayList ids = new ArrayList();
        try {
            FgskIdSearch search = new FgskIdSearch(expression);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            ArrayList resArray = (ArrayList)res;
            if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                Iterator iterator = resArray.iterator();
                while (iterator.hasNext()) {
                    ArrayList l = (ArrayList)iterator.next();
                    ids.add(l.get(0));
                }
            }
        }
        catch (ConnectionException search) {
            // empty catch block
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        int index = 1;
        try {
            for (Object id : ids) {
                Integer oId = (Integer)id;
                MetaObject wkFgObject = SessionManager.getProxy().getMetaObject(oId.intValue(), fgskMc.getID(), "WRRL_DB_MV");
                final CidsBean bean = wkFgObject.getBean();
                final String filename = (directory.endsWith("/") ? directory : directory + "/") + bean.toString() + ".pdf";
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        FgskReport r = new FgskReport(bean, filename);
                        r.print();
                    }
                });
                if (++index % 100 != 0) continue;
                executor.shutdown();
                executor.awaitTermination(1L, TimeUnit.DAYS);
                executor = Executors.newFixedThreadPool(5);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating all fgsk reports", (Throwable)e);
            System.exit(1);
        }
        try {
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            String expression = null;
            if (args.length == 0) {
                System.out.println("Als Parameter muss der Pfad zur Konfigurationsdatei angegeben werden");
                System.exit(1);
            }
            if (args.length == 2) {
                expression = args[1];
            }
            Properties properties = new Properties();
            FileReader propertiesReader = new FileReader(args[0]);
            properties.load(propertiesReader);
            ConnectionInfo connectionInfo = new ConnectionInfo();
            connectionInfo.setCallserverURL(properties.getProperty("callserver"));
            connectionInfo.setPassword(properties.getProperty("password"));
            connectionInfo.setUserDomain(properties.getProperty("userDomain"));
            connectionInfo.setUsergroup(properties.getProperty("userGroup"));
            connectionInfo.setUsergroupDomain(properties.getProperty("userGroupDomain"));
            connectionInfo.setUsername(properties.getProperty("username"));
            Connection connection = ConnectionFactory.getFactory().createConnection(properties.getProperty("connectionClass"), properties.getProperty("callserver"), null, "true".equals(properties.getProperty("compressionEnabled")));
            try {
                ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy("Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler", session);
                SessionManager.init((ConnectionProxy)proxy);
            }
            catch (UserException uexp) {
                LOG.error((Object)"autologin failed", (Throwable)uexp);
                System.exit(1);
            }
            ReportUtils.initCismap();
            FgskReport.createAllReports(properties.getProperty("report_directory"), expression);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

