/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupLosEditor;
import de.cismet.cids.custom.reports.AbstractJasperReportPrint;
import de.cismet.cids.custom.reports.ProgressMonitorHandler;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnBean;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnLegendBean;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnStationComparator;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnahmenBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.RulerBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.RulerLabelBand;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultXStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.interfaces.Band;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public final class GeppReport
extends AbstractJasperReportPrint
implements ProgressMonitorHandler {
    public static final String BOESCHUNGSBREITE = "Bn";
    public static final String BOESCHUNGSLAENGE = "Bl";
    public static final String CBMPROM = "Cm";
    public static final String DEICHKRONENBREITE = "Db";
    public static final String RANDSTREIFENBREITE = "Rs";
    public static final String SCHNITTTIEFE = "Schnitt";
    public static final String SOHLBREITE = "Sb";
    public static final String STUECK = "St.";
    public static final String STUNDE = "h";
    public static final String VORLANDBREITE = "Vb";
    static final int MAX_WIDTH = 197;
    static final int PARA_SPACE = 3;
    private static final String REPORT_URL = "/de/cismet/cids/custom/reports/gepp_pruefer.jasper";
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_unterhaltungsmassnahme");
    private static final Logger LOG = Logger.getLogger(GeppReport.class);
    private static final DateFormat DF = new SimpleDateFormat("dd.MM.yyyy");
    private JBand band = null;
    private CidsBean bean = null;
    private RulerBand ruler = new RulerBand(0.0, 5000.0);
    private BufferedImage bandImage;
    private int bandHeight = 219;
    private List<CidsBean> all;
    private List<CidsBean> rechtesUferList;
    private List<CidsBean> sohleList;
    private List<CidsBean> linkesUferList;
    private List<CidsBean> rechtesUmfeldList;
    private List<CidsBean> linkesUmfeldList;
    private ProgressMonitor monitor;

    public GeppReport(JFrame parent, CidsBean bean, JBand band, MassnahmenBand[] massnBandArray) {
        super(parent, REPORT_URL, bean);
        this.setBeansCollection(false);
        this.bean = bean;
        this.fillMassnArrays(bean);
        if (band != null) {
            RulerLabelBand rulerLabel = new RulerLabelBand(band.getModel().getMin(), band.getModel().getMax());
            this.ruler = new RulerBand(band.getModel().getMin(), band.getModel().getMax());
            ((SimpleBandModel)band.getModel()).insertBand((Band)rulerLabel, 0);
            ((SimpleBandModel)band.getModel()).insertBand((Band)this.ruler, 1);
            this.band = band;
            band.setHorizontalScrollBarPolicy(31);
            int number = 1;
            massnBandArray[0].showNumbers(number);
            massnBandArray[1].showNumbers(number += this.rechtesUferList.size());
            massnBandArray[2].showNumbers(number += this.linkesUferList.size());
            massnBandArray[3].showNumbers(number += this.sohleList.size());
            massnBandArray[4].showNumbers(number += this.rechtesUmfeldList.size());
            try {
                this.bandImage = this.componentToImage((JComponent)band);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while creating image from band", (Throwable)e);
            }
            massnBandArray[0].hideNumbers();
            massnBandArray[1].hideNumbers();
            massnBandArray[2].hideNumbers();
            massnBandArray[3].hideNumbers();
            massnBandArray[4].hideNumbers();
            ((SimpleBandModel)band.getModel()).removeBand((Band)this.ruler);
            ((SimpleBandModel)band.getModel()).removeBand((Band)rulerLabel);
            band.setHorizontalScrollBarPolicy(32);
        }
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    private void fillMassnArrays(CidsBean current) {
        this.all = current.getBeanCollectionProperty("massnahmen");
        this.rechtesUferList = new ArrayList<CidsBean>();
        this.sohleList = new ArrayList<CidsBean>();
        this.linkesUferList = new ArrayList<CidsBean>();
        this.rechtesUmfeldList = new ArrayList<CidsBean>();
        this.linkesUmfeldList = new ArrayList<CidsBean>();
        for (CidsBean tmp : this.all) {
            Integer kind = (Integer)tmp.getProperty("wo.id");
            switch (kind) {
                case 2: {
                    this.linkesUferList.add(tmp);
                    break;
                }
                case 1: {
                    this.rechtesUferList.add(tmp);
                    break;
                }
                case 3: {
                    this.linkesUmfeldList.add(tmp);
                    break;
                }
                case 4: {
                    this.rechtesUmfeldList.add(tmp);
                    break;
                }
                case 5: {
                    this.sohleList.add(tmp);
                }
            }
        }
    }

    @Override
    public Map generateReportParam(CidsBean current) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<CidsBean> list = new ArrayList<CidsBean>();
        list.add(current);
        try {
            long time = System.currentTimeMillis();
            this.bandImage = this.removeTransparentLeftMargin(this.bandImage);
            LOG.error((Object)("time " + (System.currentTimeMillis() - time)));
            this.bandHeight = this.bandImage.getHeight(null) * 605 / this.bandImage.getWidth(null);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating image from band", (Throwable)e);
        }
        params.put("currentDate", DF.format(new Date()));
        params.put("geppName", this.getGeppName(current));
        params.put("planungsabschnitt", list);
        int number = 0;
        params.put("uferRechts", this.getMassnBeans(this.rechtesUferList, number));
        params.put("uferLinks", this.getMassnBeans(this.linkesUferList, number += this.rechtesUferList.size()));
        params.put("sohle", this.getMassnBeans(this.sohleList, number += this.linkesUferList.size()));
        params.put("umfeldRechts", this.getMassnBeans(this.rechtesUmfeldList, number += this.sohleList.size()));
        params.put("umfeldLinks", this.getMassnBeans(this.linkesUmfeldList, number += this.rechtesUmfeldList.size()));
        params.put("massnLegend", this.getMassnLegendBeans(this.all));
        try {
            InputStream is = this.getClass().getResourceAsStream("/de/cismet/cids/custom/reports/GeppLegend.jpg");
            BufferedImage mapLegendImg = ImageIO.read(is);
            if (this.band != null) {
                params.put("map", this.generateMap());
                params.put("legend", mapLegendImg);
                params.put("band", this.bandImage);
                params.put("bandLegend", this.createMassnLegend(this.all));
            } else {
                File img = new File("/home/therter/TestMap.jpg");
                BufferedImage imgMap = ImageIO.read(img);
                img = new File("/home/therter/testBand.jpg");
                BufferedImage imgBand = ImageIO.read(img);
                params.put("map", this.generateMap());
                params.put("legend", mapLegendImg);
                params.put("band", imgBand);
                params.put("bandLegend", this.createMassnLegend(this.all));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while filling the parameters.", (Throwable)e);
        }
        return params;
    }

    private String getGeppName(CidsBean bean) {
        String geppName = this.toString(bean.getProperty("name"));
        geppName = geppName + " [" + String.valueOf(bean.getProperty("linie.von.wert"));
        geppName = geppName + ", " + String.valueOf(bean.getProperty("linie.bis.wert")) + "]";
        return geppName;
    }

    private List<MassnBean> getMassnBeans(List<CidsBean> cidsBeans, int startNumber) {
        ArrayList<MassnBean> beans = new ArrayList<MassnBean>();
        if (cidsBeans != null) {
            ArrayList<CidsBean> sortedCidsBeans = new ArrayList<CidsBean>(cidsBeans.size());
            sortedCidsBeans.addAll(cidsBeans);
            Collections.sort(sortedCidsBeans, new MassnStationComparator());
            int number = 0;
            for (CidsBean tmp : sortedCidsBeans) {
                MassnBean mBean = new MassnBean();
                mBean.setMassnahme((String)tmp.getProperty("massnahme.name"));
                mBean.setStationierung(this.extractStats(tmp));
                mBean.setBemerkung(this.extractBemerkung(tmp));
                mBean.setNummer(startNumber + ++number);
                try {
                    Double a = GupLosEditor.calcMenge(GupLosEditor.convertToList(tmp), GupLosEditor.getAufmassRegel(tmp));
                    if (a != null) {
                        mBean.setMenge(a + " " + GupLosEditor.getEinheit(tmp));
                    } else {
                        mBean.setMenge("Fehler");
                    }
                }
                catch (Exception e) {
                    mBean.setMenge("Fehler");
                }
                beans.add(mBean);
            }
        }
        return beans;
    }

    private List<MassnLegendBean> getMassnLegendBeans(List<CidsBean> cidsBeans) {
        ArrayList<MassnLegendBean> beans = new ArrayList<MassnLegendBean>();
        if (cidsBeans != null) {
            ArrayList<CidsBean> sortedCidsBeans = new ArrayList<CidsBean>(cidsBeans.size());
            sortedCidsBeans.addAll(cidsBeans);
            for (CidsBean tmp : sortedCidsBeans) {
                MassnLegendBean mBean = new MassnLegendBean();
                mBean.setMassnahme(this.toString(tmp.getProperty("massnahme.massnahmen_id")));
                mBean.setGewerk(this.toString(tmp.getProperty("massnahme.gewerk.name")));
                mBean.setEinsatzvariante(this.toString(tmp.getProperty("massnahme.einsatzvariante.name")));
                mBean.setVerbleib(this.toString(tmp.getProperty("massnahme.verbleib.name")));
                mBean.setGeraet(this.toString(tmp.getProperty("massnahme.geraet.name")));
                if (mBean.getMassnahme().equals("") || beans.contains(mBean)) continue;
                beans.add(mBean);
            }
        }
        Collections.sort(beans);
        return beans;
    }

    private Image createMassnLegend(List<CidsBean> cidsBeans) {
        int y;
        ArrayList<CidsBean> sortedCidsBeans = new ArrayList<CidsBean>();
        if (cidsBeans != null) {
            for (CidsBean tmp : cidsBeans) {
                CidsBean tmpArt = (CidsBean)tmp.getProperty("massnahme");
                if (tmpArt == null || tmpArt.getProperty("massnahmen_id") == null || sortedCidsBeans.contains(tmpArt)) continue;
                sortedCidsBeans.add(tmpArt);
            }
            Collections.sort(sortedCidsBeans, new MassnArtComparator());
        }
        int titleSize = 11;
        int textSize = 9;
        int textStart = 30;
        do {
            y = ++titleSize - 3;
            y = this.drawLegendIntro(null, ++textSize, 30, y, null, false);
        } while ((y = this.drawLegendMassn(sortedCidsBeans, null, titleSize, textSize, 30, y, null, false)) < this.bandHeight && textSize < 15);
        BufferedImage img = new BufferedImage(197, y, 3);
        Graphics g = img.getGraphics();
        Font basicFont = new Font("Arial", 0, --titleSize - 3);
        y = titleSize - 3;
        y = this.drawLegendIntro(basicFont, --textSize, 30, y, g, true);
        y = this.drawLegendMassn(sortedCidsBeans, basicFont, titleSize, textSize, 30, y, g, true);
        return img;
    }

    private int drawLegendIntro(Font basicFont, int textSize, int textStart, int y, Graphics g, boolean draw) {
        if (draw) {
            g.setColor(Color.BLACK);
            g.setFont(basicFont.deriveFont(1));
            g.drawString("Legende", 5, y);
        }
        try {
            y += textSize;
            if (draw) {
                g.setFont(basicFont.deriveFont(textSize - 3));
                InputStream is = this.getClass().getResourceAsStream("/de/cismet/cids/custom/reports/invalid.png");
                BufferedImage invalidImg = ImageIO.read(is);
                g.drawImage(invalidImg, 1, y - textSize / 2, null);
                g.setColor(Color.BLACK);
                g.drawString("invalide Ma\u00dfnahme", textStart, y);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot add the invalid representation to the legend.", (Throwable)e);
        }
        y += textSize;
        if (draw) {
            g.setFont(basicFont.deriveFont(textSize - 3));
            g.drawLine(8, y - textSize / 2 + textSize / 3, 8, y - textSize / 2 - textSize / 3);
            g.drawLine(9, y - textSize / 2 + textSize / 3, 9, y - textSize / 2 - textSize / 3);
            g.drawLine(13, y - textSize / 2 + textSize / 3, 13, y - textSize / 2 - textSize / 3);
            g.drawLine(14, y - textSize / 2 + textSize / 3, 14, y - textSize / 2 - textSize / 3);
            g.setColor(Color.BLACK);
            g.drawString(this.ruler.getDistance() + " m", textStart, y);
        }
        return y;
    }

    private int drawLegendMassn(List<CidsBean> sortedCidsBeans, Font basicFont, int titleSize, int textSize, int textStart, int y, Graphics g, boolean draw) {
        CidsBean komp = null;
        for (CidsBean tmp : sortedCidsBeans) {
            if (komp == null || !komp.equals((Object)((CidsBean)tmp.getProperty("kompartiment")))) {
                komp = (CidsBean)tmp.getProperty("kompartiment");
                y += titleSize;
                if (draw) {
                    g.setFont(basicFont);
                    g.setColor(Color.BLACK);
                    g.drawString(String.valueOf(tmp.getProperty("kompartiment.name")), 5, y);
                    g.setFont(basicFont.deriveFont(textSize - 3));
                }
            }
            y += textSize;
            if (!draw) continue;
            try {
                g.setColor(Color.decode((String)tmp.getProperty("color")));
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot handle colour code.", (Throwable)e);
            }
            g.drawLine(1, y - textSize / 2, 25, y - textSize / 2);
            g.drawLine(1, y - textSize / 2 + 1, 25, y - textSize / 2 + 1);
            g.setColor(Color.BLACK);
            g.drawString(String.valueOf(tmp.getProperty("massnahmen_id")), textStart, y);
        }
        return y;
    }

    private String extractStats(CidsBean cBean) {
        double von = (Double)cBean.getProperty("linie.von.wert");
        double bis = (Double)cBean.getProperty("linie.bis.wert");
        return (int)von + " - " + (int)bis;
    }

    private String extractBemerkung(CidsBean cBean) {
        String hints;
        StringBuilder bemerkungen = new StringBuilder();
        Boolean bl = (Boolean)cBean.getProperty("massnahme.gewerk.boeschungslaenge");
        Boolean bn = (Boolean)cBean.getProperty("massnahme.gewerk.boeschungsneigung");
        Boolean db = (Boolean)cBean.getProperty("massnahme.gewerk.deichkronenbreite");
        Boolean rs = (Boolean)cBean.getProperty("massnahme.gewerk.randstreifenbreite");
        Boolean sb = (Boolean)cBean.getProperty("massnahme.gewerk.sohlbreite");
        Boolean vb = (Boolean)cBean.getProperty("massnahme.gewerk.vorlandbreite");
        Boolean cm = (Boolean)cBean.getProperty("massnahme.gewerk.cbmprom");
        Boolean st = (Boolean)cBean.getProperty("massnahme.gewerk.stueck");
        Boolean stu = (Boolean)cBean.getProperty("massnahme.gewerk.stunden");
        Boolean sch = (Boolean)cBean.getProperty("massnahme.gewerk.schnitttiefe");
        if (bl != null && bl.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Bl: " + this.toString(cBean.getProperty("boeschungslaenge")));
        }
        if (bn != null && bn.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Bn: " + this.toString(cBean.getProperty("boeschungsbreite")));
        }
        if (db != null && db.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Db: " + this.toString(cBean.getProperty("deichkronenbreite")));
        }
        if (rs != null && rs.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Rs: " + this.toString(cBean.getProperty("randstreifenbreite")));
        }
        if (sb != null && sb.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Sb: " + this.toString(cBean.getProperty("sohlbreite")));
        }
        if (vb != null && vb.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Vb: " + this.toString(cBean.getProperty("vorlandbreite")));
        }
        if (cm != null && cm.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Cm: " + this.toString(cBean.getProperty("cbmprom")));
        }
        if (st != null && st.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("St.: " + this.toString(cBean.getProperty("stueck")));
        }
        if (stu != null && stu.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("h: " + this.toString(cBean.getProperty("stunden")));
        }
        if (sch != null && sch.booleanValue()) {
            if (!bemerkungen.toString().equals("")) {
                bemerkungen.append(", ");
            }
            bemerkungen.append("Schnitt: " + this.toString(cBean.getProperty("schnitttiefe")));
        }
        if (!(hints = this.toString(cBean.getProperty("hinweise"))).equals("")) {
            bemerkungen.append(", ");
        }
        bemerkungen.append(hints);
        String auflagen = this.toString(cBean.getProperty("auflagen_nb"));
        if (!auflagen.equals("")) {
            bemerkungen.append(", ");
        }
        bemerkungen.append(auflagen);
        auflagen = this.toString(cBean.getProperty("auflagen_wb"));
        if (!auflagen.equals("")) {
            bemerkungen.append(", ");
        }
        bemerkungen.append(auflagen);
        return bemerkungen.toString();
    }

    private BufferedImage componentToImage(JComponent component) {
        this.layoutComponent(component);
        BufferedImage img = new BufferedImage(component.getWidth(), component.getHeight(), 3);
        Graphics g = img.getGraphics();
        g.setColor(component.getForeground());
        g.setFont(component.getFont());
        component.paintAll(g);
        return img.getSubimage(0, 0, img.getWidth(), img.getHeight());
    }

    private BufferedImage removeTransparentLeftMargin(BufferedImage image) throws IOException {
        int x = 0;
        for (x = image.getData().getMinX(); x < image.getData().getMinX() + image.getData().getWidth(); ++x) {
            boolean isEmpty = true;
            for (int y = image.getData().getMinY(); y < image.getData().getMinY() + image.getData().getHeight(); y += 3) {
                double[] d = image.getData().getPixel(x, y, (double[])null);
                if (d[3] == 0.0) continue;
                isEmpty = false;
                break;
            }
            if (this.monitor != null && x < 100) {
                this.monitor.setProgress(x);
            }
            if (!isEmpty) break;
        }
        return image.getSubimage(x, 0, image.getWidth() - x, image.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            component.doLayout();
            if (component instanceof Container) {
                for (Component child : ((Container)component).getComponents()) {
                    this.layoutComponent(child);
                }
            }
        }
    }

    @Override
    public Map generateReportParam(Collection<CidsBean> beans) {
        return Collections.EMPTY_MAP;
    }

    public static void main(String[] args) {
        try {
            CidsBean cBean = DevelopmentTools.createCidsBeanFromRMIConnectionOnLocalhost((String)"WRRL_DB_MV", (String)"Administratoren", (String)"admin", (String)"kif", (String)"gup_planungsabschnitt", (int)19);
            System.out.println("create report");
            CismapBroker.getInstance().setDefaultCrsAlias(-1);
            CismapBroker.getInstance().setDefaultCrs("EPSG:35833");
            GeppReport report = new GeppReport(null, cBean, null, null);
            report.print();
            System.out.println("report created");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Image generateMap() {
        try {
            XBoundingBox boundingBox;
            String mapUrl = "http://www.geodaten-mv.de/dienste/webatlasde_wms/service?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=WebAtlasDE_MV_farbe&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage";
            String overlayUrl = "http://wms.fis-wasser-mv.de/services?&VERSION=1.1.1&REQUEST=GetMap&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&SRS=EPSG:5650&FORMAT=image/png&TRANSPARENT=true&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=gepp&STYLES=default";
            Geometry geom = (Geometry)this.bean.getProperty("linie.geom.geo_field");
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            SimpleWmsGetMapUrl url = new SimpleWmsGetMapUrl("http://www.geodaten-mv.de/dienste/webatlasde_wms/service?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=WebAtlasDE_MV_farbe&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage");
            SimpleWMS wms = new SimpleWMS(url);
            mapProvider.addLayer((RetrievalServiceLayer)wms);
            url = new SimpleWmsGetMapUrl("http://wms.fis-wasser-mv.de/services?&VERSION=1.1.1&REQUEST=GetMap&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&SRS=EPSG:5650&FORMAT=image/png&TRANSPARENT=true&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=gepp&STYLES=default");
            wms = new SimpleWMS(url);
            mapProvider.addLayer((RetrievalServiceLayer)wms);
            CustomFixedWidthStroke stroke = new CustomFixedWidthStroke(5.0f);
            DefaultXStyledFeature feature = new DefaultXStyledFeature(null, null, null, null, (Stroke)stroke);
            feature.setLinePaint((Paint)new Color(0, 0, 255, 128));
            feature.setGeometry(geom);
            feature.setTransparency(0.5f);
            mapProvider.addFeature((Feature)feature);
            if (CismapBroker.getInstance().getMappingComponent() != null) {
                boundingBox = new XBoundingBox(geom);
                boundingBox.setX1(boundingBox.getX1() - 50.0);
                boundingBox.setY1(boundingBox.getY1() - 50.0);
                boundingBox.setX2(boundingBox.getX2() + 50.0);
                boundingBox.setY2(boundingBox.getY2() + 50.0);
            } else {
                boundingBox = new XBoundingBox(3.32986531E7, 5994912.610934, 3.3308958598E7, 5999709.97916, "EPSG:35833", true);
            }
            mapProvider.setBoundingBox(boundingBox);
            Future imageFuture = mapProvider.getImage(72, 125, 600.0, 400.0);
            return (Image)imageFuture.get();
        }
        catch (Exception ex) {
            LOG.fatal((Object)"error", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private class MassnArtComparator
    implements Comparator<CidsBean> {
        private MassnArtComparator() {
        }

        @Override
        public int compare(CidsBean o1, CidsBean o2) {
            Integer kompId2;
            Integer kompId1 = (Integer)o1.getProperty("kompartiment.id");
            if (kompId1 == (kompId2 = (Integer)o2.getProperty("kompartiment.id"))) {
                String massnahmeId1 = (String)o1.getProperty("massnahmen_id");
                String massnahmeId2 = (String)o2.getProperty("massnahmen_id");
                if (massnahmeId1 != null && massnahmeId2 != null) {
                    return massnahmeId1.compareTo(massnahmeId2);
                }
                if (massnahmeId1 == null && massnahmeId2 == null) {
                    return 0;
                }
                if (massnahmeId1 == null) {
                    return -1;
                }
                return 1;
            }
            if (kompId1 == null) {
                return -1;
            }
            if (kompId2 == null) {
                return 1;
            }
            return (int)Math.signum(kompId1 - kompId2);
        }
    }

    public class SignallingRetrievalListener
    implements RetrievalListener {
        private BufferedImage image = null;
        private Lock lock;
        private Condition condition;

        public SignallingRetrievalListener(Lock lock, Condition condition) {
            this.lock = lock;
            this.condition = condition;
        }

        public void retrievalStarted(RetrievalEvent e) {
        }

        public void retrievalProgress(RetrievalEvent e) {
        }

        public void retrievalComplete(RetrievalEvent e) {
            if (e.getRetrievedObject() instanceof Image) {
                Image retrievedImage = (Image)e.getRetrievedObject();
                this.image = new BufferedImage(retrievedImage.getWidth(null), retrievedImage.getHeight(null), 2);
                Graphics2D g = (Graphics2D)this.image.getGraphics();
                g.drawImage(retrievedImage, 0, 0, null);
                g.dispose();
            }
            this.signalAll();
        }

        public void retrievalAborted(RetrievalEvent e) {
            this.signalAll();
        }

        public void retrievalError(RetrievalEvent e) {
            this.signalAll();
        }

        public BufferedImage getRetrievedImage() {
            return this.image;
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

