/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports;

import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupLosEditor;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.apache.log4j.Logger;
import org.openide.util.Cancellable;

public class LosReport
extends AbstractDownload
implements Cancellable {
    private static final Logger LOG = Logger.getLogger(LosReport.class);
    private String filename;
    private String extension;
    private List<String> sheetNames = new ArrayList<String>();
    private ArrayList<ArrayList> aufmass;
    private ArrayList<ArrayList> massn;

    public LosReport(ArrayList<ArrayList> aufmass, ArrayList<ArrayList> massn, String directory, String title, String filename, String extension) throws Exception {
        this.directory = directory;
        this.title = title;
        this.filename = filename;
        this.extension = extension;
        this.aufmass = aufmass;
        this.massn = massn;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        SimpleOutputStreamExporterOutput exportOut = null;
        try {
            HashMap parameters = new HashMap();
            HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
            parameters.put("dataSources", dataSources);
            FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)LosReport.class.getResourceAsStream("/de/cismet/cids/custom/reports/los.jasper"));
            dataSources.put("aufmass", this.getAufmass(this.aufmass));
            dataSources.put("massnahmen", this.getMassnahmen(this.massn));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
            FileOutputStream fout = new FileOutputStream(this.fileToSaveTo);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            JRXlsExporter exporter = new JRXlsExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
            exporter.setExporterOutput((ExporterOutput)exportOut);
            SimpleXlsReportConfiguration config = new SimpleXlsReportConfiguration();
            config.setOnePagePerSheet(Boolean.TRUE);
            config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
            config.setShowGridLines(Boolean.valueOf(true));
            config.setColumnWidthRatio(Float.valueOf(1.5f));
            config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
            config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
            config.setCellHidden(Boolean.valueOf(true));
            config.setDetectCellType(Boolean.valueOf(true));
            exporter.setConfiguration((ReportExportConfiguration)config);
            exporter.exportReport();
            exportOut.close();
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            if (exportOut != null) {
                try {
                    exportOut.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception occured while closing file.", (Throwable)e);
                }
            }
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    private FeatureDataSource getAufmass(ArrayList<ArrayList> aufmass) throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Aufma\u00df");
        for (ArrayList aufm : aufmass) {
            HashMap feature = new HashMap();
            feature.put("massn_id", aufm.get(9));
            feature.put("massn_bez", aufm.get(0));
            feature.put("leistungstext", aufm.get(6));
            feature.put("abschn", aufm.get(1));
            feature.put("laenge", aufm.get(2));
            feature.put("aufmass", aufm.get(3));
            feature.put("einheit", aufm.get(4));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getMassnahmen(ArrayList<ArrayList> massnahmen) throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Ma\u00dfnahmen");
        for (ArrayList aufm : massnahmen) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("route", aufm.get(29));
            feature.put("planungsabschnitt", aufm.get(3));
            feature.put("massn_id", aufm.get(30));
            feature.put("kompartiment", aufm.get(5));
            feature.put("von", aufm.get(6));
            feature.put("bis", aufm.get(7));
            feature.put("attr1", GupLosEditor.getAttribute(aufm, 1, GupLosEditor.FieldKind.name));
            feature.put("attr1_wert", GupLosEditor.getAttribute(aufm, 1, GupLosEditor.FieldKind.value));
            feature.put("attr1_einheit", GupLosEditor.getAttribute(aufm, 1, GupLosEditor.FieldKind.measure));
            feature.put("attr2", GupLosEditor.getAttribute(aufm, 2, GupLosEditor.FieldKind.name));
            feature.put("attr2_wert", GupLosEditor.getAttribute(aufm, 2, GupLosEditor.FieldKind.value));
            feature.put("attr2_einheit", GupLosEditor.getAttribute(aufm, 2, GupLosEditor.FieldKind.measure));
            feature.put("attr3", GupLosEditor.getAttribute(aufm, 3, GupLosEditor.FieldKind.name));
            feature.put("attr3_wert", GupLosEditor.getAttribute(aufm, 3, GupLosEditor.FieldKind.value));
            feature.put("attr3_einheit", GupLosEditor.getAttribute(aufm, 3, GupLosEditor.FieldKind.measure));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    public boolean cancel() {
        boolean cancelled = true;
        if (this.downloadFuture != null) {
            cancelled = this.downloadFuture.cancel(true);
        }
        if (cancelled) {
            this.status = Download.State.ABORTED;
            this.stateChanged();
        }
        return cancelled;
    }

    private class FeatureDataSource
    implements JRDataSource {
        private int index = -1;
        private final List<Map<String, Object>> features;

        public FeatureDataSource(FeatureDataSource copy) {
            this.features = copy.features;
        }

        public FeatureDataSource(List<Map<String, Object>> features) {
            this.features = features;
        }

        public boolean next() throws JRException {
            ++this.index;
            if (this.features.isEmpty() && this.index == 0) {
                return true;
            }
            return this.index < this.features.size();
        }

        public Object getFieldValue(JRField jrf) throws JRException {
            if (this.features.isEmpty()) {
                return null;
            }
            return this.features.get(this.index).get(jrf.getName());
        }
    }
}

