/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.UserException;
import de.cismet.cids.custom.reports.AbstractJasperReportPrint;
import de.cismet.cids.custom.wrrl_db_mv.server.search.FgskIdSearch;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WKKSearchBySingleStation;
import de.cismet.cids.custom.wrrl_db_mv.util.ReportUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public final class QBWReport
extends AbstractJasperReportPrint {
    private static final String REPORT_URL = "/de/cismet/cids/custom/reports/Querbauwerke.jasper";
    private static final Logger LOG = Logger.getLogger(QBWReport.class);
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private static final String INDETERMINATE = "nicht ermittelbar";
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"QBWReport");
    private final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"querbauwerke");

    public QBWReport(Collection<CidsBean> beans) {
        this((JFrame)null, beans);
    }

    public QBWReport(CidsBean bean) {
        super(REPORT_URL, bean);
        this.setBeansCollection(false);
    }

    public QBWReport(CidsBean bean, String filename) {
        super(REPORT_URL, bean, filename);
        this.setBeansCollection(false);
    }

    public QBWReport(JFrame parent, Collection<CidsBean> beans) {
        super(parent, REPORT_URL, beans);
        this.setBeansCollection(false);
    }

    private String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    private Integer toInteger(Object obj) {
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        return (Integer)obj;
    }

    private double convertNumberToDouble(Number obj) {
        if (obj == null) {
            return 0.0;
        }
        return obj.doubleValue();
    }

    private String convertNumberToString(Number obj) {
        if (obj == null) {
            return "0";
        }
        return String.valueOf(obj);
    }

    private void retrieveQuerbauwerkParams(CidsBean bean, Map params) {
        String gew = "<nicht gesetzt>";
        String wkName = "<nicht gesetzt>";
        String gwk = "<nicht gesetzt>";
        String statFrom = "<nicht gesetzt>";
        String statTo = "<nicht gesetzt>";
        String kartierer = "<nicht gesetzt>";
        String date = "<nicht gesetzt>";
        String wkk = "<nicht gesetzt>";
        CidsBean statVon = (CidsBean)bean.getProperty("stat09");
        CidsBean statBis = (CidsBean)bean.getProperty("stat09_bis");
        CidsBean route = null;
        if (statBis != null) {
            route = (CidsBean)statBis.getProperty("route");
            statTo = this.toString(statVon.getProperty("wert"));
        }
        if (statVon != null) {
            route = (CidsBean)statVon.getProperty("route");
            statFrom = this.toString(statVon.getProperty("wert"));
        }
        if (route != null) {
            gew = this.toString(route.getProperty("routenname"));
            gwk = this.toString(route.getProperty("gwk"));
            try {
                WKKSearchBySingleStation search = new WKKSearchBySingleStation(this.toString(route.getProperty("id")), statFrom != "<nicht gesetzt>" ? statFrom : statTo);
                Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, CC);
                ArrayList resArray = (ArrayList)res;
                if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                    Object o = ((ArrayList)resArray.get(0)).get(0);
                    if (o instanceof String) {
                        wkk = o.toString();
                        String query = "select " + this.MC.getID() + ", " + this.MC.getPrimaryKey() + " from " + this.MC.getTableName() + " where wk_k = '" + wkk + "'";
                        MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
                        wkName = metaObjects.length == 1 ? (String)metaObjects[0].getBean().getProperty("wk_n") : INDETERMINATE;
                    }
                } else {
                    LOG.error((Object)"Server error in getWk_k(). Cids server search return null. See the server logs for further information");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while determining the water body", (Throwable)e);
            }
        }
        if (bean.getProperty("kartierdatum") != null) {
            date = this.toString(DF.format(bean.getProperty("kartierdatum")));
        }
        params.put("gew", this.toString(gew));
        params.put("gwk", this.toString(gwk));
        params.put("wkk", this.toString(wkk));
        params.put("wkName", this.toString(wkName));
        params.put("statFrom", this.toString(statFrom));
        params.put("statTo", this.toString(statTo));
        params.put("kartierer", this.toString(bean.getProperty("kartierer")));
        params.put("date", this.toString(date));
        params.put("bwNummer", this.toString(bean.getProperty("bauwerksnummer")));
        params.put("anlagename", this.toString(bean.getProperty("anlagename")));
        params.put("bauwerksart", this.toString(bean.getProperty("detailtyp.value")));
        params.put("material", this.toString(bean.getProperty("material")));
        params.put("laenge", this.toString(bean.getProperty("laenge")));
        params.put("durchmesser", this.toString(bean.getProperty("durchmesser")));
        params.put("ueberdeckung", this.toString(bean.getProperty("ueberdeckung")));
        params.put("stauhoehe", this.toString(bean.getProperty("stauhoehe")));
        params.put("sohlbefestigung_laenge", this.toString(bean.getProperty("sohlbefestigung_laenge")));
        params.put("sohlbefestigung_uh_material", this.toString(bean.getProperty("sohlbefestigung_uh_material.name")));
        params.put("sohlbefestigung_oh_material", this.toString(bean.getProperty("sohlbefestigung_oh_material.name")));
        params.put("substrat", this.toString(bean.getProperty("substrat.value")));
        params.put("regulierbarkeit", this.toString(bean.getProperty("regulierbarkeit.value")));
        params.put("dgk_fische", this.toString(bean.getProperty("dgk_fische.name")));
        params.put("dgk_wirbel", this.toString(bean.getProperty("dgk_wirbel.name")));
        params.put("dgk_otter", this.toString(bean.getProperty("dgk_otter.name")));
        params.put("stand", "Stand: " + DF.format(new Date()));
    }

    @Override
    public Map generateReportParam(CidsBean current) {
        HashMap params = new HashMap();
        this.retrieveQuerbauwerkParams(current, params);
        return params;
    }

    @Override
    public Map generateReportParam(Collection<CidsBean> beans) {
        return Collections.EMPTY_MAP;
    }

    public static void createAllReports(String directory, String expression) {
        MetaClass fgskMc = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"fgsk_kartierabschnitt");
        ArrayList ids = new ArrayList();
        try {
            FgskIdSearch search = new FgskIdSearch(expression);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            ArrayList resArray = (ArrayList)res;
            if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                Iterator iterator = resArray.iterator();
                while (iterator.hasNext()) {
                    ArrayList l = (ArrayList)iterator.next();
                    ids.add(l.get(0));
                }
            }
        }
        catch (ConnectionException search) {
            // empty catch block
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        int index = 1;
        try {
            for (Object id : ids) {
                Integer oId = (Integer)id;
                MetaObject wkFgObject = SessionManager.getProxy().getMetaObject(oId.intValue(), fgskMc.getID(), "WRRL_DB_MV");
                final CidsBean bean = wkFgObject.getBean();
                final String filename = (directory.endsWith("/") ? directory : directory + "/") + bean.toString() + ".pdf";
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        QBWReport r = new QBWReport(bean, filename);
                        r.print();
                    }
                });
                if (++index % 100 != 0) continue;
                executor.shutdown();
                executor.awaitTermination(1L, TimeUnit.DAYS);
                executor = Executors.newFixedThreadPool(5);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating all fgsk reports", (Throwable)e);
            System.exit(1);
        }
        try {
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            String expression = null;
            if (args.length == 0) {
                System.out.println("Als Parameter muss der Pfad zur Konfigurationsdatei angegeben werden");
                System.exit(1);
            }
            if (args.length == 2) {
                expression = args[1];
            }
            Properties properties = new Properties();
            FileReader propertiesReader = new FileReader(args[0]);
            properties.load(propertiesReader);
            ConnectionInfo connectionInfo = new ConnectionInfo();
            connectionInfo.setCallserverURL(properties.getProperty("callserver"));
            connectionInfo.setPassword(properties.getProperty("password"));
            connectionInfo.setUserDomain(properties.getProperty("userDomain"));
            connectionInfo.setUsergroup(properties.getProperty("userGroup"));
            connectionInfo.setUsergroupDomain(properties.getProperty("userGroupDomain"));
            connectionInfo.setUsername(properties.getProperty("username"));
            Connection connection = ConnectionFactory.getFactory().createConnection(properties.getProperty("connectionClass"), properties.getProperty("callserver"), null, "true".equals(properties.getProperty("compressionEnabled")));
            try {
                ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy("Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler", session);
                SessionManager.init((ConnectionProxy)proxy);
            }
            catch (UserException uexp) {
                LOG.error((Object)"autologin failed", (Throwable)uexp);
                System.exit(1);
            }
            ReportUtils.initCismap();
            QBWReport.createAllReports(properties.getProperty("report_directory"), expression);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

