/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.UserException;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkFgIdSearch;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.LawaTableModel;
import de.cismet.cids.custom.wrrl_db_mv.util.ReportUtils;
import de.cismet.cids.custom.wrrl_db_mv.util.TeileComparator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.utils.jasperreports.CidsBeanDataSource;
import de.cismet.cids.utils.jasperreports.ReportHelper;
import de.cismet.cids.utils.jasperreports.ReportSwingWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.log4j.Logger;

public class WkFgReport {
    private static final Logger LOG = Logger.getLogger(WkFgReport.class);
    private static final String PDF_FILE_EXTENSION = ".pdf";

    public static void showReport(CidsBean cidsBean) {
        ArrayList<CidsBean> coll = new ArrayList<CidsBean>();
        coll.add(cidsBean);
        ArrayList<Collection<CidsBean>> beans = new ArrayList<Collection<CidsBean>>();
        Collection<CidsBean> massnahmenUmgesetzt = WkFgReport.getMassnahmenUmgesetzt((Integer)cidsBean.getProperty("id"));
        Collection<CidsBean> massnahmenRunning = WkFgReport.getMassnahmenRunning((Integer)cidsBean.getProperty("id"));
        beans.add(coll);
        beans.add(WkFgReport.getMassnahmen((Integer)cidsBean.getProperty("id")));
        if (massnahmenRunning != null && !massnahmenRunning.isEmpty()) {
            beans.add(massnahmenRunning);
        }
        if (massnahmenUmgesetzt != null && !massnahmenUmgesetzt.isEmpty()) {
            beans.add(massnahmenUmgesetzt);
        }
        ArrayList<String> reports = new ArrayList<String>();
        reports.add("/de/cismet/cids/custom/reports/wk_fg_komp.jasper");
        reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmen.jasper");
        if (massnahmenRunning != null && !massnahmenRunning.isEmpty()) {
            reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmenLaufend.jasper");
        }
        if (massnahmenUmgesetzt != null && !massnahmenUmgesetzt.isEmpty()) {
            reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmenUmgesetzt.jasper");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("STATIONIERUNGEN", WkFgReport.getStationierungen(cidsBean));
        parameters.put("GEWAESSERKENNZAHLEN", WkFgReport.getGewaesserkennzahlen(cidsBean));
        parameters.put("LAWA-DETAILTYP", WkFgReport.getLawaDetailTyp(cidsBean));
        parameters.put("BEWIRTSCHAFTUNGSBEREICHE", WkFgReport.getBewirtschaftungsbereiche(cidsBean));
        parameters.put("self", (String)cidsBean);
        ReportSwingWorker worker = new ReportSwingWorker(beans, reports, true, StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), CismapBroker.getInstance().getCismapFolderPath(), parameters);
        worker.execute();
    }

    public static void createReport(String directory, CidsBean cidsBean, Executor executor, boolean shortVersion) {
        ArrayList<CidsBean> coll = new ArrayList<CidsBean>();
        coll.add(cidsBean);
        ArrayList<Collection<CidsBean>> beans = new ArrayList<Collection<CidsBean>>();
        Collection<CidsBean> massnahmenUmgesetzt = WkFgReport.getMassnahmenUmgesetzt((Integer)cidsBean.getProperty("id"));
        Collection<CidsBean> massnahmenRunning = WkFgReport.getMassnahmenRunning((Integer)cidsBean.getProperty("id"));
        beans.add(coll);
        beans.add(WkFgReport.getMassnahmen((Integer)cidsBean.getProperty("id")));
        if (massnahmenRunning != null && !massnahmenRunning.isEmpty()) {
            beans.add(massnahmenRunning);
        }
        if (massnahmenUmgesetzt != null && !massnahmenUmgesetzt.isEmpty()) {
            beans.add(massnahmenUmgesetzt);
        }
        ArrayList<String> reports = new ArrayList<String>();
        reports.add("/de/cismet/cids/custom/reports/wk_fg_komp.jasper");
        reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmen.jasper");
        if (massnahmenRunning != null && !massnahmenRunning.isEmpty()) {
            reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmenLaufend.jasper");
        }
        if (massnahmenUmgesetzt != null && !massnahmenUmgesetzt.isEmpty()) {
            reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmenUmgesetzt.jasper");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("STATIONIERUNGEN", WkFgReport.getStationierungen(cidsBean));
        parameters.put("GEWAESSERKENNZAHLEN", WkFgReport.getGewaesserkennzahlen(cidsBean));
        parameters.put("LAWA-DETAILTYP", WkFgReport.getLawaDetailTyp(cidsBean));
        parameters.put("BEWIRTSCHAFTUNGSBEREICHE", WkFgReport.getBewirtschaftungsbereiche(cidsBean));
        parameters.put("self", (String)cidsBean);
        String reportName = String.valueOf(cidsBean.getProperty("wk_k"));
        ReportSwingWorker worker = new ReportSwingWorker(beans, reports, false, null, directory, parameters, reportName);
        if (executor == null) {
            worker.execute();
        } else {
            executor.execute((Runnable)worker);
        }
    }

    public static void createReport(String fileToSave, CidsBean cidsBean) throws Exception {
        ArrayList<CidsBean> coll = new ArrayList<CidsBean>();
        coll.add(cidsBean);
        ArrayList<Collection<CidsBean>> beans = new ArrayList<Collection<CidsBean>>();
        Collection<CidsBean> massnahmenUmgesetzt = WkFgReport.getMassnahmenUmgesetzt((Integer)cidsBean.getProperty("id"));
        beans.add(coll);
        beans.add(WkFgReport.getMassnahmen((Integer)cidsBean.getProperty("id")));
        if (massnahmenUmgesetzt != null && !massnahmenUmgesetzt.isEmpty()) {
            beans.add(massnahmenUmgesetzt);
        }
        ArrayList<String> reports = new ArrayList<String>();
        reports.add("/de/cismet/cids/custom/reports/wk_fg_komp.jasper");
        reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmen.jasper");
        if (massnahmenUmgesetzt != null && !massnahmenUmgesetzt.isEmpty()) {
            reports.add("/de/cismet/cids/custom/reports/wk_fg_massnahmenUmgesetzt.jasper");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("STATIONIERUNGEN", WkFgReport.getStationierungen(cidsBean));
        parameters.put("GEWAESSERKENNZAHLEN", WkFgReport.getGewaesserkennzahlen(cidsBean));
        parameters.put("LAWA-DETAILTYP", WkFgReport.getLawaDetailTyp(cidsBean));
        parameters.put("BEWIRTSCHAFTUNGSBEREICHE", WkFgReport.getBewirtschaftungsbereiche(cidsBean));
        parameters.put("self", (String)cidsBean);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileOutputStream fos = null;
        try {
            ArrayList<ByteArrayInputStream> ins = new ArrayList<ByteArrayInputStream>();
            for (int index = 0; index < reports.size(); ++index) {
                String report = (String)reports.get(index);
                Collection beansCollection = (Collection)beans.get(index);
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)ReportSwingWorker.class.getResourceAsStream(report));
                CidsBeanDataSource dataSource = new CidsBeanDataSource(beansCollection);
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource);
                jasperPrint.setOrientation(jasperReport.getOrientationValue());
                ByteArrayOutputStream outTmp = new ByteArrayOutputStream();
                JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outTmp);
                ins.add(new ByteArrayInputStream(outTmp.toByteArray()));
                outTmp.close();
            }
            ReportHelper.concatPDFs(ins, (OutputStream)out, (boolean)true);
            File file = new File(fileToSave);
            file.getParentFile().mkdirs();
            fos = new FileOutputStream(file);
            fos.write(out.toByteArray());
        }
        catch (Exception ex) {
            LOG.error((Object)"Export to PDF-Stream failed.", (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Object)"error while closing streams", (Throwable)ex);
            }
        }
    }

    public static void createAllReports(String directory, String expression, boolean shortVersion) {
        MetaClass wkFgMc = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
        ArrayList ids = new ArrayList();
        try {
            WkFgIdSearch search = new WkFgIdSearch(expression);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            ArrayList resArray = (ArrayList)res;
            if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0) {
                for (ArrayList l : resArray) {
                    ids.add(l.get(0));
                }
            }
        }
        catch (ConnectionException search) {
            // empty catch block
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            for (Object id : ids) {
                Integer oId = (Integer)id;
                MetaObject wkFgObject = SessionManager.getProxy().getMetaObject(oId.intValue(), wkFgMc.getID(), "WRRL_DB_MV");
                WkFgReport.createReport(directory, wkFgObject.getBean(), executor, shortVersion);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating all wk_fg reports", (Throwable)e);
            System.exit(1);
        }
        try {
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    public static Collection<CidsBean> getMassnahmen(int id) {
        try {
            MetaClass mcMassnahmen = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"massnahmen");
            String query = "SELECT    " + mcMassnahmen.getID() + ",    m." + mcMassnahmen.getPrimaryKey() + " FROM    " + mcMassnahmen.getTableName() + " m left join  massnahmen_realisierung mr on (realisierung = mr.id) WHERE    wk_fg = " + String.valueOf(id) + " and coalesce(massn_started, false) = false and (massn_fin is null or massn_fin = false) ORDER BY mr.name, massn_id;";
            return WkFgReport.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while getting massnahmen for wk-fg with id " + String.valueOf(id)), (Throwable)ex);
            return null;
        }
    }

    public static Collection<CidsBean> getMassnahmenRunning(int id) {
        try {
            MetaClass mcMassnahmen = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"massnahmen");
            String query = "SELECT    " + mcMassnahmen.getID() + ",    m." + mcMassnahmen.getPrimaryKey() + " FROM    " + mcMassnahmen.getTableName() + " m left join  massnahmen_realisierung mr on (realisierung = mr.id) WHERE    wk_fg = " + String.valueOf(id) + " and massn_started = true and (massn_fin is null or massn_fin = false) ORDER BY mr.name, massn_id;";
            return WkFgReport.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while getting massnahmen for wk-fg with id " + String.valueOf(id)), (Throwable)ex);
            return null;
        }
    }

    public static Collection<CidsBean> getMassnahmenUmgesetzt(int id) {
        try {
            MetaClass mcMassnahmen = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"massnahmen");
            String query = "SELECT    " + mcMassnahmen.getID() + ",    m ." + mcMassnahmen.getPrimaryKey() + " FROM    " + mcMassnahmen.getTableName() + " m left join  massnahmen_realisierung mr on (realisierung = mr.id) WHERE    wk_fg = " + String.valueOf(id) + " and massn_fin = true ORDER BY mr.name, massn_id;";
            return WkFgReport.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while getting massnahmen umgesetzt for wk-fg with id " + String.valueOf(id)), (Throwable)ex);
            return null;
        }
    }

    private static Collection<CidsBean> getBeansFromQuery(String query) {
        ArrayList<CidsBean> collection;
        block3: {
            collection = new ArrayList<CidsBean>();
            try {
                for (MetaObject mo : SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, "WRRL_DB_MV")) {
                    collection.add(mo.getBean());
                }
            }
            catch (ConnectionException ex) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"error while fetching metaobject", (Throwable)ex);
            }
        }
        return collection;
    }

    private static String getGewaesserkennzahlen(CidsBean wk_fgBean) {
        String gewaesserkennzahlen = "";
        Collection teile = (Collection)wk_fgBean.getProperty("teile");
        for (CidsBean teil : teile) {
            CidsBean linie = (CidsBean)teil.getProperty("linie");
            CidsBean station_von = (CidsBean)linie.getProperty("von");
            CidsBean route = (CidsBean)station_von.getProperty("route");
            Long gewaesserkennzahl = (Long)route.getProperty("gwk");
            gewaesserkennzahlen = gewaesserkennzahlen + gewaesserkennzahl.toString() + ", ";
        }
        if (!gewaesserkennzahlen.equals("")) {
            gewaesserkennzahlen = gewaesserkennzahlen.substring(0, gewaesserkennzahlen.length() - 2);
        }
        return gewaesserkennzahlen;
    }

    private static String getLawaDetailTyp(CidsBean wk_fgBean) {
        int i;
        LawaTableModel model = new LawaTableModel();
        model.setCidsBean(wk_fgBean);
        List<CidsBean> teile = CidsBeanSupport.getBeanCollectionFromProperty(wk_fgBean, "teile");
        if (teile != null) {
            Collections.sort(teile, new TeileComparator());
        }
        model.setTeile(teile);
        model.refreshData();
        boolean typIndex = false;
        boolean anteilIndex = true;
        int amountDifferentTypes = model.getRowCount();
        String lawaDetailTyp = null;
        HashMap indexMap = new HashMap();
        ArrayList<Pair<Integer, Double>> percentageIndexList = new ArrayList<Pair<Integer, Double>>();
        for (i = 0; i < amountDifferentTypes - 1; ++i) {
            String percentageString = (String)model.getValueAt(i, 1);
            double perc = 0.0;
            try {
                perc = Double.parseDouble(percentageString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            percentageIndexList.add(new Pair<Integer, Double>(i, perc));
        }
        Collections.sort(percentageIndexList);
        for (i = 0; i < percentageIndexList.size(); ++i) {
            indexMap.put(i, ((Pair)percentageIndexList.get(i)).getFirstValue());
        }
        for (i = 0; i < amountDifferentTypes - 1; ++i) {
            String typ = (String)model.getValueAt((Integer)indexMap.get(i), 0);
            String typ_number = typ.split("-")[0];
            String typ_name = typ.substring(typ.indexOf("-") + 1);
            String anteil = (String)model.getValueAt((Integer)indexMap.get(i), 1);
            anteil = anteil.replace('.', ',');
            lawaDetailTyp = lawaDetailTyp == null ? typ_name + " (Typ " + typ_number + ": " + anteil + " % der L\u00e4nge), " : lawaDetailTyp + "<br />" + typ_name + " (Typ " + typ_number + ": " + anteil + " % der L\u00e4nge), ";
        }
        if (lawaDetailTyp != null && !lawaDetailTyp.equals("")) {
            lawaDetailTyp = lawaDetailTyp.substring(0, lawaDetailTyp.length() - 2);
        }
        return lawaDetailTyp;
    }

    private static String getStationierungen(CidsBean wk_fgBean) {
        String stationierungen = "";
        Collection teile = (Collection)wk_fgBean.getProperty("teile");
        DecimalFormat df = new DecimalFormat(",##0");
        for (CidsBean teil : teile) {
            Double wert_von = (Double)teil.getProperty("linie.von.wert");
            Double wert_bis = (Double)teil.getProperty("linie.bis.wert");
            stationierungen = stationierungen + df.format(wert_von) + " - " + df.format(wert_bis) + ", ";
        }
        if (!stationierungen.equals("")) {
            stationierungen = stationierungen.substring(0, stationierungen.length() - 2);
        }
        return stationierungen;
    }

    private static String getBewirtschaftungsbereiche(CidsBean wk_fgBean) {
        String stationierungen = "";
        Collection teile = (Collection)wk_fgBean.getProperty("teile");
        DecimalFormat df = new DecimalFormat(",##0");
        for (CidsBean teil : teile) {
            CidsBean bewirtschaftungsende;
            Double bewirtschaftung_bis;
            Double bewirtschaftung_von = (Double)teil.getProperty("linie.von.wert");
            Collection<CidsBean> bewirtschaftungsende_coll = WkFgReport.getBewirtschaftungsende(teil);
            if (bewirtschaftungsende_coll.isEmpty()) {
                bewirtschaftung_bis = (Double)teil.getProperty("linie.bis.wert");
            } else if (bewirtschaftungsende_coll.size() == 1) {
                bewirtschaftungsende = bewirtschaftungsende_coll.iterator().next();
                bewirtschaftung_bis = (Double)bewirtschaftungsende.getProperty("stat.wert");
            } else {
                bewirtschaftungsende = bewirtschaftungsende_coll.iterator().next();
                bewirtschaftung_bis = (Double)bewirtschaftungsende.getProperty("stat.wert");
                LOG.warn((Object)("Teil " + teil.getProperty("ID") + " hat mehrere Bewirtschaftungsenden."));
            }
            stationierungen = stationierungen + df.format(bewirtschaftung_von) + " - " + df.format(bewirtschaftung_bis) + ", ";
        }
        if (!stationierungen.equals("")) {
            stationierungen = stationierungen.substring(0, stationierungen.length() - 2);
        }
        return stationierungen;
    }

    private static Collection<CidsBean> getBewirtschaftungsende(CidsBean teilBean) {
        try {
            MetaClass BEW_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"bewirtschaftungsende");
            String query = "SELECT " + BEW_MC.getID() + ", b." + BEW_MC.getPrimaryKey() + " ";
            query = query + "FROM " + BEW_MC.getTableName() + " b JOIN station s ON b.stat = s.id ";
            query = query + "WHERE route = " + teilBean.getProperty("linie.von.route.id") + " and s.wert > " + teilBean.getProperty("linie.von.wert") + " and s.wert < " + teilBean.getProperty("linie.bis.wert") + ";";
            return WkFgReport.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while getting bewirtschaftungsende for wk-fg teil: " + String.valueOf(teilBean)), (Throwable)ex);
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            boolean shortVersion = false;
            String expression = null;
            if (args.length == 0) {
                System.out.println("Als Parameter muss der Pfad zur Konfigurationsdatei angegeben werden");
                System.exit(1);
            }
            if (args.length == 2) {
                if (args[1].equals("-s")) {
                    shortVersion = true;
                } else {
                    expression = args[1];
                }
            }
            if (args.length == 3) {
                if (args[1].equals("-s") || args[2].equals("-s")) {
                    expression = args[1].equals("-s") ? args[2] : args[1];
                    shortVersion = true;
                } else {
                    System.out.println("Zu viele/ung\u00fcltige Parameter");
                    System.exit(1);
                }
            }
            Properties properties = new Properties();
            FileReader propertiesReader = new FileReader(args[0]);
            properties.load(propertiesReader);
            ConnectionInfo connectionInfo = new ConnectionInfo();
            connectionInfo.setCallserverURL(properties.getProperty("callserver"));
            connectionInfo.setPassword(properties.getProperty("password"));
            connectionInfo.setUserDomain(properties.getProperty("userDomain"));
            connectionInfo.setUsergroup(properties.getProperty("userGroup"));
            connectionInfo.setUsergroupDomain(properties.getProperty("userGroupDomain"));
            connectionInfo.setUsername(properties.getProperty("username"));
            Connection connection = ConnectionFactory.getFactory().createConnection(properties.getProperty("connectionClass"), properties.getProperty("callserver"), null, "true".equals(properties.getProperty("compressionEnabled")));
            try {
                ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy("Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler", session);
                SessionManager.init((ConnectionProxy)proxy);
            }
            catch (UserException uexp) {
                LOG.error((Object)"autologin failed", (Throwable)uexp);
                System.exit(1);
            }
            ReportUtils.initCismap();
            WkFgReport.createAllReports(properties.getProperty("report_directory"), expression, shortVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Pair<F extends Comparable, S extends Comparable>
    implements Comparable<Pair> {
        private F firstValue;
        private S secondValue;

        public Pair(F firstValue, S secondValue) {
            this.firstValue = firstValue;
            this.secondValue = secondValue;
        }

        public F getFirstValue() {
            return this.firstValue;
        }

        public void setFirstValue(F firstValue) {
            this.firstValue = firstValue;
        }

        public S getSecondValue() {
            return this.secondValue;
        }

        public void setSecondValue(S secondValue) {
            this.secondValue = secondValue;
        }

        @Override
        public int compareTo(Pair o) {
            return -1 * this.secondValue.compareTo(o.getSecondValue());
        }
    }
}

