/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.scriptlets;

import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.custom.wrrl_db_mv.util.WebDavHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.security.WebDavClient;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.fill.JRFillField;
import org.apache.log4j.Logger;

public class LoadFotoScriptlet
extends JRDefaultScriptlet {
    private static final Logger LOG = Logger.getLogger(LoadFotoScriptlet.class);
    private static final String WEB_DAV_USER;
    private static final String WEB_DAV_PASSWORD;
    private static final String WEB_DAV_DIRECTORY;
    private static final WebDavClient webDavClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image loadFoto() {
        BufferedImage result = null;
        String fileName = (String)((JRFillField)this.fieldsMap.get("file")).getValue();
        String encodedFilename = WebDavHelper.encodeURL(fileName);
        InputStream inputStream = null;
        try {
            inputStream = webDavClient.getInputStream(WEB_DAV_DIRECTORY + encodedFilename);
            result = ImageIO.read(inputStream);
        }
        catch (IOException ex) {
            LOG.error((Object)"Couldn't load photo", (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)("Couldn't close stream for " + encodedFilename), (Throwable)ex);
                }
            }
        }
        if (result == null) {
            try {
                result = ImageIO.read(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/objecteditors/wrrl_db_mv/file-broken.png"));
            }
            catch (IOException ex1) {
                LOG.error((Object)"Couldn't load fallback photo", (Throwable)ex1);
            }
        }
        return result;
    }

    public Image loadBackground() {
        BufferedImage result = null;
        try {
            result = ImageIO.read(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/reports/cidsFactsheet_de_01.png"));
        }
        catch (IOException ex1) {
            LOG.error((Object)"Couldn't load background", (Throwable)ex1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image generateMap() {
        BufferedImage result = null;
        ReentrantLock lock = new ReentrantLock();
        Condition waitForImageRetrieval = lock.newCondition();
        String call = "http://www.geodaten-mv.de/dienste/webatlasde_wms/service?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=WebAtlasDE_MV_farbe&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage";
        CidsBean pointBean = (CidsBean)((JRFillField)this.fieldsMap.get("point")).getValue();
        Point p = (Point)pointBean.getProperty("geo_field");
        BoundingBox boundingBox = new BoundingBox(p.getX() - 500.0, p.getY() - 332.0, p.getX() + 500.0, p.getY() + 332.0);
        SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl("http://www.geodaten-mv.de/dienste/webatlasde_wms/service?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=WebAtlasDE_MV_farbe&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage"));
        swms.setName((String)((JRFillField)this.fieldsMap.get("name")).getValue());
        swms.setBoundingBox(boundingBox);
        swms.setSize(372, 560);
        SignallingRetrievalListener listener = new SignallingRetrievalListener(lock, waitForImageRetrieval);
        swms.addRetrievalListener((RetrievalListener)listener);
        lock.lock();
        try {
            swms.retrieve(true);
            waitForImageRetrieval.await();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error occurred while retrieving WMS image", t);
        }
        finally {
            lock.unlock();
        }
        result = listener.getRetrievedImage();
        int centerX = result.getWidth() / 2;
        int centerY = result.getHeight() / 2;
        Graphics g = result.getGraphics();
        try {
            BufferedImage pin = ImageIO.read(((Object)((Object)this)).getClass().getResource("/de/cismet/cismap/commons/gui/res/pushpin.png"));
            int posXPin = centerX - pin.getWidth() / 2;
            int posYPin = centerY - pin.getHeight();
            g.drawImage(pin, posXPin, posYPin, pin.getWidth(), pin.getHeight(), null);
        }
        catch (IOException ex) {
            LOG.error((Object)"Error while drawing pin on retrieved map.", (Throwable)ex);
        }
        finally {
            g.dispose();
        }
        return result;
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
        String pass = bundle.getString("password");
        if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
            pass = PasswordEncrypter.decryptString((String)pass);
        }
        WEB_DAV_PASSWORD = pass;
        WEB_DAV_USER = bundle.getString("username");
        WEB_DAV_DIRECTORY = bundle.getString("url");
        webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
    }

    public class SignallingRetrievalListener
    implements RetrievalListener {
        private BufferedImage image = null;
        private Lock lock;
        private Condition condition;

        public SignallingRetrievalListener(Lock lock, Condition condition) {
            this.lock = lock;
            this.condition = condition;
        }

        public void retrievalStarted(RetrievalEvent e) {
        }

        public void retrievalProgress(RetrievalEvent e) {
        }

        public void retrievalComplete(RetrievalEvent e) {
            if (e.getRetrievedObject() instanceof Image) {
                Image retrievedImage = (Image)e.getRetrievedObject();
                this.image = new BufferedImage(retrievedImage.getWidth(null), retrievedImage.getHeight(null), 1);
                Graphics2D g = (Graphics2D)this.image.getGraphics();
                g.drawImage(retrievedImage, 0, 0, null);
                g.dispose();
            }
            this.signalAll();
        }

        public void retrievalAborted(RetrievalEvent e) {
            this.signalAll();
        }

        public void retrievalError(RetrievalEvent e) {
            this.signalAll();
        }

        public BufferedImage getRetrievedImage() {
            return this.image;
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

