/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.scriptlets;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.wrrl_db_mv.server.search.TeilgebieteSearch;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import org.apache.log4j.Logger;

public class WkFgScriptlet
extends JRDefaultScriptlet {
    private static final Logger LOG = Logger.getLogger(WkFgScriptlet.class);
    private final MetaClass MC_MST_MESS = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"chemie_mst_messungen");
    private final MetaClass MC_MST_STAMM = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"chemie_mst_stammdaten");
    private final Color[] colors = new Color[]{new Color(128, 96, 0), new Color(230, 110, 46), new Color(114, 61, 170), new Color(255, 86, 86), new Color(255, 204, 201)};
    private Collection<CidsBean> selfReference = null;
    private Collection<CidsBean> lawaTypes = null;

    public JRBeanCollectionDataSource getJRBeanCollectionDataSource() {
        try {
            ArrayList<JRDataSource> list = new ArrayList<JRDataSource>();
            list.add((JRDataSource)this.getParameterValue("REPORT_DATA_SOURCE"));
            return new JRBeanCollectionDataSource(list);
        }
        catch (JRScriptletException jRScriptletException) {
            return null;
        }
    }

    public Collection<CidsBean> getSelf() {
        if (this.selfReference == null) {
            try {
                ArrayList<CidsBean> collection = new ArrayList<CidsBean>();
                JRFillParameter param = (JRFillParameter)this.parametersMap.get("self");
                if (param != null) {
                    CidsBean self = (CidsBean)param.getValue();
                    collection.add(self);
                    this.selfReference = collection;
                    return this.selfReference;
                }
                MetaClass mcWkFg = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
                String query = "SELECT    " + mcWkFg.getID() + ",    " + mcWkFg.getPrimaryKey() + " FROM    " + mcWkFg.getTableName() + " WHERE    id = " + String.valueOf(this.getId()) + ";";
                this.selfReference = this.getBeansFromQuery(query);
                return this.selfReference;
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while getting self for wk-fg with id " + String.valueOf(this.getId())), (Throwable)ex);
                return null;
            }
        }
        return this.selfReference;
    }

    public Collection<CidsBean> getMassnahmen() {
        try {
            MetaClass mcMassnahmen = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"massnahmen");
            String query = "SELECT    " + mcMassnahmen.getID() + ",    " + mcMassnahmen.getPrimaryKey() + " FROM    " + mcMassnahmen.getTableName() + " WHERE    wk_fg = " + String.valueOf(this.getId()) + ";";
            return this.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while getting massnahmen for wk-fg with id " + String.valueOf(this.getId())), (Throwable)ex);
            return null;
        }
    }

    public String getTeilgebiet() {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
        Collection wkTeile = (Collection)((JRFillField)this.fieldsMap.get("teile")).getValue();
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (CidsBean wkTeilBean : wkTeile) {
            CidsBean geomBean = (CidsBean)wkTeilBean.getProperty("linie.geom");
            LineString geom = (LineString)geomBean.getProperty("geo_field");
            lineStrings.add(geom);
        }
        MultiLineString wkGeom = gf.createMultiLineString(lineStrings.toArray(new LineString[0]));
        String geometryText = "SRID=" + wkGeom.getSRID() + ";" + wkGeom.toText();
        try {
            Object o;
            TeilgebieteSearch search = new TeilgebieteSearch(geometryText);
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            ArrayList resArray = (ArrayList)res;
            if (resArray != null && resArray.size() > 0 && ((ArrayList)resArray.get(0)).size() > 0 && (o = ((ArrayList)resArray.get(0)).get(0)) instanceof String) {
                return o.toString();
            }
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Exception during a cids server search.", (Throwable)e);
        }
        return null;
    }

    public String getGewName() {
        Collection wkTeile = (Collection)((JRFillField)this.fieldsMap.get("teile")).getValue();
        ArrayList<String> gewNames = new ArrayList<String>();
        String allNames = null;
        for (CidsBean wkTeilBean : wkTeile) {
            String gewName = (String)wkTeilBean.getProperty("linie.von.route.routenname");
            if (gewNames.contains(gewName)) continue;
            gewNames.add(gewName);
        }
        for (String name : gewNames) {
            if (allNames == null) {
                allNames = name;
                continue;
            }
            allNames = allNames + ", " + name;
        }
        return allNames;
    }

    public Collection<CidsBean> getLawa() {
        if (this.lawaTypes == null) {
            try {
                MetaClass mcLawa = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"lawa");
                MetaClass mcStation_linie = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station_linie");
                MetaClass mcStation = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station");
                String query = "SELECT   " + mcLawa.getID() + ",    l." + mcLawa.getPrimaryKey() + ",        s.wert  FROM    " + mcLawa.getTableName() + " l  JOIN    " + mcStation_linie.getTableName() + " sl on l.linie = sl." + mcStation_linie.getPrimaryKey() + " JOIN    " + mcStation.getTableName() + " s on sl.von = s." + mcStation.getPrimaryKey() + " WHERE        wk_k = '" + this.getWkK() + "'  order by s.wert ;";
                ArrayList<CidsBean> lawa_types = this.getBeansFromQuery(query);
                if (lawa_types.size() > 1) {
                    this.extendLawa_TypesWithNoTypeElements(lawa_types);
                }
                this.lawaTypes = lawa_types;
                return this.lawaTypes;
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while getting lawa types for wk-fg with id " + String.valueOf(this.getId())), (Throwable)ex);
                return null;
            }
        }
        return this.lawaTypes;
    }

    private void extendLawa_TypesWithNoTypeElements(ArrayList<CidsBean> lawa_types) throws Exception {
        ListIterator<CidsBean> iter = lawa_types.listIterator();
        CidsBean lawa_type1 = iter.next();
        while (iter.hasNext()) {
            CidsBean lawa_type2 = iter.next();
            Double lawa1_bis = (Double)lawa_type1.getProperty("linie.bis.wert");
            Double lawa2_von = (Double)lawa_type2.getProperty("linie.von.wert");
            if (lawa1_bis < lawa2_von) {
                long cids2RouteGWK;
                CidsBean newLawa = this.createNewLawaCidsBean();
                long cids1RouteGWK = (Long)lawa_type1.getProperty("linie.von.route.gwk");
                if (cids1RouteGWK == (cids2RouteGWK = ((Long)lawa_type2.getProperty("linie.von.route.gwk")).longValue())) {
                    newLawa.setProperty("lawa_nr.description", (Object)"kein Typ");
                    newLawa.setProperty("linie.von.wert", (Object)lawa1_bis);
                    newLawa.setProperty("linie.bis.wert", (Object)lawa2_von);
                } else {
                    newLawa.setProperty("lawa_nr.description", (Object)"Gew\u00e4sserwechsel");
                }
                iter.previous();
                iter.add(newLawa);
                iter.next();
            }
            lawa_type1 = lawa_type2;
        }
    }

    private CidsBean createNewLawaCidsBean() throws Exception {
        CidsBean newLawa = CidsBeanSupport.createNewCidsBeanFromTableName("LAWA");
        CidsBean newLawa_Nr = CidsBeanSupport.createNewCidsBeanFromTableName("LA_LAWA_NR");
        CidsBean newLinie = CidsBeanSupport.createNewCidsBeanFromTableName("Station_linie");
        CidsBean newVon = CidsBeanSupport.createNewCidsBeanFromTableName("Station");
        CidsBean newBis = CidsBeanSupport.createNewCidsBeanFromTableName("Station");
        newLawa.setProperty("lawa_nr", (Object)newLawa_Nr);
        newLawa.setProperty("linie", (Object)newLinie);
        newLinie.setProperty("von", (Object)newVon);
        newLinie.setProperty("bis", (Object)newBis);
        return newLawa;
    }

    public Collection<CidsBean> getMst() {
        try {
            String query = "SELECT    " + this.MC_MST_MESS.getID() + ",    m." + this.MC_MST_MESS.getPrimaryKey() + " FROM    " + this.MC_MST_MESS.getTableName() + " m,    " + this.MC_MST_STAMM.getTableName() + " s WHERE    m.messstelle = s.id AND    s.wk_fg = " + this.getId() + " and (    (o2_owert_rakon is not null and o2_value is not null) or     (ges_p_owert_rakon is not null and ges_p_mittelwert is not null ) or     (opo4_owert_rakon is not null and opo4_mittelwert is not null ) or     (nh4_owert_rakon is not null and nh4_mittelwert is not null ) or     (cl_owert_rakon is not null and cl_mittelwert is not null )    )ORDER BY    messjahr DESC ";
            return this.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while getting mst for wk-fg with id " + String.valueOf(this.getId())), (Throwable)ex);
            return null;
        }
    }

    private int getId() {
        return (Integer)((JRFillField)this.fieldsMap.get("id")).getValue();
    }

    private String getWkK() {
        return (String)((JRFillField)this.fieldsMap.get("wk_k")).getValue();
    }

    private ArrayList<CidsBean> getBeansFromQuery(String query) {
        ArrayList<CidsBean> collection;
        block4: {
            collection = new ArrayList<CidsBean>();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)query);
                }
                for (MetaObject mo : SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, "WRRL_DB_MV")) {
                    collection.add(mo.getBean());
                }
            }
            catch (ConnectionException ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"error while fetching metaobject", (Throwable)ex);
            }
        }
        return collection;
    }

    public Image generateMap() {
        try {
            String urlBackground = "https://sgx.geodatenzentrum.de/wms_topplus_open?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=web&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=default&EXCEPTIONS=application/vnd.ogc.se_inimage";
            String urlOverlay = "http://wms.fis-wasser-mv.de/services?&VERSION=1.1.1&REQUEST=GetMap&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&SRS=EPSG:5650&FORMAT=image/png&TRANSPARENT=TRUE&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=wk_fg,report_route_stat&STYLES=Mit+K%C3%BCrzel,default";
            GeometryFactory gf = new GeometryFactory();
            Collection wkTeile = (Collection)((JRFillField)this.fieldsMap.get("teile")).getValue();
            ArrayList<LineString> lineStrings = new ArrayList<LineString>();
            for (CidsBean wkTeilBean : wkTeile) {
                CidsBean geomBean = (CidsBean)wkTeilBean.getProperty("linie.geom");
                LineString geom = (LineString)geomBean.getProperty("geo_field");
                lineStrings.add(geom);
            }
            XBoundingBox boundingBox = new XBoundingBox((Geometry)gf.createMultiLineString(lineStrings.toArray(new LineString[0])));
            boundingBox.setX1(boundingBox.getX1() - 50.0);
            boundingBox.setY1(boundingBox.getY1() - 50.0);
            boundingBox.setX2(boundingBox.getX2() + 50.0);
            boundingBox.setY2(boundingBox.getY2() + 50.0);
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            mapProvider.setCenterMapOnResize(true);
            mapProvider.setBoundingBox(boundingBox);
            SimpleWmsGetMapUrl getMapUrl = new SimpleWmsGetMapUrl("https://sgx.geodatenzentrum.de/wms_topplus_open?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=web&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=default&EXCEPTIONS=application/vnd.ogc.se_inimage");
            SimpleWMS simpleWms = new SimpleWMS(getMapUrl);
            mapProvider.addLayer((RetrievalServiceLayer)simpleWms);
            getMapUrl = new SimpleWmsGetMapUrl("http://wms.fis-wasser-mv.de/services?&VERSION=1.1.1&REQUEST=GetMap&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&SRS=EPSG:5650&FORMAT=image/png&TRANSPARENT=TRUE&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=wk_fg,report_route_stat&STYLES=Mit+K%C3%BCrzel,default");
            simpleWms = new SimpleWMS(getMapUrl);
            mapProvider.addLayer((RetrievalServiceLayer)simpleWms);
            int teilNo = 0;
            for (CidsBean wkTeilBean : wkTeile) {
                DefaultStyledFeature part = new DefaultStyledFeature();
                part.setGeometry((Geometry)wkTeilBean.getProperty("linie.geom.geo_field"));
                part.setPrimaryAnnotation(wkTeilBean.getProperty("linie.von.route.gwk").toString());
                part.setPrimaryAnnotationVisible(true);
                part.setPrimaryAnnotationPaint((Paint)Color.BLACK);
                part.setPrimaryAnnotationHalo(Color.WHITE);
                part.setAutoScale(true);
                part.setLinePaint((Paint)this.colors[teilNo++ % this.colors.length]);
                part.setLineWidth(3);
                mapProvider.addFeature((Feature)part);
            }
            return mapProvider.getImageAndWait(72, 130, 555.0, 375.0);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while retrieving map for wk: " + this.getWkK()), (Throwable)e);
            return null;
        }
    }

    public Image generateOverviewMap() {
        try {
            String urlBackground = "https://sgx.geodatenzentrum.de/wms_topplus_open?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=web&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=default&EXCEPTIONS=application/vnd.ogc.se_inimage";
            GeometryFactory gf = new GeometryFactory();
            Collection wkTeile = (Collection)((JRFillField)this.fieldsMap.get("teile")).getValue();
            ArrayList<LineString> lineStrings = new ArrayList<LineString>();
            for (CidsBean wkTeilBean : wkTeile) {
                CidsBean geomBean = (CidsBean)wkTeilBean.getProperty("linie.geom");
                LineString geom = (LineString)geomBean.getProperty("geo_field");
                lineStrings.add(geom);
            }
            XBoundingBox boundingBox = new XBoundingBox((Geometry)gf.createMultiLineString(lineStrings.toArray(new LineString[0])));
            boundingBox.increase(100);
            boundingBox.setX1(boundingBox.getX1() - 50.0);
            boundingBox.setY1(boundingBox.getY1() - 50.0);
            boundingBox.setX2(boundingBox.getX2() + 50.0);
            boundingBox.setY2(boundingBox.getY2() + 50.0);
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            mapProvider.setCenterMapOnResize(true);
            mapProvider.setBoundingBox(boundingBox);
            SimpleWmsGetMapUrl getMapUrl = new SimpleWmsGetMapUrl("https://sgx.geodatenzentrum.de/wms_topplus_open?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=web&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=default&EXCEPTIONS=application/vnd.ogc.se_inimage");
            SimpleWMS simpleWms = new SimpleWMS(getMapUrl);
            mapProvider.addLayer((RetrievalServiceLayer)simpleWms);
            DefaultStyledFeature f = new DefaultStyledFeature();
            f.setGeometry((Geometry)gf.createMultiLineString(lineStrings.toArray(new LineString[0])));
            f.setHighlightingEnabled(true);
            f.setPrimaryAnnotation((String)((JRFillField)this.fieldsMap.get("wk_k")).getValue());
            f.setPrimaryAnnotationVisible(true);
            f.setPrimaryAnnotationPaint((Paint)Color.BLACK);
            f.setPrimaryAnnotationHalo(Color.WHITE);
            f.setAutoScale(true);
            f.setLinePaint((Paint)Color.RED);
            f.setLineWidth(3);
            mapProvider.addFeature((Feature)f);
            return mapProvider.getImageAndWait(72, 130, 555.0, 375.0);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while retrieving map for wk: " + this.getWkK()), (Throwable)e);
            return null;
        }
    }

    public String formatMeasureTypeCodes(Collection<CidsBean> measureTypeCollection) {
        String measureTypeCodes = "";
        for (CidsBean measureTypeCode : measureTypeCollection) {
            measureTypeCodes = measureTypeCodes + measureTypeCode.getProperty("value") + ": " + measureTypeCode.getProperty("name") + "\n";
        }
        if (!measureTypeCodes.equals("")) {
            measureTypeCodes = measureTypeCodes.substring(0, measureTypeCodes.length() - 1);
        }
        return measureTypeCodes;
    }

    public class SignallingRetrievalListener
    implements RetrievalListener {
        private BufferedImage image = null;
        private Lock lock;
        private Condition condition;

        public SignallingRetrievalListener(Lock lock, Condition condition) {
            this.lock = lock;
            this.condition = condition;
        }

        public void retrievalStarted(RetrievalEvent e) {
        }

        public void retrievalProgress(RetrievalEvent e) {
        }

        public void retrievalComplete(RetrievalEvent e) {
            if (e.getRetrievedObject() instanceof Image) {
                Image retrievedImage = (Image)e.getRetrievedObject();
                this.image = new BufferedImage(retrievedImage.getWidth(null), retrievedImage.getHeight(null), 2);
                Graphics2D g = (Graphics2D)this.image.getGraphics();
                g.drawImage(retrievedImage, 0, 0, null);
                g.dispose();
            }
            this.signalAll();
        }

        public void retrievalAborted(RetrievalEvent e) {
            this.signalAll();
        }

        public void retrievalError(RetrievalEvent e) {
            this.signalAll();
        }

        public BufferedImage getRetrievedImage() {
            return this.image;
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

