/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.scriptlets;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.fill.JRFillField;
import org.apache.log4j.Logger;

public class WkSgScriptlet
extends JRDefaultScriptlet {
    private static final Logger LOG = Logger.getLogger(WkSgScriptlet.class);

    public JRBeanCollectionDataSource getJRBeanCollectionDataSource() {
        try {
            ArrayList<JRDataSource> list = new ArrayList<JRDataSource>();
            list.add((JRDataSource)this.getParameterValue("REPORT_DATA_SOURCE"));
            return new JRBeanCollectionDataSource(list);
        }
        catch (JRScriptletException jRScriptletException) {
            return null;
        }
    }

    public Collection<CidsBean> getSelf() {
        try {
            MetaClass mcWkSg = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_sg");
            String query = "SELECT    " + mcWkSg.getID() + ",    " + mcWkSg.getPrimaryKey() + " FROM    " + mcWkSg.getTableName() + " WHERE    id = " + String.valueOf(this.getId()) + ";";
            return this.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.fatal((Object)"", (Throwable)ex);
            }
            return null;
        }
    }

    public Collection<CidsBean> getSwstn() {
        try {
            MetaClass mcSwstn = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"swstn");
            MetaClass mcWkSg = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_sg");
            MetaClass mcGeom = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"geom");
            String query = "SELECT    " + mcSwstn.getID() + ",    swstn." + mcSwstn.getPrimaryKey() + " FROM    " + mcSwstn.getTableName() + " AS swstn,    " + mcWkSg.getTableName() + " AS wk_sg,    " + mcGeom.getTableName() + " AS gs,    " + mcGeom.getTableName() + " AS gf WHERE    swstn.point = gs.id AND    wk_sg.geom = gf.id AND    wk_sg.id = " + String.valueOf(this.getId()) + " AND    st_intersects(gf.geo_field, gs.geo_field);";
            return this.getBeansFromQuery(query);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.fatal((Object)"", (Throwable)ex);
            }
            return null;
        }
    }

    private Collection<CidsBean> getBeansFromQuery(String query) {
        ArrayList<CidsBean> collection;
        block3: {
            collection = new ArrayList<CidsBean>();
            try {
                for (MetaObject mo : SessionManager.getProxy().getMetaObjectByQuery(query, 0)) {
                    collection.add(mo.getBean());
                }
            }
            catch (ConnectionException ex) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"error while fetching metaobject", (Throwable)ex);
            }
        }
        return collection;
    }

    private int getId() {
        return (Integer)((JRFillField)this.fieldsMap.get("id")).getValue();
    }

    public Image generateMap() {
        try {
            String call = "http://www.geodaten-mv.de/dienste/webatlasde_wms/service?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=WebAtlasDE_MV_farbe&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage";
            CidsBean geomBean = (CidsBean)((JRFillField)this.fieldsMap.get("geom")).getValue();
            Geometry geom = (Geometry)geomBean.getProperty("geo_field");
            XBoundingBox boundingBox = new XBoundingBox(geom);
            boundingBox.setX1(boundingBox.getX1() - 50.0);
            boundingBox.setY1(boundingBox.getY1() - 50.0);
            boundingBox.setX2(boundingBox.getX2() + 50.0);
            boundingBox.setY2(boundingBox.getY2() + 50.0);
            SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl("http://www.geodaten-mv.de/dienste/webatlasde_wms/service?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=WebAtlasDE_MV_farbe&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage"));
            swms.setName((String)((JRFillField)this.fieldsMap.get("ls_name")).getValue());
            swms.setBoundingBox((BoundingBox)boundingBox);
            swms.setSize(375, 555);
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            mapProvider.addLayer((RetrievalServiceLayer)swms);
            mapProvider.setBoundingBox(boundingBox);
            mapProvider.setCenterMapOnResize(true);
            return mapProvider.getImageAndWait(72, 72, 555.0, 375.0);
        }
        catch (Exception ex) {
            LOG.fatal((Object)"error", (Throwable)ex);
            return null;
        }
    }

    public class SignallingRetrievalListener
    implements RetrievalListener {
        private BufferedImage image = null;
        private Lock lock;
        private Condition condition;

        public SignallingRetrievalListener(Lock lock, Condition condition) {
            this.lock = lock;
            this.condition = condition;
        }

        public void retrievalStarted(RetrievalEvent e) {
        }

        public void retrievalProgress(RetrievalEvent e) {
        }

        public void retrievalComplete(RetrievalEvent e) {
            if (e.getRetrievedObject() instanceof Image) {
                Image retrievedImage = (Image)e.getRetrievedObject();
                this.image = new BufferedImage(retrievedImage.getWidth(null), retrievedImage.getHeight(null), 1);
                Graphics2D g = (Graphics2D)this.image.getGraphics();
                g.drawImage(retrievedImage, 0, 0, null);
                g.dispose();
            }
            this.signalAll();
        }

        public void retrievalAborted(RetrievalEvent e) {
            this.signalAll();
        }

        public void retrievalError(RetrievalEvent e) {
            this.signalAll();
        }

        public BufferedImage getRetrievedImage() {
            return this.image;
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

