/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.toolbar.wrrl_db_mv;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.custom.toolbar.wrrl_db_mv.OEGWaitDialog;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.builtin.GeoSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class OEGToolProvider
implements ToolbarComponentsProvider {
    public static final String OEG_GESAMT = "OEG_GESAMT";
    public static final String OEG_EINZELN = "OEG_EINZELN";
    OEGWaitDialog waiting = null;
    ArrayList<MetaClass> oegGesamt = null;
    ArrayList<MetaClass> oegEinzeln = null;
    private final List<ToolbarComponentDescription> toolbarComponents;
    private final Logger log = Logger.getLogger(this.getClass());

    public OEGToolProvider() {
        ArrayList<ToolbarComponentDescription> preparationList = new ArrayList<ToolbarComponentDescription>();
        JSeparator sep = new JSeparator(1);
        sep.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        sep.setPreferredSize(new Dimension(2, 10));
        sep.setName("oeg-sep");
        JToggleButton cmdOEGGesamt = new JToggleButton();
        cmdOEGGesamt.setToolTipText("OEG Tool (Gesamt)");
        cmdOEGGesamt.setName("oeg_tool_gesamt");
        cmdOEGGesamt.setBorderPainted(false);
        cmdOEGGesamt.setFocusable(false);
        cmdOEGGesamt.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/toolbar/wrrl_db_mv/Tool_oeg.png")));
        cmdOEGGesamt.setHorizontalTextPosition(0);
        cmdOEGGesamt.setVerticalTextPosition(3);
        cmdOEGGesamt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (CismapBroker.getInstance().getMappingComponent().getInputListener(OEGToolProvider.OEG_GESAMT) == null) {
                        CismapBroker.getInstance().getMappingComponent().addInputListener(OEGToolProvider.OEG_GESAMT, new PBasicInputEventHandler(){

                            public void mouseClicked(PInputEvent event) {
                                OEGToolProvider.this.OegSearch(OEGToolProvider.OEG_GESAMT, event);
                            }
                        });
                        CismapBroker.getInstance().getMappingComponent().putCursor(OEGToolProvider.OEG_GESAMT, new Cursor(1));
                    }
                    CismapBroker.getInstance().getMappingComponent().setInteractionMode(OEGToolProvider.OEG_GESAMT);
                }
                catch (Exception e) {
                    OEGToolProvider.this.log.error((Object)"Fehler beim Aufruf des OEG-Tools", (Throwable)e);
                }
            }
        });
        JToggleButton cmdOEGEinzel = new JToggleButton();
        cmdOEGEinzel.setToolTipText("OEG Tool (Einzeln)");
        cmdOEGEinzel.setName("oeg_tool_einzeln");
        cmdOEGEinzel.setBorderPainted(false);
        cmdOEGEinzel.setFocusable(false);
        cmdOEGEinzel.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/toolbar/wrrl_db_mv/Tool_oeg.png")));
        cmdOEGEinzel.setHorizontalTextPosition(0);
        cmdOEGEinzel.setVerticalTextPosition(3);
        cmdOEGEinzel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CismapBroker.getInstance().getMappingComponent().getInputListener(OEGToolProvider.OEG_EINZELN) == null) {
                    CismapBroker.getInstance().getMappingComponent().addInputListener(OEGToolProvider.OEG_EINZELN, new PBasicInputEventHandler(){

                        public void mouseClicked(PInputEvent event) {
                            super.mouseClicked(event);
                            OEGToolProvider.this.OegSearch(OEGToolProvider.OEG_EINZELN, event);
                        }
                    });
                    CismapBroker.getInstance().getMappingComponent().putCursor(OEGToolProvider.OEG_EINZELN, new Cursor(1));
                }
                CismapBroker.getInstance().getMappingComponent().setInteractionMode(OEGToolProvider.OEG_EINZELN);
            }
        });
        CismapBroker.getInstance().getMappingComponent().getInteractionButtonGroup().add(cmdOEGGesamt);
        CismapBroker.getInstance().getMappingComponent().getInteractionButtonGroup().add(cmdOEGEinzel);
        preparationList.add(new ToolbarComponentDescription("tlbMain", (JComponent)sep, ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "cmdClipboard"));
        preparationList.add(new ToolbarComponentDescription("tlbMain", (JComponent)cmdOEGGesamt, ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "oeg-sep"));
        preparationList.add(new ToolbarComponentDescription("tlbMain", (JComponent)cmdOEGEinzel, ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "oeg_tool_gesamt"));
        this.toolbarComponents = Collections.unmodifiableList(preparationList);
    }

    public String getPluginName() {
        return "OEGTool";
    }

    public Collection<ToolbarComponentDescription> getToolbarComponents() {
        return this.toolbarComponents;
    }

    private void OegSearch(final String type, final PInputEvent event) {
        final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        this.waiting = new OEGWaitDialog(StaticSwingTools.getParentFrame((Component)mc), true);
        final SwingWorker<Collection<Feature>, Void> search = new SwingWorker<Collection<Feature>, Void>(){

            @Override
            protected Collection<Feature> doInBackground() throws Exception {
                Point geom = mc.getPointGeometryFromPInputEvent(event);
                Geometry transformed = CrsTransformer.transformToDefaultCrs((Geometry)geom);
                transformed.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                GeoSearch gs = (GeoSearch)Lookup.getDefault().lookup(GeoSearch.class);
                gs.setGeometry(transformed);
                if (type.equals(OEGToolProvider.OEG_GESAMT)) {
                    if (OEGToolProvider.this.oegGesamt == null) {
                        OEGToolProvider.this.oegGesamt = new ArrayList();
                        try {
                            OEGToolProvider.this.oegGesamt.add(CidsBean.getMetaClassFromTableName((String)"WRRL_DB_MV", (String)"oeg_einzugsgebiet"));
                            OEGToolProvider.this.oegGesamt.add(CidsBean.getMetaClassFromTableName((String)"WRRL_DB_MV", (String)"oeg_kummuliert"));
                        }
                        catch (Exception exception) {
                            OEGToolProvider.this.log.error((Object)"Fehler beim Setzen der KLassen", (Throwable)exception);
                        }
                    }
                    gs.setValidClasses(OEGToolProvider.this.oegGesamt);
                } else {
                    if (OEGToolProvider.this.oegEinzeln == null) {
                        OEGToolProvider.this.oegEinzeln = new ArrayList();
                        try {
                            OEGToolProvider.this.oegEinzeln.add(CidsBean.getMetaClassFromTableName((String)"WRRL_DB_MV", (String)"oeg_einzugsgebiet"));
                            OEGToolProvider.this.oegEinzeln.add(CidsBean.getMetaClassFromTableName((String)"WRRL_DB_MV", (String)"oeg_kummuliert_ref"));
                        }
                        catch (Exception exception) {
                            OEGToolProvider.this.log.error((Object)"Fehler beim Setzen der KLassen", (Throwable)exception);
                        }
                    }
                    gs.setValidClasses(OEGToolProvider.this.oegEinzeln);
                }
                ArrayList<Feature> cfs = new ArrayList<Feature>();
                Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)gs);
                for (Object o : res) {
                    MetaObjectNode mon = (MetaObjectNode)o;
                    MetaObject mo = SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain());
                    CidsFeature cf = new CidsFeature(mo);
                    cfs.add((Feature)cf);
                }
                return cfs;
            }

            @Override
            protected void done() {
                try {
                    Collection result = (Collection)this.get();
                    ArrayList expandedResults = new ArrayList((int)((double)result.size() * 1.6));
                    for (Feature f : result) {
                        if (f instanceof FeatureGroup) {
                            ArrayList allFeaturesToAdd = new ArrayList(FeatureGroups.expandAll((FeatureGroup)((FeatureGroup)f)));
                            expandedResults.addAll(allFeaturesToAdd);
                        }
                        expandedResults.add(f);
                    }
                    mc.getFeatureCollection().substituteFeatures(expandedResults);
                    if (!mc.isFixedMapExtent()) {
                        mc.zoomToFeatureCollection(mc.isFixedMapScale());
                    }
                }
                catch (Exception e) {
                    OEGToolProvider.this.log.error((Object)"Exception in Background Thread", (Throwable)e);
                }
                OEGToolProvider.this.waiting.dispose();
            }
        };
        CismetThreadPool.execute((Runnable)search);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OEGToolProvider.this.waiting.setWorker(search);
                OEGToolProvider.this.waiting.pack();
                StaticSwingTools.showDialog((JDialog)OEGToolProvider.this.waiting);
            }
        });
    }
}

