/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.fgsk;

import de.cismet.cids.custom.wrrl_db_mv.fgsk.CalcCache;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.ValidationException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.Equals;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class Calc {
    public static final String PROP_BED_SUBSTRATE_PREFIX = "PROP_BED_SUBSTRATE_";
    public static final String PROP_LAND_USE_RI = "flaechennutzung_rechts_id";
    public static final String PROP_LAND_USE_LE = "flaechennutzung_links_id";
    public static final String PROP_LINE = "linie";
    public static final String PROP_TO = "bis";
    public static final String PROP_FROM = "von";
    public static final String PROP_UPPER_PROFILE_BREADTH = "obere_profilbreite";
    public static final String PROP_WERT = "wert";
    public static final String PROP_VALUE = "value";
    public static final String PROP_WB_TRIMMING_RI = "gewaesserrandstreifen_rechts_id";
    public static final String PROP_WB_TRIMMING_LE = "gewaesserrandstreifen_links_id";
    public static final String PROP_WB_ENV_SUM_RATING = "gewaesserumfeld_summe_punktzahl";
    public static final String PROP_WB_ENV_SUM_CRIT = "gewaesserumfeld_anzahl_kriterien";
    public static final String PROP_WB_ENV_SUM_RATING_LE = "gewaesserumfeld_summe_punktzahl_links";
    public static final String PROP_WB_ENV_SUM_CRIT_LE = "gewaesserumfeld_anzahl_kriterien_links";
    public static final String PROP_WB_ENV_SUM_RATING_RI = "gewaesserumfeld_summe_punktzahl_rechts";
    public static final String PROP_WB_ENV_SUM_CRIT_RI = "gewaesserumfeld_anzahl_kriterien_rechts";
    public static final String PROP_WB_TYPE = "gewaessertyp_id";
    public static final String PROP_BAD_ENV_STRUCT_AG_LE = "s_umfeldstrukturen_ag_links";
    public static final String PROP_BAD_ENV_STRUCT_AG_RI = "s_umfeldstrukturen_ag_rechts";
    public static final String PROP_BAD_ENV_STRUCT_FT_LE = "s_umfeldstrukturen_ft_links";
    public static final String PROP_BAD_ENV_STRUCT_FT_RI = "s_umfeldstrukturen_ft_rechts";
    public static final String PROP_BAD_ENV_STRUCT_GUA_LE = "s_umfeldstrukturen_gua_links";
    public static final String PROP_BAD_ENV_STRUCT_GUA_RI = "s_umfeldstrukturen_gua_rechts";
    public static final String PROP_BAD_ENV_STRUCT_BV_LE = "s_umfeldstrukturen_bv_links";
    public static final String PROP_BAD_ENV_STRUCT_BV_RI = "s_umfeldstrukturen_bv_rechts";
    public static final String PROP_BAD_ENV_STRUCT_MA_LE = "s_umfeldstrukturen_ma_links";
    public static final String PROP_BAD_ENV_STRUCT_MA_RI = "s_umfeldstrukturen_ma_rechts";
    public static final String PROP_BAD_ENV_STRUCT_HW_LE = "s_umfeldstrukturen_hw_links";
    public static final String PROP_BAD_ENV_STRUCT_HW_RI = "s_umfeldstrukturen_hw_rechts";
    public static final String PROP_BAD_ENV_STRUCT_SO_LE = "s_umfeldstrukturen_so_links";
    public static final String PROP_BAD_ENV_STRUCT_SO_RI = "s_umfeldstrukturen_so_rechts";
    public static final String PROP_FLOW_VELOCITY = "fliessgeschwindigkeit_id";
    public static final String PROP_FLOW_DIVERSITY = "stroemungsdiversitaet_id";
    public static final String PROP_DEPTH_VARIANCE = "tiefenvarianz_id";
    public static final String PROP_DEPTH_EROSION = "tiefenerosion_id";
    public static final String PROP_CROSS_BENCH_COUNT = "querbaenke_anzahl";
    public static final String PROP_LONG_PROFILE_SUM_RATING = "laengsprofil_summe_punktzahl";
    public static final String PROP_LONG_PROFILE_SUM_CRIT = "laengsprofil_anzahl_kriterien";
    public static final String PROP_COURSE_LOOP = "laufkruemmung_id";
    public static final String PROP_LOOP_EROSION = "kruemmungserosion_id";
    public static final String PROP_LONG_BENCH_UFKG = "laengsbaenke_ufkg";
    public static final String PROP_LONG_BENCH_IB = "laengsbaenke_ib";
    public static final String PROP_LONG_BENCH_MB = "laengsbaenke_mb";
    public static final String PROP_COURSE_STRUCTURE_TV = "laufstrukturen_tv";
    public static final String PROP_COURSE_STRUCTURE_SB = "laufstrukturen_sb";
    public static final String PROP_COURSE_STRUCTURE_IBI = "laufstrukturen_ibi";
    public static final String PROP_COURSE_STRUCTURE_LW = "laufstrukturen_lw";
    public static final String PROP_COURSE_STRUCTURE_LV = "laufstrukturen_lv";
    public static final String PROP_COURSE_STRUCTURE_LG = "laufstrukturen_lg";
    public static final String PROP_COURSE_EVO_SUM_RATING = "laufentwicklung_summe_punktzahl";
    public static final String PROP_COURSE_EVO_SUM_CRIT = "laufentwicklung_anzahl_kriterien";
    public static final String PROP_PROFILE_TYPE = "profiltyp_id";
    public static final String PROP_BREADTH_VARIANCE = "breitenvarianz_id";
    public static final String PROP_BREADTH_EROSION = "breitenerosion_id";
    public static final String PROP_INCISION_DEPTH = "einschnitttiefe";
    public static final String PROP_WATER_DEPTH = "wassertiefe";
    public static final String PROP_CROSS_PROFILE_SUM_RATING = "querprofil_summe_punktzahl";
    public static final String PROP_CROSS_PROFILE_SUM_CRIT = "querprofil_anzahl_kriterien";
    public static final String PROP_BED_FITMENT = "sohlenverbau_id";
    public static final String PROP_Z_BED_FITMENT = "z_sohlenverbau_id";
    public static final String PROP_WB_SUB_TYPE = "gewaessersubtyp";
    public static final String PROP_BED_SUBSTRATE_TON = "sohlensubstrat_ton";
    public static final String PROP_BED_SUBSTRATE_SAN = "sohlensubstrat_san";
    public static final String PROP_BED_SUBSTRATE_KIE = "sohlensubstrat_kie";
    public static final String PROP_BED_SUBSTRATE_STE = "sohlensubstrat_ste";
    public static final String PROP_BED_SUBSTRATE_BLO = "sohlensubstrat_blo";
    public static final String PROP_BED_SUBSTRATE_SCH = "sohlensubstrat_sch";
    public static final String PROP_BED_SUBSTRATE_TOR = "sohlensubstrat_tor";
    public static final String PROP_BED_SUBSTRATE_TOT = "sohlensubstrat_tot";
    public static final String PROP_BED_SUBSTRATE_WUR = "sohlensubstrat_wur";
    public static final String PROP_BED_SUBSTRATE_KUE = "sohlensubstrat_kue";
    public static final String PROP_BED_STRUCTURE_RIP = "sohlenstrukturen_rip";
    public static final String PROP_BED_STRUCTURE_TH = "sohlenstrukturen_th";
    public static final String PROP_BED_STRUCTURE_WU = "sohlenstrukturen_wu";
    public static final String PROP_BED_STRUCTURE_KO = "sohlenstrukturen_ko";
    public static final String PROP_BED_CONTAMINATION_MUE = "belastung_sohle_mue";
    public static final String PROP_BED_CONTAMINATION_ST = "belastung_sohle_st";
    public static final String PROP_BED_CONTAMINATION_ABW = "belastung_sohle_abw";
    public static final String PROP_BED_CONTAMINATION_VO = "belastung_sohle_vo";
    public static final String PROP_BED_CONTAMINATION_SA = "belastung_sohle_sa";
    public static final String PROP_BED_CONTAMINATION_SO = "belastung_sohle_so";
    public static final String PROP_BED_STRUCTURE_SUM_RATING = "sohlenstruktur_summe_punktzahl";
    public static final String PROP_BED_STRUCTURE_SUM_CRIT = "sohlenstruktur_anzahl_kriterien";
    public static final String PROP_BANK_VEGETATION_LE = "ufervegetation_links_id";
    public static final String PROP_BANK_VEGETATION_RI = "ufervegetation_rechts_id";
    public static final String PROP_BANK_VEGETATION_TYPICAL_LE = "ufervegetation_links_typical";
    public static final String PROP_BANK_VEGETATION_TYPICAL_RI = "ufervegetation_rechts_typical";
    public static final String PROP_BANK_FITMENT_LE = "uferverbau_links_id";
    public static final String PROP_BANK_FITMENT_RI = "uferverbau_rechts_id";
    public static final String PROP_Z_BANK_FITMENT_LE = "z_uferverbau_links_id";
    public static final String PROP_Z_BANK_FITMENT_RI = "z_uferverbau_rechts_id";
    public static final String PROP_BANK_STRUCTURE_BU_LE = "uferstruktur_bu_links";
    public static final String PROP_BANK_STRUCTURE_BU_RI = "uferstruktur_bu_rechts";
    public static final String PROP_BANK_STRUCTURE_PB_LE = "uferstruktur_pb_links";
    public static final String PROP_BANK_STRUCTURE_PB_RI = "uferstruktur_pb_rechts";
    public static final String PROP_BANK_STRUCTURE_US_LE = "uferstruktur_us_links";
    public static final String PROP_BANK_STRUCTURE_US_RI = "uferstruktur_us_rechts";
    public static final String PROP_BANK_STRUCTURE_SB_LE = "uferstruktur_sb_links";
    public static final String PROP_BANK_STRUCTURE_SB_RI = "uferstruktur_sb_rechts";
    public static final String PROP_BANK_STRUCTURE_HA_LE = "uferstruktur_ha_links";
    public static final String PROP_BANK_STRUCTURE_HA_RI = "uferstruktur_ha_rechts";
    public static final String PROP_BANK_STRUCTURE_NBOE_LE = "uferstruktur_nboe_links";
    public static final String PROP_BANK_STRUCTURE_NBOE_RI = "uferstruktur_nboe_rechts";
    public static final String PROP_BANK_STRUCTURE_SO_LE = "uferstruktur_so_links";
    public static final String PROP_BANK_STRUCTURE_SO_RI = "uferstruktur_so_rechts";
    public static final String PROP_BANK_CONTAMINATION_MUE_LE = "uferbelastungen_mue_links";
    public static final String PROP_BANK_CONTAMINATION_MUE_RI = "uferbelastungen_mue_rechts";
    public static final String PROP_BANK_CONTAMINATION_ST_LE = "uferbelastungen_st_links";
    public static final String PROP_BANK_CONTAMINATION_ST_RI = "uferbelastungen_st_rechts";
    public static final String PROP_BANK_CONTAMINATION_TS_LE = "uferbelastungen_ts_links";
    public static final String PROP_BANK_CONTAMINATION_TS_RI = "uferbelastungen_ts_rechts";
    public static final String PROP_BANK_CONTAMINATION_EL_LE = "uferbelastungen_el_links";
    public static final String PROP_BANK_CONTAMINATION_EL_RI = "uferbelastungen_el_rechts";
    public static final String PROP_BANK_CONTAMINATION_SO_LE = "uferbelastungen_so_links";
    public static final String PROP_BANK_CONTAMINATION_SO_RI = "uferbelastungen_so_rechts";
    public static final String PROP_BANK_STRUCTURE_SUM_RATING = "uferstruktur_summe_punktzahl";
    public static final String PROP_BANK_STRUCTURE_SUM_CRIT = "uferstruktur_anzahl_kriterien";
    public static final String PROP_BANK_STRUCTURE_SUM_RATING_LE = "uferstruktur_summe_punktzahl_links";
    public static final String PROP_BANK_STRUCTURE_SUM_CRIT_LE = "uferstruktur_anzahl_kriterien_links";
    public static final String PROP_BANK_STRUCTURE_SUM_RATING_RI = "uferstruktur_summe_punktzahl_rechts";
    public static final String PROP_BANK_STRUCTURE_SUM_CRIT_RI = "uferstruktur_anzahl_kriterien_rechts";
    public static final String PROP_WB_OVERALL_RATING = "punktzahl_gesamt";
    public static final String PROP_WB_BED_RATING = "punktzahl_sohle";
    public static final String PROP_WB_BANK_RATING = "punktzahl_ufer";
    public static final String PROP_WB_BANK_RATING_LE = "punktzahl_ufer_links";
    public static final String PROP_WB_BANK_RATING_RI = "punktzahl_ufer_rechts";
    public static final String PROP_WB_ENV_RATING = "punktzahl_land";
    public static final String PROP_WB_ENV_RATING_LE = "punktzahl_land_links";
    public static final String PROP_WB_ENV_RATING_RI = "punktzahl_land_rechts";
    public static final String PROP_EXCEPTION = "sonderfall_id";
    public static final String PROP_SIM_FLOW_DIV_RATING = "bewertung_stroemungsdiversitaet";
    public static final String PROP_SIM_CROSS_BENCH_COUNT_RATING = "bewertung_anzahl_querbaenke";
    public static final String PROP_SIM_LONG_BENCH_COUNT_RATING = "bewertung_anzahl_laengsbaenke";
    public static final String PROP_SIM_BREADTH_VARIANCE_RATING = "bewertung_breitenvarianz";
    public static final String PROP_SIM_BED_STRUCTURE_COUNT_RATING = "bewertung_anzahl_besondere_sohlstrukturen";
    static final CalcCache cache = CalcCache.getInstance();
    private static final transient Logger LOG = Logger.getLogger(Calc.class);
    private final transient int scale;

    private Calc() {
        this.scale = 12;
    }

    public static Calc getInstance() {
        return LazyInitializer.INSTANCE;
    }

    public void calcWBEnvRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        this.calcWBEnvRating(kaBean, true);
        this.calcWBEnvRating(kaBean, false);
        Double ratingLeft = (Double)kaBean.getProperty(PROP_WB_ENV_SUM_RATING_LE);
        Integer criteriaCountLeft = (Integer)kaBean.getProperty(PROP_WB_ENV_SUM_CRIT_LE);
        Double ratingRight = (Double)kaBean.getProperty(PROP_WB_ENV_SUM_RATING_RI);
        Integer criteriaCountRight = (Integer)kaBean.getProperty(PROP_WB_ENV_SUM_CRIT_RI);
        double rating = ratingLeft + ratingRight;
        if (rating < 1.0) {
            rating = 1.0;
        }
        try {
            kaBean.setProperty(PROP_WB_ENV_SUM_RATING, (Object)rating);
            kaBean.setProperty(PROP_WB_ENV_SUM_CRIT, (Object)(criteriaCountLeft + criteriaCountRight));
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    private boolean isException(CidsBean kaBean) throws ValidationException {
        if (kaBean == null) {
            throw new IllegalArgumentException("cidsBean must not be null");
        }
        CidsBean exception = (CidsBean)kaBean.getProperty(PROP_EXCEPTION);
        if (exception != null && !Integer.valueOf(0).equals(exception.getProperty(PROP_VALUE))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("aborting calculation, because the kartierabschnitt is an exception: " + kaBean));
            }
            throw new ValidationException("calculation for exceptional kartierabschnitte is illegal", true);
        }
        return false;
    }

    public void calcWBEnvRating(CidsBean kaBean, boolean left) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, Calc.fieldFromCode("PROP_LAND_USE", "", left), Calc.fieldFromCode("PROP_WB_TRIMMING", "", left))) {
            throw new ValidationException("the waterbody environment properties contain null values");
        }
        CidsBean exception = (CidsBean)kaBean.getProperty(PROP_EXCEPTION);
        if (exception != null && !Integer.valueOf(0).equals(exception.getProperty(PROP_VALUE))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("aborting calculation, because the kartierabschnitt is an exception: " + kaBean));
            }
            return;
        }
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without water body type: " + kaBean);
        }
        int wbTypeId = wbTypeBean.getMetaObject().getId();
        Integer ratingWBTriming = this.getWBTrimmingRating(wbTypeId, kaBean, left);
        Integer ratingLandUse = this.getLandUseRating(wbTypeId, kaBean, left);
        double badEnvRating = this.getBadEnvRating(wbTypeId, kaBean, left);
        RatingStruct rating = new RatingStruct();
        Calc.overallRating(rating, true, ratingWBTriming, ratingLandUse);
        Calc.overallRating(rating, false, badEnvRating);
        try {
            kaBean.setProperty(Calc.fieldFromCode("PROP_WB_ENV_SUM_RATING", "", left), (Object)rating.rating);
            kaBean.setProperty(Calc.fieldFromCode("PROP_WB_ENV_SUM_CRIT", "", left), (Object)rating.criteriaCount);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public Double getBadEnvRating(int wbTypeId, CidsBean kaBean, boolean left) {
        double badEnvRating = 0.0;
        for (CalcCache.BadEnvStructureType type : CalcCache.BadEnvStructureType.values()) {
            Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BAD_ENV_STRUCT_", type.getCode(), left));
            if (count == null || !(count > 0.0)) continue;
            Double rating = cache.getBadEnvStructureRating(type, wbTypeId);
            if (rating == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("ignoring rating for type: " + (Object)((Object)type) + " | wbtypeId: " + wbTypeId));
                continue;
            }
            badEnvRating += rating.doubleValue();
        }
        badEnvRating = Calc.correctBadEnvRating(badEnvRating, wbTypeId);
        return badEnvRating;
    }

    public Double getBadEnvCount(int wbTypeId, CidsBean kaBean, boolean left) {
        double badEnvCount = 0.0;
        for (CalcCache.BadEnvStructureType type : CalcCache.BadEnvStructureType.values()) {
            Double count;
            if (type.getId() == 7 || (count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BAD_ENV_STRUCT_", type.getCode(), left))) == null || !(count > 0.0)) continue;
            badEnvCount += count.doubleValue();
        }
        return badEnvCount;
    }

    public Integer getLandUseRating(int wbTypeId, CidsBean kaBean, boolean left) {
        CidsBean landUseBean = (CidsBean)kaBean.getProperty(Calc.fieldFromCode("PROP_LAND_USE", "", left));
        return cache.getWBLandUseRating(landUseBean.getMetaObject().getId(), wbTypeId);
    }

    public Integer getWBTrimmingRating(int wbTypeId, CidsBean kaBean, boolean left) {
        CidsBean wbTrimmingBean = (CidsBean)kaBean.getProperty(Calc.fieldFromCode("PROP_WB_TRIMMING", "", left));
        return cache.getWBTrimmingRating(wbTrimmingBean.getMetaObject().getId(), wbTypeId);
    }

    public void calcWBLongProfileRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, PROP_FLOW_VELOCITY, PROP_FLOW_DIVERSITY, PROP_DEPTH_VARIANCE, PROP_DEPTH_EROSION, PROP_CROSS_BENCH_COUNT)) {
            throw new ValidationException("the waterbody long profile properties contain null values");
        }
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without water body type: " + kaBean);
        }
        int wbTypeId = wbTypeBean.getMetaObject().getId();
        double crossBenchCount = (Double)kaBean.getProperty(PROP_CROSS_BENCH_COUNT);
        Double sectionLength = cache.getCrossBenchSectionLength(wbTypeId);
        double stationLength = Calc.getStationLength(kaBean);
        Object absCrossBenchCount = crossBenchCount == 0.5 ? Double.valueOf(crossBenchCount) : (sectionLength == null ? null : Double.valueOf(Calc.round(Calc.round(crossBenchCount / (stationLength / sectionLength), this.scale))));
        CidsBean flowDiversityBean = (CidsBean)kaBean.getProperty(PROP_FLOW_DIVERSITY);
        CidsBean depthVarianceBean = (CidsBean)kaBean.getProperty(PROP_DEPTH_VARIANCE);
        CidsBean flowVelocityBean = (CidsBean)kaBean.getProperty(PROP_FLOW_VELOCITY);
        Integer ratingCrossBench = cache.getCrossBenchRating((Double)absCrossBenchCount, wbTypeId);
        Integer ratingFlowDiversity = cache.getFlowDiversityRating(flowDiversityBean.getMetaObject().getId(), wbTypeId);
        Integer ratingFlowVelocity = cache.getFlowVelocityRating(flowVelocityBean.getMetaObject().getId(), wbTypeId);
        Integer ratingDepthVariance = cache.getDepthVarianceRating(depthVarianceBean.getMetaObject().getId(), wbTypeId);
        RatingStruct rating = new RatingStruct();
        Calc.overallRating(rating, true, ratingCrossBench, ratingFlowDiversity, ratingFlowVelocity, ratingDepthVariance);
        try {
            kaBean.setProperty(PROP_LONG_PROFILE_SUM_RATING, (Object)rating.rating);
            kaBean.setProperty(PROP_LONG_PROFILE_SUM_CRIT, (Object)rating.criteriaCount);
            kaBean.setProperty(PROP_SIM_FLOW_DIV_RATING, (Object)ratingFlowDiversity);
            kaBean.setProperty(PROP_SIM_CROSS_BENCH_COUNT_RATING, (Object)ratingCrossBench);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void calcCourseEvoRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, PROP_COURSE_LOOP, PROP_LOOP_EROSION)) {
            throw new ValidationException("the waterbody course evolution properties contain null values");
        }
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without water body type: " + kaBean);
        }
        double longBenchSum = 0.0;
        for (CalcCache.LongBenchType type : CalcCache.LongBenchType.values()) {
            Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_LONG_BENCH_", type.getCode()));
            if (count == null || !(count > 0.0)) continue;
            longBenchSum += count.doubleValue();
        }
        int wbTypeId = wbTypeBean.getMetaObject().getId();
        double stationLength = Calc.getStationLength(kaBean);
        Double longBenchSectionLength = cache.getLongBenchSectionLength(wbTypeId);
        Object absLongBenchSum = longBenchSum == 0.5 ? Double.valueOf(longBenchSum) : (longBenchSectionLength == null ? null : Double.valueOf(Calc.round(Calc.round(longBenchSum / (stationLength / longBenchSectionLength), this.scale))));
        double courseStructureSum = 0.0;
        for (CalcCache.CourseStructureType type : CalcCache.CourseStructureType.values()) {
            Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_COURSE_STRUCTURE_", type.getCode()));
            if (count == null || !(count > 0.0)) continue;
            courseStructureSum += count.doubleValue();
        }
        Double courseStructureSectionLength = cache.getCourseStructureSectionLength(wbTypeId);
        Object absCourseStructureSum = courseStructureSum == 0.5 ? Double.valueOf(courseStructureSum) : (courseStructureSectionLength == null ? null : Double.valueOf(Calc.round(Calc.round(courseStructureSum / (stationLength / courseStructureSectionLength), this.scale))));
        CidsBean courseLoopBean = (CidsBean)kaBean.getProperty(PROP_COURSE_LOOP);
        CidsBean loopErosionBean = (CidsBean)kaBean.getProperty(PROP_LOOP_EROSION);
        Integer ratingCourseLoop = cache.getCourseLoopRating(courseLoopBean.getMetaObject().getId(), wbTypeId);
        Integer ratingLoopErosion = cache.getLoopErosionRating(loopErosionBean.getMetaObject().getId(), wbTypeId);
        Integer ratingCourseStructure = cache.getCourseStructureRating((Double)absCourseStructureSum, wbTypeId);
        Double ratingLongBench = cache.getLongBenchRating((Double)absLongBenchSum, wbTypeId);
        RatingStruct rating = new RatingStruct();
        Calc.overallRating(rating, true, ratingCourseLoop, ratingLoopErosion, ratingCourseStructure);
        Calc.overallRating(rating, false, ratingLongBench);
        try {
            kaBean.setProperty(PROP_COURSE_EVO_SUM_RATING, (Object)rating.rating);
            kaBean.setProperty(PROP_COURSE_EVO_SUM_CRIT, (Object)rating.criteriaCount);
            kaBean.setProperty(PROP_SIM_LONG_BENCH_COUNT_RATING, (Object)ratingLongBench);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void calcWBCrossProfileRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, PROP_PROFILE_TYPE, PROP_BREADTH_VARIANCE, PROP_BREADTH_EROSION, PROP_UPPER_PROFILE_BREADTH, PROP_INCISION_DEPTH, PROP_WATER_DEPTH)) {
            throw new ValidationException("the waterbody cross profile properties contain null values");
        }
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without water body type: " + kaBean);
        }
        int wbTypeId = wbTypeBean.getMetaObject().getId();
        double upperProfileBreadth = (Double)kaBean.getProperty(PROP_UPPER_PROFILE_BREADTH);
        double incisionDepth = (Double)kaBean.getProperty(PROP_INCISION_DEPTH);
        double waterDepth = (Double)kaBean.getProperty(PROP_WATER_DEPTH);
        double profileDepth = incisionDepth + waterDepth;
        double breadthDepthRelation = Calc.round(Calc.round(upperProfileBreadth / profileDepth, this.scale));
        CidsBean profileTypeBean = (CidsBean)kaBean.getProperty(PROP_PROFILE_TYPE);
        CidsBean breadthVarianceBean = (CidsBean)kaBean.getProperty(PROP_BREADTH_VARIANCE);
        CidsBean breadthErosionBean = (CidsBean)kaBean.getProperty(PROP_BREADTH_EROSION);
        Integer ratingDepthBreadth = cache.getProfileDepthBreadthRelationRating(breadthDepthRelation, wbTypeId);
        if (ratingDepthBreadth == null && (ratingDepthBreadth = cache.getBiggestProfileDepthBreadthRelationRating(breadthDepthRelation, wbTypeId)) == null) {
            ratingDepthBreadth = cache.getLowestProfileDepthBreadthRelationRating(breadthDepthRelation, wbTypeId);
        }
        Integer ratingBreadthVariance = cache.getBreadthVarianceRating(breadthVarianceBean.getMetaObject().getId(), wbTypeId);
        Integer ratingBreadthErosion = cache.getBreadthErosionRating(breadthErosionBean.getMetaObject().getId(), wbTypeId);
        Integer ratingProfileType = cache.getProfileTypeRating(profileTypeBean.getMetaObject().getId(), wbTypeId);
        RatingStruct rating = new RatingStruct();
        Calc.overallRating(rating, true, ratingDepthBreadth, ratingProfileType, ratingBreadthErosion, ratingBreadthVariance);
        try {
            kaBean.setProperty(PROP_CROSS_PROFILE_SUM_RATING, (Object)rating.rating);
            kaBean.setProperty(PROP_CROSS_PROFILE_SUM_CRIT, (Object)rating.criteriaCount);
            kaBean.setProperty(PROP_SIM_BREADTH_VARIANCE_RATING, (Object)ratingBreadthVariance);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void calcBedStructureRating(CidsBean kaBean) throws ValidationException {
        Double ratingSubstratesDouble;
        Integer ratingSubstrates;
        Double ratingBedStructure;
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, PROP_BED_FITMENT, PROP_Z_BED_FITMENT)) {
            throw new ValidationException("the waterbody bed structure properties contain null values");
        }
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without water body type: " + kaBean);
        }
        int naturalSubstratesCount = 0;
        for (CalcCache.BedSubtrateType type : CalcCache.BedSubtrateType.getNaturalBedSubstrateTypes()) {
            Double percentage = (Double)kaBean.getProperty(Calc.fieldFromCode(PROP_BED_SUBSTRATE_PREFIX, type.getCode()));
            if (percentage == null || !(percentage > 0.0)) continue;
            ++naturalSubstratesCount;
        }
        double artificalSubstratePercentage = 0.0;
        for (CalcCache.BedSubtrateType type : CalcCache.BedSubtrateType.getArtificialSubstrateTypes()) {
            Double percentage = (Double)kaBean.getProperty(Calc.fieldFromCode(PROP_BED_SUBSTRATE_PREFIX, type.getCode()));
            if (percentage == null) continue;
            artificalSubstratePercentage += percentage.doubleValue();
        }
        double hardSubstratePercentage = 0.0;
        for (CalcCache.BedSubtrateType type : CalcCache.BedSubtrateType.getHardSubstrateTypes()) {
            Double percentage = (Double)kaBean.getProperty(Calc.fieldFromCode(PROP_BED_SUBSTRATE_PREFIX, type.getCode()));
            if (percentage == null) continue;
            hardSubstratePercentage += percentage.doubleValue();
        }
        int wbTypeId = wbTypeBean.getMetaObject().getId();
        Double bedStructureSectionLength = cache.getBedStructureSectionLength(wbTypeId);
        double stationLength = Calc.getStationLength(kaBean);
        CidsBean bedFitmentBean = (CidsBean)kaBean.getProperty(PROP_BED_FITMENT);
        CidsBean zBedFitmentBean = (CidsBean)kaBean.getProperty(PROP_Z_BED_FITMENT);
        if (bedStructureSectionLength != null && bedStructureSectionLength > 0.0) {
            double bedStructureCount = 0.0;
            for (CalcCache.BedStructureType type : CalcCache.BedStructureType.values()) {
                Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BED_STRUCTURE_", type.getCode()));
                if (count == null) continue;
                bedStructureCount += count.doubleValue();
            }
            double absBedStructureCount = Calc.round(Calc.round(bedStructureCount / (stationLength / bedStructureSectionLength), this.scale));
            ratingBedStructure = cache.getBedStructureRating(absBedStructureCount, wbTypeId);
        } else {
            ratingBedStructure = null;
        }
        Collection wbSubTypeList = (Collection)kaBean.getProperty(PROP_WB_SUB_TYPE);
        String wbSubTypeId = null;
        if (wbSubTypeList != null && !wbSubTypeList.isEmpty()) {
            Iterator it = wbSubTypeList.iterator();
            while (it.hasNext()) {
                String val = (String)((CidsBean)it.next()).getProperty(PROP_VALUE);
                if (val == null || !"S".equals(val) && !"M".equals(val)) continue;
                if (wbSubTypeId == null) {
                    wbSubTypeId = val;
                    continue;
                }
                throw new IllegalStateException("found more than one relevant subtype for kartierabschnitt: " + kaBean);
            }
        }
        Integer ratingNaturalSubstrates = cache.getNaturalSubstrateRating(Double.valueOf(naturalSubstratesCount), wbSubTypeId, wbTypeId);
        Integer ratingArtificialSubstrates = cache.getArtificialSubstrateRating(artificalSubstratePercentage, wbSubTypeId, wbTypeId);
        Integer ratingHardSubstrates = cache.getHardSubstrateRating(hardSubstratePercentage, wbSubTypeId, wbTypeId);
        boolean ignoreSubstrates = true;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_BLO) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_BLO) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_KIE) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_KIE) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_KUE) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_KUE) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_TON) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_TON) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_TOR) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_TOR) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_TOT) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_TOT) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_SAN) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_SAN) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_SCH) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_SCH) == 0.0;
        ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_STE) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_STE) == 0.0;
        if (!(ignoreSubstrates &= kaBean.getProperty(PROP_BED_SUBSTRATE_WUR) == null || (Double)kaBean.getProperty(PROP_BED_SUBSTRATE_WUR) == 0.0) && Equals.nonNull((Object[])new Object[]{ratingNaturalSubstrates, ratingArtificialSubstrates, ratingHardSubstrates})) {
            ratingSubstrates = Calc.round(Calc.round((double)(ratingNaturalSubstrates + ratingArtificialSubstrates + ratingHardSubstrates) / 3.0, this.scale));
            ratingSubstratesDouble = Calc.round((double)(ratingNaturalSubstrates + ratingArtificialSubstrates + ratingHardSubstrates) / 3.0, 1);
        } else {
            ratingSubstrates = null;
            ratingSubstratesDouble = null;
        }
        try {
            kaBean.setProperty("bewertung_substratdiversitaet", ratingSubstratesDouble);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not set bewertung_substratdiversitaet");
        }
        Integer ratingBedFitment = cache.getBedFitmentRating(bedFitmentBean.getMetaObject().getId(), zBedFitmentBean.getMetaObject().getId(), wbTypeId);
        Double ratingBedContamination = this.calcBedContamination(kaBean, wbTypeId);
        RatingStruct rating = new RatingStruct();
        Calc.overallRating(rating, true, ratingSubstrates, ratingBedFitment);
        Calc.overallRating(rating, false, ratingBedContamination, ratingBedStructure);
        double finalRating = rating.rating;
        if (finalRating < 1.0 && rating.criteriaCount > 0) {
            finalRating = 1.0;
        }
        try {
            kaBean.setProperty(PROP_BED_STRUCTURE_SUM_RATING, (Object)finalRating);
            kaBean.setProperty(PROP_BED_STRUCTURE_SUM_CRIT, (Object)rating.criteriaCount);
            kaBean.setProperty(PROP_SIM_BED_STRUCTURE_COUNT_RATING, (Object)ratingBedStructure);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public Double calcBedContamination(CidsBean kaBean, int wbTypeId) {
        Double ratingBedContamination = null;
        Double ratingMaxBedContamination = cache.getMaxBedContaminationRating(wbTypeId);
        for (CalcCache.BedContaminationType type : CalcCache.BedContaminationType.values()) {
            Double rating;
            Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BED_CONTAMINATION_", type.getCode()));
            if (count == null || !(count > 0.0) || (rating = cache.getBedContaminationRating(type.getId(), wbTypeId)) == null) continue;
            if (ratingBedContamination == null) {
                ratingBedContamination = 0.0;
            }
            ratingBedContamination = ratingBedContamination + rating;
        }
        if (ratingBedContamination != null && ratingBedContamination < ratingMaxBedContamination) {
            ratingBedContamination = ratingMaxBedContamination;
        }
        return ratingBedContamination;
    }

    public double calcBedContaminationCount(CidsBean kaBean, int wbTypeId) {
        double bedContamination = 0.0;
        for (CalcCache.BedContaminationType type : CalcCache.BedContaminationType.values()) {
            Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BED_CONTAMINATION_", type.getCode()));
            if (count == null || !(count > 0.0)) continue;
            bedContamination += count.doubleValue();
        }
        return bedContamination;
    }

    public void calcBankStructureRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        this.calcBankStructureRating(kaBean, true);
        this.calcBankStructureRating(kaBean, false);
        Double ratingLeft = (Double)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_RATING_LE);
        Integer criteriaCountLeft = (Integer)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_CRIT_LE);
        Double ratingRight = (Double)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_RATING_RI);
        Integer criteriaCountRight = (Integer)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_CRIT_RI);
        double rating = ratingLeft + ratingRight;
        if (rating < 1.0) {
            rating = 1.0;
        }
        try {
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_RATING, (Object)rating);
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_CRIT, (Object)(criteriaCountLeft + criteriaCountRight));
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void calcBankStructureRating(CidsBean kaBean, boolean left) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, Calc.fieldFromCode("PROP_BANK_VEGETATION", "", left), Calc.fieldFromCode("PROP_BANK_FITMENT", "", left), Calc.fieldFromCode("PROP_Z_BANK_FITMENT", "", left))) {
            throw new ValidationException("the waterbody bank structure properties contain null values");
        }
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without water body type: " + kaBean);
        }
        int wbTypeId = wbTypeBean.getMetaObject().getId();
        double stationLength = Calc.getStationLength(kaBean);
        Integer ratingBankVegetation = this.getBankVegetationRating(wbTypeId, stationLength, kaBean, left);
        Integer ratingBankStructure = this.getBankStructureRating(wbTypeId, stationLength, kaBean, left);
        Integer ratingBankFitment = this.getBankFitmentRating(wbTypeId, stationLength, kaBean, left);
        Double ratingBankContamination = this.getBankContaminationRating(wbTypeId, stationLength, kaBean, left);
        RatingStruct rating = new RatingStruct();
        Calc.overallRating(rating, true, ratingBankStructure, ratingBankVegetation, ratingBankFitment);
        Calc.overallRating(rating, false, ratingBankContamination);
        try {
            kaBean.setProperty(Calc.fieldFromCode("PROP_BANK_STRUCTURE_SUM_RATING", "", left), (Object)rating.rating);
            kaBean.setProperty(Calc.fieldFromCode("PROP_BANK_STRUCTURE_SUM_CRIT", "", left), (Object)rating.criteriaCount);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public Double getBankContaminationRating(int wbTypeId, double stationLength, CidsBean kaBean, boolean left) {
        Double ratingBankContamination = null;
        for (CalcCache.BankContaminationType type : CalcCache.BankContaminationType.values()) {
            Double rating;
            Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BANK_CONTAMINATION_", type.getCode(), left));
            if (count != null && count > 0.0 && (rating = cache.getBankContaminationRating(type.getId(), wbTypeId)) != null) {
                if (ratingBankContamination == null) {
                    ratingBankContamination = 0.0;
                }
                ratingBankContamination = ratingBankContamination + rating;
            }
            if (ratingBankContamination == null || !(ratingBankContamination < -2.5)) continue;
            ratingBankContamination = -2.5;
        }
        return ratingBankContamination;
    }

    public Double getBankContaminationCount(int wbTypeId, CidsBean kaBean, boolean left) {
        double bankContamination = 0.0;
        for (CalcCache.BankContaminationType type : CalcCache.BankContaminationType.values()) {
            Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BANK_CONTAMINATION_", type.getCode(), left));
            if (count == null || !(count > 0.0)) continue;
            bankContamination += count.doubleValue();
        }
        return bankContamination;
    }

    public Integer getBankFitmentRating(int wbTypeId, double stationLength, CidsBean kaBean, boolean left) {
        CidsBean bankFitmentBean = (CidsBean)kaBean.getProperty(Calc.fieldFromCode("PROP_BANK_FITMENT", "", left));
        CidsBean zBankFitmentBean = (CidsBean)kaBean.getProperty(Calc.fieldFromCode("PROP_Z_BANK_FITMENT", "", left));
        return cache.getBankFitmentRating(bankFitmentBean.getMetaObject().getId(), zBankFitmentBean.getMetaObject().getId(), wbTypeId);
    }

    public Integer getBankVegetationRating(int wbTypeId, double stationLength, CidsBean kaBean, boolean left) {
        CidsBean bankVegetationBean = (CidsBean)kaBean.getProperty(Calc.fieldFromCode("PROP_BANK_VEGETATION", "", left));
        Boolean typical = (Boolean)kaBean.getProperty(Calc.fieldFromCode("PROP_BANK_VEGETATION_TYPICAL", "", left));
        boolean bankVegetationTypical = typical == null ? false : typical;
        return cache.getBankVegetationRating(bankVegetationBean.getMetaObject().getId(), bankVegetationTypical, wbTypeId);
    }

    public Integer getBankStructureRating(int wbTypeId, double stationLength, CidsBean kaBean, boolean left) {
        Integer ratingBankStructure;
        Double bankStructureSectionLength = cache.getBankStructureSectionLength(wbTypeId);
        if (stationLength > 0.0 && bankStructureSectionLength != null) {
            double bankStructureCount = 0.0;
            for (CalcCache.BankStructureType type : CalcCache.BankStructureType.values()) {
                Double count = (Double)kaBean.getProperty(Calc.fieldFromCode("PROP_BANK_STRUCTURE_", type.getCode(), left));
                if (count == null || !(count > 0.0)) continue;
                bankStructureCount += count.doubleValue();
            }
            double absBankStructureCount = bankStructureCount == 0.5 ? bankStructureCount : (double)Calc.round(Calc.round(bankStructureCount / stationLength * bankStructureSectionLength, this.scale));
            ratingBankStructure = cache.getBankStructureRating(absBankStructureCount, wbTypeId);
        } else {
            ratingBankStructure = null;
        }
        return ratingBankStructure;
    }

    public void calcOverallRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNullOrZero(kaBean, PROP_WB_BED_RATING, PROP_WB_BANK_RATING, PROP_WB_ENV_RATING)) {
            throw new ValidationException("the waterbody rating properties contain null or zero values");
        }
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without wb type");
        }
        Integer wbType = (Integer)wbTypeBean.getProperty(PROP_VALUE);
        if (wbType == null) {
            throw new IllegalStateException("kartierabschnitt bean with illegal wb type");
        }
        double ratingBed = (Double)kaBean.getProperty(PROP_WB_BED_RATING);
        double ratingBank = (Double)kaBean.getProperty(PROP_WB_BANK_RATING);
        double ratingEnv = (Double)kaBean.getProperty(PROP_WB_ENV_RATING);
        double ratingOverall = wbType == 23 ? (ratingBed + 2.0 * ratingBank + 2.0 * ratingEnv) / 5.0 : (ratingBed + ratingBank + ratingEnv) / 3.0;
        try {
            kaBean.setProperty(PROP_WB_OVERALL_RATING, (Object)ratingOverall);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void calcBedRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, PROP_COURSE_EVO_SUM_RATING, PROP_COURSE_EVO_SUM_CRIT, PROP_BED_STRUCTURE_SUM_RATING, PROP_BED_STRUCTURE_SUM_CRIT, PROP_LONG_PROFILE_SUM_RATING, PROP_LONG_PROFILE_SUM_CRIT)) {
            throw new ValidationException("the bed rating properties contain null values");
        }
        double ratingCourseEvo = (Double)kaBean.getProperty(PROP_COURSE_EVO_SUM_RATING);
        int critCountCourseEvo = (Integer)kaBean.getProperty(PROP_COURSE_EVO_SUM_CRIT);
        double ratingLongProfile = (Double)kaBean.getProperty(PROP_LONG_PROFILE_SUM_RATING);
        int critCountLongProfile = (Integer)kaBean.getProperty(PROP_LONG_PROFILE_SUM_CRIT);
        double ratingBedStructure = (Double)kaBean.getProperty(PROP_BED_STRUCTURE_SUM_RATING);
        int critCountBedStructure = (Integer)kaBean.getProperty(PROP_BED_STRUCTURE_SUM_CRIT);
        CidsBean wbTypeBean = (CidsBean)kaBean.getProperty(PROP_WB_TYPE);
        if (wbTypeBean == null) {
            throw new IllegalStateException("kartierabschnitt bean without wb type");
        }
        Integer wbType = (Integer)wbTypeBean.getProperty(PROP_VALUE);
        if (wbType == null) {
            throw new IllegalStateException("kartierabschnitt bean with illegal wb type");
        }
        if ((ratingLongProfile == 0.0 || critCountLongProfile == 0) && wbType != 23) {
            throw new ValidationException("the longprofile rating or criteria count is 0 but the wb type is not 23");
        }
        int critCount = critCountCourseEvo + critCountLongProfile + critCountBedStructure;
        if (critCount <= 0) {
            throw new ValidationException("the bed rating does not contain at least one criteria");
        }
        double ratingBed = Math.min((ratingCourseEvo + ratingLongProfile + ratingBedStructure) / (double)critCount, 5.0);
        try {
            kaBean.setProperty(PROP_WB_BED_RATING, (Object)ratingBed);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void calcBankRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNull(kaBean, PROP_CROSS_PROFILE_SUM_RATING, PROP_CROSS_PROFILE_SUM_CRIT, PROP_BANK_STRUCTURE_SUM_RATING, PROP_BANK_STRUCTURE_SUM_CRIT, PROP_BANK_STRUCTURE_SUM_RATING_LE, PROP_BANK_STRUCTURE_SUM_CRIT_LE, PROP_BANK_STRUCTURE_SUM_RATING_RI, PROP_BANK_STRUCTURE_SUM_CRIT_RI)) {
            throw new ValidationException("the bank rating properties contain null or zero values");
        }
        double ratingCrossProfile = (Double)kaBean.getProperty(PROP_CROSS_PROFILE_SUM_RATING);
        int critCountCrossProfile = (Integer)kaBean.getProperty(PROP_CROSS_PROFILE_SUM_CRIT);
        double ratingBankStructure = (Double)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_RATING);
        int critCountBankStructure = (Integer)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_CRIT);
        double ratingBankStructureLe = (Double)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_RATING_LE);
        int critCountBankStructureLe = (Integer)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_CRIT_LE);
        double ratingBankStructureRi = (Double)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_RATING_RI);
        int critCountBankStructureRi = (Integer)kaBean.getProperty(PROP_BANK_STRUCTURE_SUM_CRIT_RI);
        int critCount = critCountCrossProfile + critCountBankStructure;
        int critCountLe = critCountCrossProfile + critCountBankStructureLe;
        int critCountRi = critCountCrossProfile + critCountBankStructureRi;
        if (critCount <= 0 || critCountLe <= 0 || critCountRi <= 0) {
            throw new ValidationException("the bank rating does not contain at least one criteria");
        }
        double ratingBank = Math.min((ratingCrossProfile + ratingBankStructure) / (double)critCount, 5.0);
        double ratingBankLe = Math.min((ratingCrossProfile + ratingBankStructureLe) / (double)critCountLe, 5.0);
        double ratingBankRi = Math.min((ratingCrossProfile + ratingBankStructureRi) / (double)critCountRi, 5.0);
        try {
            kaBean.setProperty(PROP_WB_BANK_RATING, (Object)ratingBank);
            kaBean.setProperty(PROP_WB_BANK_RATING_LE, (Object)ratingBankLe);
            kaBean.setProperty(PROP_WB_BANK_RATING_RI, (Object)ratingBankRi);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void calcEnvRating(CidsBean kaBean) throws ValidationException {
        if (this.isException(kaBean)) {
            return;
        }
        if (!this.propsNotNullOrZero(kaBean, PROP_WB_ENV_SUM_RATING, PROP_WB_ENV_SUM_RATING_LE, PROP_WB_ENV_SUM_RATING_RI, PROP_WB_ENV_SUM_CRIT, PROP_WB_ENV_SUM_CRIT_LE, PROP_WB_ENV_SUM_CRIT_RI)) {
            throw new ValidationException("the env rating properties contain null or zero values");
        }
        double ratingWBEnv = (Double)kaBean.getProperty(PROP_WB_ENV_SUM_RATING);
        double ratingWBEnvLe = (Double)kaBean.getProperty(PROP_WB_ENV_SUM_RATING_LE);
        double ratingWBEnvRi = (Double)kaBean.getProperty(PROP_WB_ENV_SUM_RATING_RI);
        int critCountWBEnv = (Integer)kaBean.getProperty(PROP_WB_ENV_SUM_CRIT);
        int critCountWBEnvLe = (Integer)kaBean.getProperty(PROP_WB_ENV_SUM_CRIT_LE);
        int critCountWBEnvRi = (Integer)kaBean.getProperty(PROP_WB_ENV_SUM_CRIT_RI);
        double ratingEnv = Math.min(ratingWBEnv / (double)critCountWBEnv, 5.0);
        double ratingEnvLe = Math.min(ratingWBEnvLe / (double)critCountWBEnvLe, 5.0);
        double ratingEnvRi = Math.min(ratingWBEnvRi / (double)critCountWBEnvRi, 5.0);
        try {
            kaBean.setProperty(PROP_WB_ENV_RATING, (Object)ratingEnv);
            kaBean.setProperty(PROP_WB_ENV_RATING_LE, (Object)ratingEnvLe);
            kaBean.setProperty(PROP_WB_ENV_RATING_RI, (Object)ratingEnvRi);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void removeAllRatings(CidsBean kaBean) {
        try {
            kaBean.setProperty(PROP_WB_ENV_SUM_RATING, null);
            kaBean.setProperty(PROP_WB_ENV_SUM_CRIT, null);
            kaBean.setProperty(PROP_LONG_PROFILE_SUM_RATING, null);
            kaBean.setProperty(PROP_LONG_PROFILE_SUM_CRIT, null);
            kaBean.setProperty(PROP_SIM_FLOW_DIV_RATING, null);
            kaBean.setProperty(PROP_SIM_CROSS_BENCH_COUNT_RATING, null);
            kaBean.setProperty(PROP_COURSE_EVO_SUM_RATING, null);
            kaBean.setProperty(PROP_COURSE_EVO_SUM_CRIT, null);
            kaBean.setProperty(PROP_SIM_LONG_BENCH_COUNT_RATING, null);
            kaBean.setProperty(PROP_CROSS_PROFILE_SUM_RATING, null);
            kaBean.setProperty(PROP_CROSS_PROFILE_SUM_CRIT, null);
            kaBean.setProperty(PROP_SIM_BREADTH_VARIANCE_RATING, null);
            kaBean.setProperty(PROP_BED_STRUCTURE_SUM_RATING, null);
            kaBean.setProperty(PROP_BED_STRUCTURE_SUM_CRIT, null);
            kaBean.setProperty(PROP_SIM_BED_STRUCTURE_COUNT_RATING, null);
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_RATING, null);
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_CRIT, null);
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_RATING_LE, null);
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_RATING_RI, null);
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_CRIT_LE, null);
            kaBean.setProperty(PROP_BANK_STRUCTURE_SUM_CRIT_RI, null);
            kaBean.setProperty(PROP_WB_ENV_SUM_RATING_LE, null);
            kaBean.setProperty(PROP_WB_ENV_SUM_RATING_RI, null);
            kaBean.setProperty(PROP_WB_ENV_SUM_CRIT_LE, null);
            kaBean.setProperty(PROP_WB_ENV_SUM_CRIT_RI, null);
            kaBean.setProperty(PROP_WB_BED_RATING, null);
            kaBean.setProperty(PROP_WB_BANK_RATING, null);
            kaBean.setProperty(PROP_WB_BANK_RATING_LE, null);
            kaBean.setProperty(PROP_WB_BANK_RATING_RI, null);
            kaBean.setProperty(PROP_WB_ENV_RATING, null);
            kaBean.setProperty(PROP_WB_ENV_RATING_LE, null);
            kaBean.setProperty(PROP_WB_ENV_RATING_RI, null);
            kaBean.setProperty(PROP_WB_OVERALL_RATING, null);
        }
        catch (Exception e) {
            String message = "cannot update bean values: " + kaBean;
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public static double getStationLength(CidsBean kaBean) {
        try {
            CidsBean stationBean = (CidsBean)kaBean.getProperty(PROP_LINE);
            CidsBean toBean = (CidsBean)stationBean.getProperty(PROP_TO);
            CidsBean fromBean = (CidsBean)stationBean.getProperty(PROP_FROM);
            Double toValue = (Double)toBean.getProperty(PROP_WERT);
            Double fromValue = (Double)fromBean.getProperty(PROP_WERT);
            return Math.abs(toValue - fromValue);
        }
        catch (Exception e) {
            String message = "illegal station settings in kartierabschnitt";
            LOG.error((Object)"illegal station settings in kartierabschnitt", (Throwable)e);
            throw new IllegalStateException("illegal station settings in kartierabschnitt", e);
        }
    }

    public static int round(double d) {
        return (int)Math.floor(d + 0.5);
    }

    public static double round(double d, int scale) {
        long factor = Math.round(Math.pow(10.0, scale));
        double rounded = Math.floor(d * (double)factor + 0.5);
        return rounded / (double)factor;
    }

    public static void overallRating(RatingStruct rs, boolean count, Number ... criteraRatings) {
        for (Number rating : criteraRatings) {
            if (rating == null) continue;
            rs.rating += rating.doubleValue();
            if (!count) continue;
            ++rs.criteriaCount;
        }
    }

    public static double correctBadEnvRating(double badEnvRating, int wbTypeId) {
        if ((wbTypeId == 11 || wbTypeId == 12) && badEnvRating < -1.0) {
            return -1.0;
        }
        if (badEnvRating < -3.0) {
            return -3.0;
        }
        return badEnvRating;
    }

    public static String fieldFromCode(String prefix, String code) {
        return Calc.fieldFromCode(prefix, code, null);
    }

    public static String fieldFromCode(String prefix, String code, Boolean left) {
        try {
            Field f = Calc.class.getField(prefix + code.toUpperCase() + (left == null ? "" : "_" + (left != false ? "LE" : "RI")));
            return (String)f.get(null);
        }
        catch (NoSuchFieldException ex) {
            String message = "field for code not declared or illegal format: [prefix=" + prefix + "|code=" + code + "|left=" + left + "]";
            LOG.error((Object)message, (Throwable)ex);
            throw new IllegalStateException(message, ex);
        }
        catch (SecurityException ex) {
            String message = "cannot access public static field";
            LOG.fatal((Object)"cannot access public static field", (Throwable)ex);
            throw new IllegalStateException("cannot access public static field", ex);
        }
        catch (IllegalArgumentException ex) {
            String message = "cannot access public static field with null object";
            LOG.fatal((Object)"cannot access public static field with null object", (Throwable)ex);
            throw new IllegalStateException("cannot access public static field with null object", ex);
        }
        catch (IllegalAccessException ex) {
            String message = "cannot access public static field";
            LOG.fatal((Object)"cannot access public static field", (Throwable)ex);
            throw new IllegalStateException("cannot access public static field", ex);
        }
    }

    private boolean propsNotNull(CidsBean bean, String ... props) {
        if (bean == null) {
            throw new IllegalArgumentException("bean must not be null");
        }
        if (props == null) {
            throw new IllegalArgumentException("props must not be null");
        }
        if (props.length == 0) {
            LOG.warn((Object)"empty property list");
            return true;
        }
        for (String prop : props) {
            if (bean.getProperty(prop) != null) continue;
            return false;
        }
        return true;
    }

    private boolean propsNotNullOrZero(CidsBean bean, String ... props) {
        if (bean == null) {
            throw new IllegalArgumentException("bean must not be null");
        }
        if (props == null) {
            throw new IllegalArgumentException("props must not be null");
        }
        if (props.length == 0) {
            LOG.warn((Object)"empty property list");
            return true;
        }
        for (String prop : props) {
            Object value = bean.getProperty(prop);
            if (value == null) {
                return false;
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                if (n.doubleValue() != 0.0) continue;
                return false;
            }
            throw new ClassCastException("property value not instance of number: " + prop + " | " + value.getClass());
        }
        return true;
    }

    private static final class LazyInitializer {
        private static final transient Calc INSTANCE = new Calc();

        private LazyInitializer() {
        }
    }

    public static final class RatingStruct {
        public double rating = 0.0;
        public int criteriaCount = 0;
    }
}

