/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.fgsk;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.wrrl_db_mv.commons.WRRLDBMVConcurrency;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.server.search.AbstractSubstrateRatingSearch;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.server.search.AbstractTripletRatingSearch;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.server.search.ComplexRatingSearch;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.server.search.SectionLengthSearch;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.server.search.SimpleMappingSearch;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.server.search.SimpleRatingSearch;
import de.cismet.cids.server.search.CidsServerSearch;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public final class CalcCache {
    private static final transient Logger LOG = Logger.getLogger(CalcCache.class);
    public static final String ANY_KEY = "*";
    private final transient Map<String, Integer> wbTrimmingRatings;
    private final transient Map<String, Integer> wbLandUseRatings;
    private final transient Map<String, Double> badEnvStructureRatings;
    private final transient Map<Integer, Double> crossBenchSectionLength;
    private final transient Map<Integer, Map<ComplexRatingSearch.Range, Integer>> crossBenchRatings;
    private final transient Map<String, Integer> flowDiversityRatings;
    private final transient Map<String, Integer> flowVelocityRatings;
    private final transient Map<String, Integer> depthVarianceRatings;
    private final transient Map<Integer, Double> longBenchSectionLength;
    private final transient Map<Integer, Double> courseStructureSectionLength;
    private final transient Map<String, Integer> courseLoopRatings;
    private final transient Map<String, Integer> loopErosionRatings;
    private final transient Map<Integer, Map<ComplexRatingSearch.Range, Double>> longBenchRatings;
    private final transient Map<Integer, Map<ComplexRatingSearch.Range, Integer>> courseStructureRatings;
    private final transient Map<Integer, Map<ComplexRatingSearch.Range, Integer>> profileDepthBreathRelationRatings;
    private final transient Map<String, Integer> profileTypeRatingsRatings;
    private final transient Map<String, Integer> breadthErosionRatings;
    private final transient Map<String, Integer> profileTypeRatings;
    private final transient Map<Integer, Double> bedStructureSectionLength;
    private final transient Map<Integer, Map<ComplexRatingSearch.Range, Double>> bedStructureRatings;
    private final transient Map<Integer, Double> maxBedContaminationRatings;
    private final transient Map<String, Map<ComplexRatingSearch.Range, Integer>> naturalSubstrateRatings;
    private final transient Map<String, Map<ComplexRatingSearch.Range, Integer>> artificialSubstrateRatings;
    private final transient Map<String, Map<ComplexRatingSearch.Range, Integer>> hardSubstrateRatings;
    private final transient Map<String, Integer> bedFitmentRatings;
    private final transient Map<String, Double> bedContaminationRatings;
    private final transient Map<Integer, Double> bankStructureSectionLength;
    private final transient Map<Integer, Map<ComplexRatingSearch.Range, Integer>> bankStructureRatings;
    private final transient Map<String, Integer> bankVegetationRatings;
    private final transient Map<String, Integer> bankFitmentRatings;
    private final transient Map<String, Double> bankContaminationRatings;
    private final transient Object lock = new Object();
    private volatile transient boolean init = false;
    private transient ExecutorService executor;

    private CalcCache() {
        this.wbTrimmingRatings = new HashMap<String, Integer>();
        this.wbLandUseRatings = new HashMap<String, Integer>();
        this.badEnvStructureRatings = new HashMap<String, Double>();
        this.crossBenchSectionLength = new HashMap<Integer, Double>();
        this.crossBenchRatings = new HashMap<Integer, Map<ComplexRatingSearch.Range, Integer>>();
        this.flowDiversityRatings = new HashMap<String, Integer>();
        this.flowVelocityRatings = new HashMap<String, Integer>();
        this.depthVarianceRatings = new HashMap<String, Integer>();
        this.longBenchSectionLength = new HashMap<Integer, Double>();
        this.courseStructureSectionLength = new HashMap<Integer, Double>();
        this.courseLoopRatings = new HashMap<String, Integer>();
        this.loopErosionRatings = new HashMap<String, Integer>();
        this.longBenchRatings = new HashMap<Integer, Map<ComplexRatingSearch.Range, Double>>();
        this.courseStructureRatings = new HashMap<Integer, Map<ComplexRatingSearch.Range, Integer>>();
        this.profileDepthBreathRelationRatings = new HashMap<Integer, Map<ComplexRatingSearch.Range, Integer>>();
        this.profileTypeRatingsRatings = new HashMap<String, Integer>();
        this.breadthErosionRatings = new HashMap<String, Integer>();
        this.profileTypeRatings = new HashMap<String, Integer>();
        this.bedStructureSectionLength = new HashMap<Integer, Double>();
        this.bedStructureRatings = new HashMap<Integer, Map<ComplexRatingSearch.Range, Double>>();
        this.maxBedContaminationRatings = new HashMap<Integer, Double>();
        this.naturalSubstrateRatings = new HashMap<String, Map<ComplexRatingSearch.Range, Integer>>();
        this.artificialSubstrateRatings = new HashMap<String, Map<ComplexRatingSearch.Range, Integer>>();
        this.hardSubstrateRatings = new HashMap<String, Map<ComplexRatingSearch.Range, Integer>>();
        this.bedFitmentRatings = new HashMap<String, Integer>();
        this.bedContaminationRatings = new HashMap<String, Double>();
        this.bankStructureSectionLength = new HashMap<Integer, Double>();
        this.bankStructureRatings = new HashMap<Integer, Map<ComplexRatingSearch.Range, Integer>>();
        this.bankVegetationRatings = new HashMap<String, Integer>();
        this.bankFitmentRatings = new HashMap<String, Integer>();
        this.bankContaminationRatings = new HashMap<String, Double>();
    }

    public static CalcCache getInstance() {
        return LazyInitializer.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (!this.init) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.init) {
                    if (this.executor == null) {
                        this.executor = Executors.newCachedThreadPool(WRRLDBMVConcurrency.createThreadFactory((String)"calc-cache", (Thread.UncaughtExceptionHandler)new CalcCacheExceptionHandler()));
                        this.doInit();
                    } else if (this.executor.isTerminated()) {
                        this.executor = null;
                        this.init = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.init) {
                // empty if block
            }
        }
    }

    private void doInit() {
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_flaechennutzung_auswertung"), this.wbLandUseRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_gewaesserrandstreifen_auswertung"), this.wbTrimmingRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.DoubleRatingSearch("public.fgsk_schaedlicheumfeldstrukturen_auswertung"), this.badEnvStructureRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SectionLengthSearch("fgsk_querbaenke_auswertung"), this.crossBenchSectionLength));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new ComplexRatingSearch.DefaultComplexRatingSearch("public.fgsk_querbaenke_auswertung"), this.crossBenchRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_stroemungs_diversitaet_auswertung"), this.flowDiversityRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_fliessgeschwindigkeit_auswertung"), this.flowVelocityRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_tiefenvarianz_auswertung"), this.depthVarianceRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SectionLengthSearch("fgsk_laengsbaenke_auswertung"), this.longBenchSectionLength));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SectionLengthSearch("fgsk_laufstrukturen_auswertung"), this.courseStructureSectionLength));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_laufkruemmung_auswertung"), this.courseLoopRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_kruemmungserosion_auswertung"), this.loopErosionRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new ComplexRatingSearch.DefaultComplexRatingSearch("public.fgsk_laengsbaenke_auswertung"), this.longBenchRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new ComplexRatingSearch.DefaultComplexRatingSearch("public.fgsk_laufstrukturen_auswertung"), this.courseStructureRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new ComplexRatingSearch.ProfileDepthBreadthRelationRatingSearch(), this.profileDepthBreathRelationRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_breitenvarianz_auswertung"), this.profileTypeRatingsRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_breitenerosion_auswertung"), this.breadthErosionRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.IntegerRatingSearch("public.fgsk_profiltyp_auswertung"), this.profileTypeRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SectionLengthSearch("public.fgsk_sohlenstrukturen_auswertung"), this.bedStructureSectionLength));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new ComplexRatingSearch.DefaultComplexRatingSearch("public.fgsk_sohlenstrukturen_auswertung"), this.bedStructureRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleMappingSearch("public.fgsk_belastung_sohle_max_auswertung", "id_gewaessertyp", Integer.class, "maximum", Double.class), this.maxBedContaminationRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new AbstractSubstrateRatingSearch.DefaultSubstrateRatingSearch("public.fgsk_natuerliche_substrate_auswertung"), this.naturalSubstrateRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new AbstractSubstrateRatingSearch.PercentSubstrateRatingSearch("public.fgsk_prozent_kuenstliche_substrate_auswertung"), this.artificialSubstrateRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new AbstractSubstrateRatingSearch.PercentSubstrateRatingSearch("public.fgsk_prozent_organische_hartsubstrate_auswertung"), this.hardSubstrateRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new AbstractTripletRatingSearch.BedFitmentRatingSearch(), this.bedFitmentRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.DoubleRatingSearch("public.fgsk_belastung_sohle_auswertung"), this.bedContaminationRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SectionLengthSearch("public.fgsk_uferstrukturen_auswertung"), this.bankStructureSectionLength));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new ComplexRatingSearch.DefaultComplexRatingSearch("public.fgsk_uferstrukturen_auswertung"), this.bankStructureRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new AbstractTripletRatingSearch.BankVegetationRatingSearch(), this.bankVegetationRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new AbstractTripletRatingSearch.BankFitmentRatingSearch(), this.bankFitmentRatings));
        this.executor.submit(new CacheInitialiser((CidsServerSearch)new SimpleRatingSearch.DoubleRatingSearch("public.fgsk_uferbelastungen_auswertung"), this.bankContaminationRatings));
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForInit() {
        this.init();
        if (this.executor != null) {
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
                Object object = this.lock;
                synchronized (object) {
                    if (this.executor != null) {
                        this.init = true;
                    }
                }
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"cannot wait for initialisation", (Throwable)ex);
                return false;
            }
        }
        return this.init;
    }

    public Integer getWBTrimmingRating(int wbTrimmingId, int wbTypeId) {
        this.check();
        return this.wbTrimmingRatings.get(wbTrimmingId + "-" + wbTypeId);
    }

    public Integer getWBLandUseRating(int wbLandUseId, int wbTypeId) {
        this.check();
        return this.wbLandUseRatings.get(wbLandUseId + "-" + wbTypeId);
    }

    public Double getBadEnvStructureRating(BadEnvStructureType type, int wbTypeId) {
        this.check();
        return this.badEnvStructureRatings.get(type.getId() + "-" + wbTypeId);
    }

    public Double getCrossBenchSectionLength(int wbTypeId) {
        this.check();
        return this.crossBenchSectionLength.get(wbTypeId);
    }

    public Integer getCrossBenchRating(Double crossBenchCount, int wbTypeId) {
        if (crossBenchCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.crossBenchRatings.get(wbTypeId);
        return this.getRangeRating(ranges, crossBenchCount);
    }

    public Integer getFlowDiversityRating(int flowDiversityId, int wbTypeId) {
        this.check();
        return this.flowDiversityRatings.get(flowDiversityId + "-" + wbTypeId);
    }

    public Integer getFlowVelocityRating(int flowVelocityId, int wbTypeId) {
        this.check();
        return this.flowVelocityRatings.get(flowVelocityId + "-" + wbTypeId);
    }

    public Integer getDepthVarianceRating(int depthVarianceId, int wbTypeId) {
        this.check();
        return this.depthVarianceRatings.get(depthVarianceId + "-" + wbTypeId);
    }

    public Double getLongBenchSectionLength(int wbTypeId) {
        this.check();
        return this.longBenchSectionLength.get(wbTypeId);
    }

    public Double getCourseStructureSectionLength(int wbTypeId) {
        this.check();
        return this.courseStructureSectionLength.get(wbTypeId);
    }

    public Integer getCourseLoopRating(int courseLoopId, int wbTypeId) {
        this.check();
        return this.courseLoopRatings.get(courseLoopId + "-" + wbTypeId);
    }

    public Integer getLoopErosionRating(int loopErosionId, int wbTypeId) {
        this.check();
        return this.loopErosionRatings.get(loopErosionId + "-" + wbTypeId);
    }

    public Double getLongBenchRating(Double longBenchCount, int wbTypeId) {
        if (longBenchCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Double> ranges = this.longBenchRatings.get(wbTypeId);
        return this.getRangeRating(ranges, longBenchCount);
    }

    public Integer getCourseStructureRating(Double courseStructureCount, int wbTypeId) {
        if (courseStructureCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.courseStructureRatings.get(wbTypeId);
        return this.getRangeRating(ranges, courseStructureCount);
    }

    public Integer getProfileDepthBreadthRelationRating(Double depthBreathRelation, int wbTypeId) {
        if (depthBreathRelation == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.profileDepthBreathRelationRatings.get(wbTypeId);
        return this.getRangeRating(ranges, depthBreathRelation);
    }

    public Integer getBiggestProfileDepthBreadthRelationRating(Double depthBreathRelation, int wbTypeId) {
        if (depthBreathRelation == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.profileDepthBreathRelationRatings.get(wbTypeId);
        if (ranges != null) {
            for (ComplexRatingSearch.Range range : ranges.keySet()) {
                if (!(depthBreathRelation > range.getTo()) || ranges.get(range) != 5) continue;
                return 5;
            }
        }
        return null;
    }

    public Integer getLowestProfileDepthBreadthRelationRating(Double depthBreathRelation, int wbTypeId) {
        if (depthBreathRelation == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.profileDepthBreathRelationRatings.get(wbTypeId);
        if (ranges != null) {
            for (ComplexRatingSearch.Range range : ranges.keySet()) {
                if (!(depthBreathRelation < range.getFrom()) || ranges.get(range) != 1) continue;
                return 1;
            }
        }
        return null;
    }

    public Integer getBreadthVarianceRating(int breadthVarianceId, int wbTypeId) {
        this.check();
        return this.profileTypeRatingsRatings.get(breadthVarianceId + "-" + wbTypeId);
    }

    public Integer getBreadthErosionRating(int breadthErosionId, int wbTypeId) {
        this.check();
        return this.breadthErosionRatings.get(breadthErosionId + "-" + wbTypeId);
    }

    public Integer getProfileTypeRating(int profileTypeId, int wbTypeId) {
        this.check();
        return this.profileTypeRatings.get(profileTypeId + "-" + wbTypeId);
    }

    public Double getBedStructureSectionLength(int wbTypeId) {
        this.check();
        return this.bedStructureSectionLength.get(wbTypeId);
    }

    public Double getBedStructureRating(Double absBedStructureCount, int wbTypeId) {
        if (absBedStructureCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Double> ranges = this.bedStructureRatings.get(wbTypeId);
        return this.getRangeRating(ranges, absBedStructureCount);
    }

    public Double getMaxBedContaminationRating(int wbTypeId) {
        this.check();
        return this.maxBedContaminationRatings.get(wbTypeId);
    }

    public Integer getNaturalSubstrateRating(Double naturalSubstrateCount, String wbSubType, int wbTypeId) {
        if (naturalSubstrateCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.naturalSubstrateRatings.get(wbTypeId + "-" + wbSubType);
        if (ranges == null) {
            ranges = this.naturalSubstrateRatings.get(wbTypeId + "-" + ANY_KEY);
        }
        return this.getRangeRating(ranges, naturalSubstrateCount);
    }

    public Integer getArtificialSubstrateRating(Double artificialSubstrateCount, String wbSubType, int wbTypeId) {
        if (artificialSubstrateCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.artificialSubstrateRatings.get(wbTypeId + "-" + wbSubType);
        if (ranges == null) {
            ranges = this.artificialSubstrateRatings.get(wbTypeId + "-" + ANY_KEY);
        }
        return this.getRangeRating(ranges, artificialSubstrateCount);
    }

    public Integer getHardSubstrateRating(Double hardSubstrateCount, String wbSubType, int wbTypeId) {
        if (hardSubstrateCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.hardSubstrateRatings.get(wbTypeId + "-" + wbSubType);
        if (ranges == null) {
            ranges = this.hardSubstrateRatings.get(wbTypeId + "-" + ANY_KEY);
        }
        return this.getRangeRating(ranges, hardSubstrateCount);
    }

    public Integer getBedFitmentRating(int bedFitmentId, int zBedFitmentId, int wbTypeId) {
        this.check();
        return this.bedFitmentRatings.get(wbTypeId + "-" + bedFitmentId + "-" + zBedFitmentId);
    }

    public Double getBedContaminationRating(int bedContaminationID, int wbTypeId) {
        this.check();
        return this.bedContaminationRatings.get(bedContaminationID + "-" + wbTypeId);
    }

    public Double getBankStructureSectionLength(int wbTypeId) {
        this.check();
        return this.bankStructureSectionLength.get(wbTypeId);
    }

    public Integer getBankStructureRating(Double absBankStructureCount, int wbTypeId) {
        if (absBankStructureCount == null) {
            return null;
        }
        this.check();
        Map<ComplexRatingSearch.Range, Integer> ranges = this.bankStructureRatings.get(wbTypeId);
        return this.getRangeRating(ranges, absBankStructureCount);
    }

    public Integer getBankVegetationRating(int bankVegetationId, boolean bankVegetationTypical, int wbTypeId) {
        this.check();
        return this.bankVegetationRatings.get(wbTypeId + "-" + bankVegetationId + "-" + (bankVegetationTypical ? 1 : 2));
    }

    public Integer getBankFitmentRating(int bankFitmentId, int zBankFitment, int wbTypeId) {
        this.check();
        return this.bankFitmentRatings.get(wbTypeId + "-" + bankFitmentId + "-" + zBankFitment);
    }

    public Double getBankContaminationRating(int bankContaminationId, int wbTypeId) {
        this.check();
        return this.bankContaminationRatings.get(bankContaminationId + "-" + wbTypeId);
    }

    private <T extends Number> T getRangeRating(Map<ComplexRatingSearch.Range, T> ranges, double length) {
        if (ranges != null) {
            for (ComplexRatingSearch.Range range : ranges.keySet()) {
                if (!range.withinRange(length)) continue;
                return (T)((Number)ranges.get(range));
            }
        }
        return null;
    }

    public static int getQualityClass(double p) {
        int qualityClass = 0;
        if (p <= 1.4) {
            qualityClass = 5;
        } else if (p <= 2.3) {
            qualityClass = 4;
        } else if (p <= 3.2) {
            qualityClass = 3;
        } else if (p <= 4.1) {
            qualityClass = 2;
        } else if (p > 4.1) {
            qualityClass = 1;
        }
        return qualityClass;
    }

    private void check() {
        if (!this.waitForInit()) {
            throw new IllegalStateException("the cache is not properly initialised");
        }
    }

    public boolean isInitialised() {
        return this.init;
    }

    private static final class LazyInitializer {
        private static final transient CalcCache INSTANCE = new CalcCache();

        private LazyInitializer() {
        }
    }

    private final class CalcCacheExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CalcCacheExceptionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof Error) {
                LOG.fatal((Object)"encountered unexpected error", e);
                throw (Error)e;
            }
            LOG.error((Object)"cannot initialise calc cache", e);
            Object object = CalcCache.this.lock;
            synchronized (object) {
                CalcCache.this.executor.shutdownNow();
                CalcCache.this.init = false;
                CalcCache.this.executor = null;
            }
        }
    }

    private static final class CacheInitialiser
    implements Runnable {
        private final transient Map toFill;
        private final transient CidsServerSearch search;

        private CacheInitialiser(CidsServerSearch search, Map toFill) {
            if (search == null || toFill == null) {
                throw new IllegalArgumentException("no param must be null");
            }
            this.toFill = toFill;
            this.search = search;
        }

        @Override
        public void run() {
            Collection result;
            try {
                result = SessionManager.getProxy().customServerSearch(this.search);
            }
            catch (ConnectionException ex) {
                String message = "cannot perform custom search";
                LOG.error((Object)"cannot perform custom search", (Throwable)ex);
                throw new IllegalStateException("cannot perform custom search", ex);
            }
            if (result.isEmpty()) {
                String message = "illegal server search result: " + result;
                LOG.error((Object)message);
                throw new IllegalStateException(message);
            }
            Object searchResult = result.iterator().next();
            if (!(searchResult instanceof Map)) {
                String message = "illegal server search result: " + searchResult;
                LOG.error((Object)message);
                throw new IllegalStateException(message);
            }
            this.toFill.putAll((Map)searchResult);
        }
    }

    public static enum BankContaminationType {
        MUE("mue", 1),
        ST("st", 2),
        TS("ts", 3),
        EL("el", 4),
        SO("so", 5);

        private final String code;
        private final int id;

        private BankContaminationType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum BankStructureType {
        BU("bu", 1),
        PB("pb", 2),
        US("us", 3),
        SB("sb", 4),
        HA("ha", 5),
        NBOE("nboe", 6),
        SO("so", 7);

        private final String code;
        private final int id;

        private BankStructureType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum BedContaminationType {
        MUE("mue", 1),
        ST("st", 2),
        ABW("abw", 3),
        VO("vo", 4),
        SA("sa", 5),
        SO("so", 6);

        private final String code;
        private final int id;

        private BedContaminationType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum BedStructureType {
        RIP("rip", 1),
        TH("th", 2),
        WU("wu", 3),
        KO("ko", 4);

        private final String code;
        private final int id;

        private BedStructureType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum BedSubtrateType {
        CLAY("ton", 1),
        SAND("san", 2),
        FLINT("kie", 3),
        STONE("ste", 4),
        BLOCK("blo", 5),
        MUD("sch", 6),
        PEAT("tor", 7),
        DEADWOOD("tot", 8),
        ROOTS("wur", 9),
        ARTIFICIAL_SUBSTRATE("kue", 10);

        private final String code;
        private final int id;

        private BedSubtrateType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }

        public static BedSubtrateType[] getNaturalBedSubstrateTypes() {
            return new BedSubtrateType[]{CLAY, SAND, FLINT, STONE, BLOCK, PEAT, DEADWOOD, ROOTS};
        }

        public static BedSubtrateType[] getArtificialSubstrateTypes() {
            return new BedSubtrateType[]{MUD, ARTIFICIAL_SUBSTRATE};
        }

        public static BedSubtrateType[] getHardSubstrateTypes() {
            return new BedSubtrateType[]{DEADWOOD, ROOTS};
        }
    }

    public static enum CourseStructureType {
        TV("tv", 1),
        SB("sb", 2),
        IBI("ibi", 3),
        LW("lw", 4),
        LV("lv", 5),
        LG("lg", 6);

        private final String code;
        private final int id;

        private CourseStructureType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum LongBenchType {
        UFKG("ufkg", 1),
        IB("ib", 2),
        MB("mb", 3);

        private final String code;
        private final int id;

        private LongBenchType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum BadEnvStructureType {
        AG("ag", 1),
        FT("ft", 2),
        GUA("gua", 3),
        BV("bv", 4),
        MA("ma", 5),
        HW("hw", 6),
        SO("so", 7);

        private final String code;
        private final int id;

        private BadEnvStructureType(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }
    }
}

