/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.fgsk;

import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.resource.PropertyManager;
import Sirius.server.ServerExit;
import Sirius.server.ServerExitError;
import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.impls.proxy.StartProxy;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.property.ServerProperties;
import Sirius.server.registry.Registry;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.FgskKartierabschnittEditor;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.Calc;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.ValidationException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public final class CompleteFgskCalc {
    private static final String SERVER_CONFIG_FILE = "completeFgskCalc.properties";
    private static final String CLIENT_CONFIG_FILE = "completeFgskCalcClient.properties";
    private final transient Registry registry;
    private final transient StartProxy proxy;
    private final transient DomainServerImpl server;
    private final transient Connection con;
    private final transient ConnectionSession session;
    private final transient int classId;
    private final transient List<Integer> noCalcIds;
    private transient int missingDataCounter;
    private final transient List<Integer> unexpectedErrorIds;
    private final transient List<Integer> kaWoWBTypeIds;
    private transient int kaWoWBTypeCounter;
    private transient int overallRatingZeroCounter;
    private transient int exceptionCounter;
    private final transient List<Integer> exceptionIds;
    private final transient List<Integer> vorkartIds;

    public CompleteFgskCalc() throws Throwable {
        ServerProperties props = new ServerProperties(SERVER_CONFIG_FILE);
        Properties clientProps = new Properties();
        FileInputStream fis = new FileInputStream(CLIENT_CONFIG_FILE);
        clientProps.load(fis);
        this.registry = Registry.getServerInstance((int)1097);
        this.proxy = StartProxy.getInstance((String)SERVER_CONFIG_FILE);
        this.server = new DomainServerImpl(props);
        PropertyManager propertyManager = PropertyManager.getManager();
        ConnectionInfo info = propertyManager.getConnectionInfo();
        String encryptedPassword = clientProps.getProperty("password");
        String decryptedPassword = new String(PasswordEncrypter.decrypt((char[])encryptedPassword.toCharArray(), (boolean)false));
        info.setCallserverURL(clientProps.getProperty("callserverUrl"));
        info.setUsername(clientProps.getProperty("username"));
        info.setUsergroup(clientProps.getProperty("usergroup"));
        info.setPassword(decryptedPassword);
        info.setUserDomain(clientProps.getProperty("domain"));
        info.setUsergroupDomain(clientProps.getProperty("domain"));
        Sirius.navigator.connection.Connection connection = ConnectionFactory.getFactory().createConnection(propertyManager.getConnectionClass(), info.getCallserverURL(), ProxyHandler.getInstance().getProxy());
        this.session = ConnectionFactory.getFactory().createSession(connection, info, true);
        ConnectionProxy conProxy = ConnectionFactory.getFactory().createProxy(propertyManager.getConnectionProxyClass(), this.session);
        SessionManager.init((ConnectionProxy)conProxy);
        this.con = this.server.getConnectionPool().getConnection();
        this.classId = 229;
        this.missingDataCounter = 0;
        this.kaWoWBTypeCounter = 0;
        this.overallRatingZeroCounter = 0;
        this.exceptionCounter = 0;
        this.noCalcIds = new ArrayList<Integer>();
        this.kaWoWBTypeIds = new ArrayList<Integer>();
        this.unexpectedErrorIds = new ArrayList<Integer>();
        this.exceptionIds = new ArrayList<Integer>();
        this.vorkartIds = new ArrayList<Integer>();
    }

    private void shutdown() throws Throwable {
        try {
            this.server.shutdown();
        }
        catch (ServerExit serverExit) {
        }
        catch (ServerExitError e) {
            System.err.println("exit error");
        }
        try {
            this.proxy.shutdown();
        }
        catch (ServerExit e) {
        }
        catch (ServerExitError e) {
            System.err.println("exit error");
        }
        try {
            this.registry.shutdown();
        }
        catch (ServerExit e) {
        }
        catch (ServerExitError e) {
            System.err.println("exit error");
        }
    }

    private void generateReport() throws Exception {
        Statement stmtCids = this.con.createStatement();
        ResultSet setCids = stmtCids.executeQuery("select id from public.fgsk_kartierabschnitt order by id");
        int idCids = -1;
        int cidsCounter = 0;
        int unexpectedErrors = 0;
        int noCalcCounter = 0;
        int vorkCounter = 0;
        while (setCids.next()) {
            try {
                ++cidsCounter;
                idCids = setCids.getInt(1);
                MetaObject mo = this.server.getMetaObject(this.session.getUser(), idCids, this.classId);
                if (mo == null) {
                    throw new IllegalStateException("cannot fetch cids metaobject: " + idCids);
                }
                System.out.println();
                System.out.println("Kartierabschnitt: " + cidsCounter + " mit id " + idCids);
                System.out.println();
                try {
                    Calc.getInstance().removeAllRatings(mo.getBean());
                }
                catch (IllegalStateException ex) {
                    System.err.println("cannot remove all ratings");
                    ex.printStackTrace();
                }
                if (FgskKartierabschnittEditor.isException(mo.getBean())) {
                    ++this.exceptionCounter;
                    this.exceptionIds.add(idCids);
                    this.saveBean(mo.getBean());
                    continue;
                }
                Boolean vork = (Boolean)mo.getBean().getProperty("vorkatierung");
                if (vork != null && vork.booleanValue()) {
                    ++vorkCounter;
                    this.vorkartIds.add(idCids);
                    this.saveBean(mo.getBean());
                    continue;
                }
                if (this.calcAll(mo.getBean())) {
                    ++noCalcCounter;
                    this.noCalcIds.add(idCids);
                }
                this.saveBean(mo.getBean());
                System.out.println();
                System.out.println("---------------------------------------------------------------------------------");
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException && e.getMessage().contains("kartierabschnitt bean without water body type")) {
                    System.out.println("KARTIERABSCHNITT OHNE WASSERK\u00d6RPERTYP NICHT BERECHENBAR");
                    ++this.kaWoWBTypeCounter;
                    this.kaWoWBTypeIds.add(idCids);
                    continue;
                }
                System.out.println("=================================================================================");
                System.out.println();
                e.printStackTrace();
                System.out.println("=================================================================================");
                this.unexpectedErrorIds.add(idCids);
                ++unexpectedErrors;
            }
        }
        System.out.println();
        System.out.println();
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println();
        System.out.println("Anzahl FGSK Kartierabschnitte:                     " + cidsCounter);
        System.out.println("Anzahl nicht berechenbarer Kartierabschnitte:      " + noCalcCounter);
        System.out.println("Anzahl nicht berechenbarer Gesamtpunktzahlen:      " + this.overallRatingZeroCounter);
        System.out.println("Anzahl Sonderf\u00e4lle:                                " + this.exceptionCounter);
        System.out.println("Anzahl Kartierabschnitte ohne Wasserk\u00f6rpertyp:     " + this.kaWoWBTypeCounter);
        System.out.println("Anzahl unerwarteter Fehler:                        " + unexpectedErrors);
        System.out.println("Anzahl Validierungsdiskrepanz Teilberechnung:      " + this.missingDataCounter);
        System.out.println();
        System.out.println("=================================================================================");
        System.out.println("=================================================================================");
        System.out.println("=================================================================================");
        this.printIds();
    }

    private void saveBean(CidsBean bean) {
        try {
            bean.persist();
        }
        catch (Exception e) {
            System.out.println();
            System.out.println("COULD NOT STORE RATING DATA FOR BEAN: " + bean.getProperty("id"));
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.out.println();
        }
    }

    private boolean calcAll(CidsBean cidsBean) {
        boolean calcError = false;
        try {
            Calc.getInstance().calcWBEnvRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate wb env rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcWBLongProfileRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate long profile rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcCourseEvoRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate course evolution rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcWBCrossProfileRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate cross profile rating");
            ex.printStackTrace();
            calcError = true;
        }
        this.roundAll(cidsBean);
        try {
            Calc.getInstance().calcBedStructureRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate bed structure rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcBankStructureRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate bank structure rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcBedRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate bed rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcBankRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate bank rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcEnvRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate env rating");
            ex.printStackTrace();
            calcError = true;
        }
        try {
            Calc.getInstance().calcOverallRating(cidsBean);
        }
        catch (ValidationException ex) {
            System.err.println("cannot calculate overall rating");
            ex.printStackTrace();
            calcError = true;
        }
        return calcError;
    }

    private void roundAll(CidsBean bean) {
        String[] postfixes;
        for (String tmp : postfixes = new String[]{"ton", "san", "kie", "ste", "blo", "sch", "tor", "tot", "wur", "kue"}) {
            try {
                String propName = "sohlensubstrat_" + tmp;
                Double value = bean.getProperty(propName) != null ? (Double)bean.getProperty(propName) : 0.0;
                bean.setProperty(propName, (Object)Math.round(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void printIds() {
        System.out.println();
        System.out.println("APPENDIX Kartierabschnitt ids ");
        System.out.println();
        System.out.println("Nicht berechenbare Datens\u00e4tze");
        System.out.println(Arrays.toString(this.noCalcIds.toArray()));
        System.out.println();
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println();
        System.out.println("Vorkartierung");
        System.out.println(Arrays.toString(this.vorkartIds.toArray()));
        System.out.println();
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println();
        System.out.println("Sonderf\u00e4lle");
        System.out.println(Arrays.toString(this.exceptionIds.toArray()));
        System.out.println();
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println();
        System.out.println("Datens\u00e4tze ohne Wasserk\u00f6rpertyp");
        System.out.println(Arrays.toString(this.kaWoWBTypeIds.toArray()));
        System.out.println();
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println();
        System.out.println("Unerwartete Fehler");
        System.out.println(Arrays.toString(this.unexpectedErrorIds.toArray()));
        System.out.println();
        System.out.println("---------------------------------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        CompleteFgskCalc r = null;
        PrintStream ps = null;
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            ps = new PrintStream((OutputStream)new FileOutputStream(new File("/var/log/recalc.txt")), false, "UTF-8");
            r = new CompleteFgskCalc();
            System.setOut(ps);
            System.setErr(ps);
            r.generateReport();
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                System.setOut(out);
                System.setErr(err);
                super.shutdown();
                ps.close();
                throw throwable;
            }
            System.setOut(out);
            System.setErr(err);
            r.shutdown();
            ps.close();
        }
        System.setOut(out);
        System.setErr(err);
        r.shutdown();
        ps.close();
        System.out.println("FINISHED");
    }

    private static enum Status {
        OK,
        NO_ENTRY,
        MISSING_DATA,
        MISSING_DATA_IN_CIDS,
        NO_RATING_MATCH,
        NO_CRITERIA_MATCH,
        EXCEPTION;

    }
}

