/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.fgsk;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.SimSimulationsabschnittEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.SimulationEditor;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.CalcCache;
import de.cismet.cids.custom.wrrl_db_mv.server.search.LastMassnEnd;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkFgWkkSearch;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FgskSimulationHelper {
    public static final String SIM_MASSNAHME_CLASS_NAME = "de.cismet.cids.dynamics.Sim_massnahme";
    public static final String SIM_MASSNAHMEN_GRUPPE_CLASS_NAME = "de.cismet.cids.dynamics.Sim_massnahmen_gruppe";
    private static final Logger LOG = Logger.getLogger(FgskSimulationHelper.class);
    private static final MetaClass SIM_MASSNAHME_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"sim_massnahme");
    private static final MetaClass SIM_MASSNAHMEN_GRUPPE_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"sim_massnahmen_gruppe");
    private static final MetaClass SIMULATION_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"simulation");
    private static final MetaClass REALISIERUNG_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"massnahmen_realisierung");
    private static final CalculationCache<List, MetaObject[]> simMassnahmenCache = new CalculationCache((Calculator)new SimMassnCalculator());
    private static final CalculationCache<MetaClass, MetaObject[]> allSimMassnahmenCache = new CalculationCache((Calculator)new AllBeansOfTypeCalculator());
    private static final CalculationCache<MetaClass, MetaObject[]> allSimMassnahmenGruppeCache = new CalculationCache((Calculator)new AllBeansOfTypeCalculator());
    private static final Map<Integer, CidsBean> realisierungMap = new HashMap<Integer, CidsBean>();
    private static final Map<Integer, CidsBean> massnBeanMap = new HashMap<Integer, CidsBean>();
    private static final Map<Integer, CidsBean> massnGruppeBeanMap = new HashMap<Integer, CidsBean>();
    public static final String FGSK_KA_PROPERTY = "fgsk_ka";
    public static final String CUSTOM_COSTS_PROPERTY = "sonstige_kosten";
    public static final String SIMULATIONSMASSNAHMEN_PROPERTY = "angewendete_simulationsmassnahmen";
    public static final String EINZEL_MASSNAHME_PROPERTY = "einzel_massnahme";
    public static final String MASSNAHME_PROPERTY = "massnahme";

    public static List<CidsBean> getMassnahmenBeans(List<CidsBean> list) {
        ArrayList<CidsBean> massnList = new ArrayList<CidsBean>();
        if (list != null) {
            for (CidsBean tmp : list) {
                if (tmp.getClass().getName().equalsIgnoreCase(SIM_MASSNAHMEN_GRUPPE_CLASS_NAME)) {
                    List massnahmen = tmp.getBeanCollectionProperty("massnahmen");
                    if (massnahmen == null) continue;
                    massnList.addAll(massnahmen);
                    continue;
                }
                if (!tmp.getClass().getName().equalsIgnoreCase(SIM_MASSNAHME_CLASS_NAME)) continue;
                massnList.add(tmp);
            }
        }
        return massnList;
    }

    public static boolean isMassnGroupContained(CidsBean massn, CidsBean simulation, CidsBean fgsk) {
        List simList = simulation.getBeanCollectionProperty(SIMULATIONSMASSNAHMEN_PROPERTY);
        boolean isGroup = massn.getClass().getName().equals(SIM_MASSNAHMEN_GRUPPE_CLASS_NAME);
        int fgsk_id = (Integer)fgsk.getProperty("id");
        for (CidsBean simMassn : simList) {
            Object simEinzelMassn;
            Object simMassnGr;
            if (!(isGroup ? (simMassnGr = simMassn.getProperty(MASSNAHME_PROPERTY)) != null && simMassn.getProperty(FGSK_KA_PROPERTY).equals(fgsk_id) && simMassnGr.equals(massn.getProperty("id")) : !isGroup && (simEinzelMassn = simMassn.getProperty(EINZEL_MASSNAHME_PROPERTY)) != null && simMassn.getProperty(FGSK_KA_PROPERTY).equals(fgsk_id) && simEinzelMassn.equals(massn.getProperty("id")))) continue;
            return true;
        }
        return false;
    }

    public static void addMassnahme(CidsBean simulationBean, CidsBean fgsk, CidsBean massn, Boolean complete) {
        if (FgskSimulationHelper.isMassnGroupContained(massn, simulationBean, fgsk)) {
            return;
        }
        try {
            CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("sim_massnahmen_anwendungen");
            newBean.setProperty(FGSK_KA_PROPERTY, fgsk.getProperty("id"));
            if (massn.getClass().getName().equals(SIM_MASSNAHMEN_GRUPPE_CLASS_NAME)) {
                newBean.setProperty(MASSNAHME_PROPERTY, massn.getProperty("id"));
            } else if (massn.getClass().getName().equals(SIM_MASSNAHME_CLASS_NAME)) {
                newBean.setProperty(EINZEL_MASSNAHME_PROPERTY, massn.getProperty("id"));
            }
            if (complete != null && complete.booleanValue()) {
                newBean.setProperty("complete", (Object)true);
            } else {
                newBean.setProperty("complete", (Object)false);
            }
            simulationBean.getBeanCollectionProperty(SIMULATIONSMASSNAHMEN_PROPERTY).add(newBean);
        }
        catch (Exception e) {
            LOG.error((Object)"error adding new object of type sim_massnahmen_anwendung", (Throwable)e);
        }
    }

    public static CidsBean getCustomCostsBeanForFgsk(CidsBean simulationBean, CidsBean fgsk) {
        Integer fgskId = (Integer)fgsk.getProperty("id");
        List angMassn = simulationBean.getBeanCollectionProperty(SIMULATIONSMASSNAHMEN_PROPERTY);
        for (CidsBean massn : angMassn) {
            Double costs;
            if (!massn.getProperty(FGSK_KA_PROPERTY).equals(fgskId) || (costs = (Double)massn.getProperty(CUSTOM_COSTS_PROPERTY)) == null) continue;
            return massn;
        }
        return null;
    }

    public static void setCustomCostsForFgsk(CidsBean simulationBean, CidsBean fgsk, Double costs) {
        try {
            CidsBean customCostsBean = FgskSimulationHelper.getCustomCostsBeanForFgsk(simulationBean, fgsk);
            if (customCostsBean != null) {
                if (costs != null) {
                    customCostsBean.setProperty(CUSTOM_COSTS_PROPERTY, (Object)costs);
                } else {
                    List angMassn = simulationBean.getBeanCollectionProperty(SIMULATIONSMASSNAHMEN_PROPERTY);
                    angMassn.remove(customCostsBean);
                }
            } else if (costs != null) {
                CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("sim_massnahmen_anwendungen");
                newBean.setProperty(FGSK_KA_PROPERTY, fgsk.getProperty("id"));
                newBean.setProperty("complete", (Object)true);
                newBean.setProperty(CUSTOM_COSTS_PROPERTY, (Object)costs);
                simulationBean.getBeanCollectionProperty(SIMULATIONSMASSNAHMEN_PROPERTY).add(newBean);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error while changing the given costs", (Throwable)e);
        }
    }

    public static CidsBean fillMassnSimulation(CidsBean simulationBean, String wkFg, CidsBean realisierung) {
        block14: {
            try {
                MetaObject[] massnahmenMos;
                ArrayList<Object> in = new ArrayList<Object>(1);
                in.add(wkFg);
                SimulationEditor.FgskCalculator fgskCalc = new SimulationEditor.FgskCalculator();
                MetaObject[] fgskMos = fgskCalc.calculate(in);
                simulationBean.setProperty("wk_key", (Object)wkFg);
                simulationBean.setProperty("realisierung", (Object)realisierung);
                simulationBean.setProperty("read_only", (Object)true);
                HashMap massnMap = new HashMap();
                simulationBean.getBeanCollectionProperty(SIMULATIONSMASSNAHMEN_PROPERTY).clear();
                if (fgskMos == null || fgskMos.length <= 0) break block14;
                SimulationEditor.MassnBvpCalculator massnCalc = new SimulationEditor.MassnBvpCalculator();
                in.add(realisierung.getProperty("value"));
                for (MetaObject mo : massnahmenMos = massnCalc.calculate(in)) {
                    CidsBean maBean = mo.getBean();
                    List<CidsBean> MassnBeans = FgskSimulationHelper.getSimMassnBeanFromMassnBvp(maBean);
                    if (MassnBeans != null && !MassnBeans.isEmpty()) {
                        CidsBean stationLine = (CidsBean)maBean.getProperty("linie");
                        double from = Math.min((Double)stationLine.getProperty("von.wert"), (Double)stationLine.getProperty("bis.wert"));
                        double to = Math.max((Double)stationLine.getProperty("von.wert"), (Double)stationLine.getProperty("bis.wert"));
                        Long gwk = (Long)stationLine.getProperty("von.route.gwk");
                        List<CidsBean> fgskList = FgskSimulationHelper.getAllCorrespondingFgsk(from, to, gwk, fgskMos);
                        for (CidsBean fgsk : fgskList) {
                            for (CidsBean massn : MassnBeans) {
                                double percentage;
                                Boolean massnFin = (Boolean)maBean.getProperty("massn_fin");
                                if (massnFin != null && massnFin.booleanValue()) {
                                    Date date;
                                    LastMassnEnd lastEnd = new LastMassnEnd(String.valueOf(maBean.getProperty("id")));
                                    ArrayList end = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)lastEnd);
                                    if (end == null || end.size() <= 0 || ((ArrayList)end.get(0)).size() <= 0 || (date = (Date)((ArrayList)end.get(0)).get(0)).before((Timestamp)fgsk.getProperty("av_time"))) continue;
                                }
                                boolean complete = (percentage = FgskSimulationHelper.determineFgskIntersectionPercentage(fgsk, from, to, gwk)) == 100.0;
                                FgskSimulationHelper.addMassnahme(simulationBean, fgsk, massn, complete);
                                if (massnMap.get(fgsk) == null) {
                                    massnMap.put(fgsk, new ArrayList());
                                }
                                ((List)massnMap.get(fgsk)).add(massn);
                            }
                        }
                        continue;
                    }
                    if (maBean.getProperty("massnahmen_schluessel") != null) continue;
                    System.out.println("keine FGSK Ma\u00dfnahme f\u00fcr " + maBean.getProperty("id") + " gefunden");
                }
                List classList = simulationBean.getBeanCollectionProperty("klassen");
                classList.clear();
                for (MetaObject fgsk : fgskMos) {
                    CidsBean calcClass = CidsBeanSupport.createNewCidsBeanFromTableName("sim_berechnete_klasse");
                    classList.add(calcClass);
                    CidsBean fgskBean = fgsk.getBean();
                    calcClass.setProperty(FGSK_KA_PROPERTY, fgskBean.getProperty("id"));
                    Double p = null;
                    try {
                        p = SimSimulationsabschnittEditor.calc(fgskBean, (List)massnMap.get(fgskBean), false, null);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Cannot calculate fgsk kartierabschnitt", (Throwable)e);
                    }
                    CidsBean exception = (CidsBean)fgskBean.getProperty("sonderfall_id");
                    Integer cl = null;
                    if (exception != null && Integer.valueOf(1).equals(exception.getProperty("value"))) {
                        cl = 5;
                    } else if (p != null && p > 0.0) {
                        cl = CalcCache.getQualityClass(p);
                    }
                    calcClass.setProperty("klasse", cl);
                }
                return simulationBean;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while creating fgsk simulation", (Throwable)e);
            }
        }
        return null;
    }

    public static List<CidsBean> getSimMassnBeanFromMassnBvp(CidsBean massnBvpBean) {
        ArrayList<CidsBean> result = new ArrayList<CidsBean>();
        CidsBean massnSchluessel = (CidsBean)massnBvpBean.getProperty("massnahmen_schluessel");
        if (massnSchluessel != null) {
            try {
                MetaObject[] mos;
                String fgsk_nr = (String)massnSchluessel.getProperty("fgsk_nr");
                if (fgsk_nr != null && (mos = (MetaObject[])simMassnahmenCache.calcValue(Collections.nCopies(1, fgsk_nr))) != null) {
                    for (MetaObject mo : mos) {
                        result.add(mo.getBean());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"mnt is not a number", (Throwable)e);
            }
        }
        return result;
    }

    public static List<CidsBean> getAllCorrespondingFgsk(double from, double to, Long gwk, MetaObject[] fgsks) {
        ArrayList<CidsBean> resultList = new ArrayList<CidsBean>();
        for (MetaObject mo : fgsks) {
            if (!(FgskSimulationHelper.determineFgskIntersectionPercentage(mo.getBean(), from, to, gwk) > 50.0)) continue;
            resultList.add(mo.getBean());
        }
        return resultList;
    }

    public static double determineFgskIntersectionPercentage(CidsBean fgskBean, double from, double to, Long gwk) {
        if (fgskBean.getProperty("linie.von.route.gwk").equals(gwk)) {
            double fgskFrom = Math.min((Double)fgskBean.getProperty("linie.von.wert"), (Double)fgskBean.getProperty("linie.bis.wert"));
            double fgskTo = Math.max((Double)fgskBean.getProperty("linie.von.wert"), (Double)fgskBean.getProperty("linie.bis.wert"));
            double intersectionFrom = Math.max(fgskFrom, from);
            double intersectionTo = Math.min(fgskTo, to);
            double intersectionLength = intersectionTo - intersectionFrom;
            if (intersectionLength < 0.0) {
                intersectionLength = 0.0;
            }
            if (intersectionTo - intersectionFrom == 0.0) {
                LOG.warn((Object)"FGSK Kartierabschnitt with a length of 0 found.");
                return 0.0;
            }
            return intersectionLength * 100.0 / (fgskTo - fgskFrom);
        }
        return 0.0;
    }

    public static CidsBean getSimMassnahmeById(Integer id) {
        if (id == null) {
            return null;
        }
        return massnBeanMap.get(id);
    }

    public static CidsBean getSimMassnahmeGruppeById(Integer id) {
        if (id == null) {
            return null;
        }
        return massnGruppeBeanMap.get(id);
    }

    public static void reCreateSimulation(String wkk, boolean realisierung2027) {
        try {
            CidsBean simulationBean;
            MetaObject[] metaObjects;
            int realisierung = realisierung2027 ? 2027 : 2021;
            CidsBean realisierungBean = realisierungMap.get(realisierung);
            if (realisierungBean == null) {
                String real_query = "SELECT " + REALISIERUNG_MC.getID() + ",  " + REALISIERUNG_MC.getPrimaryKey() + " FROM " + REALISIERUNG_MC.getTableName() + " WHERE value =" + realisierung;
                MetaObject[] realMeta = SessionManager.getProxy().getMetaObjectByQuery(real_query, 0);
                if (realMeta != null && realMeta.length > 0) {
                    realisierungBean = realMeta[0].getBean();
                    realisierungMap.put(realisierung, realisierungBean);
                }
            }
            String query = "SELECT " + SIMULATION_MC.getID() + ",  s." + SIMULATION_MC.getPrimaryKey() + " FROM " + SIMULATION_MC.getTableName() + " s, massnahmen_realisierung mr WHERE mr.id = s.realisierung and s.wk_key = '" + wkk + "' and read_only = true and s.realisierung = mr.id and mr.value = " + realisierung;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for massnahmen: " + query));
            }
            if ((metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0)) != null && metaObjects.length > 0) {
                simulationBean = metaObjects[0].getBean();
            } else {
                simulationBean = CidsBeanSupport.createNewCidsBeanFromTableName("simulation");
                simulationBean.setProperty("name", (Object)("Simulation " + realisierung));
                simulationBean.setProperty("beschreibung", (Object)("Automatisch erstellte Simulation der geplanten Ma\u00dfnahmen bis " + realisierung + "."));
            }
            FgskSimulationHelper.fillMassnSimulation(simulationBean, wkk, realisierungBean);
            simulationBean.persist();
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot recreate simulationBean", (Throwable)e);
        }
    }

    public static void createAllSimulations() {
        try {
            WkFgWkkSearch search = new WkFgWkkSearch();
            ArrayList resArray = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            if (resArray != null) {
                int count = 0;
                for (ArrayList wkfgArray : resArray) {
                    String wkk = (String)wkfgArray.get(0);
                    if (++count <= 411) continue;
                    LOG.error((Object)("start: " + wkk + " " + count + "/" + resArray.size()));
                    FgskSimulationHelper.reCreateSimulation(wkk, true);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating all default simulations.", (Throwable)e);
        }
    }

    static {
        try {
            MetaObject[] massnMos;
            for (MetaObject massn : massnMos = (MetaObject[])allSimMassnahmenCache.calcValue((Object)SIM_MASSNAHME_MC)) {
                massnBeanMap.put(massn.getId(), massn.getBean());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving all sim_massnahme objects.", (Throwable)e);
        }
        try {
            MetaObject[] massnGruppeMos;
            for (MetaObject gruppe : massnGruppeMos = (MetaObject[])allSimMassnahmenGruppeCache.calcValue((Object)SIM_MASSNAHMEN_GRUPPE_MC)) {
                massnGruppeBeanMap.put(gruppe.getId(), gruppe.getBean());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving all sim_massnahme_gruppe objects.", (Throwable)e);
        }
    }

    private static class AllBeansOfTypeCalculator
    implements Calculator<MetaClass, MetaObject[]> {
        private AllBeansOfTypeCalculator() {
        }

        public MetaObject[] calculate(MetaClass mc) throws Exception {
            String query = "SELECT " + mc.getID() + ",  " + mc.getPrimaryKey() + " FROM " + mc.getTableName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for calculate: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            return metaObjects;
        }
    }

    private static class SimMassnCalculator
    implements Calculator<List, MetaObject[]> {
        private SimMassnCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "SELECT " + SIM_MASSNAHME_MC.getID() + ",  " + SIM_MASSNAHME_MC.getPrimaryKey() + " FROM " + SIM_MASSNAHME_MC.getTableName() + " WHERE key = '" + String.valueOf(input.get(0)) + "';";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for sim_massnahmen: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            return metaObjects;
        }
    }
}

