/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BewirtschaftungsendeHelper
implements DisposableCidsBeanStore {
    private static final Logger LOG = Logger.getLogger(BewirtschaftungsendeHelper.class);
    private static final MetaClass MC_WK_FG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
    private static final MetaClass MC_WK_FG_TEILE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg_teile");
    private static final MetaClass MC_WK_TEIL = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_teil");
    private static final MetaClass MC_STATION_LINIE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station_linie");
    private static final MetaClass MC_STATION = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station");
    public static final String PROP_WK = "wk";
    private final Collection<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private CidsBean cidsBean;
    private CidsBean wkBean;
    private final Collection<CidsBean> wkFgBeans = new ArrayList<CidsBean>();
    private final PropertyChangeListener wertListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("wert")) {
                BewirtschaftungsendeHelper.this.updateWk();
            }
        }
    };
    private final PropertyChangeListener statListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("bemerkung")) {
                BewirtschaftungsendeHelper.this.setCidsBean(BewirtschaftungsendeHelper.this.cidsBean);
            }
        }
    };

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void changeWkBean(CidsBean wkBean) {
        CidsBean oldWkBean = this.wkBean;
        this.wkBean = wkBean;
        this.fireWkChanged(oldWkBean, wkBean);
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cleanListener();
        this.cidsBean = cidsBean;
        this.reinitWkFrontiers();
        this.initListener();
    }

    public void dispose() {
        this.cleanListener();
    }

    private void initListener() {
        if (this.cidsBean != null) {
            this.cidsBean.addPropertyChangeListener(this.statListener);
            CidsBean statBean = (CidsBean)this.cidsBean.getProperty("stat");
            if (statBean != null) {
                statBean.addPropertyChangeListener(this.wertListener);
            }
        }
    }

    private void cleanListener() {
        if (this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener(this.statListener);
            CidsBean statBean = (CidsBean)this.cidsBean.getProperty("stat");
            if (statBean != null) {
                statBean.removePropertyChangeListener(this.wertListener);
            }
        }
    }

    private void reinitWkFrontiers() {
        this.wkFgBeans.clear();
        if (this.cidsBean != null && this.cidsBean.getProperty("stat") != null) {
            int route_id = (Integer)this.cidsBean.getProperty("stat.route.id");
            String queryWkFg = "SELECT    " + MC_WK_FG.getID() + ",    wk_fg." + MC_WK_FG.getPrimaryKey() + " FROM    " + MC_WK_FG.getTableName() + " AS wk_fg,    " + MC_WK_FG_TEILE.getTableName() + " AS wk_fg_teile,    " + MC_WK_TEIL.getTableName() + " AS wk_teil,    " + MC_STATION_LINIE.getTableName() + " AS station_linie,    " + MC_STATION.getTableName() + " AS station WHERE    wk_fg_teile.wk_fg_reference = wk_fg.teile    AND wk_teil.id = wk_fg_teile.teil    AND station_linie.id = wk_teil.linie    AND station.id = station_linie.von    AND station.route = " + route_id + " ;";
            try {
                MetaObject[] mosWkFg;
                for (MetaObject moWkFg : mosWkFg = SessionManager.getProxy().getMetaObjectByQuery(queryWkFg, 0)) {
                    this.wkFgBeans.add(moWkFg.getBean());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"error while loading wk_fgs", (Throwable)ex);
            }
        }
        this.updateWk();
    }

    private void updateWk() {
        try {
            for (CidsBean wkFgBean : this.wkFgBeans) {
                for (CidsBean teilBean : (Collection)wkFgBean.getProperty("teile")) {
                    double von = (Double)teilBean.getProperty("linie.von.wert");
                    double bis = (Double)teilBean.getProperty("linie.bis.wert");
                    double wert = (Double)this.cidsBean.getProperty("stat.wert");
                    if (!(wert >= von && wert <= bis) && (!(wert >= bis) || !(wert <= von))) continue;
                    this.changeWkBean(wkFgBean);
                    return;
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while calculating WK", (Throwable)ex);
        }
        this.changeWkBean(null);
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(PropertyChangeListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireWkChanged(CidsBean oldWkBean, CidsBean newWkBean) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(new PropertyChangeEvent(this, PROP_WK, oldWkBean, newWkBean));
        }
    }
}

