/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdesktop.observablecollections.ObservableCollections;

public class CidsBeanNormalizer {
    private final Logger LOG = Logger.getLogger(CidsBeanNormalizer.class);
    private final Map<CidsBeanWrapper, CidsBean> beanCache = new HashMap<CidsBeanWrapper, CidsBean>();

    public CidsBean normalizeCidsBean(CidsBean bean) throws Exception {
        return this.normalizeCidsBean(bean, true);
    }

    public CidsBean normalizeCidsBean(CidsBean bean, boolean useCache) throws Exception {
        if (bean == null) {
            return null;
        }
        CidsBean cachedBean = null;
        if (useCache) {
            cachedBean = this.beanCache.get(new CidsBeanWrapper(bean.getMetaObject().getMetaClass().getId(), bean.getMetaObject().getId()));
        }
        if (cachedBean == null) {
            for (String propName : bean.getPropertyNames()) {
                Object o = bean.getProperty(propName);
                if (o instanceof CidsBean) {
                    bean.setProperty(propName, (Object)this.normalizeCidsBean((CidsBean)o, true));
                    continue;
                }
                if (!(o instanceof List)) continue;
                List beanList = (List)o;
                ArrayList listCopy = new ArrayList(beanList);
                beanList = ObservableCollections.observableList(new ArrayList());
                bean.setProperty(propName, (Object)beanList);
                for (CidsBean b : listCopy) {
                    beanList.add(this.normalizeCidsBean(b, true));
                }
            }
            cachedBean = CidsBeanNormalizer.cloneCidsBean(bean);
            cachedBean.getMetaObject().setID(bean.getMetaObject().getId());
            if (bean.getMetaObject().getReferencingObjectAttribute() != null) {
                cachedBean.getMetaObject().setReferencingObjectAttribute(bean.getMetaObject().getReferencingObjectAttribute());
            }
            cachedBean.getMetaObject().forceStatus(0);
            if (useCache) {
                this.beanCache.put(new CidsBeanWrapper(bean.getMetaObject().getMetaClass().getId(), bean.getMetaObject().getId()), cachedBean);
            }
        } else {
            boolean bl = false;
        }
        return cachedBean;
    }

    public static CidsBean cloneCidsBean(CidsBean bean) throws Exception {
        if (bean == null) {
            return null;
        }
        CidsBean clone = CidsBean.createNewCidsBeanFromTableName((String)"WRRL_DB_MV", (String)bean.getMetaObject().getMetaClass().getTableName());
        for (String propName : bean.getPropertyNames()) {
            Object o = bean.getProperty(propName);
            if (o instanceof CidsBean) {
                clone.setProperty(propName, (Object)((CidsBean)o));
                continue;
            }
            if (o instanceof Collection) {
                List list = (List)o;
                List newList = clone.getBeanCollectionProperty(propName);
                for (CidsBean tmpBean : list) {
                    newList.add(tmpBean);
                }
                continue;
            }
            if (o instanceof Geometry) {
                clone.setProperty(propName, ((Geometry)o).clone());
                continue;
            }
            if (o instanceof Long) {
                clone.setProperty(propName, (Object)new Long(o.toString()));
                continue;
            }
            if (o instanceof Double) {
                clone.setProperty(propName, (Object)new Double(o.toString()));
                continue;
            }
            if (o instanceof Integer) {
                clone.setProperty(propName, (Object)new Integer(o.toString()));
                continue;
            }
            if (o instanceof Boolean) {
                clone.setProperty(propName, (Object)new Boolean(o.toString()));
                continue;
            }
            if (o instanceof String) {
                clone.setProperty(propName, o);
                continue;
            }
            clone.setProperty(propName, o);
        }
        return clone;
    }

    private class CidsBeanWrapper {
        private int classId;
        private int objectId;

        public CidsBeanWrapper(int classId, int objectId) {
            this.classId = classId;
            this.objectId = objectId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CidsBeanWrapper) {
                CidsBeanWrapper other = (CidsBeanWrapper)obj;
                return this.classId == other.classId && this.objectId == other.objectId;
            }
            return false;
        }

        public int hashCode() {
            int hash = 5;
            hash = 19 * hash + this.classId;
            hash = 19 * hash + this.objectId;
            return hash;
        }
    }
}

