/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public final class CidsBeanSupport {
    private static final Logger LOG = Logger.getLogger(CidsBeanSupport.class);
    public static final String FIELD_NOT_SET = "<nicht gesetzt>";

    private CidsBeanSupport() {
        throw new AssertionError();
    }

    public static CidsBean createNewCidsBeanFromTableName(String tableName, Map<String, Object> initialProperties) throws Exception {
        CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName(tableName);
        for (Map.Entry<String, Object> property : initialProperties.entrySet()) {
            newBean.setProperty(property.getKey(), property.getValue());
        }
        return newBean;
    }

    public static CidsBean createNewCidsBeanFromTableName(String tableName) throws Exception {
        MetaClass metaClass;
        if (tableName != null && (metaClass = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)tableName)) != null) {
            return metaClass.getEmptyInstance().getBean();
        }
        throw new Exception("Could not find MetaClass for table " + tableName);
    }

    public static List<CidsBean> getBeanCollectionFromProperty(CidsBean bean, String collectionProperty) {
        Object colObj;
        if (bean != null && collectionProperty != null && (colObj = bean.getProperty(collectionProperty)) instanceof Collection) {
            return (List)colObj;
        }
        return null;
    }

    public static boolean checkWritePermission(CidsBean bean) {
        User user = SessionManager.getSession().getUser();
        return bean.getHasWritePermission(user) && bean.hasObjectWritePermission(user);
    }

    public static void deleteStationIfExists(CidsBean bean, String propertyName, List<CidsBean> beansToDelete) throws Exception {
        Object station = bean.getProperty(propertyName);
        if (station instanceof CidsBean) {
            CidsBean cbean = (CidsBean)station;
            CidsBeanSupport.deletePropertyIfExists(cbean, "real_point", beansToDelete);
            cbean.delete();
            beansToDelete.add(cbean);
        }
    }

    public static void deleteStationlineIfExists(CidsBean bean, String propertyName, List<CidsBean> beansToDelete) throws Exception {
        Object line = bean.getProperty(propertyName);
        if (line instanceof CidsBean) {
            CidsBean cbean = (CidsBean)line;
            CidsBeanSupport.deleteStationIfExists(cbean, "von", beansToDelete);
            CidsBeanSupport.deleteStationIfExists(cbean, "bis", beansToDelete);
            CidsBeanSupport.deletePropertyIfExists(cbean, "geom", beansToDelete);
            cbean.delete();
            beansToDelete.add(cbean);
        }
    }

    public static void deletePropertyIfExists(CidsBean bean, String propertyName, List<CidsBean> beansToDelete) throws Exception {
        Object beanToDelete = bean.getProperty(propertyName);
        if (beanToDelete instanceof CidsBean) {
            ((CidsBean)beanToDelete).delete();
            beansToDelete.add((CidsBean)beanToDelete);
        }
    }

    public static CidsBean cloneStation(CidsBean bean) throws Exception {
        if (bean == null) {
            return null;
        }
        CidsBean clone = bean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        clone.setProperty("wert", bean.getProperty("wert"));
        Object geom = bean.getProperty("real_point");
        if (geom instanceof CidsBean) {
            clone.setProperty("real_point", (Object)CidsBeanSupport.cloneCidsBean((CidsBean)geom));
        }
        clone.setProperty("route", bean.getProperty("route"));
        return clone;
    }

    public static CidsBean cloneStationline(CidsBean bean) throws Exception {
        Object geomBean;
        Object toBean;
        if (bean == null) {
            return null;
        }
        CidsBean clone = bean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        Object fromBean = bean.getProperty("von");
        if (fromBean instanceof CidsBean) {
            clone.setProperty("von", (Object)CidsBeanSupport.cloneStation((CidsBean)fromBean));
        }
        if ((toBean = bean.getProperty("bis")) instanceof CidsBean) {
            clone.setProperty("bis", (Object)CidsBeanSupport.cloneStation((CidsBean)toBean));
        }
        if ((geomBean = bean.getProperty("geom")) instanceof CidsBean) {
            clone.setProperty("geom", (Object)CidsBeanSupport.cloneCidsBean((CidsBean)geomBean));
        }
        return clone;
    }

    public static CidsBean cloneCidsBean(CidsBean bean) throws Exception {
        return CidsBeanSupport.cloneCidsBean(bean, true);
    }

    public static CidsBean cloneCidsBean(CidsBean bean, boolean cloneBeans) throws Exception {
        return CidsBeanSupport.cloneCidsBean(bean, cloneBeans, new ArrayList<String>());
    }

    public static CidsBean cloneCidsBean(CidsBean bean, boolean cloneBeans, List<String> exceptions) throws Exception {
        if (bean == null) {
            return null;
        }
        CidsBean clone = bean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        for (String propName : bean.getPropertyNames()) {
            if (propName.toLowerCase().equals("id") || exceptions.contains(propName.toLowerCase())) continue;
            Object o = bean.getProperty(propName);
            if (o instanceof CidsBean) {
                if (cloneBeans) {
                    clone.setProperty(propName, (Object)CidsBeanSupport.cloneCidsBean((CidsBean)o));
                    continue;
                }
                clone.setProperty(propName, (Object)((CidsBean)o));
                continue;
            }
            if (o instanceof Collection) {
                List list = (List)o;
                ArrayList<CidsBean> newList = new ArrayList<CidsBean>();
                for (CidsBean tmpBean : list) {
                    if (cloneBeans) {
                        newList.add(CidsBeanSupport.cloneCidsBean(tmpBean));
                        continue;
                    }
                    newList.add(tmpBean);
                }
                clone.setProperty(propName, newList);
                continue;
            }
            if (o instanceof Geometry) {
                clone.setProperty(propName, ((Geometry)o).clone());
                continue;
            }
            if (o instanceof Long) {
                clone.setProperty(propName, (Object)new Long(o.toString()));
                continue;
            }
            if (o instanceof Double) {
                clone.setProperty(propName, (Object)new Double(o.toString()));
                continue;
            }
            if (o instanceof Integer) {
                clone.setProperty(propName, (Object)new Integer(o.toString()));
                continue;
            }
            if (o instanceof Boolean) {
                clone.setProperty(propName, (Object)new Boolean(o.toString()));
                continue;
            }
            if (o instanceof String) {
                clone.setProperty(propName, o);
                continue;
            }
            if (o != null) {
                LOG.error((Object)("unknown property type: " + o.getClass().getName()));
            }
            clone.setProperty(propName, o);
        }
        return clone;
    }

    public static double textToDouble(JTextField text, double nullValue) {
        double d = 0.0;
        if (text.getText().isEmpty()) {
            return nullValue;
        }
        try {
            d = Double.valueOf(text.getText().replace(',', '.'));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"cannot convert text to double", (Throwable)e);
        }
        return d;
    }

    public static boolean checkOptionalAttribute(CidsBean cidsBean, Component component, Map<String, String> fieldMapping) {
        ObjectAttribute[] attrs;
        for (ObjectAttribute attr : attrs = cidsBean.getMetaObject().getAttribs()) {
            if (attr.isOptional() || cidsBean.getProperty(attr.getName()) != null) continue;
            String attrDescription = null;
            if (fieldMapping != null && fieldMapping.get(attr.getName()) != null) {
                attrDescription = fieldMapping.get(attr.getName());
            } else {
                attrDescription = attr.getDescription();
                if (attrDescription == null) {
                    attrDescription = attr.getName();
                }
            }
            JOptionPane.showMessageDialog(component, NbBundle.getMessage(CidsBeanSupport.class, (String)"CidsBeanSupport.checkOptionalAttribute.message", (Object)attrDescription), NbBundle.getMessage(CidsBeanSupport.class, (String)"CidsBeanSupport.checkOptionalAttribute.title"), 0);
            return false;
        }
        return true;
    }
}

