/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;

public class CismetHttpUrlConnection
extends HttpURLConnection {
    Integer responseCode = null;
    private HttpClient client;
    private final HashMap<String, String> requestProperties = new HashMap();
    private Header[] responseHeaders = null;
    private InputStream response = null;

    public CismetHttpUrlConnection(URL url) {
        super(url);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.client == null) {
            this.connect();
        }
        return this.response;
    }

    public Header[] getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public String getContentType() {
        if (this.responseHeaders != null) {
            for (Header header : this.responseHeaders) {
                if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
                return header.getValue();
            }
            return super.getContentType();
        }
        return null;
    }

    @Override
    public String getContentEncoding() {
        return super.getContentEncoding();
    }

    private void printStream(InputStream is) {
        try {
            FileOutputStream fos = new FileOutputStream("/home/therter/test.svg");
            byte[] tmp = new byte[512];
            int count = -1;
            while ((count = is.read(tmp)) != -1) {
                fos.write(tmp, 0, count);
            }
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void disconnect() {
        try {
            this.response.close();
        }
        catch (IOException ex) {
            System.out.println("Cannot close input stream from connection");
        }
        this.response = null;
        this.client = null;
    }

    @Override
    public boolean usingProxy() {
        return ProxyHandler.getInstance().getProxy() != null;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.client == null) {
            this.connect();
        }
        if (this.responseCode == null) {
            HeadMethod head = new HeadMethod(this.url.toString());
            try {
                int n = this.client.executeMethod((HttpMethod)head);
                return n;
            }
            finally {
                head.releaseConnection();
            }
        }
        return this.responseCode;
    }

    @Override
    public void connect() throws IOException {
        if (this.client == null) {
            this.client = this.getClient();
        }
        if (this.response == null) {
            GetMethod get = new GetMethod(this.url.toString());
            this.responseCode = this.client.executeMethod((HttpMethod)get);
            for (String key : this.requestProperties.keySet()) {
                get.addRequestHeader(key, this.requestProperties.get(key));
            }
            this.responseHeaders = get.getResponseHeaders();
            this.response = get.getResponseBodyAsStream();
        }
    }

    @Override
    public int getContentLength() {
        try {
            return this.getInputStream().available();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private HttpClient getClient() {
        Proxy proxy = ProxyHandler.getInstance().getProxy();
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        ArrayList<String> authPrefs = new ArrayList<String>();
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        authPrefs.add("NTLM");
        client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        if (proxy != null && proxy.getHost() != null && proxy.getPort() > 0 && proxy.isValid() && proxy.isEnabledFor(this.url != null ? this.url.getHost() : null)) {
            client.getHostConfiguration().setProxy(proxy.getHost(), proxy.getPort());
            if (proxy.getUsername() != null && proxy.getPassword() != null) {
                AuthScope authscope = new AuthScope(proxy.getHost(), proxy.getPort());
                NTCredentials credentials = new NTCredentials(proxy.getUsername(), proxy.getPassword(), "", proxy.getDomain() == null ? "" : proxy.getDomain());
                client.getState().setProxyCredentials(authscope, (Credentials)credentials);
            }
        }
        return client;
    }
}

