/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Base64;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;

public class ConversionUtils {
    private static final DecimalFormat format = new DecimalFormat("0.00");

    public static String numberToString(Object d) {
        if (d == null) {
            return "";
        }
        return format.format(d);
    }

    public static String image2String(BufferedImage i) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)i, "png", out);
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    public static BufferedImage String2Image(String s) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
        return ImageIO.read(in);
    }

    public static String jrDataSource2String(JRDataSource c) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(c);
        oout.flush();
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    public static JRDataSource String2JRDataSource(String s) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
        ObjectInputStream oin = new ObjectInputStream(in);
        return (JRDataSource)oin.readObject();
    }

    public static boolean isValidTimeString(String t) {
        if (t.matches("\\d{1,2}?:\\d{1,2}?") || t.matches("\\d{1,2}?:\\d{1,2}?:\\d{1,2}?")) {
            StringTokenizer st = new StringTokenizer(t, ":");
            int count = 0;
            while (st.hasMoreTokens()) {
                block9: {
                    if (count == 0) {
                        try {
                            int hours = Integer.parseInt(st.nextToken());
                            if (hours < 0 || hours > 23) {
                                return false;
                            }
                            break block9;
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                    }
                    try {
                        int number = Integer.parseInt(st.nextToken());
                        if (number < 0 || number > 59) {
                            return false;
                        }
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                ++count;
            }
            return true;
        }
        return false;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(',');
        symbols.setGroupingSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(true);
    }
}

