/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import groovy.lang.GroovyShell;
import org.codehaus.groovy.control.CompilationFailedException;

public class ExpressionEvaluator {
    private char[] allowedCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', ' ', '(', ')', '+', '*', '-', '/', '^'};
    private final GroovyShell shell = new GroovyShell();

    public Double eval(String expression) throws CompilationFailedException {
        if (!this.isValidExpression(expression)) {
            return null;
        }
        Object result = this.shell.evaluate(expression);
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return null;
    }

    public boolean isValidExpression(String expression) {
        for (int i = 0; i < expression.length(); ++i) {
            if (this.isValid(expression.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isValid(char c) {
        for (char tmp : this.allowedCharacters) {
            if (c != tmp) continue;
            return true;
        }
        return false;
    }
}

