/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.actions.wrrl_db_mv.GupLoadStatus;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupPlanungsabschnittEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupUnterhaltungsmassnahmeEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanNormalizer;
import de.cismet.cids.custom.wrrl_db_mv.util.WebDavHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.commons.security.WebDavClient;
import de.cismet.tools.configuration.StartupHook;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class GupStartupHook
implements StartupHook {
    private static final Logger LOG = Logger.getLogger(GupStartupHook.class);
    private static final ExecutorService executor = CismetExecutors.newFixedThreadPool((int)10);

    public void applicationStarted() {
        GupPlanungsabschnittEditor editor = new GupPlanungsabschnittEditor();
        editor = null;
        Thread gupInit = new Thread(){
            private final MetaClass MASSNAHMENART_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_massnahmenart");
            private final MetaClass GUP_PLANUNGSABSCHNITT_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_planungsabschnitt");

            @Override
            public void run() {
                if (this.GUP_PLANUNGSABSCHNITT_MC == null || !this.GUP_PLANUNGSABSCHNITT_MC.getPermissions().hasWritePermission(SessionManager.getSession().getUser())) {
                    return;
                }
                try {
                    boolean newMos;
                    CidsBeanNormalizer normalizer = new CidsBeanNormalizer();
                    final ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                    String query = "select " + this.MASSNAHMENART_MC.getID() + "," + this.MASSNAHMENART_MC.getPrimaryKey() + " from " + this.MASSNAHMENART_MC.getTableName() + " order by id";
                    int limit = 50;
                    int offset = 0;
                    do {
                        newMos = false;
                        String loopQuery = query + " limit " + 50 + " offset " + offset;
                        MetaObject[] mo = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), loopQuery, "WRRL_DB_MV");
                        offset += 50;
                        if (mo != null && mo.length > 0) {
                            newMos = true;
                            for (MetaObject m : mo) {
                                beans.add(normalizer.normalizeCidsBean(m.getBean()));
                            }
                        }
                        mo = null;
                    } while (newMos);
                    System.runFinalization();
                    System.gc();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GupUnterhaltungsmassnahmeEditor.setMassnahmnenObjects(beans.toArray(new CidsBean[beans.size()]));
                            GupLoadStatus.getLastInstance().setStatusOk();
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while retrieving massnahmen objects.", (Throwable)e);
                }
            }
        };
        gupInit.setPriority(1);
        gupInit.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadImageFromWebDAV(WebDavClient webDavClient, String WEB_DAV_DIRECTORY, String fileName) throws IOException {
        String encodedFileName = WebDavHelper.encodeURL(fileName);
        InputStream iStream = webDavClient.getInputStream(WEB_DAV_DIRECTORY + encodedFileName);
        try {
            int count;
            String n = fileName;
            if (n.contains("/")) {
                n = n.substring(n.lastIndexOf("/") + 1);
            }
            File f = new File("/home/therter/tmp/fotos/" + n);
            FileOutputStream fout = new FileOutputStream(f);
            byte[] tmp = new byte[256];
            while ((count = iStream.read(tmp)) != -1) {
                fout.write(tmp, 0, count);
            }
            fout.flush();
            fout.close();
            File file = f;
            return file;
        }
        finally {
            IOUtils.closeQuietly((InputStream)iStream);
        }
    }
}

