/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import de.cismet.cids.custom.wrrl_db_mv.util.CismetHttpUrlConnection;
import de.cismet.tools.configuration.StartupHook;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;

public class HttpStartupHook
implements StartupHook {
    private static final Logger LOG = Logger.getLogger(HttpStartupHook.class);
    public static boolean initialised = false;

    public void applicationStarted() {
        HashMap<HostConfiguration, Integer> maxHostConnections = new HashMap<HostConfiguration, Integer>();
        maxHostConnections.put(HostConfiguration.ANY_HOST_CONFIGURATION, 64);
        HttpConnectionManagerParams.getDefaultParams().setParameter("http.connection-manager.max-per-host", maxHostConnections);
        HttpConnectionManagerParams.getDefaultParams().setIntParameter("http.connection-manager.max-total", 64);
    }

    public static synchronized void init() {
        if (!initialised) {
            // empty if block
        }
    }

    private static Map tryExtractInternalHandlerTableFromUrl() {
        try {
            Field handlersField = URL.class.getDeclaredField("handlers");
            handlersField.setAccessible(true);
            return (Map)handlersField.get(null);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot use custom http handler", (Throwable)e);
            return null;
        }
    }

    public static class CustomUrlHandler
    extends URLStreamHandler {
        private Object origHandler;

        public CustomUrlHandler(Object origHandler) {
            this.origHandler = origHandler;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            if (u.toString().startsWith("https://fis-wasser-mv.de/charts/steckbriefe")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"use cismet handler");
                }
                return new CismetHttpUrlConnection(u);
            }
            try {
                Method m = this.origHandler.getClass().getMethod("openConnection", URL.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"use orig handler");
                }
                return (URLConnection)m.invoke(this.origHandler, u);
            }
            catch (Exception e) {
                LOG.error((Object)"cannot use orig handler", (Throwable)e);
                return new CismetHttpUrlConnection(u);
            }
        }

        @Override
        protected URLConnection openConnection(URL u, Proxy p) throws IOException {
            if (u.toString().startsWith("https://fis-wasser-mv.de/charts/steckbriefe")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"use cismet handler with proxy");
                }
                return new CismetHttpUrlConnection(u);
            }
            try {
                Method m = this.origHandler.getClass().getMethod("openConnection", URL.class, Proxy.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"use orig handler with proxy");
                }
                return (URLConnection)m.invoke(this.origHandler, u, p);
            }
            catch (Exception e) {
                LOG.error((Object)"cannot use orig handler", (Throwable)e);
                return new CismetHttpUrlConnection(u);
            }
        }
    }
}

