/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkFgLawaKartierabschnittSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class LawaTableModel
extends AbstractTableModel {
    public static final String NO_TYPE = "kein Typ";
    private static final Logger LOG = Logger.getLogger(LawaTableModel.class);
    private final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"lawa");
    private String[] header = new String[]{"Typ", "Anteil %", "L\u00e4nge m", "Anzahl Teilst\u00fccke"};
    private String[][] data = new String[0][0];
    private CidsBean cidsBean;
    private List<CidsBean> teile;

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.header.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.header.length) {
            return this.header[columnIndex];
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.data.length && columnIndex < this.header.length) {
            return this.data[rowIndex][columnIndex];
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void refreshData() {
        try {
            WkFgLawaKartierabschnittSearch search = new WkFgLawaKartierabschnittSearch(((Integer)this.getCidsBean().getProperty("id")).intValue());
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            ArrayList resArray = (ArrayList)res;
            this.data = new String[0][0];
            double totalLength = -1.0;
            HashMap<Integer, LawaType> lawaTypes = new HashMap<Integer, LawaType>();
            if (resArray != null) {
                for (ArrayList attributes : resArray) {
                    if (attributes.size() != 6) continue;
                    Object codeObject = attributes.get(0);
                    Object descriptionObject = attributes.get(1);
                    Object totalLengthObject = attributes.get(2);
                    Object intersectionLengthObject = attributes.get(3);
                    if (codeObject instanceof Integer && descriptionObject instanceof String && totalLengthObject instanceof Double && intersectionLengthObject instanceof Double) {
                        LawaType type;
                        if (!((Double)intersectionLengthObject > 0.0)) continue;
                        if (totalLength == -1.0 && ((Integer)codeObject != -1 || resArray.size() == 1)) {
                            totalLength = (Double)totalLengthObject;
                        }
                        if ((type = lawaTypes.get((Integer)codeObject)) == null) {
                            type = new LawaType();
                            type.setCode((Integer)codeObject);
                            type.setDescription((String)descriptionObject);
                            lawaTypes.put((Integer)codeObject, type);
                        }
                        type.setCount(type.getCount() + 1);
                        type.setTotalLength(type.getTotalLength() + (Double)intersectionLengthObject);
                        continue;
                    }
                    LOG.error((Object)"The search results have the wrong data types");
                }
                LawaType noType = (LawaType)lawaTypes.get(-1);
                if (noType != null) {
                    int count = this.calcNoTypeCount(resArray);
                    noType.setCount(count);
                }
                this.fillData(lawaTypes, totalLength);
            }
            this.fireTableDataChanged();
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Error while trying to receive measurements.", (Throwable)e);
        }
    }

    private int calcNoTypeCount(ArrayList<ArrayList> resArray) {
        int count = 0;
        double lastEnd = -1.0;
        double partEnd = 0.0;
        int index = 0;
        if (this.getTeile() == null || this.getTeile().size() < 1) {
            return 0;
        }
        CidsBean currentPart = this.getTeile().get(index++);
        lastEnd = (Double)currentPart.getProperty("linie.von.wert");
        partEnd = (Double)currentPart.getProperty("linie.bis.wert");
        for (int i = 0; i < resArray.size(); ++i) {
            ArrayList attributes = resArray.get(i);
            if (attributes.size() != 6) continue;
            Integer code = (Integer)attributes.get(0);
            Double intersectionLength = (Double)attributes.get(3);
            Long gwk = (Long)attributes.get(4);
            Double from = (Double)attributes.get(5);
            if (code == -1) continue;
            if (!gwk.equals((Long)currentPart.getProperty("linie.von.route.gwk"))) {
                ++count;
                if (index >= this.getTeile().size()) {
                    return count;
                }
                currentPart = this.getTeile().get(index++);
                lastEnd = (Double)currentPart.getProperty("linie.von.wert");
                partEnd = (Double)currentPart.getProperty("linie.bis.wert");
                --i;
                continue;
            }
            if (from > lastEnd && from < partEnd) {
                ++count;
            }
            if (!(from + intersectionLength > lastEnd) || !((lastEnd = from + intersectionLength) >= partEnd)) continue;
            if (index >= this.getTeile().size()) {
                return count;
            }
            currentPart = this.getTeile().get(index++);
            lastEnd = (Double)currentPart.getProperty("linie.von.wert");
            partEnd = (Double)currentPart.getProperty("linie.bis.wert");
            --i;
        }
        if (lastEnd < partEnd) {
            ++count;
        }
        return count;
    }

    private void fillData(HashMap<Integer, LawaType> lawaTypes, double wkFgTotalLength) {
        this.data = new String[lawaTypes.keySet().size() + 1][this.header.length];
        Iterator<Integer> keyIt = lawaTypes.keySet().iterator();
        int counter = 0;
        int counterTotal = 0;
        double percentageTotal = 0.0;
        double lengthTotal = 0.0;
        while (keyIt.hasNext()) {
            LawaType type = lawaTypes.get(keyIt.next());
            if (type != null && type.getCode() != -1) {
                double percentage = type.getTotalLength() * 100.0 / wkFgTotalLength;
                percentageTotal += percentage;
                lengthTotal += type.getTotalLength();
                counterTotal += type.getCount();
                this.data[counter][0] = type.getCode() + "-" + type.getDescription();
                this.data[counter][1] = String.valueOf(this.round(percentage, 1));
                this.data[counter][2] = String.valueOf(this.round(type.getTotalLength(), 0));
                this.data[counter][3] = String.valueOf(type.getCount());
            } else if (type != null && type.getCode() == -1) {
                --counter;
            } else {
                LOG.error((Object)"LawaType object is null. This should never happen");
            }
            ++counter;
        }
        LawaType noType = lawaTypes.get(-1);
        if (noType != null) {
            percentageTotal += noType.getTotalLength() * 100.0 / wkFgTotalLength;
            lengthTotal += noType.getTotalLength();
            counterTotal += noType.getCount();
        }
        this.data[counter][0] = NO_TYPE;
        if (noType != null) {
            this.data[counter][1] = String.valueOf(this.round(noType.getTotalLength() * 100.0 / wkFgTotalLength, 1));
            this.data[counter][2] = String.valueOf(this.round(noType.getTotalLength(), 0));
            this.data[counter][3] = String.valueOf(noType.getCount());
        } else {
            --counter;
        }
        this.data[++counter][0] = "Gesamt";
        this.data[counter][1] = String.valueOf(this.round(percentageTotal, 1));
        this.data[counter][2] = String.valueOf(this.round(lengthTotal, 0));
        this.data[counter][3] = String.valueOf(counterTotal);
    }

    private double round(double value, int scale) {
        double pow = Math.pow(10.0, scale);
        int rounded = (int)(value * pow);
        return (double)rounded / pow;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
    }

    public List<CidsBean> getTeile() {
        return this.teile;
    }

    public void setTeile(List<CidsBean> teile) {
        this.teile = teile;
    }

    private class LawaType {
        private int code;
        private String description;
        private double totalLength;
        private int count;

        private LawaType() {
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public double getTotalLength() {
            return this.totalLength;
        }

        public void setTotalLength(double totalLength) {
            this.totalLength = totalLength;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

