/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.MassnahmenUmsetzungEditor;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MassnahmenUmsetzungCache
extends Hashtable<String, CidsBean>
implements Runnable {
    private static final Logger LOG = Logger.getLogger(MassnahmenUmsetzungCache.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"massnahmen");
    private static final MetaClass MC_WK_FG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
    private static final MetaClass MC_WK_SG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_sg");
    private static final MetaClass MC_WK_KG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_kg");
    private static final MetaClass MC_WK_GW = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_gw");
    public static final String ACTION_PREFIX = "action";
    public static final String WKK_PREFIX = "wkk";
    CidsBean bean = null;
    private Thread loader = null;

    public MassnahmenUmsetzungCache(CidsBean bean) {
        this.bean = bean;
    }

    public void refresh() {
        if (this.loader != null && this.loader.isAlive()) {
            this.loader.interrupt();
        }
        while (this.loader != null && this.loader.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.clear();
        this.loader = new Thread(this);
        this.loader.start();
    }

    @Override
    public void run() {
        if (this.bean != null) {
            List impls = this.bean.getBeanCollectionProperty("umsetzung");
            for (CidsBean impl : new ArrayList(impls)) {
                String key = ACTION_PREFIX + impl.getProperty("massnahme");
                if (Thread.interrupted()) {
                    return;
                }
                if (!key.endsWith("null") && this.get(key) == null) {
                    CidsBean cacheItem = MassnahmenUmsetzungCache.bindActionField(null, impl);
                    this.put(key, cacheItem);
                }
                if (Thread.interrupted()) {
                    return;
                }
                MetaClass mc = MassnahmenUmsetzungCache.getWkMc(impl);
                if (mc == null || (key = mc.getTableName() + WKK_PREFIX + MassnahmenUmsetzungCache.getWk_kId(impl)).endsWith("null") || this.get(key) != null) continue;
                CidsBean cacheItem = MassnahmenUmsetzungCache.bindWkkField(null, impl);
                this.put(key, cacheItem);
            }
        }
    }

    public static CidsBean bindWkkField(JLabel lblValWk_k, CidsBean cidsBean) {
        CidsBean wkFgObject = null;
        String labelText = "";
        if (cidsBean != null) {
            Integer wk_id = MassnahmenUmsetzungCache.getWk_kId(cidsBean);
            if (wk_id == null) {
                labelText = "<nicht gesetzt>";
            } else {
                MetaClass mc = MassnahmenUmsetzungCache.getWkMc(cidsBean);
                String query = "select " + mc.getID() + ", m." + mc.getPrimaryKey() + " from " + mc.getTableName();
                query = query + " m WHERE m.id = " + wk_id;
                try {
                    if (!SwingUtilities.isEventDispatchThread() && Thread.interrupted()) {
                        return null;
                    }
                    MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
                    if (metaObjects.length == 1) {
                        wkFgObject = metaObjects[0].getBean();
                        Object wk_text = wkFgObject.getProperty(MassnahmenUmsetzungCache.getWk_kProperty(cidsBean));
                        if (!SwingUtilities.isEventDispatchThread() && Thread.interrupted()) {
                            return null;
                        }
                        labelText = wk_text != null ? wk_text.toString() : "<nicht gesetzt>";
                    } else {
                        LOG.error((Object)(metaObjects.length + " water bodies found, but exactly one water body should be found."));
                        labelText = "Error";
                    }
                }
                catch (ConnectionException e) {
                    LOG.error((Object)("Error while loading the water body object with query: " + query), (Throwable)e);
                }
            }
        }
        MassnahmenUmsetzungCache.setTextInEdt(lblValWk_k, labelText);
        return wkFgObject;
    }

    public static CidsBean bindActionField(JLabel lblValMassnahme_nr, CidsBean cidsBean) {
        String labelText = "";
        CidsBean massnahme = null;
        if (cidsBean != null) {
            Integer massn_id = (Integer)cidsBean.getProperty("massnahme");
            if (massn_id == null) {
                labelText = "<nicht gesetzt>";
            } else {
                String query = "select " + MC.getID() + ", m." + MC.getPrimaryKey() + " from " + MC.getTableName();
                query = query + " m WHERE m.id = " + massn_id;
                try {
                    if (!SwingUtilities.isEventDispatchThread() && Thread.interrupted()) {
                        return null;
                    }
                    MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
                    if (metaObjects.length == 1) {
                        massnahme = metaObjects[0].getBean();
                        Object massn_id_text = massnahme.getProperty("massn_id");
                        if (!SwingUtilities.isEventDispatchThread() && Thread.interrupted()) {
                            return null;
                        }
                        labelText = massn_id_text != null ? massn_id_text.toString() : "<nicht gesetzt>";
                    } else {
                        LOG.error((Object)(metaObjects.length + " activity found, but exactly one activity should be found."));
                        labelText = "Error";
                    }
                }
                catch (ConnectionException e) {
                    LOG.error((Object)("Error while loading the measurement object with query: " + query), (Throwable)e);
                }
            }
        }
        MassnahmenUmsetzungCache.setTextInEdt(lblValMassnahme_nr, labelText);
        return massnahme;
    }

    public static void setTextInEdt(final JLabel label, final String text) {
        if (label == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            label.setText(text);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        label.setText(text);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)"Exception while setting text.", (Throwable)e);
            }
        }
    }

    public static Integer getWk_kId(CidsBean cidsBean) {
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[0]) != null) {
            return (Integer)cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[0]);
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[1]) != null) {
            return (Integer)cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[1]);
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[2]) != null) {
            return (Integer)cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[2]);
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[3]) != null) {
            return (Integer)cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[3]);
        }
        return null;
    }

    public static MetaClass getWkMc(CidsBean cidsBean) {
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[0]) != null) {
            return MC_WK_FG;
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[1]) != null) {
            return MC_WK_SG;
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[2]) != null) {
            return MC_WK_KG;
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[3]) != null) {
            return MC_WK_GW;
        }
        return null;
    }

    public static String getWk_kProperty(CidsBean cidsBean) {
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[0]) != null) {
            return "wk_k";
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[1]) != null) {
            return "wk_k";
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[2]) != null) {
            return "name";
        }
        if (cidsBean.getProperty(MassnahmenUmsetzungEditor.WB_PROPERTIES[3]) != null) {
            return "name";
        }
        return null;
    }

    public CidsBean getAction(CidsBean massnahmenUmsetzung) {
        if (massnahmenUmsetzung != null) {
            String actionKey = ACTION_PREFIX + massnahmenUmsetzung.getProperty("massnahme");
            return (CidsBean)this.get(actionKey);
        }
        return null;
    }

    public CidsBean getWB(CidsBean massnahmenUmsetzung) {
        MetaClass mc = MassnahmenUmsetzungCache.getWkMc(massnahmenUmsetzung);
        if (mc != null && massnahmenUmsetzung != null) {
            String wkkKey = mc.getTableName() + WKK_PREFIX + MassnahmenUmsetzungCache.getWk_kId(massnahmenUmsetzung);
            return (CidsBean)this.get(wkkKey);
        }
        return null;
    }

    public void addAction(CidsBean massnahmenUmsetzung, CidsBean action) {
        if (massnahmenUmsetzung != null && action != null) {
            String actionKey = ACTION_PREFIX + massnahmenUmsetzung.getProperty("massnahme");
            this.put(actionKey, action);
        }
    }

    public void addWB(CidsBean massnahmenUmsetzung, CidsBean wb) {
        MetaClass mc;
        if (massnahmenUmsetzung != null && wb != null && (mc = MassnahmenUmsetzungCache.getWkMc(massnahmenUmsetzung)) != null) {
            String wkkKey = mc.getTableName() + WKK_PREFIX + MassnahmenUmsetzungCache.getWk_kId(massnahmenUmsetzung);
            this.put(wkkKey, wb);
        }
    }
}

