/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class NumberConverter
extends Converter<Double, String> {
    private static final transient Logger LOG = Logger.getLogger(NumberConverter.class);
    private static final NumberConverter INSTANCE = new NumberConverter();

    public static NumberConverter getInstance() {
        return INSTANCE;
    }

    public String convertForward(Double value) {
        return value.toString();
    }

    public Double convertReverse(String value) {
        try {
            if (value == null) {
                return null;
            }
            return new Double(value.replace(',', '.'));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("No valid number: " + value), (Throwable)e);
            if (value.trim().startsWith("kein")) {
                return 0.0;
            }
            return null;
        }
    }
}

