/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.SimSimulationsabschnittEditor;
import de.cismet.cids.custom.wrrl_db_mv.fgsk.CalcCache;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.AbschnittsinfoMember;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.jbands.JBandCursorManager;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberMouseListeningComponent;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PinstripePainter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class ReadOnlyFgskBandMember
extends AbschnittsinfoMember
implements BandMemberSelectable,
BandMemberMouseListeningComponent {
    private static final Logger LOG = Logger.getLogger(ReadOnlyFgskBandMember.class);
    private CidsBean cidsBean;
    private boolean selected;
    private Painter unselectedBackgroundPainter;
    private Painter selectedBackgroundPainter;
    private final String lineFieldName = "linie";
    private List<CidsBean> massnahmen;
    private Color backgroundColor = null;
    private DefaultStyledFeature fgskFeature = null;
    private int bottomBorder = 1;

    public ReadOnlyFgskBandMember(List<CidsBean> massnahmen, Boolean complete) {
        this.setMinimumSize(new Dimension(1, 7));
        this.setPreferredSize(this.getMinimumSize());
        this.massnahmen = massnahmen;
        this.bottomBorder = complete == null || complete != false ? 1 : 5;
        this.setBorder(new MatteBorder(new Insets(1, 1, this.bottomBorder, 1), Color.BLACK));
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
        this.cidsBean = cidsBean;
        this.refresh(this.getMassnahmen());
    }

    protected void determineBackgroundColour() {
        Integer cl = null;
        if (this.cidsBean != null) {
            Double p = null;
            try {
                p = SimSimulationsabschnittEditor.calc(this.cidsBean, this.getMassnahmen(), false, null);
            }
            catch (Exception e) {
                LOG.warn((Object)"FGSK calculation error", (Throwable)e);
            }
            CidsBean exception = (CidsBean)this.cidsBean.getProperty("sonderfall_id");
            if (p == null && exception != null && Integer.valueOf(1).equals(exception.getProperty("value"))) {
                cl = 5;
            } else if (p != null && p > 0.0) {
                cl = CalcCache.getQualityClass(p);
            }
        }
        this.unselectedBackgroundPainter = this.getMassnahmen() == null || this.getMassnahmen().isEmpty() ? this.getBackgroundPainterForClass(cl) : new CompoundPainter(new Painter[]{this.getBackgroundPainterForClass(cl), new PinstripePainter((Paint)new Color(255, 66, 66), 45.0, 2.0, 5.0)});
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    private void setDefaultBackground() {
        this.setBackgroundPainter((Painter)new MattePainter((Paint)new Color(229, 0, 0)));
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
    }

    private MattePainter getBackgroundPainterForClass(Integer cl) {
        if (cl != null) {
            switch (cl) {
                case 1: {
                    this.backgroundColor = new Color(0, 0, 255);
                    break;
                }
                case 2: {
                    this.backgroundColor = new Color(0, 153, 0);
                    break;
                }
                case 3: {
                    this.backgroundColor = new Color(255, 255, 0);
                    break;
                }
                case 4: {
                    this.backgroundColor = new Color(255, 153, 0);
                    break;
                }
                case 5: {
                    this.backgroundColor = new Color(255, 0, 0);
                    break;
                }
                default: {
                    this.backgroundColor = new Color(193, 193, 193);
                    break;
                }
            }
        } else {
            this.backgroundColor = new Color(193, 193, 193);
        }
        return new MattePainter((Paint)this.backgroundColor);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selection) {
        this.selected = selection;
        if (this.selected) {
            this.fgskFeature = new DefaultStyledFeature();
            this.fgskFeature.setGeometry((Geometry)this.cidsBean.getProperty("linie.geom.geo_field"));
            this.fgskFeature.setLinePaint((Paint)this.backgroundColor);
            this.fgskFeature.setLineWidth(4);
            CismapBroker.getInstance().getMappingComponent().addFeaturesToMap(new Feature[]{this.fgskFeature});
            this.setBackgroundPainter(this.selectedBackgroundPainter);
            this.setBorder(new MatteBorder(new Insets(3, 1, this.bottomBorder, 1), Color.BLACK));
        } else {
            if (this.fgskFeature != null) {
                CismapBroker.getInstance().getMappingComponent().removeFeatures(Arrays.asList(this.fgskFeature));
                this.fgskFeature = null;
            }
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
            this.setBorder(new MatteBorder(new Insets(1, 1, this.bottomBorder, 1), Color.BLACK));
        }
    }

    public void setComplete(Boolean complete) {
        this.bottomBorder = complete == null || complete != false ? 1 : 5;
        this.setBorder(new MatteBorder(new Insets(1, 1, this.bottomBorder, 1), Color.BLACK));
    }

    public boolean isSelectable() {
        return true;
    }

    public BandMember getBandMember() {
        return this;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.cidsBean != null) {
            Geometry g = (Geometry)this.cidsBean.getProperty("linie.geom.geo_field");
            final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            XBoundingBox xbb = new XBoundingBox(g);
            mc.gotoBoundingBoxWithHistory((BoundingBox)new XBoundingBox(g.getEnvelope().buffer((xbb.getWidth() + xbb.getHeight()) / 2.0 * 0.1)));
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(g);
            dsf.setCanBeSelected(false);
            dsf.setLinePaint((Paint)Color.YELLOW);
            dsf.setLineWidth(6);
            final PFeature highlighter = new PFeature((Feature)dsf, mc);
            mc.getHighlightingLayer().addChild((PNode)highlighter);
            highlighter.animateToTransparency(0.1f, 2000L);
            CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Thread.currentThread();
                    Thread.sleep(2500L);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        mc.getHighlightingLayer().removeChild((PNode)highlighter);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        this.setAlpha(1.0f);
    }

    public void mouseExited(MouseEvent e) {
        this.setAlpha(0.8f);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (!JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        } else {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }

    public void dispose() {
        if (this.fgskFeature != null) {
            CismapBroker.getInstance().getMappingComponent().removeFeatures(Arrays.asList(this.fgskFeature));
            this.fgskFeature = null;
        }
    }

    public void refresh(List<CidsBean> massnahmen) {
        this.massnahmen = massnahmen;
        this.determineBackgroundColour();
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
        this.setSelected(this.selected);
    }

    public List<CidsBean> getMassnahmen() {
        return this.massnahmen;
    }
}

