/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class RoundedNumberConverter
extends Converter<Double, String> {
    private static final Logger LOG = Logger.getLogger(RoundedNumberConverter.class);
    private static final RoundedNumberConverter INSTANCE = new RoundedNumberConverter();

    public static RoundedNumberConverter getInstance() {
        return INSTANCE;
    }

    public String convertForward(Double value) {
        if (value == null) {
            return "";
        }
        double val = value;
        val = (double)Math.round(val * 100.0) / 100.0;
        return String.valueOf(val);
    }

    public Double convertReverse(String value) {
        try {
            if (value == null) {
                return null;
            }
            return new Double(value.replace(',', '.'));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("No valid number: " + value), (Throwable)e);
            return null;
        }
    }
}

