/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LineEditorDropBehavior;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class RouteWBDropBehavior
implements LineEditorDropBehavior {
    private static final Logger LOG = Logger.getLogger(RouteWBDropBehavior.class);
    private static final MetaClass MC_WK_FG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
    private CidsBean wkFg = null;
    private Component comp = null;
    private boolean routeChanged = false;

    public RouteWBDropBehavior(Component comp) {
        this.comp = comp;
    }

    public void setWkFgById(Integer id) {
        this.routeChanged = false;
        String query = "select " + MC_WK_FG.getID() + ", m." + MC_WK_FG.getPrimaryKey() + " from " + MC_WK_FG.getTableName();
        query = query + " m";
        query = query + " WHERE m.id = " + id;
        try {
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            if (metaObjects.length == 1) {
                this.wkFg = metaObjects[0].getBean();
            } else {
                LOG.error((Object)(metaObjects.length + " water bodies found, but exactly one water body should be found."));
            }
        }
        catch (ConnectionException e) {
            LOG.error((Object)("Error while loading the water body object with query: " + query), (Throwable)e);
        }
    }

    public void setWkFg(CidsBean wkFg) {
        this.routeChanged = false;
        this.wkFg = wkFg;
    }

    public CidsBean getWkFg() {
        return this.wkFg;
    }

    @Override
    public boolean checkForAdding(CidsBean cidsBean) {
        int droppedRouteId = (Integer)cidsBean.getProperty("id");
        if (this.wkFg != null) {
            List<CidsBean> teile = CidsBeanSupport.getBeanCollectionFromProperty(this.wkFg, "teile");
            if (teile != null) {
                for (CidsBean bean : teile) {
                    int id;
                    CidsBean route;
                    CidsBean stat;
                    CidsBean line = (CidsBean)bean.getProperty("linie");
                    if (line == null || (stat = (CidsBean)line.getProperty("von")) == null || (route = (CidsBean)stat.getProperty("route")) == null || (id = ((Integer)route.getProperty("id")).intValue()) != droppedRouteId) continue;
                    this.routeChanged = true;
                    return true;
                }
            }
        } else {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.comp), "Es wurde noch kein Flie\u00dfgew\u00e4sser zugeordnet.", "Kein Flie\u00dfgew\u00e4sser", 0);
            return false;
        }
        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.comp), "Die gew\u00e4hlte Route geh\u00f6rt nicht zum eingestellten Flie\u00dfgew\u00e4sser.", "Route ung\u00fcltig", 0);
        return false;
    }

    public boolean isRouteChanged() {
        return this.routeChanged;
    }
}

