/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import com.jgoodies.looks.plastic.PlasticComboBoxUI;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

class ScrollableComboUI
extends PlasticComboBoxUI {
    private ScrollableComboUI() {
    }

    public static ComponentUI createUI(JComponent b) {
        PlasticComboBoxUI.createUI((JComponent)b);
        return new ScrollableComboUI();
    }

    protected ComboPopup createPopup() {
        return new PlasticScrollableComboPopup(this.comboBox);
    }

    private class PlasticScrollableComboPopup
    extends BasicComboPopup {
        private PlasticScrollableComboPopup(JComboBox combo) {
            super(combo);
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setForeground(UIManager.getColor("MenuItem.foreground"));
            this.list.setBackground(UIManager.getColor("MenuItem.background"));
        }

        @Override
        protected JScrollPane createScroller() {
            JScrollPane sp = new JScrollPane(this.list, 20, 30);
            return sp;
        }

        @Override
        protected void configureScroller() {
            super.configureScroller();
            this.scroller.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
            this.scroller.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            boolean hasVerticalScrollBar;
            Rectangle defaultBounds = super.computePopupBounds(px, py, pw, ph);
            Object popupPrototypeDisplayValue = this.comboBox.getClientProperty("ComboBox.popupPrototypeDisplayValue");
            if (popupPrototypeDisplayValue == null) {
                return defaultBounds;
            }
            ListCellRenderer<Object> renderer = this.list.getCellRenderer();
            Component c = renderer.getListCellRendererComponent(this.list, popupPrototypeDisplayValue, -1, true, true);
            pw = c.getPreferredSize().width;
            boolean bl = hasVerticalScrollBar = this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
            if (hasVerticalScrollBar) {
                JScrollBar verticalBar = this.scroller.getVerticalScrollBar();
                pw += verticalBar.getPreferredSize().width;
            }
            Rectangle prototypeBasedBounds = super.computePopupBounds(px, py, pw, ph);
            return prototypeBasedBounds.width > defaultBounds.width ? prototypeBasedBounds : defaultBounds;
        }
    }
}

