/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import de.cismet.cids.custom.wrrl_db_mv.util.TimestampConverter;
import de.cismet.cids.dynamics.CidsBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

public class UIUtil {
    private static final Logger LOG = Logger.getLogger(UIUtil.class);

    private UIUtil() {
        throw new AssertionError();
    }

    public static void showExceptionToUser(Exception ex, JComponent parent) {
        ErrorInfo ei = new ErrorInfo("Fehler", "Beim Vorgang ist ein Fehler aufgetreten", null, null, (Throwable)ex, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)parent, (ErrorInfo)ei);
    }

    public static void findOptimalPositionOnScreen(JDialog component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize(screenSize.width / 2, screenSize.height / 2);
        Insets insets = component.getInsets();
        component.setSize(component.getWidth() + insets.left + insets.right, component.getHeight() + insets.top + insets.bottom + 20);
        component.setLocation((screenSize.width - component.getWidth()) / 2, (screenSize.height - component.getHeight()) / 2);
    }

    public static void setLastModifier(CidsBean cidsBean, JLabel lab) {
        Object avUser = cidsBean.getProperty("av_user");
        Object avTime = cidsBean.getProperty("av_time");
        if (avUser == null) {
            avUser = "(unbekannt)";
        }
        avTime = avTime instanceof Timestamp ? TimestampConverter.getInstance().convertForward((Timestamp)avTime) : "(unbekannt)";
        lab.setText("Zuletzt bearbeitet von " + avUser + " am " + avTime);
    }

    public static void refreshTree(TreePath treePath) {
        if (treePath != null) {
            try {
                MetaCatalogueTree tree = ComponentRegistry.getRegistry().getCatalogueTree();
                ((DefaultTreeModel)tree.getModel()).reload();
                tree.exploreSubtree(treePath);
            }
            catch (Exception e) {
                LOG.error((Object)"Error when refreshing Tree", (Throwable)e);
            }
        }
    }
}

