/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import de.cismet.commons.security.WebDavClient;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.ProgressMonitorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class WebDavHelper {
    private static Logger LOG = Logger.getLogger(WebDavHelper.class);

    public static String generateWebDAVFileName(String prefix, File originalFile) {
        String[] fileNameSplit = originalFile.getName().split("\\.");
        String webFileName = prefix + System.currentTimeMillis() + "-" + Math.abs(originalFile.getName().hashCode());
        if (fileNameSplit.length > 1) {
            String ext = fileNameSplit[fileNameSplit.length - 1];
            webFileName = webFileName + "." + ext;
        }
        return webFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadFileToWebDAV(String fileName, File toUpload, String webDavDirectory, WebDavClient webDavClient, Component parent) throws IOException {
        BufferedInputStream bfis = new BufferedInputStream(new ProgressMonitorInputStream(parent, "Bild wird \u00fcbertragen...", new FileInputStream(toUpload)));
        try {
            webDavClient.put(webDavDirectory + WebDavHelper.encodeURL(fileName), (InputStream)bfis);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bfis);
        }
    }

    public static boolean deleteFileFromWebDAV(String fileName, WebDavClient webDavClient, String webDavDirectory) {
        if (fileName != null && fileName.length() > 0) {
            try {
                webDavClient.delete(webDavDirectory + WebDavHelper.encodeURL(fileName));
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return false;
    }

    public static String encodeURL(String url) {
        try {
            if (url == null) {
                return null;
            }
            String[] tokens = url.split("/", -1);
            StringBuilder encodedURL = null;
            for (String tmp : tokens) {
                if (encodedURL == null) {
                    encodedURL = new StringBuilder(URLEncoder.encode(tmp, "UTF-8"));
                    continue;
                }
                encodedURL.append("/").append(URLEncoder.encode(tmp, "UTF-8"));
            }
            if (encodedURL != null) {
                return encodedURL.toString().replaceAll("\\+", "%20");
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Unsupported encoding.", (Throwable)e);
            return url;
        }
    }
}

