/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util;

import de.cismet.cids.custom.wrrl_db_mv.util.TimestampConverter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class YearTimestampConverter
extends Converter<Timestamp, String> {
    private static final Logger log = Logger.getLogger(YearTimestampConverter.class);
    private static final TimestampConverter INSTANCE = new TimestampConverter();

    public static TimestampConverter getInstance() {
        return INSTANCE;
    }

    public String convertForward(Timestamp value) {
        if (value == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy", Locale.getDefault()).format(value);
    }

    public Timestamp convertReverse(String value) {
        Timestamp timestamp;
        block2: {
            String formatString = "yyyy";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy", Locale.getDefault());
            timestamp = null;
            try {
                timestamp = new Timestamp(sdf.parse(value).getTime());
            }
            catch (ParseException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("The string " + value + " cannot be converted to a timestamp. It should have the format " + "yyyy"));
            }
        }
        return timestamp;
    }
}

