/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.WebDavHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.commons.security.WebDavClient;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.WebDavDownload;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class DocumentDropList
extends JList
implements DropTargetListener,
EditorSaveListener {
    private static final Logger LOG = Logger.getLogger(DocumentDropList.class);
    private static final String FILE_PROTOCOL_PREFIX = "file://";
    private CidsBean cidsBean = null;
    private final String WEB_DAV_USER;
    private final String WEB_DAV_PASSWORD;
    private final String WEB_DAV_DIRECTORY;
    private boolean readOnly = false;
    private WebDavClient webDavClient = null;
    private final List<CidsBean> removedFotoBeans = new ArrayList<CidsBean>();
    private final List<CidsBean> removeNewAddedFotoBean = new ArrayList<CidsBean>();
    private String beanProperty = "dokumente";
    private DropTarget dropTarget = null;

    public DocumentDropList(boolean readOnly, String beanProperty) {
        ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
        String pass = bundle.getString("password");
        if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
            pass = PasswordEncrypter.decryptString((String)pass);
        }
        this.WEB_DAV_PASSWORD = pass;
        this.WEB_DAV_USER = bundle.getString("username");
        this.WEB_DAV_DIRECTORY = bundle.getString("url");
        if (!readOnly) {
            this.dropTarget = new DropTarget(this, this);
        }
        this.webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), this.WEB_DAV_USER, this.WEB_DAV_PASSWORD, true);
        this.beanProperty = beanProperty;
        this.readOnly = readOnly;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean a = false;
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(dtde.getDropAction());
                    List files = (List)tr.getTransferData(flavors[i]);
                    if (files != null && files.size() > 0) {
                        this.addFiles(files);
                    }
                    dtde.dropComplete(true);
                    return;
                }
                if (!flavors[i].isRepresentationClassInputStream()) continue;
                if (!a) {
                    dtde.acceptDrop(dtde.getDropAction());
                    a = true;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tr.getTransferData(flavors[i])));
                String tmp = null;
                ArrayList<File> fileList = new ArrayList<File>();
                while ((tmp = br.readLine()) != null) {
                    if (!tmp.trim().startsWith(FILE_PROTOCOL_PREFIX)) continue;
                    File f = new File(tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()));
                    if (f.exists()) {
                        fileList.add(f);
                        continue;
                    }
                    f = new File(URLDecoder.decode(tmp.trim().substring(FILE_PROTOCOL_PREFIX.length()), "UTF-8"));
                    if (f.exists()) {
                        fileList.add(f);
                        continue;
                    }
                    LOG.warn((Object)("File " + f.toString() + " does not exist."));
                }
                br.close();
                if (fileList == null || fileList.size() <= 0) continue;
                this.addFiles(fileList);
                dtde.dropComplete(true);
                return;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
        }
        dtde.rejectDrop();
    }

    public void addFiles(List<File> fileList) {
        if (fileList != null && fileList.size() > 0) {
            WaitDialog wd = new WaitDialog(StaticSwingTools.getParentFrame((Component)this), true, "Speichere Dokument", null);
            CismetThreadPool.execute((Runnable)new DocumentUploadWorker(fileList, wd));
            StaticSwingTools.showDialog((JDialog)wd);
        }
    }

    public void removeObject(int index) {
        CidsBean bean = (CidsBean)this.getModel().getElementAt(index);
        List<CidsBean> docs = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, this.beanProperty);
        docs.remove(bean);
        this.removedFotoBeans.add(bean);
    }

    public void downloadSelectedDocs() {
        Object[] docs;
        for (Object doc : docs = this.getSelectedValues()) {
            if (!(doc instanceof CidsBean)) continue;
            CidsBean bean = (CidsBean)doc;
            if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) continue;
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            String name = bean.getProperty("name").toString();
            String file = bean.getProperty("file").toString();
            String extension = name.substring(name.lastIndexOf("."));
            String filename = name.substring(0, name.lastIndexOf("."));
            DownloadManager.instance().add((Download)new WebDavDownload(this.webDavClient, this.WEB_DAV_DIRECTORY + WebDavHelper.encodeURL(file), jobname, filename + extension, filename, extension));
        }
    }

    public void editorClosed(EditorClosedEvent event) {
        if (EditorSaveListener.EditorSaveStatus.SAVE_SUCCESS == event.getStatus()) {
            for (CidsBean deleteBean : this.removedFotoBeans) {
                String fileName = (String)deleteBean.getProperty("file");
                try {
                    WebDavHelper.deleteFileFromWebDAV(fileName, this.webDavClient, this.WEB_DAV_DIRECTORY);
                    deleteBean.delete();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        } else {
            for (CidsBean deleteBean : this.removeNewAddedFotoBean) {
                String fileName = (String)deleteBean.getProperty("file");
                WebDavHelper.deleteFileFromWebDAV(fileName, this.webDavClient, this.WEB_DAV_DIRECTORY);
            }
        }
    }

    public boolean prepareForSave() {
        return true;
    }

    final class DocumentUploadWorker
    extends SwingWorker<Collection<CidsBean>, Void> {
        private static final String FILE_PREFIX = "DOC-";
        private final Collection<File> docs;
        private final WaitDialog wd;

        public DocumentUploadWorker(Collection<File> docs, WaitDialog wd) {
            this.docs = docs;
            this.wd = wd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Collection<CidsBean> doInBackground() throws Exception {
            try {
                ArrayList<CidsBean> newBeans = new ArrayList<CidsBean>();
                for (File imageFile : this.docs) {
                    String webFileName = WebDavHelper.generateWebDAVFileName(FILE_PREFIX, imageFile);
                    WebDavHelper.uploadFileToWebDAV(webFileName, imageFile, DocumentDropList.this.WEB_DAV_DIRECTORY, DocumentDropList.this.webDavClient, DocumentDropList.this);
                    CidsBean newFotoBean = CidsBeanSupport.createNewCidsBeanFromTableName("GUP_DOKUMENT");
                    newFotoBean.setProperty("name", (Object)imageFile.getName());
                    newFotoBean.setProperty("file", (Object)webFileName);
                    newBeans.add(newFotoBean);
                }
                ArrayList<CidsBean> arrayList = newBeans;
                return arrayList;
            }
            finally {
                while (!this.wd.isVisible()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.wd.setVisible(false);
                this.wd.dispose();
            }
        }

        @Override
        protected void done() {
            try {
                Collection newBeans = (Collection)this.get();
                if (!newBeans.isEmpty()) {
                    List<CidsBean> oldBeans = CidsBeanSupport.getBeanCollectionFromProperty(DocumentDropList.this.cidsBean, DocumentDropList.this.beanProperty);
                    oldBeans.addAll(newBeans);
                    DocumentDropList.this.removeNewAddedFotoBean.addAll(newBeans);
                    DocumentDropList.this.setSelectedValue(newBeans.iterator().next(), true);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
}

