/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.custom.wrrl_db_mv.util.gup.GaebExport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.gaeb.types.GaebContainer;
import de.cismet.cids.gaeb.types.GaebLvItem;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.openide.util.Cancellable;

public class GaebDownload
extends AbstractDownload
implements Cancellable {
    private String filename;
    private String extension;
    private CidsBean cidsBean;
    private ArrayList<ArrayList> massnBeans;

    public GaebDownload(ArrayList<ArrayList> massnBeans, CidsBean cidsBean, String directory, String title, String filename, String extension) {
        this.massnBeans = massnBeans;
        this.cidsBean = cidsBean;
        this.directory = directory;
        this.title = title;
        this.filename = filename;
        this.extension = extension;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block19: {
            if (this.status != Download.State.WAITING) {
                return;
            }
            this.status = Download.State.RUNNING;
            this.stateChanged();
            BufferedWriter bw = null;
            try {
                GaebExport ex = new GaebExport();
                GaebContainer c = new GaebContainer();
                ArrayList<GaebLvItem> l = new ArrayList<GaebLvItem>();
                int i = 0;
                if (this.massnBeans != null) {
                    for (ArrayList al : this.massnBeans) {
                        GaebLvItem item = new GaebLvItem();
                        item.setId(((Integer)al.get(5)).toString());
                        item.setAmount(new BigDecimal((Double)al.get(3)));
                        item.setMeasure(String.valueOf(al.get(4)));
                        item.setDescription(String.valueOf(al.get(6)));
                        item.setDescriptionShort(String.valueOf(al.get(0)));
                        item.setOz(String.valueOf(++i));
                        l.add(item);
                    }
                }
                c.setItemList(l);
                c.setProjectName(String.valueOf(this.cidsBean.getProperty("bezeichnung")));
                c.setDescription(String.valueOf(this.cidsBean.getProperty("bemerkung")));
                c.setNebenangebot(true);
                c.setBieterKommentar(true);
                String result = ex.startExport(c);
                if (!Thread.interrupted()) {
                    bw = new BufferedWriter(new FileWriter(this.fileToSaveTo));
                    bw.write(result);
                    break block19;
                }
                log.info((Object)"Download was interuppted");
                this.deleteFile();
                return;
            }
            catch (Exception e) {
                this.error(e);
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception occured while closing file.", (Throwable)e);
                    }
                }
            }
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GaebDownload)) {
            return false;
        }
        GaebDownload other = (GaebDownload)((Object)obj);
        boolean result = true;
        if (!(this.cidsBean == other.cidsBean || this.cidsBean != null && this.cidsBean.equals((Object)other.cidsBean))) {
            result &= false;
        }
        if (this.fileToSaveTo == null ? other.fileToSaveTo != null : !this.fileToSaveTo.equals(other.fileToSaveTo)) {
            result &= false;
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.cidsBean != null ? this.cidsBean.hashCode() : 0);
        hash = 43 * hash + (this.fileToSaveTo != null ? this.fileToSaveTo.hashCode() : 0);
        return hash;
    }

    public boolean cancel() {
        boolean cancelled = true;
        if (this.downloadFuture != null) {
            cancelled = this.downloadFuture.cancel(true);
        }
        if (cancelled) {
            this.status = Download.State.ABORTED;
            this.stateChanged();
        }
        return cancelled;
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }
}

