/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.gaeb.types.GaebContainer;
import de.cismet.cids.gaeb.types.GaebLvItem;
import de.cismet.cids.gaeb.xsd.types.ObjectFactory;
import de.cismet.cids.gaeb.xsd.types.TgAddress;
import de.cismet.cids.gaeb.xsd.types.TgAward;
import de.cismet.cids.gaeb.xsd.types.TgAwardInfo;
import de.cismet.cids.gaeb.xsd.types.TgBoQ;
import de.cismet.cids.gaeb.xsd.types.TgBoQBody;
import de.cismet.cids.gaeb.xsd.types.TgBoQInfo;
import de.cismet.cids.gaeb.xsd.types.TgBoQText;
import de.cismet.cids.gaeb.xsd.types.TgCompleteText;
import de.cismet.cids.gaeb.xsd.types.TgDescription;
import de.cismet.cids.gaeb.xsd.types.TgFText;
import de.cismet.cids.gaeb.xsd.types.TgGAEB;
import de.cismet.cids.gaeb.xsd.types.TgGAEBInfo;
import de.cismet.cids.gaeb.xsd.types.TgItem;
import de.cismet.cids.gaeb.xsd.types.TgItemlist;
import de.cismet.cids.gaeb.xsd.types.TgMLText;
import de.cismet.cids.gaeb.xsd.types.TgOWN;
import de.cismet.cids.gaeb.xsd.types.TgOutlTxt;
import de.cismet.cids.gaeb.xsd.types.TgOutlineText;
import de.cismet.cids.gaeb.xsd.types.TgPrjInfo;
import de.cismet.cids.gaeb.xsd.types.TgYes;
import de.cismet.cids.gaeb.xsd.types.TgYesNo;
import de.cismet.cids.gaeb.xsd.types.Tgp;
import de.cismet.cids.gaeb.xsd.types.Tgspan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class GaebExport {
    private final ObjectFactory factory = new ObjectFactory();

    public String startExport(GaebContainer gaebContainer) throws DatatypeConfigurationException, JAXBException, IOException {
        DatatypeFactory df = DatatypeFactory.newInstance();
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar versDate = new GregorianCalendar(2007, 5, 1);
        TgGAEB gaeb = this.factory.createTgGAEB();
        TgGAEBInfo gaebInfo = this.factory.createTgGAEBInfo();
        TgPrjInfo prjInfo = this.factory.createTgPrjInfo();
        TgAward award = this.factory.createTgAward();
        TgOWN own = this.factory.createTgOWN();
        gaeb.setGAEBInfo(gaebInfo);
        gaeb.setPrjInfo(prjInfo);
        gaeb.setAward(award);
        gaebInfo.setVersion("3.1");
        gaebInfo.setVersDate(df.newXMLGregorianCalendar(versDate));
        gaebInfo.setDate(df.newXMLGregorianCalendarDate(now.get(1), now.get(2) + 1, now.get(5), Integer.MIN_VALUE));
        gaebInfo.setTime(df.newXMLGregorianCalendarTime(now.get(11), now.get(12), now.get(13), Integer.MIN_VALUE));
        gaebInfo.setProgSystem("cids GAEB tool");
        gaebInfo.setProgName("FIS Navigator");
        prjInfo.setNamePrj(gaebContainer.getProjectName());
        prjInfo.setDescrip(this.getSimpleText(gaebContainer.getDescription()));
        prjInfo.setBidCommPerm(this.getYesNo(gaebContainer.isBieterKommentar()));
        if (gaebContainer.isNebenangebot()) {
            prjInfo.setAlterBidPerm(TgYes.YES);
        }
        prjInfo.setCur("EUR");
        prjInfo.setCurLbl("Euro");
        TgAwardInfo awardInfo = this.factory.createTgAwardInfo();
        award.setDP("81");
        award.setAwardInfo(awardInfo);
        awardInfo.setCur("EUR");
        awardInfo.setCurLbl("Euro");
        award.setOWN(own);
        TgAddress address = this.factory.createTgAddress();
        own.setAddress(address);
        TgBoQ boq = this.factory.createTgBoQ();
        award.setBoQ(boq);
        TgBoQInfo boqInfo = this.factory.createTgBoQInfo();
        boq.setBoQInfo(boqInfo);
        TgBoQBody body = this.factory.createTgBoQBody();
        TgItemlist itemList = this.factory.createTgItemlist();
        body.setItemlist(itemList);
        for (GaebLvItem tmp : gaebContainer.getItemList()) {
            itemList.getRemarkOrPerfDescrOrItem().add(this.getItem(tmp));
        }
        boq.setBoQBody(body);
        String result = new String(this.marshall(gaeb));
        result = result.replace("xmlns:ns2", "xmlns");
        result = result.replace("ns2:", "");
        result = result.replace("xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", "xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"");
        return result;
    }

    private TgItem getItem(GaebLvItem gaebItem) {
        TgItem item = this.factory.createTgItem();
        item.setID(gaebItem.getId());
        JAXBElement<BigDecimal> menge = this.factory.createTgItemQty(gaebItem.getAmount());
        JAXBElement<String> einheit = this.factory.createTgItemQU(gaebItem.getMeasure());
        TgDescription description = this.factory.createTgDescription();
        TgOutlineText kurzbeschreibung = this.factory.createTgOutlineText();
        TgCompleteText langbeschreibung = this.factory.createTgCompleteText();
        langbeschreibung.setOutlineText(kurzbeschreibung);
        TgOutlTxt text = this.factory.createTgOutlTxt();
        TgMLText mlText = this.factory.createTgMLText();
        text.getTextOutlTxtOrTextComplement().add(mlText);
        mlText.getPOrDivOrSpan().add(this.getSpan(gaebItem.getDescriptionShort()));
        kurzbeschreibung.setOutlTxt(text);
        TgBoQText langText = this.factory.createTgBoQText();
        langText.getTextOrTextComplementOrAttachment().add(this.factory.createTgBoQTextText(this.getSimpleText(gaebItem.getDescription())));
        langbeschreibung.setDetailTxt(langText);
        description.setCompleteText(langbeschreibung);
        description.setOutlineText(kurzbeschreibung);
        item.getContent().add(menge);
        item.getContent().add(einheit);
        item.getContent().add(this.factory.createTgItemDescription(description));
        item.setRNoPart(String.valueOf(gaebItem.getOz()));
        return item;
    }

    private TgFText getSimpleText(String string) {
        TgFText text = this.factory.createTgFText();
        Tgp tp = this.factory.createTgp();
        tp.getSpanOrBrOrImage().add(this.getSpan(string));
        JAXBElement<Tgp> p = this.factory.createTgFTextP(tp);
        text.getPOrDivOrSpan().add(p);
        return text;
    }

    private JAXBElement<Tgspan> getSpan(String text) {
        Tgspan span = this.factory.createTgspan();
        span.setValue(text);
        return this.factory.createTgFTextSpan(span);
    }

    private TgYesNo getYesNo(boolean yes) {
        return yes ? TgYesNo.YES : TgYesNo.NO;
    }

    private byte[] marshall(TgGAEB gaeb) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"de.cismet.cids.gaeb.xsd.types");
        Marshaller marshaller = context.createMarshaller();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        marshaller.marshal(this.factory.createGAEB(gaeb), (OutputStream)os);
        return os.toByteArray();
    }

    public static void main(String[] args) throws Exception {
    }
}

