/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GeschuetzteArtRWBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import java.awt.Color;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class GeschuetzteArtRWBandMember
extends LineBandMember {
    private static final MetaClass GESCHUETZTE_ART = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GESCHUETZTE_ART");

    public GeschuetzteArtRWBandMember(GeschuetzteArtRWBand parent) {
        super(parent);
        this.lineFieldName = "linie";
    }

    public GeschuetzteArtRWBandMember(GeschuetzteArtRWBand parent, boolean readOnly) {
        super(parent, readOnly);
        this.lineFieldName = "linie";
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
        if (this.bean.getProperty("art.name") != null) {
            this.setToolTipText(this.bean.getProperty("art.name") + "");
        } else {
            this.setToolTipText("");
        }
    }

    @Override
    protected void determineBackgroundColour() {
        if (this.bean.getProperty("art") == null || this.bean.getProperty("art.color") == null) {
            this.setDefaultBackground();
            return;
        }
        String color = (String)this.bean.getProperty("art.color");
        if (color != null) {
            try {
                this.setBackgroundPainter((Painter)new MattePainter((Paint)Color.decode(color)));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Error while parsing the color.", (Throwable)e);
                this.setDefaultBackground();
            }
        }
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("art")) {
            this.determineBackgroundColour();
            this.setSelected(this.isSelected);
            if (this.bean.getProperty("art.name") != null) {
                this.setToolTipText(this.bean.getProperty("art.name") + "");
            } else {
                this.setToolTipText("");
            }
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected CidsBean cloneBean(CidsBean bean) throws Exception {
        return CidsBeanSupport.cloneCidsBean(bean, false);
    }
}

