/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.wrrl_db_mv.server.search.NaturschutzgebietSearch;
import de.cismet.cids.custom.wrrl_db_mv.server.search.QuerbautenSearchByStations;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class GupHelper {
    private static final Logger LOG = Logger.getLogger(GupHelper.class);
    public static final CalculationCache<List, MetaObject[]> schutzgebietCache = new CalculationCache((Calculator)new SchutzgebietCalculator());
    public static final CalculationCache<List, MetaObject[]> umlandCache = new CalculationCache((Calculator)new UmlandnutzungCalculator());
    public static final CalculationCache<List, MetaObject[]> umlandnutzerCache = new CalculationCache((Calculator)new UmlandnutzerCalculator());
    public static final CalculationCache<List, MetaObject[]> entwicklungszielCache = new CalculationCache((Calculator)new EntwicklungszielCalculator(false));
    public static final CalculationCache<List, MetaObject[]> entwicklungsziel33Cache = new CalculationCache((Calculator)new EntwicklungszielCalculator(true));
    public static final CalculationCache<List, ArrayList<ArrayList>> querbauwerkCache = new CalculationCache((Calculator)new QuerbauwerkeCalculator());
    public static final CalculationCache<List, MetaObject[]> unterhaltungserfordernisCache = new CalculationCache((Calculator)new UnterhaltungserfordernisCalculator());
    public static final CalculationCache<List, MetaObject[]> verbreitungsraumCache = new CalculationCache((Calculator)new VerbreitungsraumCalculator());
    public static final CalculationCache<List, MetaObject[]> operativeZieleCache = new CalculationCache((Calculator)new OperativesZielCalculator());
    public static final CalculationCache<List, MetaObject[]> unterhaltungshinweiseCache = new CalculationCache((Calculator)new UnterhaltungshinweiseCalculator());
    public static final CalculationCache<List, MetaObject[]> hydrologieCache = new CalculationCache((Calculator)new HydrologieCalculator());
    public static final CalculationCache<List, MetaObject[]> unterhaltungsmassnahmeCache = new CalculationCache((Calculator)new UnterhaltungsmassnahmeCalculator());
    private static final List<String> PROPERTY_LIST = new ArrayList<String>();

    private static void adjustBorders(MetaObject[] metaObjects, double min, double max) {
        if (metaObjects != null) {
            for (MetaObject tmp : metaObjects) {
                double bis;
                double von = (Double)tmp.getBean().getProperty("linie.von.wert");
                if (von > (bis = ((Double)tmp.getBean().getProperty("linie.bis.wert")).doubleValue())) {
                    try {
                        tmp.getBean().setProperty("linie.von.wert", (Object)bis);
                        tmp.getBean().setProperty("linie.bis.wert", (Object)von);
                        double tmpValue = von;
                        von = bis;
                        bis = tmpValue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot swap von and bis value", (Throwable)e);
                    }
                }
                try {
                    if (von < min) {
                        tmp.getBean().setProperty("linie.von.wert", (Object)min);
                    }
                    if (!(bis > max)) continue;
                    tmp.getBean().setProperty("linie.bis.wert", (Object)max);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot adjust the station value", (Throwable)e);
                }
            }
        }
    }

    public static CidsBean getStationLinie(CidsBean cidsBean) {
        for (int i = 0; i < PROPERTY_LIST.size(); ++i) {
            List<CidsBean> beans = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, PROPERTY_LIST.get(i));
            if (beans == null || beans.size() <= 0) continue;
            return (CidsBean)beans.get(0).getProperty("linie");
        }
        return null;
    }

    public static double getMinStart(CidsBean cidsBean) {
        double minStart = -1.0;
        for (int i = 0; i < PROPERTY_LIST.size(); ++i) {
            List<CidsBean> beans = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, PROPERTY_LIST.get(i));
            if (beans == null || beans.size() <= 0) continue;
            for (CidsBean tmp : beans) {
                Double value;
                CidsBean start;
                CidsBean line = (CidsBean)tmp.getProperty("linie");
                if (line == null || (start = (CidsBean)line.getProperty("von")) == null || (value = (Double)start.getProperty("wert")) == null || minStart != -1.0 && !(minStart > value)) continue;
                minStart = value;
            }
        }
        return minStart;
    }

    public static double getMaxEnd(CidsBean cidsBean) {
        double maxEnd = -1.0;
        for (int i = 0; i < PROPERTY_LIST.size(); ++i) {
            List<CidsBean> beans = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, PROPERTY_LIST.get(i));
            if (beans == null || beans.size() <= 0) continue;
            for (CidsBean tmp : beans) {
                Double value;
                CidsBean end;
                CidsBean line = (CidsBean)tmp.getProperty("linie");
                if (line == null || (end = (CidsBean)line.getProperty("bis")) == null || (value = (Double)end.getProperty("wert")) == null || maxEnd != -1.0 && !(maxEnd < value)) continue;
                maxEnd = value;
            }
        }
        return maxEnd;
    }

    static {
        PROPERTY_LIST.add("massnahmen");
    }

    private static class QuerbauwerkeCalculator
    implements Calculator<List, ArrayList<ArrayList>> {
        private QuerbauwerkeCalculator() {
        }

        public ArrayList<ArrayList> calculate(List input) throws Exception {
            QuerbautenSearchByStations searchQB = new QuerbautenSearchByStations(((Double)input.get(0)).doubleValue(), ((Double)input.get(1)).doubleValue(), String.valueOf(input.get(2)));
            Collection resQB = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchQB);
            return (ArrayList)resQB;
        }
    }

    private static class UnterhaltungsmassnahmeCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass UNTERHALTUNGSMASSNAHME = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_UNTERHALTUNGSMASSNAHME");

        private UnterhaltungsmassnahmeCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + UNTERHALTUNGSMASSNAHME.getID() + ", u." + UNTERHALTUNGSMASSNAHME.getPrimaryKey() + " from " + UNTERHALTUNGSMASSNAHME.getTableName() + " u, GUP_PLANUNGSABSCHNITT_GUP_UNTERHALTUNGSMASSNAHME route, station_linie sl, station von, station bis, route r WHERE route.gup_unterhaltungsmassnahme = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Unterhaltungsmassnahmen: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class UnterhaltungserfordernisCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass UNTERHALTUNGSERFORDERNIS = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_UNTERHALTUNGSERFORDERNIS");

        private UnterhaltungserfordernisCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + UNTERHALTUNGSERFORDERNIS.getID() + ", u." + UNTERHALTUNGSERFORDERNIS.getPrimaryKey() + " from " + UNTERHALTUNGSERFORDERNIS.getTableName() + " u, gup_unterhaltungserfordernis_route_unterhaltungserfordernis route, station_linie sl, station von, station bis, route r WHERE route.unterhaltungserfordernis = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Situationstypen: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class UnterhaltungshinweiseCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass GUP_POI = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_poi");

        private UnterhaltungshinweiseCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + GUP_POI.getID() + ", u." + GUP_POI.getPrimaryKey() + " from " + GUP_POI.getTableName() + " u, gup_poi_route route, station_linie sl, station von, station bis, route r WHERE route.id = u.poi_route and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Gup_POIs: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class EntwicklungszielCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass ENTWICKLUNGSZIEL = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_ENTWICKLUNGSZIEL");
        private boolean after27;

        public EntwicklungszielCalculator(boolean after27) {
            this.after27 = after27;
        }

        public MetaObject[] calculate(List input) throws Exception {
            String realisierung = this.after27 ? "(7,8)" : "(1,2,3,5)";
            String query = "select " + ENTWICKLUNGSZIEL.getID() + ", u." + ENTWICKLUNGSZIEL.getPrimaryKey() + " from " + ENTWICKLUNGSZIEL.getTableName() + " u, entwicklungsziel_route_entwicklungsziel route, station_linie sl, station von, station bis, route r WHERE route.entwicklungsziel = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + ")) and realisierung in " + realisierung;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Entwicklungsziel: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class VerbreitungsraumCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass GESCHUETZTE_ART_ABSCHNITT = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GESCHUETZTE_ART_ABSCHNITT");

        private VerbreitungsraumCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + GESCHUETZTE_ART_ABSCHNITT.getID() + ", u." + GESCHUETZTE_ART_ABSCHNITT.getPrimaryKey() + " from " + GESCHUETZTE_ART_ABSCHNITT.getTableName() + " u, verbreitungsraum_geschuetzte_art_abschnitt route, station_linie sl, station von, station bis, route r WHERE route.abschnitt = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Verbreitungsraum: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class OperativesZielCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass OPERATIVES_ZIEL = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_OPERATIVES_ZIEL_ABSCHNITT");

        private OperativesZielCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + OPERATIVES_ZIEL.getID() + ", u." + OPERATIVES_ZIEL.getPrimaryKey() + " from " + OPERATIVES_ZIEL.getTableName() + " u, gup_operatives_ziel_route_abschnitt route, station_linie sl, station von, station bis, route r WHERE route.abschnitt = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for operatives Ziel: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class SchutzgebietCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass SCHUTZGEBIET = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"SCHUTZGEBIET");

        private SchutzgebietCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + SCHUTZGEBIET.getID() + ", u." + SCHUTZGEBIET.getPrimaryKey() + " from " + SCHUTZGEBIET.getTableName() + " u, station_linie sl, station von, station bis, route r WHERE u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Schutzgebiete: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class HydrologieCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass HYDROLOGIE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_HYDROLOG");

        private HydrologieCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + HYDROLOGIE.getID() + ", u." + HYDROLOGIE.getPrimaryKey() + " from " + HYDROLOGIE.getTableName() + " u, hydrolog_route_hydrolog route, station_linie sl, station von, station bis, route r WHERE route.hydrologie = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Hydrologie: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class UmlandnutzerCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass UMLANDNUTZER = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"UMLANDNUTZER");

        private UmlandnutzerCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + UMLANDNUTZER.getID() + ", u." + UMLANDNUTZER.getPrimaryKey() + " from " + UMLANDNUTZER.getTableName() + " u, umlandnutzer_route_umlandnutzer route, station_linie sl, station von, station bis, route r WHERE route.umlandnutzer = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Umlandnutzer: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class UmlandnutzungCalculator
    implements Calculator<List, MetaObject[]> {
        private static final MetaClass UMLANDNUTZUNG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_UMLANDNUTZUNG");

        private UmlandnutzungCalculator() {
        }

        public MetaObject[] calculate(List input) throws Exception {
            String query = "select " + UMLANDNUTZUNG.getID() + ", u." + UMLANDNUTZUNG.getPrimaryKey() + " from " + UMLANDNUTZUNG.getTableName() + " u, umlandnutzung_route_umlandnutzung route, station_linie sl, station von, station bis, route r WHERE route.umlandnutzung = u.id and u.linie = sl.id and sl.von = von.id and sl.bis = bis.id and von.route = r.id       and r.gwk = " + String.valueOf(input.get(2)) + " and (( von.wert > " + (Double)input.get(0) + " and von.wert < " + (Double)input.get(1) + ") OR              (bis.wert > " + (Double)input.get(0) + " AND bis.wert < " + (Double)input.get(1) + " ) OR (von.wert <= " + (Double)input.get(0) + " and bis.wert >= " + (Double)input.get(1) + "))";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for Umlandnutzung: " + query));
            }
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            GupHelper.adjustBorders(metaObjects, (Double)input.get(0), (Double)input.get(1));
            return metaObjects;
        }
    }

    private static class NaturschutzCalculator
    implements Calculator<List, ArrayList<ArrayList>> {
        private NaturschutzCalculator() {
        }

        public ArrayList<ArrayList> calculate(List input) throws Exception {
            NaturschutzgebietSearch searchNSG = new NaturschutzgebietSearch(((Double)input.get(0)).doubleValue(), ((Double)input.get(1)).doubleValue(), String.valueOf(input.get(2)));
            Collection resNSG = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchNSG);
            return (ArrayList)resNSG;
        }
    }
}

