/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.CopyableBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanCollectionStore;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.jbands.BandEvent;
import de.cismet.tools.gui.jbands.BandMemberEvent;
import de.cismet.tools.gui.jbands.interfaces.BandListener;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberListener;
import de.cismet.tools.gui.jbands.interfaces.BandModificationProvider;
import de.cismet.tools.gui.jbands.interfaces.DisposableBand;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class LineBand
extends CopyableBand
implements CidsBeanCollectionStore,
BandModificationProvider,
BandMemberListener,
EditorSaveListener,
DisposableBand {
    private static final Logger LOG = Logger.getLogger(LineBand.class);
    protected Collection<CidsBean> objectBeans = new ArrayList<CidsBean>();
    protected String objectTableName = null;
    protected String lineFieldName = "linie";
    protected Double fixMin = null;
    protected Double fixMax = null;
    private final List<BandListener> listenerList = new ArrayList<BandListener>();
    private boolean onlyAcceptNewBeanWithValue = true;
    private final HashMap<String, CidsBean> beanMap = new HashMap();
    private boolean normalise = false;
    private CidsBean route;
    private final List<CidsBean> beansToDelete = new ArrayList<CidsBean>();

    public LineBand(String title, String objectTableName) {
        this(1.0f, title, objectTableName);
    }

    public LineBand(float heightWeight, String objectTableName) {
        super(heightWeight);
        this.objectTableName = objectTableName;
    }

    public LineBand(float heightWeight, String title, String objectTableName) {
        super(heightWeight, title);
        this.objectTableName = objectTableName;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.objectBeans;
    }

    public void setCidsBeans(Collection<CidsBean> beans) {
        this.disposeAllMember();
        this.objectBeans = beans;
        super.removeAllMember();
        this.normalizeStations();
        if (this.objectBeans != null) {
            for (CidsBean massnahme : this.objectBeans) {
                LineBandMember m = this.createBandMemberFromBean();
                m.setReadOnly(this.readOnly);
                m.addBandMemberListener(this);
                m.setCidsBean(massnahme);
                this.addMember((BandMember)m);
            }
        } else {
            this.objectBeans = new ArrayList<CidsBean>();
        }
    }

    public void setRoute(CidsBean route) {
        this.route = route;
    }

    public CidsBean getRoute() {
        return this.route;
    }

    public void addMember(final Double startStation, final Double endStation, final Double minStart, final Double maxEnd, final List<BandMember> memberList) {
        WaitingDialogThread<Void> wdt = new WaitingDialogThread<Void>(StaticSwingTools.getParentFrame((Component)this.getPrefixComponent()), true, "Erstelle Abschnitt", null, 100){

            protected Void doInBackground() throws Exception {
                if (endStation == null) {
                    LineBand.this.addUnspecifiedMember(startStation, minStart, maxEnd, memberList);
                } else {
                    LineBand.this.addSpecifiedMember(startStation, endStation);
                }
                return null;
            }
        };
        wdt.start();
    }

    public void addMember(CidsBean objectBean, CidsBean startStation, CidsBean endStation) {
        try {
            CidsBean line = CidsBeanSupport.createNewCidsBeanFromTableName("station_linie");
            line.setProperty("von", (Object)startStation);
            line.setProperty("bis", (Object)endStation);
            line.setProperty("id", (Object)LinearReferencingHelper.getNewLineId());
            objectBean.setProperty(this.lineFieldName, (Object)line);
            Geometry lineGeom = LinearReferencedLineFeature.createSubline((double)((Double)startStation.getProperty("wert")), (double)((Double)endStation.getProperty("wert")), (Geometry)((Geometry)startStation.getProperty("route.geom.geo_field")));
            lineGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            try {
                LinearReferencingHelper.setGeometryToLineBean(lineGeom, line);
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot create geometry for station", (Throwable)ex);
            }
            LineBandMember m = this.refresh(objectBean, true);
            this.objectBeans.add(objectBean);
            this.fireBandChanged(new BandEvent());
        }
        catch (Exception e) {
            LOG.error((Object)"error while creating new station.", (Throwable)e);
        }
    }

    private void normalizeStations() {
        this.beanMap.clear();
        this.setNormalise(true);
        if (this.objectBeans != null) {
            for (CidsBean massnahme : this.objectBeans) {
                CidsBean line = LinearReferencingSingletonInstances.CIDSBEAN_CACHE.getCachedBeanFor((CidsBean)massnahme.getProperty(this.lineFieldName));
                try {
                    if (line != null && line != massnahme.getProperty(this.lineFieldName)) {
                        massnahme.setProperty(this.lineFieldName, (Object)line);
                    }
                    CidsBean von = LinearReferencingSingletonInstances.CIDSBEAN_CACHE.getCachedBeanFor((CidsBean)massnahme.getProperty(this.lineFieldName + ".von"));
                    CidsBean bis = LinearReferencingSingletonInstances.CIDSBEAN_CACHE.getCachedBeanFor((CidsBean)massnahme.getProperty(this.lineFieldName + ".bis"));
                    if (von != null && von != massnahme.getProperty(this.lineFieldName + ".von")) {
                        massnahme.setProperty(this.lineFieldName + ".von", (Object)von);
                    }
                    if (bis == null || bis == massnahme.getProperty(this.lineFieldName + ".bis")) continue;
                    massnahme.setProperty(this.lineFieldName + ".bis", (Object)bis);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while setting cidsBean.", (Throwable)e);
                }
            }
            this.setNormalise(false);
            this.fireBandChanged(new BandEvent());
        }
    }

    public void normalizeStationOfModifiedMember(CidsBean member, boolean isFrom) {
        String propWert = isFrom ? this.lineFieldName + ".von.wert" : this.lineFieldName + ".bis.wert";
        String propStat = isFrom ? this.lineFieldName + ".von" : this.lineFieldName + ".bis";
        String memberWert = String.valueOf(member.getProperty(propWert));
        CidsBean memberStat = (CidsBean)member.getProperty(propStat);
        for (CidsBean otherBean : this.objectBeans) {
            if (otherBean == member) continue;
            CidsBean otherStat = (CidsBean)otherBean.getProperty(this.lineFieldName + ".von");
            this.checkToMerge(member, otherStat, memberStat, memberWert, isFrom);
            otherStat = (CidsBean)otherBean.getProperty(this.lineFieldName + ".bis");
            this.checkToMerge(member, otherStat, memberStat, memberWert, isFrom);
        }
        this.normalizeStations();
    }

    private void checkToMerge(CidsBean objectBean, CidsBean otherStat, CidsBean memberStat, String memberWert, boolean isFrom) {
        String wert;
        if (otherStat != null && (wert = String.valueOf(otherStat.getProperty("wert"))) != null && !wert.equals("null") && wert.equals(memberWert)) {
            try {
                if (otherStat != memberStat) {
                    LinearReferencingSingletonInstances.MERGE_REGISTRY.firePointBeanMergeRequest(objectBean, isFrom, otherStat);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while sharing station.", (Throwable)e);
            }
        }
    }

    public void splitStation(CidsBean bean, double value, boolean isFrom) {
        String prop = isFrom ? this.lineFieldName + ".von" : this.lineFieldName + ".bis";
        CidsBean station = (CidsBean)bean.getProperty(prop);
        for (CidsBean otherBean : this.objectBeans) {
            CidsBean otherStat;
            if (otherBean == bean || (otherStat = (CidsBean)otherBean.getProperty(this.lineFieldName + "." + (isFrom ? "bis" : "von"))) == null || otherStat != station) continue;
            try {
                LinearReferencingSingletonInstances.MERGE_REGISTRY.firePointBeanSplitRequest(bean, isFrom);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while sharing station.", (Throwable)e);
            }
        }
        this.normalizeStations();
    }

    public static CidsBean createNewStation(CidsBean route, double value) throws Exception {
        CidsBean newStat = CidsBeanSupport.createNewCidsBeanFromTableName("station");
        CidsBean geom = CidsBeanSupport.createNewCidsBeanFromTableName("geom");
        newStat.setProperty("route", (Object)route);
        newStat.setProperty("wert", (Object)value);
        newStat.setProperty("id", (Object)LinearReferencingHelper.getNewStationId());
        newStat.setProperty("real_point", (Object)geom);
        Geometry pointGeom = LinearReferencedPointFeature.getPointOnLine((double)LinearReferencingHelper.getLinearValueFromStationBean(newStat), (Geometry)LinearReferencingHelper.getRouteGeometryFromStationBean(newStat));
        pointGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        LinearReferencingHelper.setPointGeometryToStationBean(pointGeom, newStat);
        CidsBean tmp = newStat.persist();
        return newStat;
    }

    private void addUnspecifiedMember(Double startStation, Double minStart, Double maxEnd, List<BandMember> memberList) {
        double distanceBefore = Double.MAX_VALUE;
        double distanceBehind = Double.MAX_VALUE;
        CidsBean beanBefore = null;
        CidsBean beanBehind = null;
        if (memberList != null) {
            for (BandMember bandMember : memberList) {
                if (bandMember instanceof CidsBeanStore) {
                    CidsBean b = ((CidsBeanStore)bandMember).getCidsBean();
                    Double from = bandMember.getMin();
                    Double till = bandMember.getMax();
                    if (from == null || till == null) continue;
                    double distance = startStation - till;
                    if (distance < distanceBefore && distance >= 0.0) {
                        distanceBefore = distance;
                        beanBefore = (CidsBean)b.getProperty(this.lineFieldName + ".bis");
                    }
                    if (!((distance = from - startStation) < distanceBehind) || !(distance >= 0.0)) continue;
                    distanceBehind = distance;
                    beanBehind = (CidsBean)b.getProperty(this.lineFieldName + ".von");
                    continue;
                }
                beanBefore = null;
                beanBehind = null;
                memberList = null;
            }
        }
        if (memberList == null) {
            for (CidsBean cidsBean : this.objectBeans) {
                Double from = (Double)cidsBean.getProperty(this.lineFieldName + ".von.wert");
                Double till = (Double)cidsBean.getProperty(this.lineFieldName + ".bis.wert");
                if (from == null || till == null) continue;
                double distance = startStation - till;
                if (distance < distanceBefore && distance >= 0.0) {
                    distanceBefore = distance;
                    beanBefore = (CidsBean)cidsBean.getProperty(this.lineFieldName + ".bis");
                }
                if (!((distance = from - startStation) < distanceBehind) || !(distance >= 0.0)) continue;
                distanceBehind = distance;
                beanBehind = (CidsBean)cidsBean.getProperty(this.lineFieldName + ".von");
            }
        }
        try {
            if (beanBefore == null) {
                beanBefore = LineBand.createNewStation(this.getRoute(), minStart == Double.MAX_VALUE ? 0.0 : minStart);
            }
            if (beanBehind == null) {
                if (maxEnd == Double.MIN_VALUE) {
                    String geomString = "geom.geo_field";
                    Geometry geometry = (Geometry)this.getRoute().getProperty("geom.geo_field");
                    beanBehind = LineBand.createNewStation(this.getRoute(), geometry.getLength());
                } else {
                    beanBehind = LineBand.createNewStation(this.getRoute(), maxEnd);
                }
            }
            this.addNewMember(beanBefore, beanBehind);
        }
        catch (Exception e) {
            LOG.error((Object)"error while creating new station.", (Throwable)e);
        }
    }

    @Override
    protected void addSpecifiedMember(Double startStation, Double endStation) {
        CidsBean beanBefore = null;
        CidsBean beanBehind = null;
        try {
            beanBefore = LineBand.createNewStation(this.getRoute(), startStation);
            beanBehind = LineBand.createNewStation(this.getRoute(), endStation);
            this.addNewMember(beanBefore, beanBehind);
        }
        catch (Exception e) {
            LOG.error((Object)"error while creating new station.", (Throwable)e);
        }
    }

    private void addNewMember(CidsBean beanBefore, CidsBean beanBehind) throws Exception {
        CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName(this.objectTableName);
        CidsBean line = CidsBeanSupport.createNewCidsBeanFromTableName("station_linie");
        CidsBean geom = CidsBeanSupport.createNewCidsBeanFromTableName("geom");
        Geometry lineGeom = LinearReferencedLineFeature.createSubline((double)((Double)beanBefore.getProperty("wert")), (double)((Double)beanBehind.getProperty("wert")), (Geometry)((Geometry)beanBehind.getProperty("route.geom.geo_field")));
        lineGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        geom.setProperty("geo_field", (Object)lineGeom);
        line.setProperty("von", (Object)beanBefore);
        line.setProperty("bis", (Object)beanBehind);
        line.setProperty("geom", (Object)geom);
        line.setProperty("id", (Object)LinearReferencingHelper.getNewStationId());
        newBean.setProperty(this.lineFieldName, (Object)line);
        LineBandMember m = this.refresh(newBean, true);
        this.objectBeans.add(newBean);
        this.fireBandChanged(new BandEvent());
        if (this.onlyAcceptNewBeanWithValue) {
            m.setNewMode();
        }
    }

    private LineBandMember refresh(CidsBean special, boolean add) {
        this.disposeAllMember();
        super.removeAllMember();
        for (CidsBean objectBean : this.objectBeans) {
            if (!add && objectBean == special) continue;
            LineBandMember m = this.createBandMemberFromBean();
            m.setReadOnly(this.readOnly);
            m.setCidsBean(objectBean);
            m.addBandMemberListener(this);
            this.addMember((BandMember)m);
        }
        if (add) {
            LineBandMember m = this.createBandMemberFromBean();
            m.setReadOnly(this.readOnly);
            m.setCidsBean(special);
            m.addBandMemberListener(this);
            this.addMember((BandMember)m);
            return m;
        }
        return null;
    }

    protected abstract LineBandMember createBandMemberFromBean();

    public void addBandListener(BandListener listener) {
        this.listenerList.add(listener);
    }

    public void removeBandListener(BandListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireBandChanged(BandEvent e) {
        for (BandListener l : this.listenerList) {
            l.bandChanged(e);
        }
    }

    public void bandMemberChanged(BandMemberEvent e) {
        BandEvent ev = new BandEvent();
        if (e != null) {
            if (e.isSelectionLost()) {
                ev.setSelectionLost(true);
            }
            ev.setModelChanged(e.isModelChanged());
        }
        this.fireBandChanged(ev);
    }

    public void deleteMember(LineBandMember member) {
        member.dispose();
        CidsBean memberBean = member.getCidsBean();
        this.refresh(memberBean, false);
        this.objectBeans.remove(memberBean);
        this.beansToDelete.add(memberBean);
        BandEvent e = new BandEvent();
        e.setSelectionLost(true);
        this.fireBandChanged(e);
    }

    public void editorClosed(EditorClosedEvent event) {
        if (event.getStatus() == EditorSaveListener.EditorSaveStatus.SAVE_SUCCESS) {
            CismetThreadPool.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (CidsBean tmp : LineBand.this.beansToDelete) {
                        try {
                            tmp.delete();
                            tmp.persist();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Cannot delete bean.", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public boolean prepareForSave() {
        return true;
    }

    public boolean isNormalise() {
        return this.normalise;
    }

    public void setNormalise(boolean normalise) {
        this.normalise = normalise;
    }

    public boolean isOnlyAcceptNewBeanWithValue() {
        return this.onlyAcceptNewBeanWithValue;
    }

    public void setOnlyAcceptNewBeanWithValue(boolean onlyAcceptNewBeanWithValue) {
        this.onlyAcceptNewBeanWithValue = onlyAcceptNewBeanWithValue;
    }

    public void removeAllMember() {
        this.disposeAllMember();
        this.objectBeans.clear();
        super.removeAllMember();
        this.refresh(null, false);
    }

    public void setMin(Double min) {
        this.fixMin = min;
    }

    public void setMax(Double max) {
        this.fixMax = max;
    }

    public double getMin() {
        if (this.fixMin != null) {
            return this.fixMin;
        }
        return super.getMin();
    }

    public double getMax() {
        if (this.fixMax != null) {
            return this.fixMax;
        }
        return super.getMax();
    }

    public void dispose() {
        this.disposeAllMember();
    }

    private void disposeAllMember() {
        for (int i = 0; i < this.getNumberOfMembers(); ++i) {
            BandMember member = this.getMember(i);
            if (!(member instanceof LineBandMember)) continue;
            ((LineBandMember)member).dispose();
        }
    }
}

